/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TextPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(TextPanel.class);
    protected JComponent[] fields;
    protected JComponent[] labels;

    public TextPanel(JComponent[] aFields, String[] aLabels, char[] mnemonics, int[] widths, String[] tips) {
        super(new FormLayout(8, 8));
        this.fields = new JComponent[aFields.length];
        System.arraycopy(aFields, 0, this.fields, 0, aFields.length);
        this.labels = new JComponent[aLabels.length];
        int i = 0;
        while (i < aLabels.length) {
            if (i < tips.length) {
                this.fields[i].setToolTipText(tips[i]);
            }
            if (i < widths.length && this.fields[i] instanceof JTextField) {
                ((JTextField)this.fields[i]).setColumns(widths[i]);
            }
            JLabel lab = new JLabel(aLabels[i], 4);
            lab.setLabelFor(this.fields[i]);
            if (i < mnemonics.length) {
                lab.setDisplayedMnemonic(mnemonics[i]);
            }
            this.labels[i] = lab;
            this.add(lab);
            this.add(this.fields[i]);
            ++i;
        }
    }

    public JComponent getField(int i) {
        return this.fields[i];
    }

    public JComponent getLabel(int i) {
        return this.labels[i];
    }

    public static void main(String[] args) {
        JComponent[] fields = new JTextField[]{new JTextField(), new JTextField(), new JTextField(), new JTextField()};
        String[] labels = new String[]{"First Name", "Middle Initial", "Last Name", "Age"};
        char[] mnemonics = new char[]{'F', 'M', 'L', 'A'};
        int[] widths = new int[]{15, 1, 15, 3};
        String[] descs = new String[]{"First Name", "Middle Initial", "Last Name", "Age"};
        TextPanel form = new TextPanel(fields, labels, mnemonics, widths, descs);
        JButton submit = new JButton("Submit Form");
        submit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                logger.info((Object)(TextPanel.this.getField(0) + " " + TextPanel.this.getField(1) + ". " + TextPanel.this.getField(2) + ", age " + TextPanel.this.getField(3)));
            }
        });
        JFrame f = new JFrame("Text Form Example");
        f.setDefaultCloseOperation(3);
        f.getContentPane().add((Component)form, "North");
        JPanel p = new JPanel();
        p.add(submit);
        f.getContentPane().add((Component)p, "South");
        f.pack();
        f.setVisible(true);
    }
}

