/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.Color;
import java.awt.Point;
import junit.framework.TestCase;

public class TestRelationship
extends TestCase {
    Relationship rel;
    PlayPen pp;
    TablePane tp1;
    TablePane tp2;

    protected void setUp() throws Exception {
        super.setUp();
        this.pp = ArchitectFrame.getMainInstance().getProject().getPlayPen();
        SQLTable t1 = new SQLTable(this.pp.getDatabase(), true);
        t1.addColumn(new SQLColumn(t1, "pkcol_1", 4, 10, 0));
        t1.addColumn(new SQLColumn(t1, "fkcol_1", 4, 10, 0));
        t1.getColumnByName("pkcol_1").setPrimaryKeySeq(0);
        this.pp.getDatabase().addChild(t1);
        this.tp1 = new TablePane(t1, this.pp);
        this.pp.addTablePane(this.tp1, new Point(0, 0));
        SQLTable t2 = new SQLTable(this.pp.getDatabase(), true);
        t2.addColumn(new SQLColumn(t2, "col_1", 4, 10, 0));
        t2.addColumn(new SQLColumn(t2, "fkcol", 4, 10, 0));
        this.pp.getDatabase().addChild(t2);
        this.tp2 = new TablePane(t2, this.pp);
        this.pp.addTablePane(this.tp2, new Point(0, 0));
        SQLRelationship sqlrel = new SQLRelationship();
        sqlrel.attachRelationship(t1, t2, false);
        sqlrel.addMapping(t1.getColumnByName("pkcol_1"), t2.getColumnByName("fkcol"));
        this.rel = new Relationship(this.pp, sqlrel);
    }

    public void testCopyConstructor() {
        PlayPen newpp = new PlayPen(this.pp.getDatabase());
        Relationship rel2 = new Relationship(this.rel, newpp.getContentPane(), null, null);
        TestRelationship.assertNotSame((String)"The new relationship component has the same UI delegate as the original", (Object)this.rel.getUI(), (Object)rel2.getUI());
    }

    public void testHighlightWithRelationshipTypeChange() throws ArchitectException {
        this.rel.setSelected(true);
        TestRelationship.assertEquals((Object)Color.RED, (Object)this.tp1.getColumnHighlight(0));
        TestRelationship.assertEquals((Object)Color.RED, (Object)this.tp2.getColumnHighlight(1));
        TestRelationship.assertEquals((Object)this.tp2.getForeground(), (Object)this.tp2.getColumnHighlight(0));
        this.rel.setSelected(false);
        TestRelationship.assertEquals((Object)this.tp1.getForeground(), (Object)this.tp1.getColumnHighlight(0));
        TestRelationship.assertEquals((Object)this.tp2.getForeground(), (Object)this.tp2.getColumnHighlight(1));
        TestRelationship.assertEquals((Object)this.tp2.getForeground(), (Object)this.tp2.getColumnHighlight(0));
        this.rel.setSelected(true);
        this.rel.getModel().setIdentifying(true);
        TestRelationship.assertEquals((Object)Color.RED, (Object)this.tp1.getColumnHighlight(0));
        SQLColumn fkCol = this.tp2.getModel().getColumnByName("fkcol");
        TestRelationship.assertEquals((int)0, (int)this.tp2.getModel().getColumnIndex(fkCol));
        TestRelationship.assertEquals((Object)Color.RED, (Object)this.tp2.getColumnHighlight(0));
        TestRelationship.assertEquals((Object)this.tp2.getForeground(), (Object)this.tp2.getColumnHighlight(1));
    }

    private void setupRefCountTests(SQLDatabase db, SQLTable pkTable, SQLTable fkTable, SQLRelationship sourceRel) throws ArchitectException {
        pkTable.setName("pkTable");
        pkTable.addColumn(new SQLColumn(pkTable, "PKTableCol1", 4, 1, 0));
        pkTable.addColumn(new SQLColumn(pkTable, "PKTableCol2", 4, 1, 0));
        pkTable.getColumn(0).setPrimaryKeySeq(0);
        db.addChild(pkTable);
        fkTable.setName("child");
        fkTable.addColumn(new SQLColumn(fkTable, "FKTableCol1", 4, 1, 0));
        db.addChild(fkTable);
        sourceRel.addMapping(pkTable.getColumn(0), fkTable.getColumn(0));
        sourceRel.attachRelationship(pkTable, fkTable, true);
    }

    public void testRefCountWithFkTableInsertedFirst() throws ArchitectException {
        SQLDatabase db = new SQLDatabase();
        SQLTable fkTable = new SQLTable(db, true);
        SQLRelationship sourceRel = new SQLRelationship();
        SQLTable pkTable = new SQLTable(db, true);
        this.setupRefCountTests(db, pkTable, fkTable, sourceRel);
        TablePane FkPane = this.pp.importTableCopy(fkTable, new Point(10, 10));
        TablePane PkPane = this.pp.importTableCopy(pkTable, new Point(10, 10));
        TestRelationship.assertEquals((int)2, (int)FkPane.getModel().getColumn(0).getReferenceCount());
        TestRelationship.assertEquals((int)1, (int)PkPane.getModel().getColumn(0).getReferenceCount());
    }

    public void testRefCountWithPkTableInsertedFirst() throws ArchitectException {
        SQLDatabase db = new SQLDatabase();
        SQLTable fkTable = new SQLTable(db, true);
        SQLRelationship sourceRel = new SQLRelationship();
        SQLTable pkTable = new SQLTable(db, true);
        this.setupRefCountTests(db, pkTable, fkTable, sourceRel);
        TablePane PkPane = this.pp.importTableCopy(pkTable, new Point(10, 10));
        TablePane FkPane = this.pp.importTableCopy(fkTable, new Point(10, 10));
        TestRelationship.assertEquals((int)2, (int)FkPane.getModel().getColumn(0).getReferenceCount());
        TestRelationship.assertEquals((int)1, (int)PkPane.getModel().getColumn(0).getReferenceCount());
    }

    public void testRefCountWithMultipleTablesInserted() throws ArchitectException {
        SQLDatabase db = new SQLDatabase();
        SQLTable fkTable = new SQLTable(db, true);
        SQLRelationship sourceRel = new SQLRelationship();
        SQLTable pkTable = new SQLTable(db, true);
        this.setupRefCountTests(db, pkTable, fkTable, sourceRel);
        SQLTable fkTable2 = new SQLTable(db, true);
        fkTable2.addColumn(new SQLColumn(fkTable2, "FKTable2Col1", 4, 1, 0));
        SQLRelationship newRel = new SQLRelationship();
        newRel.addMapping(pkTable.getColumn(0), fkTable2.getColumn(0));
        newRel.attachRelationship(pkTable, fkTable2, true);
        TablePane PkPane = this.pp.importTableCopy(pkTable, new Point(10, 10));
        TablePane FkPane = this.pp.importTableCopy(fkTable, new Point(10, 10));
        TablePane FkPane2 = this.pp.importTableCopy(fkTable2, new Point(10, 10));
        TestRelationship.assertEquals((int)1, (int)PkPane.getModel().getColumn(0).getReferenceCount());
        TestRelationship.assertEquals((int)2, (int)FkPane.getModel().getColumn(0).getReferenceCount());
        TestRelationship.assertEquals((int)2, (int)FkPane2.getModel().getColumn(0).getReferenceCount());
    }
}

