/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.Point;
import junit.framework.TestCase;

public class TestPlayPenContentPane
extends TestCase {
    Relationship rel1;
    Relationship rel2;
    Relationship rel3;
    Relationship rel4;
    TablePane tp1;
    TablePane tp2;
    TablePane tp3;
    PlayPenContentPane ppcp;
    PlayPen pp;

    protected void setUp() throws Exception {
        super.setUp();
        super.setUp();
        this.pp = ArchitectFrame.getMainInstance().getProject().getPlayPen();
        SQLTable t1 = new SQLTable(this.pp.getDatabase(), true);
        this.pp.getDatabase().addChild(t1);
        this.tp1 = new TablePane(t1, this.pp);
        this.pp.addTablePane(this.tp1, new Point(0, -10));
        SQLTable t2 = new SQLTable(this.pp.getDatabase(), true);
        this.pp.getDatabase().addChild(t2);
        this.tp2 = new TablePane(t2, this.pp);
        this.pp.addTablePane(this.tp2, new Point(-10, 0));
        SQLRelationship sqlrel = new SQLRelationship();
        sqlrel.attachRelationship(t1, t2, false);
        this.ppcp = new PlayPenContentPane(this.pp);
        this.rel1 = new Relationship(this.pp, sqlrel);
        this.rel2 = new Relationship(this.pp, sqlrel);
        this.rel3 = new Relationship(this.pp, sqlrel);
        this.rel4 = new Relationship(this.pp, sqlrel);
        this.tp3 = new TablePane(t1, this.pp);
    }

    public void testGetFirstRelationIndex() {
        TestPlayPenContentPane.assertEquals((String)"The children list is not size 0", (int)0, (int)this.ppcp.getFirstRelationIndex());
        this.ppcp.add(this.rel1, 0);
        TestPlayPenContentPane.assertEquals((String)"The relation was added as a non-relation", (int)0, (int)this.ppcp.getFirstRelationIndex());
        this.ppcp.add(this.rel2, 0);
        this.ppcp.add(this.tp1, 0);
        TestPlayPenContentPane.assertEquals((String)"There should be 1 non relations in the list", (int)1, (int)this.ppcp.getFirstRelationIndex());
        this.ppcp.remove(this.tp1);
        TestPlayPenContentPane.assertEquals((String)"There should be 0 non relations in the list", (int)0, (int)this.ppcp.getFirstRelationIndex());
        this.ppcp.remove(this.rel2);
        TestPlayPenContentPane.assertEquals((String)"Removing a relation should not effect the index of the first relation", (int)0, (int)this.ppcp.getFirstRelationIndex());
    }

    public void testGetComponentCount() {
        TestPlayPenContentPane.assertEquals((String)"The children list is not size 0", (int)0, (int)this.ppcp.getComponentCount());
        this.ppcp.add(this.rel1, 0);
        TestPlayPenContentPane.assertEquals((String)"The relation was not added to the list properly", (int)1, (int)this.ppcp.getComponentCount());
        this.ppcp.add(this.rel2, 0);
        this.ppcp.add(this.tp1, 0);
        TestPlayPenContentPane.assertEquals((String)"There should be 3 components in the list", (int)3, (int)this.ppcp.getComponentCount());
        this.ppcp.remove(this.tp1);
        TestPlayPenContentPane.assertEquals((String)"Removing a non relationship gives an incorrect component count", (int)2, (int)this.ppcp.getComponentCount());
        this.ppcp.remove(this.rel2);
        TestPlayPenContentPane.assertEquals((String)"Removing a relation gives an incorrect component count", (int)1, (int)this.ppcp.getComponentCount());
    }
}

