/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ColumnEditPanel;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.SQLType;
import ca.sqlpower.architect.swingui.TablePane;
import junit.framework.TestCase;

public class TestColumnEditPanel
extends TestCase {
    SQLDatabase db;
    SQLTable table;
    SQLColumn col1;
    SQLColumn col2;
    SQLColumn col3;
    SQLColumn col4;
    SQLTable table2;
    ColumnEditPanel panel;

    protected void setUp() throws Exception {
        this.db = new SQLDatabase();
        this.table = new SQLTable(this.db, "Table1", "remark1", "Table", true);
        this.table2 = new SQLTable(this.db, "Table2", "remark2", "Table", true);
        this.db.addChild(0, this.table);
        this.col1 = new SQLColumn(null, "Column 1", 1, 2, 3);
        this.col2 = new SQLColumn(null, "Column 2", 2, 3, 4);
        this.col3 = new SQLColumn(null, "Column 3", 1, 2, 3);
        this.col4 = new SQLColumn(null, "Column 4", 1, 2, 3);
        this.col2.setAutoIncrement(false);
        this.col2.setNullable(0);
        this.col2.setPrimaryKeySeq(0);
        this.table.addColumn(this.col1);
        this.table.addColumn(this.col2);
        this.table.addColumn(this.col3);
        this.table2.addColumn(this.col4);
        this.panel = new ColumnEditPanel(this.col2);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.db = null;
        this.table = null;
        this.col1 = null;
        this.col2 = null;
        this.col3 = null;
        this.col4 = null;
        super.tearDown();
    }

    public void testEditColumn() throws ArchitectException {
        TestColumnEditPanel.assertEquals((int)2, (int)this.table.getColumnIndex(this.col3));
        TestColumnEditPanel.assertEquals((String)"The column we plan to edit should not be in PK", null, (Object)this.col3.getPrimaryKeySeq());
        this.panel.editColumn(this.col3);
        TestColumnEditPanel.assertEquals((String)"Wrong column name", (String)this.col3.getName(), (String)this.panel.getColName().getText());
        TestColumnEditPanel.assertEquals((String)"Wrong Precision", (int)this.col3.getPrecision(), (int)((Integer)this.panel.getColPrec().getValue()));
        TestColumnEditPanel.assertEquals((String)"Wrong type", (int)this.col3.getType(), (int)((SQLType)this.panel.getColType().getSelectedItem()).getType());
        TestColumnEditPanel.assertEquals((String)"Wrong Scale", (int)this.col3.getScale(), (int)((Integer)this.panel.getColScale().getValue()));
        TestColumnEditPanel.assertEquals((boolean)this.col3.isAutoIncrement(), (boolean)this.panel.getColAutoInc().getModel().isSelected());
        TestColumnEditPanel.assertEquals((boolean)this.col3.isPrimaryKey(), (boolean)this.panel.getColInPK().getModel().isSelected());
        TestColumnEditPanel.assertEquals((this.col3.getNullable() == 1 ? 1 : 0) != 0, (boolean)this.panel.getColNullable().getModel().isSelected());
        TestColumnEditPanel.assertEquals((String)"None Specified", (String)this.panel.getSourceDB().getText());
        TestColumnEditPanel.assertEquals((String)"None Specified", (String)this.panel.getSourceTableCol().getText());
        this.panel.editColumn(this.col2);
        TestColumnEditPanel.assertEquals((String)"Wrong column name", (String)this.col2.getName(), (String)this.panel.getColName().getText());
        TestColumnEditPanel.assertEquals((String)"Wrong Precision", (int)this.col2.getPrecision(), (int)((Integer)this.panel.getColPrec().getValue()));
        TestColumnEditPanel.assertEquals((String)"Wrong type", (int)this.col2.getType(), (int)((SQLType)this.panel.getColType().getSelectedItem()).getType());
        TestColumnEditPanel.assertEquals((String)"Wrong Scale", (int)this.col2.getScale(), (int)((Integer)this.panel.getColScale().getValue()));
        TestColumnEditPanel.assertEquals((boolean)this.col2.isAutoIncrement(), (boolean)this.panel.getColAutoInc().getModel().isSelected());
        TestColumnEditPanel.assertEquals((boolean)this.col2.isPrimaryKey(), (boolean)this.panel.getColInPK().getModel().isSelected());
        TestColumnEditPanel.assertEquals((this.col2.getNullable() == 1 ? 1 : 0) != 0, (boolean)this.panel.getColNullable().getModel().isSelected());
        TestColumnEditPanel.assertEquals((String)"None Specified", (String)this.panel.getSourceDB().getText());
        TestColumnEditPanel.assertEquals((String)"None Specified", (String)this.panel.getSourceTableCol().getText());
    }

    public void testApplyChanges() {
        this.panel.getColName().setText("CHANGED");
        this.panel.getColPrec().setValue(new Integer(1234));
        this.panel.getColType().setSelectedIndex(5);
        this.panel.getColScale().setValue(new Integer(5432));
        this.panel.getColInPK().getModel().setSelected(true);
        this.panel.getColAutoInc().getModel().setSelected(true);
        this.panel.getColNullable().getModel().setSelected(true);
        this.panel.applyChanges();
        TestColumnEditPanel.assertEquals((String)"Panel check boxes borked", (boolean)true, (boolean)this.panel.getColAutoInc().getModel().isSelected());
        TestColumnEditPanel.assertEquals((String)"Wrong column name", (String)"CHANGED", (String)this.col2.getName());
        TestColumnEditPanel.assertEquals((String)"Wrong Precision", (int)1234, (int)this.col2.getPrecision());
        TestColumnEditPanel.assertEquals((String)"Wrong type", (int)1, (int)this.col2.getType());
        TestColumnEditPanel.assertEquals((String)"Wrong Scale", (int)5432, (int)this.col2.getScale());
        TestColumnEditPanel.assertTrue((boolean)this.col2.isAutoIncrement());
        TestColumnEditPanel.assertTrue((boolean)this.col2.isPrimaryKey());
        TestColumnEditPanel.assertTrue((boolean)this.col2.isDefinitelyNullable());
    }

    public void testDiscardChanges() {
        this.panel.getColName().setText("CHANGED");
        this.panel.getColPrec().setValue(new Integer(1234));
        this.panel.getColType().setSelectedIndex(5);
        this.panel.getColScale().setValue(new Integer(5432));
        this.panel.getColAutoInc().getModel().setSelected(true);
        this.panel.getColInPK().getModel().setSelected(true);
        this.panel.getColNullable().getModel().setSelected(true);
        this.panel.discardChanges();
        TestColumnEditPanel.assertEquals((String)"Wrong column name", (String)"Column 2", (String)this.col2.getName());
        TestColumnEditPanel.assertEquals((String)"Wrong Precision", (int)3, (int)this.col2.getPrecision());
        TestColumnEditPanel.assertEquals((String)"Wrong type", (int)2, (int)this.col2.getType());
        TestColumnEditPanel.assertEquals((String)"Wrong Scale", (int)4, (int)this.col2.getScale());
        TestColumnEditPanel.assertFalse((boolean)this.col2.isAutoIncrement());
        TestColumnEditPanel.assertFalse((boolean)this.col2.isPrimaryKey());
        TestColumnEditPanel.assertFalse((boolean)this.col2.isDefinitelyNullable());
    }

    public void testPKColumnMoveRegression() throws ArchitectException {
        SQLColumn c1 = new SQLColumn(this.table, "PKColumn 1", 1, 2, 3);
        SQLColumn c2 = new SQLColumn(this.table, "PKColumn 2", 1, 2, 3);
        this.table.addColumn(c1);
        this.table.addColumn(c2);
        c1.setPrimaryKeySeq(0);
        c2.setPrimaryKeySeq(1);
        TestColumnEditPanel.assertEquals((int)5, (int)this.table.getColumns().size());
        TestColumnEditPanel.assertTrue((boolean)c1.isPrimaryKey());
        TestColumnEditPanel.assertTrue((boolean)c1.isPrimaryKey());
        int previousIdx = this.table.getColumnIndex(this.table.getColumnByName("PKColumn 1"));
        ColumnEditPanel editPanel = new ColumnEditPanel(c1);
        editPanel.applyChanges();
        TestColumnEditPanel.assertEquals((int)previousIdx, (int)this.table.getColumnIndex(this.table.getColumnByName("PKColumn 1")));
    }

    public void testColumnStaysSelectedWhenMovedToPK() throws ArchitectException {
        PlayPen pp = new PlayPen(this.db);
        TablePane tp = new TablePane(this.table, pp);
        tp.setSelected(true);
        tp.selectColumn(this.table.getColumnIndex(this.col3));
        ColumnEditPanel ce = new ColumnEditPanel(this.col3);
        ce.getColInPK().setSelected(true);
        ce.applyChanges();
        TestColumnEditPanel.assertEquals((int)this.table.getColumnIndex(this.col3), (int)tp.getSelectedColumnIndex());
    }

    public void testDenyEmptyColumnName() {
        TestColumnEditPanel.fail((String)"This test is disabled due to sucky design");
        this.panel.getColName().setText("");
        try {
            this.panel.applyChanges();
            TestColumnEditPanel.fail((String)"Having an empty column name should throw exception!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

