/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TableEditPanel
extends JPanel
implements ArchitectPanel {
    protected SQLTable table;
    JTextField name;
    JTextField pkName;
    JTextArea remarks;
    protected LinkedList<UndoCompoundEventListener> undoEventListeners = new LinkedList();

    public TableEditPanel(SQLTable t) {
        super(new FormLayout());
        this.addUndoEventListener(ArchitectFrame.getMainInstance().getProject().getUndoManager().getEventAdapter());
        this.add(new JLabel("Table Name"));
        this.name = new JTextField("", 30);
        this.add(this.name);
        this.add(new JLabel("Primary Key Name"));
        this.pkName = new JTextField("", 30);
        this.add(this.pkName);
        this.add(new JLabel("Remarks"));
        this.remarks = new JTextArea(4, 30);
        this.add(new JScrollPane(this.remarks));
        this.remarks.setLineWrap(true);
        this.remarks.setWrapStyleWord(true);
        this.editTable(t);
    }

    public void editTable(SQLTable t) {
        this.table = t;
        this.name.setText(t.getName());
        this.pkName.setText(t.getPrimaryKeyName());
        this.remarks.setText(t.getRemarks());
    }

    public boolean applyChanges() {
        this.startCompoundEdit("Table Properties Change");
        try {
            StringBuffer warnings = new StringBuffer();
            if (this.name.getText().trim().length() == 0) {
                warnings.append("The table cannot be assigned a blank name \n");
            }
            if (this.pkName.getText().trim().length() == 0) {
                warnings.append("The primary key cannot be assigned a blank name");
            }
            if (warnings.toString().length() == 0) {
                this.table.setName(this.name.getText());
                this.table.setPrimaryKeyName(this.pkName.getText());
                this.table.setRemarks(this.remarks.getText());
                return true;
            }
            JOptionPane.showMessageDialog(this, warnings.toString());
            return false;
        }
        finally {
            this.endCompoundEdit("Ending new compound edit event in table edit panel");
        }
    }

    public void discardChanges() {
    }

    public void addUndoEventListener(UndoCompoundEventListener l) {
        this.undoEventListeners.add(l);
    }

    public void removeUndoEventListener(UndoCompoundEventListener l) {
        this.undoEventListeners.remove(l);
    }

    /*
     * Unable to fully structure code
     */
    protected void fireUndoCompoundEvent(UndoCompoundEvent e) {
        block2: {
            it = this.undoEventListeners.iterator();
            if (!e.getType().isStartEvent()) ** GOTO lbl8
            while (it.hasNext()) {
                ((UndoCompoundEventListener)it.next()).compoundEditStart(e);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                ((UndoCompoundEventListener)it.next()).compoundEditEnd(e);
lbl8:
                // 2 sources

                ** while (it.hasNext())
            }
        }
    }

    public void startCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_START, message));
    }

    public void endCompoundEdit(String message) {
        this.fireUndoCompoundEvent(new UndoCompoundEvent((Object)this, UndoCompoundEvent.EventTypes.COMPOUND_EDIT_END, message));
    }

    public JPanel getPanel() {
        return this;
    }

    public String getNameText() {
        return this.name.getText();
    }

    public void setNameText(String newName) {
        this.name.setText(newName);
    }
}

