/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.CommonCloseAction;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.JDefaultButton;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class SearchReplace {
    private static final Logger logger = Logger.getLogger(SearchReplace.class);
    private JRadioButton substringMatch;
    private JRadioButton exactMatch;
    private JRadioButton regexMatch;
    private JRadioButton tableSearch;
    private JRadioButton relationshipSearch;
    private JRadioButton columnSearch;
    private JRadioButton allSearch;
    private JTextField searchExpression;
    private JCheckBox caseInsensitive;

    public void showSearchDialog(final PlayPen pp) {
        final JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(JFrame.class, pp), "Find");
        ButtonGroup matchType = new ButtonGroup();
        this.substringMatch = new JRadioButton("Substring");
        matchType.add(this.substringMatch);
        this.exactMatch = new JRadioButton("Exact Match");
        matchType.add(this.exactMatch);
        this.regexMatch = new JRadioButton("Regex");
        matchType.add(this.regexMatch);
        JPanel matchTypePanel = new JPanel(new GridLayout(1, 3));
        matchTypePanel.add(this.substringMatch);
        matchTypePanel.add(this.exactMatch);
        matchTypePanel.add(this.regexMatch);
        this.substringMatch.setSelected(true);
        ButtonGroup searchType = new ButtonGroup();
        this.tableSearch = new JRadioButton("Tables");
        searchType.add(this.tableSearch);
        this.relationshipSearch = new JRadioButton("Relationships");
        searchType.add(this.relationshipSearch);
        this.columnSearch = new JRadioButton("Columns");
        searchType.add(this.columnSearch);
        this.allSearch = new JRadioButton("Anything");
        searchType.add(this.allSearch);
        JPanel searchTypePanel = new JPanel(new GridLayout(4, 1));
        searchTypePanel.add(this.tableSearch);
        searchTypePanel.add(this.relationshipSearch);
        searchTypePanel.add(this.columnSearch);
        searchTypePanel.add(this.allSearch);
        this.allSearch.setSelected(true);
        this.caseInsensitive = new JCheckBox("Ignoring case");
        this.caseInsensitive.setSelected(true);
        this.searchExpression = new JTextField();
        JDefaultButton searchButton = new JDefaultButton("Search");
        searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    SearchReplace.this.showResults(d, pp);
                }
                catch (ArchitectException ex) {
                    ASUtils.showExceptionDialog("Encountered a problem during search", ex);
                }
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                d.setVisible(false);
                d.dispose();
            }
        };
        cancelAction.putValue("Name", "Cancel");
        JButton cancelButton = new JButton(cancelAction);
        ASUtils.makeJDialogCancellable(d, cancelAction);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(searchButton);
        buttonPanel.add(cancelButton);
        JComponent cp = (JComponent)d.getContentPane();
        cp.setLayout(new FormLayout(10, 10));
        cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        cp.add(new JLabel("Look for"));
        cp.add(searchTypePanel);
        cp.add(new JLabel("Named"));
        cp.add(this.searchExpression);
        cp.add(new JLabel("Comparing by"));
        cp.add(matchTypePanel);
        cp.add(new JLabel(""));
        cp.add(this.caseInsensitive);
        cp.add(new JLabel(""));
        cp.add(buttonPanel);
        d.getRootPane().setDefaultButton(searchButton);
        d.pack();
        d.setLocationRelativeTo(pp);
        d.setVisible(true);
        this.searchExpression.requestFocus();
    }

    public void showResults(JDialog parent, final PlayPen pp) throws ArchitectException {
        try {
            final List results = this.doSearch(pp.getDatabase());
            final JDialog d = new JDialog((Dialog)parent, "Search Results");
            final JTable t = new JTable(new SearchResultsTableModel(results));
            final JButton renameButton = new JButton("Rename Selected...");
            renameButton.setEnabled(false);
            renameButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String newName = JOptionPane.showInputDialog(d, (Object)"Enter the new name");
                    TableModel m = t.getModel();
                    int[] selectedRows = t.getSelectedRows();
                    int i = 0;
                    while (i < selectedRows.length) {
                        if (newName != null) {
                            m.setValueAt(newName, selectedRows[i], 1);
                        }
                        ++i;
                    }
                }
            });
            final JButton gotoButton = new JButton("Show in Playpen");
            gotoButton.setEnabled(false);
            gotoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int row = t.getSelectedRow();
                    if (row >= 0) {
                        Relationship r;
                        SQLObject searchObj = (SQLObject)results.get(row);
                        SQLTable searchTable = null;
                        SQLColumn searchColumn = null;
                        SQLRelationship searchRelationship = null;
                        if (searchObj instanceof SQLColumn) {
                            searchColumn = (SQLColumn)searchObj;
                            searchTable = searchColumn.getParentTable();
                        } else if (searchObj instanceof SQLTable) {
                            searchTable = (SQLTable)searchObj;
                        } else if (searchObj instanceof SQLRelationship) {
                            searchRelationship = (SQLRelationship)searchObj;
                        } else {
                            JOptionPane.showMessageDialog(null, "Sorry, the selected search result is of an unknown type!");
                            return;
                        }
                        if (searchTable != null) {
                            TablePane tp = pp.findTablePane(searchTable);
                            if (tp != null) {
                                pp.selectNone();
                                tp.setSelected(true);
                                pp.scrollRectToVisible(tp.getBounds());
                                if (searchColumn != null) {
                                    try {
                                        tp.selectColumn(searchTable.getColumnIndex(searchColumn));
                                    }
                                    catch (ArchitectException ex) {
                                        logger.error((Object)"Failed to select column becuase getColumnIndex threw the following exception:", (Throwable)ex);
                                        JOptionPane.showMessageDialog(null, "Sorry, couldn't select the column you asked for.\n\nMore information is available in the application log.");
                                    }
                                }
                            }
                        } else if (searchRelationship != null && (r = pp.findRelationship(searchRelationship)) != null) {
                            pp.selectNone();
                            r.setSelected(true);
                            pp.scrollRectToVisible(r.getBounds());
                        }
                    }
                }
            });
            CommonCloseAction closeAction = new CommonCloseAction(d);
            JButton closeButton = new JButton(closeAction);
            ASUtils.makeJDialogCancellable(d, closeAction);
            ListSelectionListener buttonActivator = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    renameButton.setEnabled(t.getSelectedRowCount() > 0);
                    gotoButton.setEnabled(t.getSelectedRowCount() == 1);
                }
            };
            t.getSelectionModel().addListSelectionListener(buttonActivator);
            JComponent cp = (JComponent)d.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)new JScrollPane(t), "Center");
            Box buttonBox = new Box(1);
            buttonBox.add(renameButton);
            buttonBox.add(gotoButton);
            buttonBox.add(Box.createVerticalGlue());
            buttonBox.add(closeButton);
            cp.add((Component)buttonBox, "East");
            d.pack();
            d.setLocationRelativeTo(parent);
            d.setVisible(true);
        }
        catch (PatternSyntaxException e) {
            JOptionPane.showMessageDialog(null, e.getDescription(), "Regular Expression Error", 1);
        }
    }

    public List doSearch(SQLObject start) throws ArchitectException {
        String pat;
        ArrayList results = new ArrayList();
        if (this.substringMatch.isSelected() || this.exactMatch.isSelected()) {
            String p = this.searchExpression.getText();
            StringBuffer escapedPat = new StringBuffer();
            int i = 0;
            while (i < p.length()) {
                if (!Character.isLetterOrDigit(p.charAt(i)) && !Character.isSpaceChar(p.charAt(i))) {
                    escapedPat.append("\\");
                }
                escapedPat.append(p.charAt(i));
                ++i;
            }
            pat = this.exactMatch.isSelected() ? "^" + escapedPat + "$" : ".*" + escapedPat + ".*";
        } else if (this.regexMatch.isSelected()) {
            pat = this.searchExpression.getText();
        } else {
            throw new IllegalStateException("Search mode is not substring, exact, or regex.  Don't know what to do.");
        }
        int patternFlags = 0;
        if (this.caseInsensitive.isSelected()) {
            patternFlags |= 0x42;
        }
        Pattern searchPattern = Pattern.compile(pat, patternFlags);
        return this.recursiveSearch(start, searchPattern, results);
    }

    private List recursiveSearch(SQLObject obj, Pattern searchPattern, List appendTo) throws ArchitectException {
        List children;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Matching \"" + obj.getName() + "\" against /" + searchPattern.pattern() + "/"));
        }
        if (searchPattern.matcher(obj.getName()).matches() && this.searchTypeMatches(obj)) {
            appendTo.add(obj);
        }
        if ((children = obj.getChildren()) != null) {
            for (SQLObject so : children) {
                this.recursiveSearch(so, searchPattern, appendTo);
            }
        }
        return appendTo;
    }

    private boolean searchTypeMatches(SQLObject obj) {
        if (this.allSearch.isSelected() && !(obj instanceof SQLTable.Folder)) {
            return true;
        }
        if (this.tableSearch.isSelected() && obj instanceof SQLTable) {
            return true;
        }
        if (this.columnSearch.isSelected() && obj instanceof SQLColumn) {
            return true;
        }
        return this.relationshipSearch.isSelected() && obj instanceof SQLRelationship;
    }

    public String getSearchExpressionText() {
        return this.searchExpression.getText();
    }

    public void setSearchExpression(String searchExpressionText) {
        this.searchExpression.setText(searchExpressionText);
    }

    private class SearchResultsTableModel
    implements TableModel {
        private List results;
        private ArrayList listeners = new ArrayList();

        public SearchResultsTableModel(List results) {
            this.results = results;
            this.results.remove(ArchitectFrame.getMainInstance().playpen.getDatabase());
        }

        public int getRowCount() {
            return this.results.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Type";
            }
            if (columnIndex == 1) {
                return "Name";
            }
            return "Invalid column index: " + columnIndex;
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            SQLObject obj = (SQLObject)this.results.get(rowIndex);
            return columnIndex == 1 && (obj instanceof SQLTable || obj instanceof SQLColumn || obj instanceof SQLRelationship);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            SQLObject obj = (SQLObject)this.results.get(rowIndex);
            if (columnIndex == 0) {
                if (obj instanceof SQLColumn) {
                    return "Column of " + ((SQLColumn)obj).getParentTable().getName();
                }
                String className = obj.getClass().getName();
                return className.substring(className.lastIndexOf(46) + 4);
            }
            if (columnIndex == 1) {
                return obj.getName();
            }
            return "Invalid column: " + columnIndex;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SQLObject obj = (SQLObject)this.results.get(rowIndex);
            if (columnIndex == 1) {
                if (obj instanceof SQLTable) {
                    ((SQLTable)obj).setName((String)aValue);
                } else if (obj instanceof SQLColumn) {
                    ((SQLColumn)obj).setName((String)aValue);
                } else if (obj instanceof SQLRelationship) {
                    ((SQLRelationship)obj).setName((String)aValue);
                }
                this.fireEvent(new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0));
            }
        }

        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        private void fireEvent(TableModelEvent evt) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ((TableModelListener)it.next()).tableChanged(evt);
            }
        }
    }
}

