/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.swingui.Monitorable;
import ca.sqlpower.architect.swingui.event.TaskTerminationEvent;
import ca.sqlpower.architect.swingui.event.TaskTerminationListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class ProgressWatcher
implements ActionListener {
    private JProgressBar bar = null;
    private ProgressMonitor pm = null;
    private Monitorable monitorable = null;
    private JLabel label = null;
    private Timer timer;
    private List taskTerminationListeners = new ArrayList();
    private static final Logger logger = Logger.getLogger(ProgressWatcher.class);

    public ProgressWatcher() {
    }

    public ProgressWatcher(JProgressBar bar, Monitorable monitorable) {
        this(bar, monitorable, null);
    }

    public ProgressWatcher(JProgressBar bar, Monitorable monitorable, JLabel label) {
        this();
        this.bar = bar;
        this.monitorable = monitorable;
        this.label = label;
        this.timer = new Timer(50, this);
        this.timer.start();
    }

    public ProgressWatcher(ProgressMonitor pm, Monitorable monitorable) {
        this();
        this.pm = pm;
        this.monitorable = monitorable;
        this.timer = new Timer(50, this);
        this.timer.start();
    }

    public void addTaskTerminationListener(TaskTerminationListener ttl) {
        this.taskTerminationListeners.add(ttl);
    }

    public void removeTaskTerminationListener(TaskTerminationListener ttl) {
        this.taskTerminationListeners.remove(ttl);
    }

    private void fireTaskFinished() {
        TaskTerminationEvent tte = new TaskTerminationEvent(this);
        for (TaskTerminationListener ttl : this.taskTerminationListeners) {
            ttl.taskFinished(tte);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        logger.debug((Object)"updating progress bar...");
        try {
            try {
                Integer jobSize = this.monitorable.getJobSize();
                if (this.bar != null) {
                    if (this.monitorable.hasStarted()) {
                        if (jobSize == null) {
                            this.bar.setIndeterminate(true);
                        } else {
                            this.bar.setIndeterminate(false);
                            this.bar.setMaximum(jobSize);
                            this.bar.setValue(this.monitorable.getProgress());
                        }
                        this.bar.setVisible(true);
                    }
                    if (this.monitorable.isFinished()) {
                        this.bar.setVisible(false);
                    }
                }
                if (this.label != null) {
                    this.label.setVisible(true);
                }
                if (this.pm != null && this.monitorable.hasStarted()) {
                    if (jobSize != null) {
                        this.pm.setMaximum(jobSize);
                    }
                    this.pm.setProgress(this.monitorable.getProgress());
                    logger.debug((Object)("progress: " + this.monitorable.getProgress()));
                    this.pm.setNote(this.monitorable.getMessage());
                }
            }
            catch (ArchitectException e) {
                logger.error((Object)"Couldn't update progress bar (Monitorable threw an exception)", (Throwable)e);
            }
        }
        finally {
            try {
                logger.debug((Object)("monitorable.isFinished():" + this.monitorable.isFinished()));
                if (this.monitorable.isFinished()) {
                    if (this.label != null) {
                        this.label.setText("");
                    }
                    if (this.bar != null) {
                        this.bar.setValue(0);
                    }
                    if (this.pm != null) {
                        logger.debug((Object)("pm done, max was: " + this.pm.getMaximum()));
                        this.pm.close();
                    }
                    this.fireTaskFinished();
                    logger.debug((Object)"trying to stop timer thread...");
                    this.timer.stop();
                    logger.debug((Object)"did the timer thread stop???");
                }
            }
            catch (ArchitectException e1) {
                logger.error((Object)"Couldn't tell if Monitorable was finished (it threw an exception)", (Throwable)e1);
            }
        }
    }
}

