/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.event.PlayPenComponentEvent;
import ca.sqlpower.architect.swingui.event.PlayPenComponentListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public abstract class PlayPenComponent
implements Selectable {
    private static final Logger logger = Logger.getLogger(PlayPenComponent.class);
    private PlayPenContentPane parent;
    private Rectangle bounds = new Rectangle();
    private Color backgroundColor;
    private Insets insets = new Insets(0, 0, 0, 0);
    private String name;
    private Color foregroundColor;
    private String toolTipText;
    private boolean opaque;
    private PlayPenComponentUI ui;
    private List propertyChangeListeners = new ArrayList();
    private List playPenComponentListeners = new ArrayList();

    protected PlayPenComponent(PlayPenContentPane parent) {
        this.parent = parent;
    }

    public PlayPen getPlayPen() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getOwner();
    }

    public PlayPenComponentUI getUI() {
        return this.ui;
    }

    public void setUI(PlayPenComponentUI ui) {
        this.ui = ui;
        this.revalidate();
    }

    public void showPopup(JPopupMenu menu, Point p) {
        int xAdjust = 5;
        p.translate(this.getX(), this.getY());
        this.getPlayPen().zoomPoint(p);
        menu.show(this.getPlayPen(), p.x + 5, p.y);
    }

    public void revalidate() {
        PlayPen pp = this.getPlayPen();
        if (pp == null) {
            logger.debug((Object)"getPlayPen() returned null.  Not generating repaint request.");
            return;
        }
        Rectangle r = new Rectangle(this.bounds);
        PlayPenComponentUI ui = this.getUI();
        if (ui != null) {
            ui.revalidate();
            Dimension ps = ui.getPreferredSize();
            if (ps != null) {
                this.setSize(ps);
            }
        }
        pp.zoomRect(r);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scheduling repaint at " + r));
        }
        pp.repaint(r);
    }

    protected void setBoundsImpl(int x, int y, int width, int height) {
        Rectangle oldBounds = this.getBounds();
        PlayPen owner = this.getPlayPen();
        if (owner != null) {
            Rectangle r = this.getBounds();
            double zoom = owner.getZoom();
            owner.repaint((int)Math.floor((double)r.x * zoom), (int)Math.floor((double)r.y * zoom), (int)Math.ceil((double)r.width * zoom), (int)Math.ceil((double)r.height * zoom));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u001b[36mUpdating bounds on " + this.getName() + " to [" + x + "," + y + "," + width + "," + height + "]\u001b[0m"));
        }
        Point oldPoint = new Point(this.bounds.x, this.bounds.y);
        this.bounds.setBounds(x, y, width, height);
        if (oldBounds.x != x || oldBounds.y != y) {
            this.firePlayPenComponentMoved(oldPoint, new Point(x, y));
        }
        if (oldBounds.width != width || oldBounds.height != height) {
            this.firePlayPenComponentResized();
        }
        this.repaint();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBoundsImpl(x, y, width, height);
    }

    public Rectangle getBounds() {
        return this.getBounds(null);
    }

    public Rectangle getBounds(Rectangle r) {
        if (r == null) {
            r = new Rectangle();
        }
        r.setBounds(this.bounds);
        return r;
    }

    public Dimension getSize() {
        return new Dimension(this.bounds.width, this.bounds.height);
    }

    public Point getPreferredLocation() {
        return this.getLocation();
    }

    public Point getLocation() {
        return this.getLocation(null);
    }

    public Point getLocation(Point p) {
        if (p == null) {
            p = new Point();
        }
        p.x = this.bounds.x;
        p.y = this.bounds.y;
        return p;
    }

    public void setLocation(Point point) {
        this.setBoundsImpl(point.x, point.y, this.getWidth(), this.getHeight());
    }

    public void setLocation(int x, int y) {
        this.setBoundsImpl(x, y, this.getWidth(), this.getHeight());
    }

    public void setSize(Dimension size) {
        this.setBoundsImpl(this.getX(), this.getY(), size.width, size.height);
    }

    public void repaint() {
        this.repaint(this.getBounds());
    }

    public void repaint(Rectangle r) {
        this.repaint(0L, r.x, r.y, r.width, r.height);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.remove(l);
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(this, propName, oldValue, newValue);
        Iterator it = this.propertyChangeListeners.iterator();
        while (it.hasNext()) {
            ((PropertyChangeListener)it.next()).propertyChange(e);
        }
    }

    protected void firePropertyChange(String propName, int oldValue, int newValue) {
        this.firePropertyChange(propName, new Integer(oldValue), new Integer(newValue));
    }

    public void addPlayPenComponentListener(PlayPenComponentListener l) {
        this.playPenComponentListeners.add(l);
    }

    public void removePlayPenComponentListener(PlayPenComponentListener l) {
        this.playPenComponentListeners.remove(l);
    }

    protected void firePlayPenComponentMoved(Point oldPoint, Point newPoint) {
        PlayPenComponentEvent e = new PlayPenComponentEvent(this, oldPoint, newPoint);
        Iterator it = this.playPenComponentListeners.iterator();
        while (it.hasNext()) {
            ((PlayPenComponentListener)it.next()).componentMoved(e);
        }
    }

    protected void firePlayPenComponentResized() {
        PlayPenComponentEvent e = new PlayPenComponentEvent(this);
        Iterator it = this.playPenComponentListeners.iterator();
        while (it.hasNext()) {
            ((PlayPenComponentListener)it.next()).componentResized(e);
        }
    }

    public int getX() {
        return this.bounds.x;
    }

    public int getY() {
        return this.bounds.y;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Insets getInsets() {
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    public void setInsets(Insets insets) {
        this.insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        PlayPen owner = this.getPlayPen();
        if (owner == null) {
            return;
        }
        double zoom = owner.getZoom();
        owner.repaint((int)Math.floor((double)x * zoom), (int)Math.floor((double)y * zoom), (int)Math.ceil((double)width * zoom), (int)Math.ceil((double)height * zoom));
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
        this.revalidate();
    }

    public Color getBackground() {
        if (this.backgroundColor == null) {
            return this.getPlayPen().getBackground();
        }
        return this.backgroundColor;
    }

    public void setBackground(Color c) {
        this.backgroundColor = c;
        this.revalidate();
    }

    public Color getForeground() {
        if (this.foregroundColor == null) {
            return this.getPlayPen().getForeground();
        }
        return this.foregroundColor;
    }

    public void setForeground(Color c) {
        this.foregroundColor = c;
        this.revalidate();
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        if (toolTipText == null && this.toolTipText == null) {
            return;
        }
        if (toolTipText != null && toolTipText.equals(this.toolTipText)) {
            return;
        }
        this.toolTipText = toolTipText;
        logger.debug((Object)("ToolTipText changed to " + toolTipText));
    }

    public Font getFont() {
        return this.getPlayPen().getFont();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.getPlayPen().getFontMetrics(f);
    }

    public FontRenderContext getFontRenderContext() {
        return this.getPlayPen().getFontRenderContext();
    }

    public boolean contains(Point p) {
        return this.getUI().contains(p);
    }

    public void paint(Graphics2D g2) {
        this.getUI().paint(g2);
    }

    public Dimension getPreferredSize() {
        return this.getUI().getPreferredSize();
    }

    public abstract Object getModel();
}

