/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.Monitorable;
import ca.sqlpower.architect.swingui.ProgressWatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDriverPanel
extends JPanel
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(JDBCDriverPanel.class);
    protected ArchitectSession session;
    protected JTree driverTree;
    protected DefaultTreeModel dtm;
    JFileChooser fileChooser;
    protected JProgressBar progressBar;
    protected Timer timer;
    protected boolean doneLoadingJDBC;
    protected JLabel progressLabel;
    protected JButton addButton;
    protected JButton delButton;
    DefaultMutableTreeNode rootNode;

    public JDBCDriverPanel(ArchitectSession session) {
        this.session = session;
        this.setup();
        try {
            this.dtm.setRoot(new DefaultMutableTreeNode());
            this.doLoad(session.getDriverJarList());
        }
        catch (ArchitectException e) {
            logger.error((Object)"revertToUserSettings failed.", (Throwable)e);
        }
    }

    public void setup() {
        this.fileChooser = new JFileChooser();
        this.setLayout(new BorderLayout());
        this.rootNode = new DefaultMutableTreeNode("The Root");
        this.dtm = new DefaultTreeModel(this.rootNode);
        this.driverTree = new JTree(this.dtm);
        this.driverTree.setRootVisible(false);
        this.driverTree.getSelectionModel().setSelectionMode(4);
        this.driverTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                JDBCDriverPanel.this.delButton.setEnabled(true);
            }
        });
        this.add((Component)new JScrollPane(this.driverTree), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.addButton = new JButton(new AddAction());
        buttonPanel.add(this.addButton);
        this.delButton = new JButton(new DelAction());
        buttonPanel.add(this.delButton);
        this.delButton.setEnabled(false);
        this.add((Component)buttonPanel, "South");
        JPanel progressPanel = new JPanel(new FlowLayout(1));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        progressPanel.add(this.progressBar);
        this.progressLabel = new JLabel("Scanning for JDBC Drivers...");
        this.progressLabel.setVisible(false);
        progressPanel.add(this.progressLabel);
        this.add((Component)progressPanel, "North");
    }

    @Override
    public boolean applyChanges() {
        logger.debug((Object)"applyChanges");
        this.session.clearDriverJarList();
        int i = 0;
        int n = this.dtm.getChildCount(this.dtm.getRoot());
        while (i < n) {
            this.session.addDriverJar(((DefaultMutableTreeNode)this.dtm.getChild(this.dtm.getRoot(), i)).getUserObject().toString());
            ++i;
        }
        return true;
    }

    @Override
    public void discardChanges() {
    }

    private void doLoad(List<String> list) throws ArchitectException {
        LoadJDBCDrivers ljd = new LoadJDBCDrivers(list);
        LoadJDBCDriversWorker worker = new LoadJDBCDriversWorker(ljd);
        new ProgressWatcher(this.progressBar, ljd, this.progressLabel);
        new Thread(worker).start();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    protected class AddAction
    extends AbstractAction {
        public AddAction() {
            super("Add...");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JDBCDriverPanel.this.fileChooser.addChoosableFileFilter(ASUtils.JAR_ZIP_FILE_FILTER);
                JDBCDriverPanel.this.fileChooser.setMultiSelectionEnabled(true);
                int returnVal = JDBCDriverPanel.this.fileChooser.showOpenDialog(JDBCDriverPanel.this);
                if (returnVal == 0) {
                    File[] files = JDBCDriverPanel.this.fileChooser.getSelectedFiles();
                    ArrayList<String> list = new ArrayList<String>();
                    int ii = 0;
                    while (ii < files.length) {
                        list.add(files[ii].getAbsolutePath());
                        ++ii;
                    }
                    JDBCDriverPanel.this.doLoad(list);
                    int i = 0;
                    while (i < files.length) {
                        JDBCDriverPanel.this.session.addDriverJar(files[i].getAbsolutePath());
                        ++i;
                    }
                }
            }
            catch (ArchitectException ex) {
                logger.error((Object)"AddAction.actionPerformed() problem.", (Throwable)ex);
            }
        }
    }

    protected class DelAction
    extends AbstractAction {
        public DelAction() {
            super("Remove");
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] treePathArray = JDBCDriverPanel.this.driverTree.getSelectionPaths();
            int n = 0;
            int n2 = treePathArray.length;
            while (n < n2) {
                TreePath p = treePathArray[n];
                logger.debug((Object)String.format("DelAction: p=%s, pathCount=%d", p, p.getPathCount()));
                if (p != null && p.getPathCount() >= 2) {
                    logger.debug((Object)("Removing: " + p.getPathComponent(1)));
                    JDBCDriverPanel.this.dtm.removeNodeFromParent((MutableTreeNode)p.getPathComponent(1));
                    JDBCDriverPanel.this.session.removeDriverJar(p.getPathComponent(1).toString());
                }
                ++n;
            }
            JDBCDriverPanel.this.delButton.setEnabled(false);
        }
    }

    protected class LoadJDBCDriversWorker
    implements Runnable {
        LoadJDBCDrivers ljd;

        LoadJDBCDriversWorker(LoadJDBCDrivers ljd) {
            this.ljd = ljd;
        }

        public void run() {
            this.ljd.execute();
        }
    }

    protected class LoadJDBCDrivers
    implements Monitorable {
        public boolean hasStarted = false;
        public boolean finished = false;
        private List driverJarList = null;
        private int jarCount = 0;
        private JarFile jf = null;
        private JDBCScanClassLoader cl = null;

        public LoadJDBCDrivers(List driverJarList) throws ArchitectException {
            this.driverJarList = driverJarList;
            logger.debug((Object)"in constructor, setting finished to false...");
            this.finished = false;
        }

        public Integer getJobSize() throws ArchitectException {
            return new Integer(this.driverJarList.size() * 1000);
        }

        public int getProgress() throws ArchitectException {
            double fraction = 0.0;
            if (this.cl != null) {
                fraction = this.cl.getFraction();
            }
            int progress = (this.jarCount - 1) * 1000 + (int)(fraction * 1000.0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("******************* progress is: " + progress + " of " + this.getJobSize()));
            }
            return progress;
        }

        public boolean isFinished() throws ArchitectException {
            return this.finished;
        }

        public void setCancelled(boolean cancelled) {
        }

        public boolean hasStarted() throws ArchitectException {
            return this.hasStarted;
        }

        public String getMessage() {
            return null;
        }

        public void execute() {
            this.hasStarted = true;
            try {
                try {
                    Iterator it = this.driverJarList.iterator();
                    while (it.hasNext()) {
                        ++this.jarCount;
                        logger.debug((Object)("**************** processin file #" + this.jarCount + " of " + this.driverJarList.size()));
                        String path = (String)it.next();
                        this.addJarFile(new File(path));
                    }
                    this.finished = true;
                    logger.debug((Object)"done loading (normal operation), setting finished to true.");
                }
                catch (Exception exp) {
                    logger.error((Object)"something went wrong in LoadJDBCDrivers worker thread!", (Throwable)exp);
                }
            }
            finally {
                this.finished = true;
                this.hasStarted = false;
                logger.debug((Object)"done loading (error condition), setting finished to true.");
            }
        }

        public void addJarFile(File file) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)JDBCDriverPanel.this.dtm.getRoot();
            try {
                this.jf = new JarFile(file);
                this.cl = new JDBCScanClassLoader(this.jf);
                List driverClasses = this.cl.scanForDrivers();
                logger.info((Object)("Found drivers: " + driverClasses));
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(file.getPath());
                JDBCDriverPanel.this.dtm.insertNodeInto(node, root, root.getChildCount());
                Iterator it = driverClasses.iterator();
                while (it.hasNext()) {
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(it.next());
                    JDBCDriverPanel.this.dtm.insertNodeInto(child, node, node.getChildCount());
                }
                TreePath path = new TreePath(node.getPath());
                JDBCDriverPanel.this.driverTree.expandPath(path);
                JDBCDriverPanel.this.driverTree.scrollPathToVisible(path);
            }
            catch (IOException ex) {
                logger.warn((Object)"I/O Error reading JAR file", (Throwable)ex);
                final IOException fex = ex;
                final File ffile = file;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(JDBCDriverPanel.this, "Could not read JAR file \"" + ffile.getPath() + "\"\n" + fex.getMessage());
                    }
                });
            }
        }
    }

    protected class JDBCScanClassLoader
    extends ClassLoader {
        JarFile jf;
        List drivers;
        int count = 0;

        public JDBCScanClassLoader(JarFile jf) {
            this.jf = jf;
        }

        public synchronized double getFraction() {
            double retval = 0.0;
            if (this.jf != null) {
                retval = (double)this.count / (double)this.jf.size();
            }
            return retval;
        }

        public List scanForDrivers() {
            this.drivers = new LinkedList();
            logger.debug((Object)("********* " + this.jf.getName() + " has " + this.jf.size() + " files."));
            Enumeration<JarEntry> entries = this.jf.entries();
            while (entries.hasMoreElements()) {
                ++this.count;
                ZipEntry ent = entries.nextElement();
                if (!ent.getName().endsWith(".class")) continue;
                try {
                    String[] s = ent.getName().split("\\.");
                    this.findClass(s[0].replace('/', '.'));
                }
                catch (ClassFormatError ex) {
                    logger.warn((Object)("JAR entry " + ent.getName() + " ends in .class but is not a class"), (Throwable)ex);
                }
                catch (NoClassDefFoundError ex) {
                    logger.warn((Object)("JAR does not contain dependency needed by: " + ent.getName()));
                }
                catch (Throwable ex) {
                    logger.warn((Object)("Unexpected exception while scanning JAR file " + this.jf.getName()), ex);
                }
            }
            return this.drivers;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            try {
                ZipEntry ent = this.jf.getEntry(String.valueOf(name.replace('.', '/')) + ".class");
                if (ent == null) {
                    throw new ClassNotFoundException("No class file " + name + " is in my jar file");
                }
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
                InputStream is = this.jf.getInputStream(ent);
                return this.readAndCheckClass(is, (int)ent.getSize(), name);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("IO Exception reading class from jar file", ex);
            }
        }

        private Class readAndCheckClass(InputStream is, int size, String expectedName) throws IOException, ClassFormatError {
            Class<?> clazz;
            int n;
            byte[] buf = new byte[size];
            int start = 0;
            while ((n = is.read(buf, start, size - start)) > 0) {
                start += n;
            }
            if (start + n != size) {
                logger.warn((Object)("Only read " + (start + n) + " bytes of class " + expectedName + " from JAR file; exptected " + size));
            }
            if (Driver.class.isAssignableFrom(clazz = this.defineClass(expectedName, buf, 0, start + n))) {
                logger.info((Object)("Found jdbc driver " + clazz.getName()));
                this.drivers.add(clazz.getName());
            }
            return clazz;
        }
    }
}

