/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.TextPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class DBCSPanel
extends JPanel
implements ArchitectPanel {
    private static final Logger logger = Logger.getLogger(DBCSPanel.class);
    private ArchitectDataSource dbcs;
    private TextPanel form;
    private JTextField dbNameField;
    private JComboBox dbDriverField;
    private JComponent platformSpecificOptions;
    private JTextField dbUrlField;
    private JTextField dbUserField;
    private JPasswordField dbPassField;
    private JTextField plSchemaField;
    private JComboBox plDbTypeField;
    private JTextField odbcDSNField;
    private Map<String, String> jdbcDrivers;
    private Map<String, String> jdbcSystems;
    private JDBCURLUpdater urlUpdater = new JDBCURLUpdater();
    private boolean updatingUrlFromFields = false;
    private boolean updatingFieldsFromUrl = false;

    public DBCSPanel() {
        this.setLayout(new BorderLayout());
        this.dbDriverField = new JComboBox<String>(this.getDriverClasses());
        this.dbDriverField.insertItemAt("", 0);
        this.dbNameField = new JTextField();
        this.dbNameField.setName("dbNameField");
        this.platformSpecificOptions = new JPanel();
        this.platformSpecificOptions.setLayout(new PlatformOptionsLayout());
        this.platformSpecificOptions.setBorder(BorderFactory.createEmptyBorder());
        this.platformSpecificOptions.add(new JLabel("(No options for current driver)"));
        JComponent[] jComponentArray = new JComponent[9];
        jComponentArray[0] = this.dbNameField;
        jComponentArray[1] = this.dbDriverField;
        jComponentArray[2] = this.platformSpecificOptions;
        this.dbUrlField = new JTextField();
        jComponentArray[3] = this.dbUrlField;
        this.dbUserField = new JTextField();
        jComponentArray[4] = this.dbUserField;
        this.dbPassField = new JPasswordField();
        jComponentArray[5] = this.dbPassField;
        this.plSchemaField = new JTextField();
        jComponentArray[6] = this.plSchemaField;
        jComponentArray[7] = this.plDbTypeField = new JComboBox<String>(this.getDriverTypes());
        this.odbcDSNField = new JTextField();
        jComponentArray[8] = this.odbcDSNField;
        JComponent[] fields = jComponentArray;
        String[] labels = new String[]{"Connection Name", "JDBC Driver", "Connect Options", "JDBC URL", "Username", "Password", "PL Schema Owner", "Database Type", "ODBC Data Source Name"};
        char[] mnemonics = new char[]{'n', 'd', 'o', 'u', 'r', 'p', 's', 't', 'b'};
        int[] widths = new int[]{40, 40, 40, 40, 40, 40, 40, 40, 40};
        String[] tips = new String[]{"Your nickname for this database", "The class name of the JDBC Driver", "Connection parameters specific to this driver", "Vendor-specific JDBC URL", "Username for this database", "Password for this database", "Qualifier to put before references to PL system tables", "The Power*Loader type code for this database", "The ODBC data source name for this database"};
        this.dbDriverField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashMap driverToType = (HashMap)ArchitectUtils.getDriverTypeMap();
                DBCSPanel.this.createFieldsFromTemplate();
                DBCSPanel.this.updateUrlFromFields();
                String driverField = (String)DBCSPanel.this.dbDriverField.getSelectedItem();
                String typeField = (String)driverToType.get(driverField);
                DBCSPanel.this.plDbTypeField.setSelectedItem(typeField);
            }
        });
        this.dbUrlField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                DBCSPanel.this.updateFieldsFromUrl();
            }

            public void removeUpdate(DocumentEvent e) {
                DBCSPanel.this.updateFieldsFromUrl();
            }

            public void changedUpdate(DocumentEvent e) {
                DBCSPanel.this.updateFieldsFromUrl();
            }
        });
        this.form = new TextPanel(fields, labels, mnemonics, widths, tips);
        this.add((Component)this.form, "Center");
    }

    private String[] getDriverClasses() {
        if (this.jdbcDrivers == null) {
            this.setupDriverMap();
        }
        return this.jdbcDrivers.keySet().toArray(new String[0]);
    }

    private String[] getDriverTypes() {
        if (this.jdbcSystems == null) {
            this.setupDriverSystemMap();
        }
        return this.jdbcSystems.values().toArray(new String[0]);
    }

    private String getTemplateForDriver(String driverClassName) {
        if (this.jdbcDrivers == null) {
            this.setupDriverMap();
        }
        return this.jdbcDrivers.get(driverClassName);
    }

    private void createFieldsFromTemplate() {
        int i = 0;
        while (i < this.platformSpecificOptions.getComponentCount()) {
            Component c = this.platformSpecificOptions.getComponent(i);
            if (c instanceof JTextField) {
                ((JTextField)c).getDocument().removeDocumentListener(this.urlUpdater);
            }
            ++i;
        }
        this.platformSpecificOptions.removeAll();
        String driverClassName = this.dbDriverField.getSelectedItem().toString();
        String template = this.getTemplateForDriver(driverClassName);
        if (template != null) {
            Pattern varPattern = Pattern.compile("<(.*?)>");
            Matcher varMatcher = varPattern.matcher(template);
            ArrayList<String> templateVars = new ArrayList<String>();
            while (varMatcher.find()) {
                templateVars.add(varMatcher.group(1));
            }
            logger.debug((Object)("Found variables: " + templateVars));
            for (String var : templateVars) {
                String def = "";
                if (var.indexOf(58) != -1) {
                    int i2 = var.indexOf(58);
                    def = var.substring(i2 + 1);
                    var = var.substring(0, i2);
                }
                this.platformSpecificOptions.add(new JLabel(var));
                JTextField field = new JTextField(def);
                this.platformSpecificOptions.add(field);
                field.getDocument().addDocumentListener(this.urlUpdater);
            }
        } else {
            this.platformSpecificOptions.add(new JLabel("Unknown driver class.  Fill in URL manually."));
        }
        this.platformSpecificOptions.revalidate();
        this.platformSpecificOptions.repaint();
    }

    private void setupDriverMap() {
        this.jdbcDrivers = ArchitectUtils.getDriverTemplateMap();
    }

    private void setupDriverSystemMap() {
        this.jdbcSystems = ArchitectUtils.getDriverTypeMap();
    }

    private void updateUrlFromFields() {
        if (this.updatingFieldsFromUrl) {
            return;
        }
        String template = this.getTemplateForDriver(this.dbDriverField.getSelectedItem().toString());
        if (template == null) {
            return;
        }
        try {
            this.updatingUrlFromFields = true;
            StringBuffer newUrl = new StringBuffer();
            Pattern p = Pattern.compile("<(.*?)>");
            Matcher m = p.matcher(template);
            while (m.find()) {
                String varName = m.group(1);
                if (varName.indexOf(58) != -1) {
                    varName = varName.substring(0, varName.indexOf(58));
                }
                String varValue = this.getPlatformSpecificFieldValue(varName);
                m.appendReplacement(newUrl, varValue);
            }
            m.appendTail(newUrl);
            this.dbUrlField.setText(newUrl.toString());
        }
        finally {
            this.updatingUrlFromFields = false;
        }
    }

    private void updateFieldsFromUrl() {
        if (this.updatingUrlFromFields) {
            return;
        }
        try {
            this.updatingFieldsFromUrl = true;
            int i = 0;
            while (i < this.platformSpecificOptions.getComponentCount()) {
                this.platformSpecificOptions.getComponent(i).setEnabled(true);
                ++i;
            }
            String template = this.getTemplateForDriver(this.dbDriverField.getSelectedItem().toString());
            logger.debug((Object)("Updating based on template " + template));
            if (template == null) {
                return;
            }
            String reTemplate = template.replaceAll("<.*?>", "(.*)");
            logger.debug((Object)("Regex of template is " + reTemplate));
            Pattern p = Pattern.compile(reTemplate);
            Matcher m = p.matcher(this.dbUrlField.getText());
            if (m.find()) {
                this.platformSpecificOptions.setEnabled(true);
                int g = 1;
                while (g <= m.groupCount()) {
                    ((JTextField)this.platformSpecificOptions.getComponent(2 * g - 1)).setText(m.group(g));
                    ++g;
                }
            } else {
                int i2 = 0;
                while (i2 < this.platformSpecificOptions.getComponentCount()) {
                    this.platformSpecificOptions.getComponent(i2).setEnabled(false);
                    ++i2;
                }
            }
        }
        finally {
            this.updatingFieldsFromUrl = false;
        }
    }

    private String getPlatformSpecificFieldValue(String varName) {
        int i = 0;
        while (i < this.platformSpecificOptions.getComponentCount()) {
            if (this.platformSpecificOptions.getComponent(i) instanceof JLabel && ((JLabel)this.platformSpecificOptions.getComponent(i)).getText().equals(varName) && this.platformSpecificOptions.getComponentCount() >= i + 1) {
                return ((JTextField)this.platformSpecificOptions.getComponent(i + 1)).getText();
            }
            ++i;
        }
        return "";
    }

    public boolean applyChanges() {
        String name = this.dbNameField.getText();
        this.dbcs.setName(name);
        this.dbcs.setDisplayName(name);
        this.dbcs.setDriverClass(this.dbDriverField.getSelectedItem().toString());
        this.dbcs.setUrl(this.dbUrlField.getText());
        this.dbcs.setUser(this.dbUserField.getText());
        this.dbcs.setPass(new String(this.dbPassField.getPassword()));
        this.dbcs.setPlSchema(this.plSchemaField.getText());
        this.dbcs.setPlDbType((String)this.plDbTypeField.getSelectedItem());
        this.dbcs.setOdbcDsn(this.odbcDSNField.getText());
        return true;
    }

    public void discardChanges() {
    }

    public void setDbcs(ArchitectDataSource dbcs) {
        this.dbNameField.setText(dbcs.getName());
        this.dbDriverField.removeItemAt(0);
        if (dbcs.getDriverClass() != null) {
            this.dbDriverField.insertItemAt(dbcs.getDriverClass(), 0);
        } else {
            this.dbDriverField.insertItemAt("", 0);
        }
        this.dbDriverField.setSelectedIndex(0);
        this.dbUrlField.setText(dbcs.getUrl());
        this.dbUserField.setText(dbcs.getUser());
        this.dbPassField.setText(dbcs.getPass());
        this.plSchemaField.setText(dbcs.getPlSchema());
        this.plDbTypeField.setSelectedItem(dbcs.getPlDbType());
        this.odbcDSNField.setText(dbcs.getOdbcDsn());
        this.dbcs = dbcs;
    }

    public ArchitectDataSource getDbcs() {
        return this.dbcs;
    }

    public JPanel getPanel() {
        return this;
    }

    private class JDBCURLUpdater
    implements DocumentListener {
        private JDBCURLUpdater() {
        }

        public void insertUpdate(DocumentEvent e) {
            DBCSPanel.this.updateUrlFromFields();
        }

        public void removeUpdate(DocumentEvent e) {
            DBCSPanel.this.updateUrlFromFields();
        }

        public void changedUpdate(DocumentEvent e) {
            DBCSPanel.this.updateUrlFromFields();
        }
    }

    private static class PlatformOptionsLayout
    implements LayoutManager {
        int preLabelGap = 10;
        int gap = 5;

        private PlatformOptionsLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            int height = 0;
            int i = 0;
            while (i < parent.getComponentCount()) {
                Component c = parent.getComponent(i);
                height = Math.max(height, c.getPreferredSize().height);
                ++i;
            }
            return new Dimension(parent.getWidth(), height);
        }

        public Dimension minimumLayoutSize(Container parent) {
            int height = 0;
            int i = 0;
            while (i < parent.getComponentCount()) {
                Component c = parent.getComponent(i);
                height = Math.max(height, c.getMinimumSize().height);
                ++i;
            }
            return new Dimension(parent.getWidth(), height);
        }

        public void layoutContainer(Container parent) {
            int labelSize = 0;
            int labelCount = 0;
            int i = 0;
            while (i < parent.getComponentCount()) {
                Component c = parent.getComponent(i);
                if (c instanceof JLabel) {
                    if (i > 0) {
                        labelSize += this.preLabelGap;
                    }
                    labelSize += c.getPreferredSize().width;
                    ++labelCount;
                }
                ++i;
            }
            int gapSize = this.gap * (parent.getComponentCount() - 1);
            int nonLabelWidth = 0;
            if (parent.getComponentCount() != labelCount) {
                nonLabelWidth = (parent.getWidth() - labelSize - gapSize) / (parent.getComponentCount() - labelCount);
            }
            if (nonLabelWidth < 20) {
                nonLabelWidth = 20;
            }
            int x = 0;
            int i2 = 0;
            while (i2 < parent.getComponentCount()) {
                Component c = parent.getComponent(i2);
                if (i2 > 0) {
                    x += this.gap;
                }
                if (c instanceof JLabel) {
                    if (i2 > 0) {
                        x += this.preLabelGap;
                    }
                    c.setBounds(x, 0, c.getPreferredSize().width, parent.getHeight());
                    x += c.getPreferredSize().width;
                } else {
                    c.setBounds(x, 0, nonLabelWidth, parent.getHeight());
                    x += nonLabelWidth;
                }
                ++i2;
            }
        }
    }
}

