/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.TestCase;

public class ASUtilsTest
extends TestCase {
    final String FAKE_CLASS_NAME = "my.test";

    public void testStackTrace() {
        String answer = this.getPrintOut(new Exception("Boo!"));
        ASUtilsTest.assertTrue((answer.indexOf(((Object)((Object)this)).getClass().getName()) >= 0 ? 1 : 0) != 0);
    }

    public void testStackTraceArithmetic() {
        int STACK_DEPTH = 16;
        ASUtilsTest.assertTrue((boolean)true);
        Throwable t = this.fakeUpException(16);
        String answer = this.getPrintOut(t);
        ASUtilsTest.assertTrue((answer.indexOf("my.test") >= 0 ? 1 : 0) != 0);
        int expectedLength = 6;
        System.out.println("ANSER=" + answer);
        System.out.println("EXPECT=" + expectedLength);
        ASUtilsTest.assertTrue((answer.indexOf(String.valueOf(expectedLength) + " more") >= 0 ? 1 : 0) != 0);
    }

    public void testStackTraceBoundary() {
        Throwable t = this.fakeUpException(10);
        String answer = this.getPrintOut(t);
        ASUtilsTest.assertFalse((answer.indexOf("more...") >= 0 ? 1 : 0) != 0);
    }

    private String getPrintOut(Throwable t) {
        StringWriter sWriter = new StringWriter();
        PrintWriter pout = new PrintWriter(sWriter);
        ASUtils.printStackTrace(t, pout);
        pout.close();
        return sWriter.toString();
    }

    private Throwable fakeUpException(int howMany) {
        StackTraceElement[] data = new StackTraceElement[howMany];
        data[0] = new StackTraceElement("my.test", "foo", "mytest.java", 123);
        int i = 1;
        while (i < howMany) {
            data[i] = new StackTraceElement("java.lang.Fake", "method" + i, "yourtest.java", i);
            ++i;
        }
        RuntimeException t = new RuntimeException();
        t.setStackTrace(data);
        return t;
    }

    public void testClassNameStuff() {
        ASUtilsTest.assertEquals((String)"String", (String)ASUtils.niceClassName(""));
        ASUtilsTest.assertEquals((String)"Object", (String)ASUtils.niceClassName(new Object()));
    }
}

