/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.sqlrunner;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.sqlrunner.OutputMode;
import ca.sqlpower.architect.sqlrunner.ResultsDecorator;
import ca.sqlpower.architect.sqlrunner.ResultsDecoratorHTML;
import ca.sqlpower.architect.sqlrunner.ResultsDecoratorSQL;
import ca.sqlpower.architect.sqlrunner.ResultsDecoratorText;
import ca.sqlpower.architect.sqlrunner.ResultsDecoratorXML;
import ca.sqlpower.architect.sqlrunner.Verbosity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLRunner {
    OutputMode outputMode = OutputMode.t;
    private Connection conn;
    private DatabaseMetaData dbMeta;
    private Statement statement;
    private PrintWriter out;
    private ResultsDecorator currentDecorator;
    private ResultsDecorator textDecorator;
    private ResultsDecorator sqlDecorator;
    private ResultsDecorator htmlDecorator;
    private ResultsDecorator xmlDecorator;
    private boolean debug;
    private boolean upperCaseTableNames;
    private static Verbosity verbosity = Verbosity.QUIET;

    public SQLRunner(Connection c, String outputFileName, String outputModeName) throws IOException, SQLException {
        this.conn = c;
        this.dbMeta = this.conn.getMetaData();
        this.upperCaseTableNames = this.dbMeta.getDatabaseProductName().indexOf("DB2") >= 0;
        String dbName = this.dbMeta.getDatabaseProductName();
        System.out.println("SQLRunner: Connected to " + dbName);
        this.statement = this.conn.createStatement();
        this.out = outputFileName == null ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(outputFileName));
        this.setOutputMode(outputModeName);
    }

    void setOutputMode(String outputModeName) {
        if (outputModeName == null || outputModeName.length() == 0) {
            System.err.println("invalid mode: " + (Object)((Object)this.outputMode) + "; must be t, h or s");
        }
        this.outputMode = OutputMode.valueOf(outputModeName);
        this.setOutputMode(this.outputMode);
    }

    void setOutputMode(OutputMode outputMode) {
        ResultsDecorator newDecorator = null;
        switch (outputMode) {
            case t: {
                if (this.textDecorator == null) {
                    this.textDecorator = new ResultsDecoratorText(this.out, verbosity);
                }
                newDecorator = this.textDecorator;
                break;
            }
            case h: {
                if (this.htmlDecorator == null) {
                    this.htmlDecorator = new ResultsDecoratorHTML(this.out, verbosity);
                }
                newDecorator = this.htmlDecorator;
                break;
            }
            case s: {
                if (this.sqlDecorator == null) {
                    this.sqlDecorator = new ResultsDecoratorSQL(this.out, verbosity);
                }
                newDecorator = this.sqlDecorator;
                break;
            }
            case x: {
                if (this.xmlDecorator == null) {
                    this.xmlDecorator = new ResultsDecoratorXML(this.out, verbosity);
                }
                newDecorator = this.xmlDecorator;
                break;
            }
            default: {
                String values = OutputMode.values().toString();
                System.err.println("invalid mode: " + (Object)((Object)outputMode) + "; must be " + values);
            }
        }
        if (this.currentDecorator != newDecorator) {
            this.currentDecorator = newDecorator;
            if (this.debug) {
                System.out.println("Mode set to  " + (Object)((Object)outputMode));
            }
        }
        this.currentDecorator.setWriter(this.out);
    }

    private void doEscape(String str) throws IOException, SQLException, ArchitectException {
        String rest = null;
        if (str.length() > 2) {
            rest = str.substring(2);
        }
        if (str.startsWith("\\d")) {
            if (rest == null) {
                throw new ArchitectException("\\d needs display arg");
            }
            this.display(rest);
        } else if (str.startsWith("\\m")) {
            if (rest == null) {
                throw new ArchitectException("\\m needs output mode arg");
            }
            this.setOutputMode(rest);
        } else if (str.startsWith("\\o")) {
            if (rest == null) {
                throw new ArchitectException("\\o needs output file arg");
            }
            this.setOutputFile(rest);
        } else {
            throw new ArchitectException("Unknown escape: " + str);
        }
    }

    private void display(String rest) throws IOException, SQLException, ArchitectException {
        if (rest.equals("t")) {
            List<String> userTables = SQLRunner.getUserTables(this.conn);
            for (String name : userTables) {
                this.textDecorator.println(name);
            }
        } else if (rest.startsWith("t")) {
            String tableName = rest.substring(1).trim();
            if (this.upperCaseTableNames) {
                tableName = tableName.toUpperCase();
            }
            System.out.println("# Display table " + tableName);
            DatabaseMetaData md = this.conn.getMetaData();
            ResultSet rs = md.getColumns(null, null, tableName, "%");
            while (rs.next()) {
                this.textDecorator.println(rs.getString(4));
            }
        } else {
            throw new ArchitectException("\\d" + rest + " invalid");
        }
    }

    public static List<String> getUserTables(Connection conn) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        DatabaseMetaData md = conn.getMetaData();
        ResultSet rs = md.getTables(null, null, "%", null);
        while (rs.next()) {
            String catName = rs.getString(2);
            if (catName.startsWith("SYS")) continue;
            result.add(rs.getString(3));
        }
        return result;
    }

    public void setOutputFile(String fileName) throws IOException {
        if (fileName == null) {
            this.setOutputFile(new PrintWriter(System.out, true));
        } else {
            File file = new File(fileName);
            this.setOutputFile(new PrintWriter((Writer)new FileWriter(file), true));
            System.out.println("Output set to " + file.getCanonicalPath());
        }
    }

    public void setOutputFile(PrintWriter writer) {
        this.out = writer;
        this.textDecorator = new ResultsDecoratorText(this.out, verbosity);
    }

    public void runStatement(String rawString) throws IOException, SQLException, ArchitectException {
        String inString = rawString.trim();
        if (verbosity != Verbosity.QUIET) {
            this.out.println("Executing : <<" + inString.trim() + ">>");
            this.out.flush();
        }
        if (inString.startsWith("\\")) {
            this.doEscape(inString);
            return;
        }
        boolean hasResultSet = this.statement.execute(inString);
        if (!hasResultSet) {
            this.currentDecorator.printRowCount(this.statement.getUpdateCount());
        } else {
            ResultSet rs = this.statement.getResultSet();
            int n = this.currentDecorator.write(rs);
            this.currentDecorator.printRowCount(n);
            this.currentDecorator.flush();
        }
    }

    public static String getStatement(BufferedReader is) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = is.readLine()) != null) {
            if (verbosity == Verbosity.DEBUG) {
                System.out.println("SQLRunner.getStatement(): LINE " + line);
            }
            if (line == null || line.length() == 0 || (line = line.trim()).startsWith("#") || line.startsWith("--")) continue;
            if (line.startsWith("\\")) {
                if (sb.length() == 0) {
                    return line;
                }
                throw new IllegalArgumentException("Escape command found inside statement");
            }
            sb.append(line);
            int nb = sb.length();
            if (nb > 0 && sb.charAt(nb - 1) == ';') {
                if (nb == 1) {
                    return "";
                }
                sb.setLength(nb - 1);
                return sb.toString();
            }
            sb.append(' ');
        }
        return null;
    }

    public void close() throws SQLException {
        this.statement.close();
        this.conn.close();
        this.out.flush();
        this.out.close();
    }

    public static Verbosity getVerbosity() {
        return verbosity;
    }

    public static void setVerbosity(Verbosity verbosity) {
        SQLRunner.verbosity = verbosity;
    }
}

