/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.sqlrunner;

import ca.sqlpower.architect.sqlrunner.ResultsDecorator;
import ca.sqlpower.architect.sqlrunner.Verbosity;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultsDecoratorSQL
extends ResultsDecorator {
    public ResultsDecoratorSQL(PrintWriter out, Verbosity v) {
        super(out, v);
    }

    public int write(ResultSet rs) throws IOException, SQLException {
        ResultSetMetaData md = rs.getMetaData();
        String tableName = md.getTableName(1);
        if (tableName == null) {
            tableName = "XXXTABLENAMEXXX";
            System.err.println("Warning: at least one tablename null");
        }
        int colCount = md.getColumnCount();
        StringBuffer sb = new StringBuffer("insert into ").append(tableName).append("(");
        int i = 1;
        while (i <= colCount) {
            sb.append(md.getColumnName(i));
            if (i != colCount) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(") values (");
        String insertCommand = sb.toString();
        int rowCount = 0;
        while (rs.next()) {
            ++rowCount;
            this.println(insertCommand);
            int i2 = 1;
            while (i2 <= colCount) {
                String tmp = rs.getString(i2);
                if (rs.wasNull()) {
                    this.print("null");
                } else {
                    int type = md.getColumnType(i2);
                    switch (type) {
                        default: {
                            this.print(tmp);
                            break;
                        }
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: {
                            tmp = tmp.replaceAll("'", "''");
                            this.print("'" + tmp + "'");
                        }
                    }
                }
                if (i2 != colCount) {
                    this.print(", ");
                }
                ++i2;
            }
            this.println(");");
        }
        return rowCount;
    }

    public void printRowCount(int rowCount) throws IOException {
        this.println("-- RowCount: " + rowCount);
    }

    public String getName() {
        return "SQL";
    }
}

