/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.etl;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectSessionImpl;
import ca.sqlpower.architect.DepthFirstSearch;
import ca.sqlpower.architect.LogWriter;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.etl.PLUtils;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.Monitorable;
import ca.sqlpower.security.PLSecurityException;
import ca.sqlpower.security.PLSecurityManager;
import ca.sqlpower.sql.DBConnection;
import ca.sqlpower.sql.DatabaseObject;
import ca.sqlpower.sql.DefaultParameters;
import ca.sqlpower.sql.PLSchemaException;
import ca.sqlpower.sql.SQL;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLExport
implements Monitorable {
    private static final Logger logger = Logger.getLogger(PLExport.class);
    private LogWriter logWriter = null;
    public static final String PL_GENERATOR_VERSION = "PLExport $Revision: 1.40 $".replace('$', ' ').trim();
    private DefaultParameters defParam;
    private File file;
    private String folderName;
    private String jobId;
    private String jobDescription;
    private String jobComment;
    private boolean runPLEngine;
    private PLSecurityManager sm;
    private ArchitectDataSource repositoryDataSource;
    private ArchitectDataSource targetDataSource;
    private String targetSchema;
    private String targetCatalog;
    private String repositorySchema;
    private String repositoryCatalog;
    private boolean hasStarted;
    private ArrayList<ASUtils.LabelValueBean> exportResultList = new ArrayList();
    private boolean finished;
    private boolean cancelled;
    List<SQLTable> currentDB;
    int tableCount = 0;

    @Override
    public boolean hasStarted() {
        return this.hasStarted;
    }

    @Override
    public Integer getJobSize() throws ArchitectException {
        if (this.currentDB != null) {
            return new Integer(this.currentDB.size());
        }
        return null;
    }

    @Override
    public int getProgress() throws ArchitectException {
        if (this.currentDB != null) {
            return this.tableCount;
        }
        return 0;
    }

    @Override
    public boolean isFinished() throws ArchitectException {
        return this.finished;
    }

    @Override
    public String getMessage() {
        return null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void cancelJob() {
        this.finished = true;
        this.cancelled = true;
    }

    public void maybeInsertFolder(Connection con) throws SQLException {
        if (this.folderName == null || this.folderName.length() == 0) {
            this.exportResultList.add(new ASUtils.LabelValueBean("Create Folder:" + this.folderName, "Skipped, no parameter"));
            return;
        }
        String status = "Unknown";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = con.createStatement();
                String folder_table = DDLUtils.toQualifiedName(this.repositoryCatalog, this.repositorySchema, "pl_folder");
                rs = stmt.executeQuery("SELECT 1 FROM " + folder_table + " WHERE folder_name=" + SQL.quote((String)this.folderName));
                if (!rs.next()) {
                    status = "OK";
                    StringBuffer sql = new StringBuffer("INSERT INTO ");
                    sql.append(folder_table);
                    sql.append(" (folder_name,folder_desc,folder_status,last_backup_no)");
                    sql.append(" VALUES (");
                    sql.append(SQL.quote((String)this.folderName));
                    sql.append(",").append(SQL.quote((String)"This Folder contains jobs and transactions created by the Power*Architect"));
                    sql.append(",").append(SQL.quote(null));
                    sql.append(",").append(SQL.quote(null));
                    sql.append(")");
                    this.logWriter.info("Insert into " + folder_table + ", PK=" + this.folderName);
                    logger.debug((Object)("MAYBE INSERT SQL: " + sql.toString()));
                    stmt.executeUpdate(sql.toString());
                } else {
                    status = "Skipped, exist";
                }
            }
            catch (SQLException e) {
                status = "Error";
                throw e;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            this.exportResultList.add(new ASUtils.LabelValueBean("Create Folder:" + this.folderName, status));
        }
    }

    public void insertFolderDetail(Connection con, String objectType, String objectName) throws SQLException {
        if (this.folderName == null || this.folderName.length() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(DDLUtils.toQualifiedName(this.repositoryCatalog, this.repositorySchema, "PL_FOLDER_DETAIL"));
        sql.append(" (folder_name,object_type,object_name)");
        sql.append(" VALUES (");
        sql.append(SQL.quote((String)this.folderName));
        sql.append(",").append(SQL.quote((String)objectType));
        sql.append(",").append(SQL.quote((String)objectName));
        sql.append(")");
        this.logWriter.info("Insert into PL FOLDER_DETAIL, PK=" + this.folderName + "|" + objectType + "|" + objectName);
        Statement s = con.createStatement();
        try {
            logger.debug((Object)("INSERT FOLDER DETAIL SQL: " + sql.toString()));
            s.executeUpdate(sql.toString());
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    public Set getTransName(Connection con, String baseTransId) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT TRANS_ID FROM ");
        sql.append(DDLUtils.toQualifiedName(this.repositoryCatalog, this.repositorySchema, "TRANS"));
        sql.append(" WHERE TRANS_ID LIKE ");
        sql.append(SQL.quote((String)(String.valueOf(baseTransId) + "%")));
        Statement s = con.createStatement();
        ResultSet rs = null;
        HashSet<String> set = new HashSet<String>();
        try {
            logger.debug((Object)("DETECT TRANS_ID COLLISION: " + sql.toString()));
            rs = s.executeQuery(sql.toString());
            while (rs.next()) {
                set.add(rs.getString(1));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (s != null) {
                s.close();
            }
        }
        return set;
    }

    public int generateUniqueTransIdx(Connection con, String transId) throws SQLException {
        Set set = this.getTransName(con, transId);
        boolean foundUnique = false;
        int i = 0;
        while (!foundUnique) {
            boolean bl = foundUnique = !set.contains(String.valueOf(transId) + "_" + ++i);
            if (!foundUnique) {
                logger.debug((Object)("detected collision for trans id: " + transId + "_" + i));
                continue;
            }
            logger.debug((Object)("next unique trans id is: " + transId + "_" + i));
        }
        return i;
    }

    public int generateUniqueTransIdx(Set set, String transId) throws SQLException {
        boolean foundUnique = false;
        int i = 0;
        while (!foundUnique) {
            boolean bl = foundUnique = !set.contains(String.valueOf(transId) + "_" + ++i);
            if (!foundUnique) {
                logger.debug((Object)("detected collision for trans id: " + transId + "_" + i));
                continue;
            }
            logger.debug((Object)("next unique trans id is: " + transId + "_" + i));
        }
        return i;
    }

    private void insertJob(Connection con) throws SQLException {
        String status = "Unknown";
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(DDLUtils.toQualifiedName(this.repositoryCatalog, this.repositorySchema, "PL_JOB"));
        sql.append(" (JOB_ID, JOB_DESC, JOB_FREQ_DESC, PROCESS_CNT, SHOW_PROGRESS_FREQ, PROCESS_SEQ_CODE, MAX_RETRY_COUNT, WRITE_DB_ERRORS_IND, ROLLBACK_SEGMENT_NAME, LOG_FILE_NAME, ERR_FILE_NAME, UNIX_LOG_FILE_NAME, UNIX_ERR_FILE_NAME, APPEND_TO_LOG_IND, APPEND_TO_ERR_IND, DEBUG_MODE_IND, COMMIT_FREQ, JOB_COMMENT, CREATE_DATE, LAST_update_DATE, LAST_update_USER, BATCH_SCRIPT_FILE_NAME, JOB_SCRIPT_FILE_NAME, UNIX_BATCH_SCRIPT_FILE_NAME, UNIX_JOB_SCRIPT_FILE_NAME, JOB_STATUS, LAST_BACKUP_NO, LAST_RUN_DATE, SKIP_PACKAGES_IND, SEND_EMAIL_IND, LAST_update_OS_USER, STATS_IND, checked_out_ind, checked_out_date, checked_out_user, checked_out_os_user");
        sql.append(") VALUES (");
        sql.append(SQL.quote((String)this.jobId));
        sql.append(",").append(SQL.quote((String)this.jobDescription));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        logger.debug((Object)("default log path is: " + this.defParam.get("default_log_file_path")));
        logger.debug((Object)("default err path is: " + this.defParam.get("default_err_file_path")));
        sql.append(",").append(SQL.quote((String)(String.valueOf(this.escapeString(con, this.fixWindowsPath(this.defParam.get("default_log_file_path")))) + this.jobId + ".log")));
        sql.append(",").append(SQL.quote((String)(String.valueOf(this.escapeString(con, this.fixWindowsPath(this.defParam.get("default_err_file_path")))) + this.jobId + ".err")));
        sql.append(",").append(SQL.quote((String)(String.valueOf(this.fixUnixPath(this.defParam.get("default_log_file_path"))) + this.jobId + ".log")));
        sql.append(",").append(SQL.quote((String)(String.valueOf(this.fixUnixPath(this.defParam.get("default_err_file_path"))) + this.jobId + ".err")));
        sql.append(",").append(SQL.quote((String)"N"));
        sql.append(",").append(SQL.quote((String)"N"));
        sql.append(",").append(SQL.quote((String)"N"));
        sql.append(",").append("100");
        sql.append(",").append(SQL.quote((String)this.jobComment));
        sql.append(",").append(SQL.escapeDate((Connection)con, (Date)new Date()));
        sql.append(",").append(SQL.escapeDate((Connection)con, (Date)new Date()));
        sql.append(",").append(SQL.quote((String)con.getMetaData().getUserName()));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote((String)"N"));
        sql.append(",").append(SQL.quote((String)System.getProperty("user.name")));
        sql.append(",").append(SQL.quote((String)"N"));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(")");
        Statement s = con.createStatement();
        this.logWriter.info("INSERT into PL JOB, PK=" + this.jobId);
        try {
            try {
                logger.debug((Object)("INSERT PL JOB: " + sql.toString()));
                s.executeUpdate(sql.toString());
                status = "OK";
            }
            catch (SQLException e) {
                status = "Error";
                throw e;
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            this.exportResultList.add(new ASUtils.LabelValueBean("Create Job " + this.jobId, status));
        }
    }

    public void insertJobDetail(Connection con, int seqNo, String objectType, String objectName) throws SQLException {
        String status = "Unknown";
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(DDLUtils.toQualifiedName(this.repositoryCatalog, this.repositorySchema, "JOB_DETAIL"));
        sql.append(" (JOB_ID, JOB_PROCESS_SEQ_NO, OBJECT_TYPE, OBJECT_NAME, JOB_DETAIL_COMMENT, LAST_update_DATE, LAST_update_USER, FAILURE_ABORT_IND, WARNING_ABORT_IND, PKG_PARAM, ACTIVE_IND, LAST_update_OS_USER )");
        sql.append(" VALUES (");
        sql.append(SQL.quote((String)this.jobId));
        sql.append(",").append(seqNo);
        sql.append(",").append(SQL.quote((String)objectType));
        sql.append(",").append(SQL.quote((String)objectName));
        sql.append(",").append(SQL.quote((String)("Generated by Power*Architect " + PL_GENERATOR_VERSION)));
        sql.append(",").append(SQL.escapeDate((Connection)con, (Date)new Date()));
        sql.append(",").append(SQL.quote((String)con.getMetaData().getUserName()));
        sql.append(",").append(SQL.quote((String)"N"));
        sql.append(",").append(SQL.quote((String)"N"));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote((String)"Y"));
        sql.append(",").append(SQL.quote((String)System.getProperty("user.name")));
        sql.append(")");
        this.logWriter.info("INSERT into JOB DETAIL, PK=" + this.jobId + "|" + seqNo);
        Statement s = con.createStatement();
        try {
            try {
                logger.debug((Object)("INSERT JOB DETAIL: " + sql.toString()));
                s.executeUpdate(sql.toString());
                status = "OK";
            }
            catch (SQLException e) {
                status = "Error";
                throw e;
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            this.exportResultList.add(new ASUtils.LabelValueBean("Create Job Step " + seqNo + objectName, status));
        }
    }

    public void insertTrans(Connection con, String transId, String remarks) throws ArchitectException, SQLException {
        String status = "Unknown";
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ");
        sql.append(DDLUtils.toQualifiedName(this.repositoryCatalog, this.repositorySchema, "TRANS"));
        sql.append(" (TRANS_ID, TRANS_DESC, TRANS_COMMENT, ACTION_TYPE, MAX_RETRY_COUNT,\n");
        sql.append(" PROCESS_SEQ_CODE, LAST_update_DATE, LAST_update_USER, DEBUG_MODE_IND,\n");
        sql.append(" COMMIT_FREQ, PROCESS_ADD_IND, PROCESS_UPD_IND, PROCESS_DEL_IND,\n");
        sql.append(" WRITE_DB_ERRORS_IND, ROLLBACK_SEGMENT_NAME, ERR_FILE_NAME,\n");
        sql.append(" LOG_FILE_NAME, BAD_FILE_NAME, SHOW_PROGRESS_FREQ, SKIP_CNT,\n");
        sql.append(" PROCESS_CNT, CREATE_DATE, UNIX_LOG_FILE_NAME,\n");
        sql.append(" UNIX_ERR_FILE_NAME, UNIX_BAD_FILE_NAME, REMOTE_CONNECTION_STRING,\n");
        sql.append(" APPEND_TO_LOG_IND, APPEND_TO_ERR_IND, APPEND_TO_BAD_IND, TRANS_STATUS,\n");
        sql.append(" LAST_BACKUP_NO, LAST_RUN_DATE, SKIP_PACKAGES_IND, SEND_EMAIL_IND,\n");
        sql.append(" PROMPT_COLMAP_INDEXES_IND, TRANSACTION_TYPE, DELTA_SORT_IND,\n");
        sql.append(" LAST_update_OS_USER, STATS_IND, ODBC_IND, checked_out_ind,\n");
        sql.append(" checked_out_date, checked_out_user, checked_out_os_user\n");
        sql.append(") VALUES (");
        sql.append(SQL.quote((String)transId));
        sql.append(",\n").append(SQL.quote((String)("Generated by Power*Architect " + PL_GENERATOR_VERSION)));
        sql.append(",\n").append(SQL.quote((String)remarks));
        sql.append(",\n").append(SQL.quote((String)"ADD"));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.escapeDate((Connection)con, (Date)new Date()));
        sql.append(",\n").append(SQL.quote((String)con.getMetaData().getUserName()));
        sql.append(",\n").append(SQL.quote((String)"N"));
        sql.append(",\n").append(this.defParam.get("commit_freq"));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        logger.debug((Object)("err_file_path: " + this.defParam.get("default_err_file_path")));
        logger.debug((Object)("log_file_path: " + this.defParam.get("default_log_file_path")));
        logger.debug((Object)("bad_file_path: " + this.defParam.get("default_bad_file_path")));
        sql.append(",\n").append(SQL.quote((String)(String.valueOf(this.escapeString(con, this.fixWindowsPath(this.defParam.get("default_err_file_path")))) + transId + ".err")));
        sql.append(",\n").append(SQL.quote((String)(String.valueOf(this.escapeString(con, this.fixWindowsPath(this.defParam.get("default_log_file_path")))) + transId + ".log")));
        sql.append(",\n").append(SQL.quote((String)(String.valueOf(this.escapeString(con, this.fixWindowsPath(this.defParam.get("default_bad_file_path")))) + transId + ".bad")));
        sql.append(",\n").append(this.defParam.get("show_progress_freq"));
        sql.append(",\n").append("0");
        sql.append(",\n").append("0");
        sql.append(",\n").append(SQL.escapeDate((Connection)con, (Date)new Date()));
        sql.append(",\n").append(SQL.quote((String)(String.valueOf(this.fixUnixPath(this.defParam.get("default_unix_log_file_path"))) + transId + ".log")));
        sql.append(",\n").append(SQL.quote((String)(String.valueOf(this.fixUnixPath(this.defParam.get("default_unix_err_file_path"))) + transId + ".err")));
        sql.append(",\n").append(SQL.quote((String)(String.valueOf(this.fixUnixPath(this.defParam.get("default_unix_bad_file_path"))) + transId + ".bad")));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote((String)this.defParam.get("append_to_log_ind")));
        sql.append(",\n").append(SQL.quote((String)this.defParam.get("append_to_err_ind")));
        sql.append(",\n").append(SQL.quote((String)this.defParam.get("append_to_bad_ind")));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote((String)"N"));
        sql.append(",\n").append(SQL.quote((String)"N"));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote((String)"POWER_LOADER"));
        sql.append(",\n").append(SQL.quote((String)"Y"));
        sql.append(",\n").append(SQL.quote((String)System.getProperty("user.name")));
        sql.append(",\n").append(SQL.quote((String)"N"));
        sql.append(",\n").append(SQL.quote((String)"Y"));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(",\n").append(SQL.quote(null));
        sql.append(")");
        this.logWriter.info("INSERT into TRANS, PK=" + transId);
        Statement s = con.createStatement();
        try {
            try {
                logger.debug((Object)("INSERT TRANS: " + sql.toString()));
                s.executeUpdate(sql.toString());
                status = "OK";
            }
            catch (SQLException ex) {
                logger.error((Object)("This statement caused an exception: " + sql));
                status = "Error";
                throw ex;
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
            this.exportResultList.add(new ASUtils.LabelValueBean("Create Trans " + transId, status));
        }
    }

    public void insertTransTableFile(Connection con, String transId, String tableFileId, SQLTable table, boolean isOutput, int seqNo) throws SQLException {
        String type;
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(DDLUtils.toQualifiedName(this.repositoryCatalog, this.repositorySchema, "TRANS_TABLE_FILE"));
        sql.append(" (TRANS_ID, TABLE_FILE_ID, TABLE_FILE_IND, TABLE_FILE_TYPE, INPUT_OUTPUT_IND, SYSTEM_NAME, SERVER_NAME, FILE_CHAR_SET, TEXT_DELIMITER, TEXT_QUALIFIER, OWNER, TABLE_FILE_NAME, TABLE_FILE_ACCESS_PATH, MAX_ADD_COUNT, MAX_UPD_COUNT, MAX_DEL_COUNT, MAX_ERR_COUNT, FILTER_CRITERION, PROC_SEQ_NO, HEADER_REC_IND, LAST_UPDATE_DATE, LAST_UPDATE_USER, TRANS_TABLE_FILE_COMMENT, DB_CONNECT_NAME, UNIX_FILE_ACCESS_PATH, REC_DELIMITER, SELECT_CLAUSE, FROM_CLAUSE, WHERE_CLAUSE, ORDER_BY_CRITERION, TRUNCATE_IND, ACTION_TYPE, ANALYZE_IND, PRE_PROCESSED_FILE_NAME, UNIX_PRE_PROCESSED_FILE_NAME, PARENT_FILE_ID, CHILD_REQUIRED_IND, LAST_UPDATE_OS_USER, DELETE_IND, FROM_CLAUSE_DB)");
        sql.append(" VALUES (");
        sql.append(SQL.quote((String)transId));
        sql.append(",").append(SQL.quote((String)tableFileId));
        sql.append(",").append(SQL.quote((String)"TABLE"));
        ArchitectDataSource dataSource = isOutput ? this.targetDataSource : table.getParentDatabase().getDataSource();
        String dbConnectName = dataSource.get("Logical");
        if (this.isOracle(dataSource)) {
            type = "ORACLE";
        } else if (this.isSQLServer(dataSource)) {
            type = "SQL SERVER";
        } else if (this.isDB2(dataSource)) {
            type = "DB2";
        } else if (this.isPostgres(dataSource)) {
            type = "POSTGRES";
        } else {
            throw new IllegalArgumentException("Unsupported target database type");
        }
        sql.append(",").append(SQL.quote((String)type));
        sql.append(",").append(SQL.quote((String)(isOutput ? "O" : "I")));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote((String)(isOutput ? this.targetSchema : table.getParent().toString())));
        sql.append(",").append(SQL.quote((String)table.getName()));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(seqNo);
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.escapeDate((Connection)con, (Date)new Date()));
        sql.append(",").append(SQL.quote((String)con.getMetaData().getUserName()));
        sql.append(",").append(SQL.quote((String)("Generated by Power*Architect " + PL_GENERATOR_VERSION)));
        sql.append(",").append(SQL.quote((String)dbConnectName));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote((String)System.getProperty("user.name")));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(")");
        this.logWriter.info("INSERT into TRANS_TABLE_FILE, PK=" + transId + "|" + tableFileId);
        Statement s = con.createStatement();
        try {
            logger.debug((Object)("INSERT TRANS_TABLE_FILE: " + sql.toString()));
            s.executeUpdate(sql.toString());
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    public void insertMappings(Connection con, String transId, String outputTableId, SQLTable outputTable, String inputTableId, SQLTable inputTable) throws SQLException, ArchitectException {
        int seqNo = 1;
        for (SQLColumn outCol : outputTable.getColumns()) {
            SQLColumn sourceCol = outCol.getSourceColumn();
            if (sourceCol == null || sourceCol.getParentTable() != inputTable || outCol.getNullable() != 0 && sourceCol == null) continue;
            this.insertTransColMap(con, transId, outputTableId, outCol, inputTableId, seqNo);
            ++seqNo;
        }
    }

    public void insertTransColMap(Connection con, String transId, String outputTableId, SQLColumn outputColumn, String inputTableId, int seqNo) throws SQLException {
        SQLColumn inputColumn = outputColumn.getSourceColumn();
        String inputColumnName = inputColumn != null ? inputColumn.getName() : null;
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(DDLUtils.toQualifiedName(this.repositoryCatalog, this.repositorySchema, "TRANS_COL_MAP"));
        sql.append(" (TRANS_ID, INPUT_TABLE_FILE_ID, INPUT_TRANS_COL_NAME, OUTPUT_TABLE_FILE_ID, OUTPUT_TRANS_COL_NAME, VALID_ACTION_TYPE, NATURAL_ID_IND, REAL_MEM_TRANS_IND, DEFAULT_VALUE, INPUT_TRANS_VALUE, OUTPUT_TRANS_VALUE, TRANS_TABLE_NAME, SEQ_NAME, GRP_FUNC_STRING, TRANS_COL_MAP_COMMENT, PROCESS_SEQ_NO, LAST_update_DATE, LAST_update_USER, OUTPUT_PROC_SEQ_NO, TRANSLATION_VALUE, ACTIVE_IND, PL_SEQ_IND, PL_SEQ_INCREMENT, LAST_update_OS_USER, TRANSFORMATION_CRITERIA, PL_SEQ_update_TABLE_IND, SEQ_TABLE_IND, SEQ_WHERE_CLAUSE)");
        sql.append(" VALUES (");
        sql.append(SQL.quote((String)transId));
        sql.append(",").append(SQL.quote((String)inputTableId));
        sql.append(",").append(SQL.quote((String)inputColumnName));
        sql.append(",").append(SQL.quote((String)outputTableId));
        sql.append(",").append(SQL.quote((String)outputColumn.getName()));
        sql.append(",").append(SQL.quote((String)(outputColumn.getPrimaryKeySeq() != null ? "A" : "AU")));
        sql.append(",").append(SQL.quote((String)(outputColumn.getPrimaryKeySeq() != null ? "Y" : "N")));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote((String)outputColumn.getDefaultValue()));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote((String)("Generated by Power*Architect " + PL_GENERATOR_VERSION)));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.escapeDate((Connection)con, (Date)new Date()));
        sql.append(",").append(SQL.quote((String)con.getMetaData().getUserName()));
        sql.append(",").append(seqNo);
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote((String)"Y"));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote((String)System.getProperty("user.name")));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(")");
        this.logWriter.info("INSERT into TRANS_COL_MAP, PK=" + transId + "|" + outputTableId + "|" + outputColumn.getName());
        Statement s = con.createStatement();
        try {
            logger.debug((Object)("INSERT TRANS_COL_MAP: " + sql.toString()));
            s.executeUpdate(sql.toString());
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertTransExceptHandler(Connection con, String actionType, String transId, Connection targetConnection) throws SQLException {
        String resultActionType;
        String errorCode = "";
        String databaseType = "";
        if (DBConnection.isOracle((Connection)targetConnection)) {
            databaseType = "ORACLE";
            if (actionType.equals("A")) {
                errorCode = "-1";
                resultActionType = "CHANGE_TO_UPD";
            } else if (actionType.equals("U")) {
                errorCode = "1403";
                resultActionType = "CHANGE_TO_ADD";
            } else {
                if (!actionType.equals("D")) throw new IllegalArgumentException("Invalid Action type " + actionType);
                errorCode = "1403";
                resultActionType = "SKIP";
            }
        } else if (DBConnection.isSQLServer((Connection)targetConnection)) {
            databaseType = "SQL SERVER";
            if (actionType.equals("A")) {
                errorCode = "-2627";
                resultActionType = "CHANGE_TO_UPD";
            } else if (actionType.equals("U")) {
                errorCode = "100";
                resultActionType = "CHANGE_TO_ADD";
            } else {
                if (!actionType.equals("D")) throw new IllegalArgumentException("Invalid Action type " + actionType);
                errorCode = "100";
                resultActionType = "SKIP";
            }
        } else if (DBConnection.isDB2((Connection)targetConnection)) {
            databaseType = "DB2";
            if (actionType.equals("A")) {
                errorCode = "-803";
                resultActionType = "CHANGE_TO_UPD";
            } else if (actionType.equals("U")) {
                errorCode = "100";
                resultActionType = "CHANGE_TO_ADD";
            } else {
                if (!actionType.equals("D")) throw new IllegalArgumentException("Invalid Action type " + actionType);
                errorCode = "100";
                resultActionType = "SKIP";
            }
        } else {
            if (!DBConnection.isPostgres((Connection)targetConnection)) throw new IllegalArgumentException("Unsupported Target Database type");
            databaseType = "POSTGRES";
            if (actionType.equals("A")) {
                errorCode = "23505";
                resultActionType = "CHANGE_TO_UPD";
            } else if (actionType.equals("U")) {
                errorCode = "100";
                resultActionType = "CHANGE_TO_ADD";
            } else {
                if (!actionType.equals("D")) throw new IllegalArgumentException("Invalid Action type " + actionType);
                errorCode = "100";
                resultActionType = "SKIP";
            }
        }
        StringBuffer sql = new StringBuffer("INSERT INTO ");
        sql.append(DDLUtils.toQualifiedName(this.repositoryCatalog, this.repositorySchema, "TRANS_EXCEPT_HANDLE"));
        sql.append(" (TRANS_ID, INPUT_ACTION_TYPE, DBMS_ERROR_CODE, RESULT_ACTION_TYPE, EXCEPT_HANDLE_COMMENT, LAST_update_DATE, LAST_update_USER, PKG_NAME, PKG_PARAM, PROC_FUNC_IND, ACTIVE_IND, LAST_update_OS_USER, DATABASE_TYPE)");
        sql.append(" VALUES (");
        sql.append(SQL.quote((String)transId));
        sql.append(",").append(SQL.quote((String)actionType));
        sql.append(",").append(SQL.quote((String)errorCode));
        sql.append(",").append(SQL.quote((String)resultActionType));
        sql.append(",").append(SQL.quote((String)("Generated by Power*Architect " + PL_GENERATOR_VERSION)));
        sql.append(",").append(SQL.escapeDate((Connection)con, (Date)new Date()));
        sql.append(",").append(SQL.quote((String)con.getMetaData().getUserName()));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote(null));
        sql.append(",").append(SQL.quote((String)"Y"));
        sql.append(",").append(SQL.quote((String)System.getProperty("user.name")));
        sql.append(",").append(SQL.quote((String)databaseType));
        sql.append(")");
        this.logWriter.info("INSERT into TRANS_EXCEPT_HANDLE, PK=" + transId + "|" + actionType + "|" + errorCode);
        Statement s = con.createStatement();
        try {
            logger.debug((Object)("INSERT TRANS_EXCEPT_HANDLE: " + sql.toString()));
            s.executeUpdate(sql.toString());
            return;
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    public void export(List<SQLTable> tablesToExport) throws SQLException, ArchitectException {
        logger.debug((Object)("Starting export of tables: " + tablesToExport));
        this.finished = false;
        this.hasStarted = true;
        Connection con = null;
        Connection tCon = null;
        try {
            this.currentDB = tablesToExport;
            this.logWriter = new LogWriter(ArchitectSessionImpl.getInstance().getUserSettings().getETLUserSettings().getString("ETLUserSettings.PROP_ETL_LOG_PATH", ""));
            SQLDatabase repository = new SQLDatabase(this.repositoryDataSource);
            con = repository.getConnection();
            try {
                this.defParam = new DefaultParameters(con);
            }
            catch (PLSchemaException p) {
                throw new ArchitectException("couldn't load default parameters", p);
            }
            SQLDatabase target = new SQLDatabase(this.targetDataSource);
            tCon = target.getConnection();
            this.exportResultList.add(new ASUtils.LabelValueBean("\n  Creating Power Loader Job", "\n"));
            this.sm = null;
            int tryNum = 0;
            while (tryNum < 3 && this.sm == null) {
                String username = tryNum == 1 ? this.repositoryDataSource.get("UID").toUpperCase() : (tryNum == 2 ? this.repositoryDataSource.get("UID").toLowerCase() : this.repositoryDataSource.get("UID"));
                try {
                    this.sm = new PLSecurityManager(con, username, this.repositoryDataSource.get("PWD"), false);
                }
                catch (PLSecurityException se) {
                    logger.debug((Object)("Couldn't find pl user " + username), (Throwable)se);
                }
                ++tryNum;
            }
            if (this.sm == null) {
                throw new ArchitectException("There is no entry for \"" + this.repositoryDataSource.get("UID") + "\" in the PL_USER table");
            }
            this.logWriter.info("Starting creation of job <" + this.jobId + "> at " + new Date(System.currentTimeMillis()));
            this.logWriter.info("Connected to database: " + this.repositoryDataSource.toString());
            this.maybeInsertFolder(con);
            PLJob job = new PLJob(this.jobId);
            this.insertJob(con);
            this.insertFolderDetail(con, job.getObjectType(), job.getObjectName());
            DepthFirstSearch targetDFS = new DepthFirstSearch(tablesToExport);
            LinkedList tables = targetDFS.getFinishOrder();
            if (logger.isDebugEnabled()) {
                StringBuffer tableOrder = new StringBuffer();
                Iterator dit = tables.iterator();
                while (dit.hasNext()) {
                    tableOrder.append(((SQLTable)dit.next()).getName()).append(", ");
                }
                logger.debug((Object)("Safe load order for job is: " + tableOrder));
            }
            int outputTableNum = 1;
            Hashtable<SQLTable, PLTransaction> inputTables = new Hashtable<SQLTable, PLTransaction>();
            Iterator targetTableIt = tables.iterator();
            while (targetTableIt.hasNext()) {
                ++this.tableCount;
                SQLTable outputTable = (SQLTable)targetTableIt.next();
                boolean createdOutputTableMetaData = false;
                int transNum = 0;
                int seqNum = 1;
                String transName = null;
                String outputTableId = null;
                String inputTableId = null;
                for (SQLColumn outputCol : outputTable.getColumns()) {
                    SQLColumn inputCol = outputCol.getSourceColumn();
                    if (inputCol != null && !inputTables.keySet().contains(inputCol.getParentTable())) {
                        SQLTable inputTable = inputCol.getParentTable();
                        String baseTransName = PLUtils.toPLIdentifier("LOAD_" + outputTable.getName());
                        transNum = this.generateUniqueTransIdx(con, baseTransName);
                        transName = String.valueOf(baseTransName) + "_" + transNum;
                        logger.debug((Object)("transName: " + transName));
                        this.insertTrans(con, transName, outputTable.getRemarks());
                        this.insertFolderDetail(con, "TRANSACTION", transName);
                        this.insertTransExceptHandler(con, "A", transName, tCon);
                        this.insertTransExceptHandler(con, "U", transName, tCon);
                        this.insertTransExceptHandler(con, "D", transName, tCon);
                        this.insertJobDetail(con, outputTableNum * 10, "TRANSACTION", transName);
                        inputTableId = PLUtils.toPLIdentifier(String.valueOf(inputTable.getName()) + "_IN_" + transNum);
                        logger.debug((Object)("inputTableId: " + inputTableId));
                        this.insertTransTableFile(con, transName, inputTableId, inputTable, false, transNum);
                        inputTables.put(inputTable, new PLTransaction(transName, inputTableId, transNum));
                    } else {
                        PLTransaction plt = (PLTransaction)inputTables.get(inputCol.getParentTable());
                        transName = plt.getName();
                        inputTableId = plt.getInputTableId();
                        transNum = plt.getTransNum();
                    }
                    if (!createdOutputTableMetaData) {
                        logger.debug((Object)("outputTableNum: " + outputTableNum));
                        outputTableId = PLUtils.toPLIdentifier(String.valueOf(outputTable.getName()) + "_OUT_" + outputTableNum);
                        logger.debug((Object)("outputTableId: " + outputTableId));
                        this.insertTransTableFile(con, transName, outputTableId, outputTable, true, transNum);
                        createdOutputTableMetaData = true;
                    }
                    if (inputCol != null) {
                        this.insertTransColMap(con, transName, outputTableId, outputCol, inputTableId, seqNum * 10);
                    }
                    ++seqNum;
                    ++outputTableNum;
                }
            }
        }
        finally {
            this.hasStarted = false;
            this.finished = true;
            this.currentDB = null;
            this.logWriter.flush();
            this.logWriter.close();
            this.logWriter = null;
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Couldn't close repository connection", (Throwable)e);
            }
            try {
                if (tCon != null) {
                    tCon.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Couldn't close target connection", (Throwable)e);
            }
        }
    }

    private String fixWindowsPath(String path) {
        if (path == null) {
            return "";
        }
        if (!path.endsWith("\\")) {
            path = String.valueOf(path) + "\\";
        }
        return path;
    }

    private String fixUnixPath(String path) {
        if (path == null) {
            path = "";
        } else if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    private String escapeString(Connection con, String string) {
        String retString = null;
        retString = DBConnection.isPostgres((Connection)con) ? string.replaceAll("\\\\", "\\\\\\\\") : string;
        return retString;
    }

    private boolean isOracle(ArchitectDataSource dbcs) {
        return dbcs.getDriverClass().toLowerCase().indexOf("oracledriver") >= 0;
    }

    private boolean isSQLServer(ArchitectDataSource dbcs) {
        return dbcs.getDriverClass().toLowerCase().indexOf("sqlserver") >= 0;
    }

    private boolean isDB2(ArchitectDataSource dbcs) {
        return dbcs.getDriverClass().toLowerCase().indexOf("db2") >= 0;
    }

    private boolean isPostgres(ArchitectDataSource dbcs) {
        return dbcs.getDriverClass().toLowerCase().indexOf("postgres") >= 0;
    }

    public void setJobId(String jobId) {
        this.jobId = PLUtils.toPLIdentifier(jobId);
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setFolderName(String folderName) {
        this.folderName = PLUtils.toPLIdentifier(folderName);
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public void setJobComment(String jobComment) {
        this.jobComment = jobComment;
    }

    public String getJobComment() {
        return this.jobComment;
    }

    public void setRepositoryDataSource(ArchitectDataSource dbcs) {
        this.repositoryDataSource = dbcs;
    }

    public ArchitectDataSource getRepositoryDataSource() {
        return this.repositoryDataSource;
    }

    public boolean getRunPLEngine() {
        return this.runPLEngine;
    }

    public void setRunPLEngine(boolean runEngine) {
        this.runPLEngine = runEngine;
    }

    public void setPlSecurityManager(PLSecurityManager sm) {
        this.sm = sm;
    }

    public PLSecurityManager getPlSecurityManager() {
        return this.sm;
    }

    public ArchitectDataSource getTargetDataSource() {
        return this.targetDataSource;
    }

    public void setTargetDataSource(ArchitectDataSource targetDataSource) {
        this.targetDataSource = targetDataSource;
    }

    public String getTargetSchema() {
        return this.targetSchema;
    }

    public void setTargetSchema(String schema) {
        this.targetSchema = schema;
    }

    public void setTargetSchema(SQLSchema schema) {
        if (schema != null) {
            this.targetSchema = schema.getName();
        }
    }

    public String getTargetCatalog() {
        return this.targetCatalog;
    }

    public void setTargetCatalog(String targetCatalog) {
        this.targetCatalog = targetCatalog;
    }

    public void setTargetCatalog(SQLCatalog targetCatalog) {
        if (targetCatalog != null) {
            this.targetCatalog = targetCatalog.getName();
        }
    }

    public String getRepositoryCatalog() {
        return this.repositoryCatalog;
    }

    public void setRepositoryCatalog(SQLCatalog repositoryCatalog) {
        if (repositoryCatalog != null) {
            this.repositoryCatalog = repositoryCatalog.getName();
        }
    }

    public void setRepositoryCatalog(String repositoryCatalog) {
        this.repositoryCatalog = repositoryCatalog;
    }

    public String getRepositorySchema() {
        return this.repositorySchema;
    }

    public void setRepositorySchema(SQLSchema repositorySchema) {
        if (repositorySchema != null) {
            this.repositorySchema = repositorySchema.getName();
        }
    }

    public void setRepositorySchema(String repositorySchema) {
        this.repositorySchema = repositorySchema;
    }

    public ArrayList<ASUtils.LabelValueBean> getExportResultList() {
        return this.exportResultList;
    }

    public void setExportResultList(ArrayList<ASUtils.LabelValueBean> exportResultList) {
        this.exportResultList = exportResultList;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    private void println(PrintWriter out, int indent, String text) {
        int i = 0;
        while (i < indent) {
            out.print(" ");
            ++i;
        }
        out.println(text);
    }

    public void exportXML(List<SQLTable> tablesToExport) throws IOException, ArchitectException, SQLException {
        PrintWriter out = null;
        String encoding = "ISO-8859-1";
        int indent = 0;
        out = new PrintWriter(this.file);
        Connection con = null;
        try {
            SQLDatabase repository = new SQLDatabase(this.repositoryDataSource);
            con = repository.getConnection();
            this.currentDB = tablesToExport;
            try {
                this.defParam = new DefaultParameters(con);
            }
            catch (PLSchemaException p) {
                throw new ArchitectException("couldn't load default parameters", p);
            }
            this.sm = null;
            int tryNum = 0;
            while (tryNum < 3 && this.sm == null) {
                String username = tryNum == 1 ? this.repositoryDataSource.get("UID").toUpperCase() : (tryNum == 2 ? this.repositoryDataSource.get("UID").toLowerCase() : this.repositoryDataSource.get("UID"));
                try {
                    this.sm = new PLSecurityManager(con, username, this.repositoryDataSource.get("PWD"), false);
                }
                catch (PLSecurityException se) {
                    logger.debug((Object)("Couldn't find pl user " + username), (Throwable)se);
                }
                ++tryNum;
            }
            if (this.sm == null) {
                throw new ArchitectException("Could not find login for: " + this.repositoryDataSource.get("UID"));
            }
            this.println(out, indent, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            this.println(out, indent, "<EXPORT>");
            this.println(out, ++indent, "<SCHEMA_VERSION>5.0.22</SCHEMA_VERSION>");
            this.exportXMLJobs(out, indent, con);
            if (this.folderName != null) {
                this.exportXMLFolder(out, indent, this.folderName);
                this.exportXMLFolderDetail(out, indent, this.folderName, "JOB", this.jobId);
            }
            Hashtable<SQLTable, PLTransaction> inputTables = new Hashtable<SQLTable, PLTransaction>();
            Hashtable<String, Set> trans = new Hashtable<String, Set>();
            this.tableCount = 0;
            Iterator<SQLTable> targetTableIt = this.currentDB.iterator();
            while (targetTableIt.hasNext()) {
                ++this.tableCount;
                int outputTableNum = 1;
                SQLTable outputTable = targetTableIt.next();
                String baseTransName = PLUtils.toPLIdentifier("LOAD_" + outputTable.getName());
                boolean createdOutputTableMetaData = false;
                Iterator<SQLColumn> cols = outputTable.getColumns().iterator();
                String outputTableId = null;
                String inputTableId = null;
                int seqNum = 1;
                while (cols.hasNext()) {
                    String transName;
                    int transNum;
                    SQLColumn outputCol = cols.next();
                    SQLColumn inputCol = outputCol.getSourceColumn();
                    if (inputCol != null && !inputTables.keySet().contains(inputCol.getParentTable())) {
                        Set set;
                        SQLTable inputTable = inputCol.getParentTable();
                        if (!trans.keySet().contains(baseTransName)) {
                            set = this.getTransName(con, baseTransName);
                            trans.put(baseTransName, set);
                        } else {
                            set = (Set)trans.get(baseTransName);
                        }
                        transNum = this.generateUniqueTransIdx(set, baseTransName);
                        transName = String.valueOf(baseTransName) + "_" + transNum;
                        set.add(transName);
                        this.exportXMLJobsDetail(out, indent, con, transName, this.tableCount * 10);
                        this.exportXMLTrans(out, indent, con, transName, outputTable.getRemarks());
                        this.exportXMLTransException(out, indent, con, transName, "A");
                        this.exportXMLTransException(out, indent, con, transName, "U");
                        this.exportXMLTransException(out, indent, con, transName, "D");
                        inputTableId = PLUtils.toPLIdentifier(String.valueOf(inputTable.getName()) + "_IN_" + transNum);
                        inputTables.put(inputTable, new PLTransaction(transName, inputTableId, transNum));
                        this.exportXMLTransTableFile(out, indent, con, transName, inputTableId, inputTable, 10 * seqNum++, false);
                        if (this.folderName != null) {
                            this.exportXMLFolder(out, indent, this.folderName);
                            this.exportXMLFolderDetail(out, indent, this.folderName, "TRANSACTION", transName);
                        }
                    } else {
                        PLTransaction plt = (PLTransaction)inputTables.get(inputCol.getParentTable());
                        transName = plt.getName();
                        inputTableId = plt.getInputTableId();
                        transNum = plt.getTransNum();
                    }
                    if (!createdOutputTableMetaData) {
                        outputTableId = PLUtils.toPLIdentifier(String.valueOf(outputTable.getName()) + "_OUT_" + outputTableNum);
                        this.exportXMLTransTableFile(out, indent, con, transName, outputTableId, outputTable, 10 * seqNum++, true);
                        createdOutputTableMetaData = true;
                    }
                    if (inputCol == null) continue;
                    this.exportXMLTransColMap(out, indent, con, inputCol, transName, inputTableId, outputTableId, seqNum);
                }
                ++outputTableNum;
            }
            this.println(out, --indent, "</EXPORT>");
        }
        finally {
            if (out != null) {
                out.close();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Couldn't close connection", (Throwable)e);
            }
            this.currentDB = null;
        }
    }

    public void exportXMLJobs(PrintWriter out, int indent, Connection con) {
        this.println(out, indent, "<PL_JOB>");
        this.println(out, ++indent, "<JOB_ID>" + this.jobId + "</JOB_ID>");
        if (this.jobDescription != null) {
            this.println(out, indent, "<JOB_DESC>" + this.jobDescription + "</JOB_DESC>");
        }
        this.println(out, indent, "<SHOW_PROGRESS_FREQ>100</SHOW_PROGRESS_FREQ>");
        this.println(out, indent, "<LOG_FILE_NAME>" + this.fixWindowsPath(this.defParam.get("default_log_file_path")) + this.jobId + ".log" + "</LOG_FILE_NAME>");
        this.println(out, indent, "<ERR_FILE_NAME>" + this.fixWindowsPath(this.defParam.get("default_err_file_path")) + this.jobId + ".err" + "</ERR_FILE_NAME>");
        this.println(out, indent, "<UNIX_LOG_FILE_NAME>" + this.fixUnixPath(this.defParam.get("default_log_file_path")) + this.jobId + ".log" + "</UNIX_LOG_FILE_NAME>");
        this.println(out, indent, "<UNIX_ERR_FILE_NAME>" + this.fixUnixPath(this.defParam.get("default_err_file_path")) + this.jobId + ".err" + "</UNIX_ERR_FILE_NAME>");
        this.println(out, indent, "<APPEND_TO_LOG_IND>N</APPEND_TO_LOG_IND>");
        this.println(out, indent, "<APPEND_TO_ERR_IND>N</APPEND_TO_ERR_IND>");
        this.println(out, indent, "<DEBUG_MODE_IND>N</DEBUG_MODE_IND>");
        this.println(out, indent, "<APPEND_TO_ERR_IND>N</APPEND_TO_ERR_IND>");
        this.println(out, indent, "<COMMIT_FREQ>100</COMMIT_FREQ>");
        if (this.jobComment != null) {
            this.println(out, indent, "<JOB_COMMENT>" + this.jobComment + "</JOB_COMMENT>");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.println(out, indent, "<CREATE_DATE><DATE>" + df.format(new Date()) + "</DATE></CREATE_DATE>");
        this.println(out, indent, "<LAST_UPDATE_DATE><DATE>" + df.format(new Date()) + "</DATE></LAST_UPDATE_DATE>");
        this.println(out, indent, "<LAST_UPDATE_USER></LAST_UPDATE_USER>");
        this.println(out, indent, "<SKIP_PACKAGES_IND>N</SKIP_PACKAGES_IND>");
        this.println(out, indent, "<SEND_EMAIL_IND>N</SEND_EMAIL_IND>");
        this.println(out, indent, "<LAST_UPDATE_OS_USER>" + System.getProperty("user.name") + "</LAST_UPDATE_OS_USER>");
        this.println(out, indent, "<STATS_IND>N</STATS_IND>");
        this.println(out, indent, "<ODBC_IND>N</ODBC_IND>");
        this.println(out, --indent, "</PL_JOB>");
    }

    public void exportXMLJobsDetail(PrintWriter out, int indent, Connection con, String objName, int seqno) throws SQLException {
        this.println(out, indent, "<JOB_DETAIL>");
        this.println(out, ++indent, "<JOB_ID>" + this.jobId + "</JOB_ID>");
        this.println(out, indent, "<JOB_PROCESS_SEQ_NO>" + seqno + "</JOB_PROCESS_SEQ_NO>");
        this.println(out, indent, "<OBJECT_TYPE>TRANSACTION</OBJECT_TYPE>");
        this.println(out, indent, "<OBJECT_NAME>" + objName + "</OBJECT_NAME>");
        this.println(out, indent, "<JOB_DETAIL_COMMENT>Generated by POWER*Architect PLExport Revision: " + PL_GENERATOR_VERSION + "</JOB_DETAIL_COMMENT>");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.println(out, indent, "<LAST_UPDATE_DATE><DATE>" + df.format(new Date()) + "</DATE></LAST_UPDATE_DATE>");
        this.println(out, indent, "<LAST_UPDATE_USER>" + con.getMetaData().getUserName() + "</LAST_UPDATE_USER>");
        this.println(out, indent, "<FAILURE_ABORT_IND>N</FAILURE_ABORT_IND>");
        this.println(out, indent, "<WARNING_ABORT_IND>N</WARNING_ABORT_IND>");
        this.println(out, indent, "<ACTIVE_IND>Y</ACTIVE_IND>");
        this.println(out, indent, "<LAST_UPDATE_OS_USER>" + System.getProperty("user.name") + "</LAST_UPDATE_OS_USER>");
        this.println(out, --indent, "</JOB_DETAIL>");
    }

    public void exportXMLFolder(PrintWriter out, int indent, String name) {
        this.println(out, indent, "<PL_FOLDER>");
        this.println(out, ++indent, "<FOLDER_NAME>" + name + "</FOLDER_NAME>");
        this.println(out, --indent, "</PL_FOLDER>");
    }

    private void exportXMLFolderDetail(PrintWriter out, int indent, String name, Object objType, Object objName) {
        this.println(out, indent, "<PL_FOLDER_DETAIL>");
        this.println(out, ++indent, "<FOLDER_NAME>" + name + "</FOLDER_NAME>");
        this.println(out, indent, "<OBJECT_TYPE>" + objType + "</OBJECT_TYPE>");
        this.println(out, indent, "<OBJECT_NAME>" + objName + "</OBJECT_NAME>");
        this.println(out, --indent, "</PL_FOLDER_DETAIL>");
    }

    private void exportXMLTrans(PrintWriter out, int indent, Connection con, String transId, String comment) throws SQLException {
        this.println(out, indent, "<TRANS>");
        this.println(out, ++indent, "<TRANS_ID>" + transId + "</TRANS_ID>");
        this.println(out, indent, "<TRANS_DESC>Generated by Power*Architect " + PL_GENERATOR_VERSION + "</TRANS_DESC>");
        this.println(out, indent, "<TRANS_COMMENT>" + comment + "</TRANS_COMMENT>");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.println(out, indent, "<LAST_UPDATE_DATE><DATE>" + df.format(new Date()) + "</DATE></LAST_UPDATE_DATE>");
        this.println(out, indent, "<LAST_UPDATE_USER>" + con.getMetaData().getUserName() + "</LAST_UPDATE_USER>");
        this.println(out, indent, "<DEBUG_MODE_IND>N</DEBUG_MODE_IND>");
        this.println(out, indent, "<ERR_FILE_NAME>" + this.escapeString(con, this.fixWindowsPath(this.defParam.get("default_err_file_path"))) + transId + ".err" + "</ERR_FILE_NAME>");
        this.println(out, indent, "<LOG_FILE_NAME>" + this.escapeString(con, this.fixWindowsPath(this.defParam.get("default_log_file_path"))) + transId + ".err" + "</LOG_FILE_NAME>");
        this.println(out, indent, "<BAD_FILE_NAME>" + this.escapeString(con, this.fixWindowsPath(this.defParam.get("default_bad_file_path"))) + transId + ".err" + "</BAD_FILE_NAME>");
        this.println(out, indent, "<SKIP_CNT>0</SKIP_CNT>");
        this.println(out, indent, "<PROCESS_CNT>0</PROCESS_CNT>");
        this.println(out, indent, "<CREATE_DATE><DATE>" + SQL.escapeDate((Connection)con, (Date)new Date()) + "</DATE></CREATE_DATE>");
        this.println(out, indent, "<UNIX_LOG_FILE_NAME>" + this.escapeString(con, this.fixUnixPath(this.defParam.get("default_unix_log_file_path"))) + transId + ".err" + "</UNIX_LOG_FILE_NAME>");
        this.println(out, indent, "<UNIX_ERR_FILE_NAME>" + this.escapeString(con, this.fixUnixPath(this.defParam.get("default_unix_err_file_path"))) + transId + ".err" + "</UNIX_ERR_FILE_NAME>");
        this.println(out, indent, "<UNIX_BAD_FILE_NAME>" + this.escapeString(con, this.fixUnixPath(this.defParam.get("default_unix_bad_file_path"))) + transId + ".err" + "</UNIX_BAD_FILE_NAME>");
        this.println(out, indent, "<SKIP_PACKAGES_IND>N</SKIP_PACKAGES_IND>");
        this.println(out, indent, "<SEND_EMAIL_IND>N</SEND_EMAIL_IND>");
        this.println(out, indent, "<TRANSACTION_TYPE>POWER_LOADER</TRANSACTION_TYPE>");
        this.println(out, indent, "<DELTA_SORT_IND>Y</DELTA_SORT_IND>");
        this.println(out, indent, "<LAST_UPDATE_OS_USER>" + System.getProperty("user.name") + "</LAST_UPDATE_OS_USER>");
        this.println(out, indent, "<STATS_IND>N</STATS_IND>");
        this.println(out, indent, "<ODBC_IND>Y</ODBC_IND>");
        this.println(out, --indent, "</TRANS>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exportXMLTransException(PrintWriter out, int indent, Connection con, String transId, String actionType) throws SQLException {
        String resultActionType;
        String errorCode = "";
        String databaseType = "";
        if (DBConnection.isOracle((Connection)con)) {
            databaseType = "ORACLE";
            if (actionType.equals("A")) {
                errorCode = "-1";
                resultActionType = "CHANGE_TO_UPD";
            } else if (actionType.equals("U")) {
                errorCode = "1403";
                resultActionType = "CHANGE_TO_ADD";
            } else {
                if (!actionType.equals("D")) throw new IllegalArgumentException("Invalid Action type " + actionType);
                errorCode = "1403";
                resultActionType = "SKIP";
            }
        } else if (DBConnection.isSQLServer((Connection)con)) {
            databaseType = "SQL SERVER";
            if (actionType.equals("A")) {
                errorCode = "-2627";
                resultActionType = "CHANGE_TO_UPD";
            } else if (actionType.equals("U")) {
                errorCode = "100";
                resultActionType = "CHANGE_TO_ADD";
            } else {
                if (!actionType.equals("D")) throw new IllegalArgumentException("Invalid Action type " + actionType);
                errorCode = "100";
                resultActionType = "SKIP";
            }
        } else if (DBConnection.isDB2((Connection)con)) {
            databaseType = "DB2";
            if (actionType.equals("A")) {
                errorCode = "-803";
                resultActionType = "CHANGE_TO_UPD";
            } else if (actionType.equals("U")) {
                errorCode = "100";
                resultActionType = "CHANGE_TO_ADD";
            } else {
                if (!actionType.equals("D")) throw new IllegalArgumentException("Invalid Action type " + actionType);
                errorCode = "100";
                resultActionType = "SKIP";
            }
        } else {
            if (!DBConnection.isPostgres((Connection)con)) throw new IllegalArgumentException("Unsupported Target Database type");
            databaseType = "POSTGRES";
            if (actionType.equals("A")) {
                errorCode = "23505";
                resultActionType = "CHANGE_TO_UPD";
            } else if (actionType.equals("U")) {
                errorCode = "100";
                resultActionType = "CHANGE_TO_ADD";
            } else {
                if (!actionType.equals("D")) throw new IllegalArgumentException("Invalid Action type " + actionType);
                errorCode = "100";
                resultActionType = "SKIP";
            }
        }
        this.println(out, indent, "<TRANS_EXCEPT_HANDLE>");
        this.println(out, ++indent, "<TRANS_ID>" + transId + "</TRANS_ID>");
        this.println(out, indent, "<database_type>" + databaseType + "</database_type>");
        this.println(out, indent, "<INPUT_ACTION_TYPE>" + actionType + "</INPUT_ACTION_TYPE>");
        this.println(out, indent, "<DBMS_ERROR_CODE>" + errorCode + "</DBMS_ERROR_CODE>");
        this.println(out, indent, "<RESULT_ACTION_TYPE>" + resultActionType + "</RESULT_ACTION_TYPE>");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.println(out, indent, "<LAST_UPDATE_DATE><DATE>" + df.format(new Date()) + "</DATE></LAST_UPDATE_DATE>");
        this.println(out, indent, "<LAST_UPDATE_USER>" + con.getMetaData().getUserName() + "</LAST_UPDATE_USER>");
        this.println(out, indent, "<ACTIVE_IND>Y</ACTIVE_IND>");
        this.println(out, indent, "<LAST_UPDATE_OS_USER>" + System.getProperty("user.name") + "</LAST_UPDATE_OS_USER>");
        this.println(out, --indent, "</TRANS_EXCEPT_HANDLE>");
    }

    private void exportXMLTransTableFile(PrintWriter out, int indent, Connection con, String transId, String inputTableId, SQLTable table, int seqNo, boolean isOutput) throws SQLException {
        this.println(out, indent, "<TRANS_TABLE_FILE>");
        this.println(out, ++indent, "<TRANS_ID>" + transId + "</TRANS_ID>");
        this.println(out, indent, "<TABLE_FILE_ID>" + inputTableId + "</TABLE_FILE_ID>");
        this.println(out, indent, "<TABLE_FILE_IND>TABLE</TABLE_FILE_IND>");
        this.println(out, indent, "<INPUT_OUTPUT_IND>" + (isOutput ? "O" : "I") + "</INPUT_OUTPUT_IND>");
        SQLDatabase database = table.getParentDatabase();
        if (database != null) {
            ArchitectDataSource dataSource = database.getDataSource();
            String dbConnectName = dataSource.get("Logical");
            try {
                String type;
                if (dataSource != null && this.isOracle(dataSource)) {
                    type = "ORACLE";
                } else if (dataSource != null && this.isSQLServer(dataSource)) {
                    type = "SQL SERVER";
                } else if (dataSource != null && this.isDB2(dataSource)) {
                    type = "DB2";
                } else if (dataSource != null && this.isPostgres(dataSource)) {
                    type = "POSTGRES";
                } else {
                    throw new IllegalArgumentException("Unsupported target database type");
                }
                this.println(out, indent, "<TABLE_FILE_TYPE>" + type + "</TABLE_FILE_TYPE>");
                this.println(out, indent, "<DB_CONNECT_NAME>" + dbConnectName + "</DB_CONNECT_NAME>");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.println(out, indent, "<OWNER>" + table.getParent().toString() + "</OWNER>");
        this.println(out, indent, "<TABLE_FILE_NAME>" + table.getName() + "</TABLE_FILE_NAME>");
        this.println(out, indent, "<PROC_SEQ_NO>" + seqNo + "</PROC_SEQ_NO>");
        this.println(out, indent, "<TRANS_TABLE_FILE_COMMENT>Generated by Power*Architect " + PL_GENERATOR_VERSION + "</TRANS_TABLE_FILE_COMMENT>");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.println(out, indent, "<LAST_UPDATE_DATE><DATE>" + df.format(new Date()) + "</DATE></LAST_UPDATE_DATE>");
        this.println(out, indent, "<LAST_UPDATE_USER>" + con.getMetaData().getUserName() + "</LAST_UPDATE_USER>");
        this.println(out, indent, "<LAST_UPDATE_OS_USER>" + System.getProperty("user.name") + "</LAST_UPDATE_OS_USER>");
        this.println(out, --indent, "</TRANS_TABLE_FILE>");
    }

    private void exportXMLTransColMap(PrintWriter out, int indent, Connection con, SQLColumn outputColumn, String transId, String inputTableId, String outputTableId, int seqNo) throws SQLException {
        SQLColumn inputColumn = outputColumn.getSourceColumn();
        String inputColumnName = inputColumn != null ? inputColumn.getName() : null;
        this.println(out, indent, "<TRANS_COL_MAP>");
        this.println(out, ++indent, "<TRANS_ID>" + transId + "</TRANS_ID>");
        this.println(out, indent, "<INPUT_TABLE_FILE_ID>" + inputTableId + "</INPUT_TABLE_FILE_ID>");
        this.println(out, indent, "<INPUT_TRANS_COL_NAME>" + inputColumnName + "</INPUT_TRANS_COL_NAME>");
        this.println(out, indent, "<OUTPUT_TABLE_FILE_ID>" + outputTableId + "</OUTPUT_TABLE_FILE_ID>");
        this.println(out, indent, "<OUTPUT_TRANS_COL_NAME>" + outputColumn.getName() + "</OUTPUT_TRANS_COL_NAME>");
        this.println(out, indent, "<VALID_ACTION_TYPE>" + (outputColumn.getPrimaryKeySeq() != null ? "A" : "AU") + "</VALID_ACTION_TYPE>");
        this.println(out, indent, "<NATURAL_ID_IND>" + (outputColumn.getPrimaryKeySeq() != null ? "Y" : "N") + "</NATURAL_ID_IND>");
        this.println(out, indent, "<OUTPUT_PROC_SEQ_NO>" + seqNo + "</OUTPUT_PROC_SEQ_NO>");
        this.println(out, indent, "<TRANS_COL_MAP_COMMENT>Generated by Power*Architect " + PL_GENERATOR_VERSION + "</TRANS_COL_MAP_COMMENT>");
        this.println(out, indent, "<ACTIVE_IND>Y</ACTIVE_IND>");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.println(out, indent, "<LAST_UPDATE_DATE><DATE>" + df.format(new Date()) + "</DATE></LAST_UPDATE_DATE>");
        this.println(out, indent, "<LAST_UPDATE_USER>" + con.getMetaData().getUserName() + "</LAST_UPDATE_USER>");
        this.println(out, indent, "<LAST_UPDATE_OS_USER>" + System.getProperty("user.name") + "</LAST_UPDATE_OS_USER>");
        this.println(out, --indent, "</TRANS_COL_MAP>");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PLExport:");
        sb.append("\n    currentDB=").append(this.currentDB);
        sb.append("\n    file=").append(this.file);
        sb.append("\n    folderName=").append(this.folderName);
        sb.append("\n    jobComment=").append(this.jobComment);
        sb.append("\n    jobDescription=").append(this.jobDescription);
        sb.append("\n    jobId=").append(this.jobId);
        sb.append("\n    repositoryDataSource=").append(this.repositoryDataSource);
        sb.append("\n    repositoryCatalog=").append(this.repositoryCatalog);
        sb.append("\n    repositorySchema=").append(this.repositorySchema);
        sb.append("\n    runPLEngine=").append(this.runPLEngine);
        sb.append("\n    targetDataSource=").append(this.targetDataSource);
        sb.append("\n    targetCatalog=").append(this.targetCatalog);
        sb.append("\n    targetSchema=").append(this.targetSchema);
        return sb.toString();
    }

    class PLTransaction {
        private String name;
        private String inputTableId;
        private int transNum;

        public PLTransaction(String name, String inputTableId, int transNum) {
            this.name = name;
            this.inputTableId = inputTableId;
            this.transNum = transNum;
        }

        public String getInputTableId() {
            return this.inputTableId;
        }

        public void setInputTableId(String inputTableId) {
            this.inputTableId = inputTableId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getTransNum() {
            return this.transNum;
        }

        public void setTransNum(int transNum) {
            this.transNum = transNum;
        }
    }

    public static class PLJob
    implements DatabaseObject {
        public String jobId;

        public PLJob(String jobId) {
            this.jobId = jobId;
        }

        public String getObjectType() {
            return "JOB";
        }

        public String getObjectName() {
            return this.jobId;
        }
    }

    public static class PLTrans
    implements DatabaseObject {
        public String transId;

        public PLTrans(String transId) {
            this.transId = transId;
        }

        public String getObjectType() {
            return "TRANSACTION";
        }

        public String getObjectName() {
            return this.transId;
        }
    }
}

