/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.etl;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportCSV {
    private Collection<SQLTable> exportList;
    private boolean passwordVisible;
    private static final String EOL = System.getProperty("line.separator");

    public ExportCSV(Collection<SQLTable> exportList) {
        this.exportList = exportList;
    }

    public String getCSVMapping() throws ArchitectException {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.createHeader()) + EOL);
        for (String row : this.createBody()) {
            buf.append(row);
            buf.append(EOL);
        }
        return buf.toString();
    }

    public String createHeader() {
        return String.valueOf(this.getColumnToCSVHeaders("SOURCE_")) + "," + this.getColumnToCSVHeaders("TARGET_");
    }

    public List<String> createBody() throws ArchitectException {
        ArrayList<String> rows = new ArrayList<String>();
        for (SQLTable o : this.exportList) {
            if (!(o instanceof SQLTable)) continue;
            for (SQLColumn c : o.getColumns()) {
                rows.add(this.columnToCSV(c.getSourceColumn()) + "," + this.columnToCSV(c));
            }
        }
        return rows;
    }

    private String getColumnToCSVHeaders(String prefix) {
        StringBuffer buf = new StringBuffer(this.getDsToCSVHeaders(prefix));
        buf.append(",").append(prefix).append("DATABASE");
        buf.append(",").append(prefix).append("SCHEMA");
        buf.append(",").append(prefix).append("CATALOG");
        buf.append(",").append(prefix).append("TABLE");
        buf.append(",").append(prefix).append("COLUMN");
        return buf.toString();
    }

    private StringBuffer columnToCSV(SQLColumn c) throws ArchitectException {
        StringBuffer connection = new StringBuffer();
        StringBuffer database = new StringBuffer();
        StringBuffer schema = new StringBuffer();
        StringBuffer catalog = new StringBuffer();
        StringBuffer table = new StringBuffer();
        if (c != null) {
            SQLObject parent = c.getParent();
            while (parent != null) {
                if (parent instanceof SQLDatabase) {
                    SQLDatabase db = (SQLDatabase)parent;
                    connection.append(this.dsToCSV(db.getDataSource()));
                    database.append(db.getPhysicalName());
                } else if (parent instanceof SQLSchema) {
                    schema.append(parent.getPhysicalName());
                } else if (parent instanceof SQLCatalog) {
                    catalog.append(parent.getPhysicalName());
                } else if (parent instanceof SQLTable) {
                    table.append(parent.getPhysicalName());
                } else if (!(parent instanceof SQLTable.Folder)) {
                    throw new ArchitectException("Invalid object tree, parent should be a database, schema or catalog");
                }
                parent = parent.getParent();
            }
        }
        if (connection.length() == 0) {
            connection.append(this.dsToCSV(null));
        }
        connection.append(",").append("\"" + database.toString().replaceAll("\"", "\"\"") + "\"");
        connection.append(",").append("\"" + catalog.toString().replaceAll("\"", "\"\"") + "\"");
        connection.append(",").append("\"" + schema.toString().replaceAll("\"", "\"\"") + "\"");
        connection.append(",").append("\"" + table.toString().replaceAll("\"", "\"\"") + "\"");
        connection.append(",");
        if (c != null) {
            connection.append("\"" + c.getPhysicalName().replaceAll("\"", "\"\"") + "\"");
        }
        return connection;
    }

    private String getDsToCSVHeaders(String prefix) {
        StringBuffer header = new StringBuffer();
        header.append(prefix).append("DISPLAY_NAME,");
        header.append(prefix).append("DRIVER_CLASS,");
        header.append(prefix).append("JDBC_URL,");
        header.append(prefix).append("USERNAME,");
        if (this.isPasswordVisible()) {
            header.append(prefix).append("PASSWORD,");
        }
        header.append(prefix).append("ODBC_DSN");
        return header.toString();
    }

    private StringBuffer dsToCSV(ArchitectDataSource ds) {
        StringBuffer buf = new StringBuffer();
        if (ds != null && ds.getDisplayName() != null) {
            buf.append("\"" + ds.getDisplayName().replaceAll("\"", "\"\"") + "\"");
        }
        buf.append(",");
        if (ds != null && ds.getDriverClass() != null) {
            buf.append("\"" + ds.getDriverClass().replaceAll("\"", "\"\"") + "\"");
        }
        buf.append(",");
        if (ds != null && ds.getUrl() != null) {
            buf.append("\"" + ds.getUrl().replaceAll("\"", "\"\"") + "\"");
        }
        buf.append(",");
        if (ds != null && ds.getUser() != null) {
            buf.append("\"" + ds.getUser().replaceAll("\"", "\"\"") + "\"");
        }
        if (this.isPasswordVisible()) {
            buf.append(",");
            if (ds != null && ds.getPass() != null) {
                buf.append("\"" + ds.getPass().replaceAll("\"", "\"\"") + "\"");
            }
        }
        buf.append(",");
        if (ds != null && ds.getOdbcDsn() != null) {
            buf.append("\"" + ds.getOdbcDsn().replaceAll("\"", "\"\"") + "\"");
        }
        return buf;
    }

    public boolean isPasswordVisible() {
        return this.passwordVisible;
    }

    public void setPasswordVisible(boolean passwordVisible) {
        this.passwordVisible = passwordVisible;
    }
}

