/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.diff;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.diff.SQLObjectComparator;
import java.util.Comparator;
import junit.framework.TestCase;

public class SQLComparatorTest
extends TestCase {
    Comparator<SQLObject> comparator = new SQLObjectComparator();
    SQLObject o1 = new SQLObject(){

        @Override
        public SQLObject getParent() {
            return null;
        }

        @Override
        protected void setParent(SQLObject parent) {
        }

        @Override
        protected void populate() throws ArchitectException {
        }

        @Override
        public String getShortDisplayName() {
            return null;
        }

        @Override
        public boolean allowsChildren() {
            return false;
        }

        @Override
        public Class<? extends SQLObject> getChildType() {
            return null;
        }
    };

    public void testForNull() {
        SQLComparatorTest.assertEquals((int)0, (int)this.comparator.compare(null, null));
        SQLComparatorTest.assertEquals((int)0, (int)this.comparator.compare(this.o1, this.o1));
    }

    public void testForConsistentWithEquals() {
    }

    public void testForObjectCompareToNull() throws ArchitectException {
        SQLTable t = new SQLTable();
        t.setName("Testing");
        SQLComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t, null));
        SQLComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(null, t));
    }

    public void testForObjectCompareToObject() throws ArchitectException {
        SQLTable t1 = new SQLTable();
        SQLTable t2 = new SQLTable();
        t1.setName("cow");
        t2.setName("pigs");
        SQLComparatorTest.assertTrue((this.comparator.compare(t1, t2) < 0 ? 1 : 0) != 0);
    }

    public void testWithNullName() throws ArchitectException {
        SQLTable t1 = new SQLTable();
        SQLTable t2 = new SQLTable();
        SQLComparatorTest.assertEquals((int)0, (int)this.comparator.compare(t1, t2));
    }

    public void testWithSameName() throws ArchitectException {
        SQLTable t1 = new SQLTable();
        SQLTable t2 = new SQLTable();
        t1.setName("cow");
        t2.setName("cow");
        SQLComparatorTest.assertEquals((int)0, (int)this.comparator.compare(t1, t2));
    }
}

