/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTestCase;

public class TestSQLIndex
extends SQLTestCase {
    SQLIndex index;

    public TestSQLIndex(String name) throws Exception {
        super(name);
        this.propertiesToIgnoreForEventGeneration.add("parentTable");
        this.propertiesToIgnoreForUndo.add("parentTable");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.index = new SQLIndex("Test Index", true, "a", SQLIndex.IndexType.HASHED, "b");
        SQLColumn col1 = new SQLColumn();
        SQLColumn col2 = new SQLColumn();
        SQLColumn col3 = new SQLColumn();
        this.index.addIndexColumn(col1, true, true);
        this.index.addIndexColumn(col2, false, true);
        this.index.addIndexColumn(col3, true, false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected SQLObject getSQLObjectUnderTest() {
        return this.index;
    }

    public void testCopyConstructor() throws ArchitectException {
        SQLIndex copyIndex = new SQLIndex(this.index);
        TestSQLIndex.assertEquals((String)"Different Name", (String)this.index.getName(), (String)copyIndex.getName());
        TestSQLIndex.assertEquals((String)"Different uniqueness values", (boolean)this.index.isUnique(), (boolean)copyIndex.isUnique());
        TestSQLIndex.assertEquals((String)"Different index types", (Object)((Object)this.index.getType()), (Object)((Object)copyIndex.getType()));
        TestSQLIndex.assertEquals((String)"Different qualifiers", (String)this.index.getQualifier(), (String)copyIndex.getQualifier());
        TestSQLIndex.assertEquals((String)"Different filters", (String)this.index.getFilterCondition(), (String)copyIndex.getFilterCondition());
        TestSQLIndex.assertEquals((String)"Different number of children", (int)this.index.getChildCount(), (int)copyIndex.getChildCount());
        int i = 0;
        while (i < this.index.getChildCount()) {
            TestSQLIndex.assertEquals((String)"Different columns for index column 1", (Object)this.index.getChild(i).getColumn(), (Object)copyIndex.getChild(i).getColumn());
            ++i;
        }
    }
}

