/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.SQLTestCase;
import ca.sqlpower.architect.TestSQLColumn;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TestFolder
extends SQLTestCase {
    private SQLTable table1pk;

    public TestFolder(String name) throws Exception {
        super(name);
    }

    public static void oneTimeSetUp() throws Exception {
        System.out.println("TestSQLColumn.oneTimeSetUp()");
        SQLDatabase mydb = new SQLDatabase(TestFolder.getDataSource());
        Connection con = null;
        Statement stmt = null;
        try {
            con = mydb.getConnection();
            stmt = con.createStatement();
            TestFolder.dropTableNoFail(con, "SQL_COLUMN_TEST_1PK");
            TestFolder.dropTableNoFail(con, "SQL_COLUMN_TEST_3PK");
            TestFolder.dropTableNoFail(con, "SQL_COLUMN_TEST_0PK");
            stmt.executeUpdate("CREATE TABLE SQL_COLUMN_TEST_1PK (\n cow numeric(11) CONSTRAINT test1pk PRIMARY KEY,\n moo varchar(10),\n foo char(10))");
            stmt.executeUpdate("CREATE TABLE SQL_COLUMN_TEST_3PK (\n cow numeric(11) NOT NULL,\n moo varchar(10) NOT NULL,\n foo char(10) NOT NULL,\n CONSTRAINT test3pk PRIMARY KEY (cow, moo, foo))");
            stmt.executeUpdate("CREATE TABLE SQL_COLUMN_TEST_0PK (\n cow numeric(11),\n moo varchar(10),\n foo char(10))");
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                System.out.println("Couldn't close statement");
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                System.out.println("Couldn't close connection");
            }
        }
    }

    private static void dropTableNoFail(Connection con, String tableName) throws SQLException {
        Statement stmt = null;
        try {
            try {
                stmt = con.createStatement();
                stmt.executeUpdate("DROP TABLE " + tableName);
            }
            catch (SQLException e) {
                System.out.println("Ignoring SQLException.  Assume " + tableName + " didn't exist.");
                e.printStackTrace();
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public static void oneTimeTearDown() {
        System.out.println("TestSQLColumn.oneTimeTearDown()");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.table1pk = this.db.getTableByName("SQL_COLUMN_TEST_1PK");
        this.db.getTableByName("SQL_COLUMN_TEST_0PK");
        this.db.getTableByName("SQL_COLUMN_TEST_3PK");
    }

    protected SQLObject getSQLObjectUnderTest() {
        return this.table1pk.getColumnsFolder();
    }

    public void testGetName() {
        SQLTable.Folder f1 = new SQLTable.Folder(1, true);
        TestFolder.assertEquals((String)f1.getName(), (String)"Columns");
        f1 = new SQLTable.Folder(2, true);
        TestFolder.assertEquals((String)f1.getName(), (String)"Imported Keys");
        f1 = new SQLTable.Folder(3, true);
        TestFolder.assertEquals((String)f1.getName(), (String)"Exported Keys");
        f1.setName("xyz");
        TestFolder.assertEquals((String)f1.getName(), (String)"xyz");
        f1.setName(null);
        TestFolder.assertNull((Object)f1.getName());
    }

    public void testGetParent() throws ArchitectException {
        SQLTable.Folder f1 = new SQLTable.Folder(1, true);
        SQLTable.Folder f2 = new SQLTable.Folder(2, true);
        SQLTable.Folder f3 = new SQLTable.Folder(3, true);
        TestFolder.assertNull((Object)f1.getParent());
        SQLTable t1 = new SQLTable();
        t1.addChild(f1);
        t1.addChild(f2);
        t1.addChild(f3);
        TestFolder.assertEquals((Object)f1.getParent(), (Object)t1);
        TestFolder.assertEquals((Object)f2.getParent(), (Object)t1);
        TestFolder.assertEquals((Object)f3.getParent(), (Object)t1);
        t1.removeChild(1);
        TestFolder.assertEquals((Object)t1.getChild(1), f3);
        t1.removeChild(f1);
        TestFolder.assertEquals((Object)t1.getChild(0), f3);
        TestFolder.assertEquals((int)1, (int)f1.getType());
        TestFolder.assertEquals((int)2, (int)f2.getType());
        TestFolder.assertEquals((int)3, (int)f3.getType());
    }

    public void testPopulate() {
    }

    public void testAddChild() throws ArchitectException {
        SQLTable.Folder main1 = new SQLTable.Folder(1, true);
        SQLColumn c1 = new SQLColumn();
        SQLColumn c2 = new SQLColumn();
        SQLColumn c3 = new SQLColumn();
        main1.addChild(c1);
        TestFolder.assertEquals((Object)main1.getChild(0), (Object)c1);
        main1.addChild(c2);
        TestFolder.assertEquals((Object)main1.getChild(1), (Object)c2);
        main1.addChild(1, c3);
        ArrayList children = new ArrayList(main1.getChildren());
        TestFolder.assertTrue((boolean)children.contains(c1));
        TestFolder.assertTrue((boolean)children.contains(c2));
        TestFolder.assertTrue((boolean)children.contains(c3));
        TestFolder.assertEquals((int)children.size(), (int)3);
        TestFolder.assertEquals((int)main1.getChildCount(), (int)3);
        TestFolder.assertEquals((Object)main1.getChild(1), (Object)c3);
        main1.removeChild(c3);
        TestFolder.assertEquals((Object)main1.getChild(1), (Object)c2);
        main1.removeChild(0);
        TestFolder.assertEquals((Object)main1.getChild(0), (Object)c2);
    }

    public void testFireDbChildrenInserted() throws Exception {
        SQLTable.Folder f1 = new SQLTable.Folder(1, true);
        TestSQLColumn.TestSQLObjectListener test1 = new TestSQLColumn.TestSQLObjectListener();
        f1.addSQLObjectListener(test1);
        TestSQLColumn.TestSQLObjectListener test2 = new TestSQLColumn.TestSQLObjectListener();
        f1.addSQLObjectListener(test2);
        TestFolder.assertEquals((int)test1.getInsertedCount(), (int)0);
        TestFolder.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestFolder.assertEquals((int)test1.getChangedCount(), (int)0);
        TestFolder.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestFolder.assertEquals((int)test2.getInsertedCount(), (int)0);
        TestFolder.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestFolder.assertEquals((int)test2.getChangedCount(), (int)0);
        TestFolder.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        SQLColumn tmpCol = new SQLColumn();
        f1.addChild(tmpCol);
        TestFolder.assertEquals((int)test1.getInsertedCount(), (int)1);
        TestFolder.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestFolder.assertEquals((int)test1.getChangedCount(), (int)0);
        TestFolder.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestFolder.assertEquals((int)test2.getInsertedCount(), (int)1);
        TestFolder.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestFolder.assertEquals((int)test2.getChangedCount(), (int)0);
        TestFolder.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        f1.removeSQLObjectListener(test1);
        f1.removeChild(tmpCol);
        TestFolder.assertEquals((int)test1.getInsertedCount(), (int)1);
        TestFolder.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestFolder.assertEquals((int)test1.getChangedCount(), (int)0);
        TestFolder.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestFolder.assertEquals((int)test2.getInsertedCount(), (int)1);
        TestFolder.assertEquals((int)test2.getRemovedCount(), (int)1);
        TestFolder.assertEquals((int)test2.getChangedCount(), (int)0);
        TestFolder.assertEquals((int)test2.getStructureChangedCount(), (int)0);
    }
}

