/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLExceptionNode;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import junit.framework.TestCase;

public class SQLObjectTest
extends TestCase {
    SQLObject target;

    public void setUp() {
        this.target = new SQLObjectImpl();
    }

    public final void testIsPopulated() {
        SQLObjectTest.assertFalse((boolean)this.target.isPopulated());
    }

    public final void testSetPopulated() {
        this.target.setPopulated(true);
        SQLObjectTest.assertTrue((boolean)this.target.isPopulated());
    }

    public final void testGetChildType() {
    }

    public final void testAllChildHandlingMethods() throws ArchitectException {
        SQLObjectTest.assertEquals((int)0, (int)this.target.getChildCount());
        SQLObjectImpl x = new SQLObjectImpl();
        this.target.addChild(x);
        SQLObjectTest.assertEquals((int)1, (int)this.target.getChildCount());
        SQLObjectTest.assertEquals((Object)x, (Object)this.target.getChild(0));
        SQLObjectImpl y = new SQLObjectImpl();
        this.target.addChild(0, y);
        SQLObjectTest.assertEquals((Object)y, (Object)this.target.getChild(0));
        SQLObjectTest.assertEquals((Object)x, (Object)this.target.getChild(1));
        this.target.removeChild(1);
        LinkedList<SQLObjectImpl> list2 = new LinkedList<SQLObjectImpl>();
        list2.add(y);
        SQLObjectTest.assertEquals(list2, (Object)this.target.getChildren());
        this.target.removeChild(y);
        SQLObjectTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.target.getChildren());
    }

    public final void testSQLObjectListenerHandling() throws ArchitectException {
        TestListener t;
        TestListener tt = t = new TestListener();
        this.target.addSQLObjectListener(t);
        ((SQLObjectImpl)this.target).allowsChildren = true;
        tt.setChildInserted(false);
        SQLObjectImpl objectImpl = new SQLObjectImpl();
        this.target.addChild(objectImpl);
        SQLObjectTest.assertTrue((boolean)tt.isChildInserted());
        tt.setObjectChanged(false);
        ((SQLObjectImpl)this.target).fakeObjectChanged("fred", "old value", "new value");
        SQLObjectTest.assertTrue((boolean)tt.isObjectChanged());
        tt.setObjectChanged(false);
        ((SQLObjectImpl)this.target).fakeObjectChanged("fred", "old value", "old value");
        SQLObjectTest.assertFalse((boolean)tt.isObjectChanged());
        tt.setStructureChanged(false);
        ((SQLObjectImpl)this.target).fakeStructureChanged();
        SQLObjectTest.assertTrue((boolean)tt.isStructureChanged());
        this.target.removeSQLObjectListener(t);
        SQLObjectTest.assertEquals((Object)Collections.EMPTY_LIST, this.target.getSQLObjectListeners());
    }

    public void testNoMixChildTypes() throws ArchitectException {
        this.target.addChild(new SQLExceptionNode(null, "everything is ok. don't panic."));
        try {
            this.target.addChild(new SQLObjectImpl());
            SQLObjectTest.fail((String)"Target didn't throw exception for mixing child types!");
        }
        catch (ArchitectException architectException) {
            // empty catch block
        }
    }

    public void testAllowMixedChildrenThatAreSubclassesOfEachOther() throws ArchitectException {
        SQLObjectImpl subImpl = new SQLObjectImpl(){};
        this.target.addChild(new SQLObjectImpl());
        this.target.addChild(subImpl);
        this.target.removeChild(0);
        this.target.addChild(new SQLObjectImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SQLObjectImpl
    extends SQLObject {
        protected boolean allowsChildren;
        SQLObject parent = null;

        SQLObjectImpl() {
            this.children = new ArrayList();
        }

        @Override
        public String getName() {
            throw new RuntimeException("test abstract stub");
        }

        @Override
        public SQLObject getParent() {
            return this.parent;
        }

        @Override
        protected void setParent(SQLObject parent) {
            this.parent = parent;
        }

        @Override
        protected void populate() throws ArchitectException {
        }

        @Override
        public String getShortDisplayName() {
            throw new RuntimeException("test abstract stub");
        }

        @Override
        public boolean allowsChildren() {
            return this.allowsChildren;
        }

        public void fakeObjectChanged(String string, Object oldValue, Object newValue) {
            this.fireDbObjectChanged(string, oldValue, newValue);
        }

        public void fakeStructureChanged() {
            this.fireDbStructureChanged();
        }

        @Override
        public Class<? extends SQLObject> getChildType() {
            return SQLObject.class;
        }
    }

    class TestListener
    implements SQLObjectListener {
        boolean childInserted;
        boolean childRemoved;
        boolean objectChanged;
        boolean structureChanged;

        TestListener() {
        }

        public void dbChildrenInserted(SQLObjectEvent e) {
            System.out.println("Listener.dbChildrenInserted()");
            this.setChildInserted(true);
        }

        public void dbChildrenRemoved(SQLObjectEvent e) {
            System.out.println("Listener.dbChildrenRemoved()");
            this.setChildRemoved(true);
        }

        public void dbObjectChanged(SQLObjectEvent e) {
            System.out.println("Listener.dbObjectChanged()");
            this.setObjectChanged(true);
        }

        public void dbStructureChanged(SQLObjectEvent e) {
            System.out.println("Listener.dbStructureChanged()");
            this.setStructureChanged(true);
        }

        public boolean isChildInserted() {
            return this.childInserted;
        }

        public void setChildInserted(boolean childInserted) {
            this.childInserted = childInserted;
        }

        public boolean isChildRemoved() {
            return this.childRemoved;
        }

        public void setChildRemoved(boolean childRemoved) {
            this.childRemoved = childRemoved;
        }

        public boolean isObjectChanged() {
            return this.objectChanged;
        }

        public void setObjectChanged(boolean objectChanged) {
            this.objectChanged = objectChanged;
        }

        public boolean isStructureChanged() {
            return this.structureChanged;
        }

        public void setStructureChanged(boolean structureChanged) {
            this.structureChanged = structureChanged;
        }
    }
}

