/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.DatabaseListChangeEvent;
import ca.sqlpower.architect.DatabaseListChangeListener;
import ca.sqlpower.architect.PlDotIni;
import junit.framework.TestCase;

public class PlDotIniListenersTest
extends TestCase {
    DataSourceCollection pld = new PlDotIni();
    ArchitectDataSource dbcs = new ArchitectDataSource();
    DatabaseListChangeEvent addNotified;
    DatabaseListChangeEvent removeNotified;
    DatabaseListChangeListener liszt = new DatabaseListChangeListener(){

        public void databaseAdded(DatabaseListChangeEvent e) {
            PlDotIniListenersTest.this.addNotified = e;
        }

        public void databaseRemoved(DatabaseListChangeEvent e) {
            PlDotIniListenersTest.this.removeNotified = e;
        }
    };

    protected void setUp() throws Exception {
        this.dbcs.setDisplayName("Goofus");
    }

    public void testAddDataSource() {
        PlDotIniListenersTest.assertEquals((int)0, (int)this.pld.getConnections().size());
        this.pld.addDataSource(this.dbcs);
        PlDotIniListenersTest.assertEquals((int)1, (int)this.pld.getConnections().size());
        try {
            this.pld.addDataSource(this.dbcs);
            PlDotIniListenersTest.fail((String)"Didn't fail to add a second copy!");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Caught expected " + e);
        }
    }

    public void testMergeDataSource() {
        this.pld.addDataSource(this.dbcs);
        this.dbcs.setDriverClass("mock.Driver");
        this.pld.mergeDataSource(this.dbcs);
    }

    public void testRemoveDataSource() {
        PlDotIniListenersTest.assertEquals((int)0, (int)this.pld.getConnections().size());
        this.pld.addDataSource(this.dbcs);
        PlDotIniListenersTest.assertEquals((int)1, (int)this.pld.getConnections().size());
        PlDotIniListenersTest.assertSame((Object)this.dbcs, (Object)this.pld.getConnections().get(0));
        this.pld.removeDataSource(this.dbcs);
        PlDotIniListenersTest.assertEquals((int)0, (int)this.pld.getConnections().size());
    }

    public void testAddListener() {
        this.pld.addDatabaseListChangeListener(this.liszt);
        PlDotIniListenersTest.assertNull((Object)this.addNotified);
        this.pld.addDataSource(this.dbcs);
        PlDotIniListenersTest.assertNotNull((Object)this.addNotified);
        System.out.println(this.addNotified);
    }

    public void testRemoveListener() {
    }
}

