/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.PlDotIni;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import junit.framework.TestCase;

public class PLDotIniTest
extends TestCase {
    private static final String FUN_DATASOURCE_NAME = "broomhilda";
    private DataSourceCollection target;

    public void setUp() {
        this.target = new PlDotIni();
    }

    public void testRead() throws IOException {
        File tmp = this.makeTempFile();
        this.target.read(tmp);
        System.out.println("PLDotIniTest::testRead(): Getting here counts as success");
    }

    private File makeTempFile() throws IOException, FileNotFoundException {
        File tmp = File.createTempFile("pl.ini", null);
        PrintWriter out = new PrintWriter(tmp);
        out.print("[random_crap]\r\n");
        out.print("foo=bar\r\n");
        out.print("fred=george\r\n");
        out.print("[Databases_1]\r\n");
        out.print("Logical=broomhilda\r\n");
        out.print("Type=POSTGRES\r\n");
        out.print("JDBC Driver Class=org.postgresql.Driver\r\n");
        out.print("PWD=\r\n");
        out.print("L Schema Owner=\r\n");
        out.print("DSN=\r\n");
        out.print("JDBC URL=jdbc:postgresql://:5432/\r\n");
        out.flush();
        out.close();
        return tmp;
    }

    public void testWriteOutputStream() throws IOException {
        File tmp1 = this.makeTempFile();
        this.target.read(tmp1);
        File tmp2 = File.createTempFile("pl.out", null);
        this.target.write(tmp2);
        PLDotIniTest.assertEquals((long)tmp1.length(), (long)tmp2.length());
        tmp1.deleteOnExit();
        tmp2.deleteOnExit();
    }

    public void testGetDataSource() throws IOException {
        File tmp = this.makeTempFile();
        this.target.read(tmp);
        ArchitectDataSource ds = this.target.getDataSource(FUN_DATASOURCE_NAME);
        PLDotIniTest.assertNotNull((Object)ds);
        tmp.deleteOnExit();
    }

    public void testGetConnections() throws IOException {
        File tmp = this.makeTempFile();
        this.target.read(tmp);
        List<ArchitectDataSource> l = this.target.getConnections();
        PLDotIniTest.assertEquals((int)1, (int)l.size());
        PLDotIniTest.assertEquals((Object)this.target.getDataSource(FUN_DATASOURCE_NAME), (Object)l.get(0));
        tmp.deleteOnExit();
    }
}

