/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.util.VersionFormatException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Version
implements Comparable,
Serializable,
Cloneable {
    int major;
    int minor;
    int tiny;

    public Version() {
        this.major = -1;
        this.minor = -1;
        this.tiny = -1;
    }

    public Version(int major, int minor, int tiny) {
        this.major = major;
        this.minor = minor;
        this.tiny = tiny;
    }

    public Version(String version) throws VersionFormatException {
        this.setVersion(version);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int argMajor) {
        this.major = argMajor;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int argMinor) {
        this.minor = argMinor;
    }

    public int getTiny() {
        return this.tiny;
    }

    public void setTiny(int argTiny) {
        this.tiny = argTiny;
    }

    public void setVersion(String versionString) throws VersionFormatException {
        StringTokenizer st = new StringTokenizer(versionString, ".");
        try {
            this.major = Integer.parseInt(st.nextToken());
            this.minor = Integer.parseInt(st.nextToken());
            this.tiny = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException e) {
            throw new VersionFormatException("A component of the version string '" + versionString + "' is not an integer", 0, e);
        }
        catch (NoSuchElementException e) {
            throw new VersionFormatException("The version string '" + versionString + "' has fewer than three components", 0, e);
        }
        if (st.hasMoreTokens()) {
            throw new VersionFormatException("The version string '" + versionString + "' has too many components", 0, null);
        }
    }

    public String getVersion() {
        return this.major + "." + this.minor + "." + this.tiny;
    }

    public String toString() {
        return this.getVersion();
    }

    public int compareTo(Object other) {
        Version otherVersion = (Version)other;
        if (this.major < otherVersion.major) {
            return -1;
        }
        if (this.major > otherVersion.major) {
            return 1;
        }
        if (this.minor < otherVersion.minor) {
            return -1;
        }
        if (this.minor > otherVersion.minor) {
            return 1;
        }
        if (this.tiny < otherVersion.tiny) {
            return -1;
        }
        if (this.tiny > otherVersion.tiny) {
            return 1;
        }
        return 0;
    }

    public Object clone() {
        try {
            return (Version)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Caught impossible CloneNotSupportedException");
        }
    }
}

