/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.database.DataBaseException;
import com.darwinsys.sql.ConnectionUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;

public class ConnectionUtilTest
extends TestCase {
    static final String MOCK_JBDB_DRIVER = "mock.MockJdbcDriver";

    public void testList() throws Exception {
        System.out.println("ConnectionUtilTest.testList()");
        Set<String> configs = ConnectionUtil.getConfigurations();
        Iterator<String> iter = configs.iterator();
        boolean hasConfigNames = false;
        while (iter.hasNext()) {
            String element = iter.next();
            System.out.println(element);
            hasConfigNames = true;
        }
        ConnectionUtilTest.assertTrue((boolean)hasConfigNames);
    }

    public void testGetConnectionBadDriver() throws Exception {
        try {
            Connection c = ConnectionUtil.getConnection("url", "mydriver", "operator", "secret");
            ConnectionUtilTest.fail((String)"getConnection w/ bad params Did not throw exception");
            System.out.println(c);
        }
        catch (ClassNotFoundException nfe) {
            String m = nfe.getMessage();
            ConnectionUtilTest.assertEquals((String)"failing driver class name", (String)"mydriver", (String)m);
            System.out.println("Caught expected ClassNotFoundException");
        }
        catch (DataBaseException e) {
            ConnectionUtilTest.fail((String)("Caught wrong exception " + e + "; check order of params"));
        }
    }

    public void testGetConnectionBadURL() throws Exception {
        try {
            Connection c = ConnectionUtil.getConnection("url", MOCK_JBDB_DRIVER, "operator", "secret");
            ConnectionUtilTest.fail((String)"getConnection w/ bad params did not throw exception");
            System.out.println(c);
        }
        catch (SQLException e) {
            System.out.println("Caught expected Exception " + e);
        }
    }
}

