/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.database.DataBaseException;
import com.darwinsys.sql.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionUtil {
    public static final String DEFAULT_NAME = ".db.properties";
    private static String configFileName = String.valueOf(System.getProperty("user.home")) + File.separator + ".db.properties";

    public static Configuration getConfiguration(String config) throws DataBaseException {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(configFileName));
            return ConnectionUtil.getConfiguration(p, config);
        }
        catch (IOException ex) {
            throw new DataBaseException(ex.toString());
        }
    }

    private static Configuration getConfiguration(Properties p, String config) {
        String db_driver = p.getProperty(String.valueOf(config) + "." + "DBDriver");
        String db_url = p.getProperty(String.valueOf(config) + "." + "DBURL");
        String db_user = p.getProperty(String.valueOf(config) + "." + "DBUser");
        String db_password = p.getProperty(String.valueOf(config) + "." + "DBPassword");
        if (db_driver == null || db_url == null) {
            throw new DataBaseException("Driver or URL null: " + config);
        }
        return new Configuration(db_url, db_driver, db_user, db_password);
    }

    public static Connection getConnection(String configName) throws DataBaseException {
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(configFileName));
            return ConnectionUtil.getConnection(p, configName);
        }
        catch (IOException ex) {
            throw new DataBaseException(ex.toString());
        }
    }

    public static Connection getConnection(Properties p, String configName) throws DataBaseException {
        try {
            String db_driver = p.getProperty(String.valueOf(configName) + "." + "DBDriver");
            String db_url = p.getProperty(String.valueOf(configName) + "." + "DBURL");
            String db_user = p.getProperty(String.valueOf(configName) + "." + "DBUser");
            String db_password = p.getProperty(String.valueOf(configName) + "." + "DBPassword");
            if (db_driver == null || db_url == null) {
                throw new DataBaseException("Driver or URL null: " + configName);
            }
            return ConnectionUtil.getConnection(db_url, db_driver, db_user, db_password);
        }
        catch (ClassNotFoundException ex) {
            throw new DataBaseException(ex.toString());
        }
        catch (SQLException ex) {
            throw new DataBaseException(ex.toString());
        }
    }

    public static Connection getConnection(String dbUrl, String dbDriver, String dbUserName, String dbPassword) throws ClassNotFoundException, SQLException {
        System.out.println("Loading driver " + dbDriver);
        Class.forName(dbDriver);
        System.out.println("Connecting to DB " + dbUrl);
        return DriverManager.getConnection(dbUrl, dbUserName, dbPassword);
    }

    public static Connection getConnection(Configuration c) throws ClassNotFoundException, SQLException {
        return ConnectionUtil.getConnection(c.dbDriverName, c.dbURL, c.dbUserName, c.dbPassword);
    }

    public static String getConfigFileName() {
        return configFileName;
    }

    public static void setConfigFileName(String configFileNam) {
        configFileName = configFileNam;
        File file = new File(configFileName);
        if (!file.canRead()) {
            throw new IllegalArgumentException("Unreadable: " + configFileName);
        }
        try {
            configFileName = file.getCanonicalPath();
        }
        catch (IOException ex) {
            System.err.println("Warning: IO error checking path: " + configFileName);
        }
    }

    public static Set<String> getConfigurations() {
        TreeSet<String> configNames = new TreeSet<String>();
        try {
            Properties p = new Properties();
            FileInputStream is = new FileInputStream(configFileName);
            p.load(is);
            is.close();
            Enumeration<Object> enumeration = p.keys();
            while (enumeration.hasMoreElements()) {
                String element = (String)enumeration.nextElement();
                int offset = element.indexOf(46);
                if (offset == -1) continue;
                String configName = element.substring(0, offset);
                configNames.add(configName);
            }
        }
        catch (IOException ex) {
            throw new DataBaseException(ex.toString());
        }
        return configNames;
    }
}

