/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.csv;

import com.darwinsys.csv.CSVRE;
import java.util.List;
import junit.framework.TestCase;

public class CSVRETest
extends TestCase {
    CSVRE target = new CSVRE();

    public void testCanonical() {
        List<String> list = this.target.parse("\"a\",\"b\",\"c\"");
        CSVRETest.assertEquals((int)3, (int)list.size());
        CSVRETest.assertEquals((Object)"a", (Object)list.get(0));
        CSVRETest.assertEquals((Object)"b", (Object)list.get(1));
        CSVRETest.assertEquals((Object)"c", (Object)list.get(2));
    }

    public void testNullField() {
        List<String> list = this.target.parse("\"a\",,\"c\"");
        CSVRETest.assertEquals((int)3, (int)list.size());
        CSVRETest.assertEquals((Object)"a", (Object)list.get(0));
        CSVRETest.assertEquals(null, (Object)list.get(1));
        CSVRETest.assertEquals((Object)"c", (Object)list.get(2));
    }

    public void testNotAllQuoted() {
        List<String> list = this.target.parse("\"a\",b,\"c\"");
        CSVRETest.assertEquals((int)3, (int)list.size());
        CSVRETest.assertEquals((Object)"a", (Object)list.get(0));
        CSVRETest.assertEquals((Object)"b", (Object)list.get(1));
        CSVRETest.assertEquals((Object)"c", (Object)list.get(2));
    }

    public void testAllUnQuoted() {
        List<String> list = this.target.parse("a,b,c");
        CSVRETest.assertEquals((int)3, (int)list.size());
        CSVRETest.assertEquals((Object)"a", (Object)list.get(0));
        CSVRETest.assertEquals((Object)"b", (Object)list.get(1));
        CSVRETest.assertEquals((Object)"c", (Object)list.get(2));
    }

    public void testMixedField() {
        List<String> list = this.target.parse("\"LU\",86.25|\"11/4/1998\"|\"2:19PM\"|+4.0625");
        CSVRETest.assertEquals((int)2, (int)list.size());
    }
}

