<?php
/**
 * Implementation of the Quota API for IMAP servers with a unix quota command.
 * This requires a modified "quota" command that allows the httpd server
 * account to get quotas for other users. It also requires that your
 * web server and imap server be the same server or at least have shared
 * authentication and file servers (e.g. via NIS/NFS).  And last, it (as
 * written) requires the POSIX PHP extensions.
 *
 * You must configure this driver in horde/imp/config/servers.php.  The
 * driver supports the following parameters:
 *   'quota_path' => Path to the quota binary - REQUIRED
 *   'grep_path'  => Path to the grep binary - REQUIRED
 *   'partition'  => If all user mailboxes are on a single partition, the
 *                   partition label.  By default, quota will determine
 *                   quota information using the user's home directory value.
 *
 * $Horde: imp/lib/Quota/command.php,v 1.11.10.9 2006/02/10 04:58:26 selsky Exp $
 *
 * Copyright 2002-2006 Eric Jon Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @since   IMP 4.0
 * @package IMP_Quota
 */
class IMP_Quota_command extends IMP_Quota {

    /**
     * Constructor
     *
     * @param array $params  Hash containing connection parameters.
     */
    function IMP_Quota_command($params = array())
    {
        $this->_params = array(
            'quota_path' => 'quota',
            'grep_path'  => 'grep',
            'partition'  => null
        );

        $this->_params = array_merge($this->_params, $params);
    }

    /**
     * Get quota information (used/allocated), in bytes.
     *
     * @return mixed  An associative array.
     *                'limit' = Maximum quota allowed
     *                'usage' = Currently used portion of quota (in bytes)
     *                Returns PEAR_Error on failure.
     */
    function getQuota()
    {
        $imap_user = strtolower($GLOBALS['imp']['user']);
        if (empty($this->_params['partition'])) {
            $passwd_array = posix_getpwnam($imap_user);
            list($junk, $search_string, $junk) = explode('/', $passwd_array['dir']);
        } else {
            $search_string = $this->_params['partition'];
        }
        $cmdline = $this->_params['quota_path'] . ' -u ' . $imap_user . ' | ' .
                   $this->_params['grep_path'] . ' ' . $search_string;
        exec($cmdline, $quota_data, $return_code);
        if (($return_code == 0) && (count($quota_data) == 1)) {
           $quota = split("[[:blank:]]+", trim($quota_data[0]));
           return array('usage' => $quota[1] * 1024, 'limit' => $quota[2] * 1024);
        }
        return PEAR::raiseError(_("Unable to retrieve quota"), 'horde.error');
    }

}
