require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__M88K_CPU_H__)) {
    eval 'sub __M88K_CPU_H__ () {1;}' unless defined(&__M88K_CPU_H__);
    eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_MAXID () {2;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&_KERNEL)) {
	require 'machine/pcb.ph';
	require 'machine/psl.ph';
	require 'machine/intr.ph';
	require 'sys/sched.ph';
	if(defined( &MULTIPROCESSOR)) {
	    if(!defined( &MAX_CPUS) || (defined(&MAX_CPUS) ? &MAX_CPUS : 0) > 4) {
		undef(&MAX_CPUS) if defined(&MAX_CPUS);
		eval 'sub MAX_CPUS () {4;}' unless defined(&MAX_CPUS);
	    }
	} else {
	    if(!defined( &MAX_CPUS)) {
		undef(&MAX_CPUS) if defined(&MAX_CPUS);
		eval 'sub MAX_CPUS () {1;}' unless defined(&MAX_CPUS);
	    }
	}
	unless(defined(&_LOCORE)) {
	    eval 'sub CI_DDB_RUNNING () {0;}' unless defined(&CI_DDB_RUNNING);
	    eval 'sub CI_DDB_ENTERDDB () {1;}' unless defined(&CI_DDB_ENTERDDB);
	    eval 'sub CI_DDB_INDDB () {2;}' unless defined(&CI_DDB_INDDB);
	    eval 'sub CPU_INFO_ITERATOR () { &cpuid_t;}' unless defined(&CPU_INFO_ITERATOR);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q( &for (($cii) = 0; ($cii) <  &MAX_CPUS; ($cii)++)  &if ((($ci) =  $m88k_cpus[$cii])-> &ci_alive != 0));
	    }' unless defined(&CPU_INFO_FOREACH);
	    eval 'sub CPU_INFO_UNIT {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_cpuid));
	    }' unless defined(&CPU_INFO_UNIT);
	    if(defined( &MULTIPROCESSOR)) {
		eval 'sub curcpu () {
		    eval q(\\"(assembly code)\\");
		}' unless defined(&curcpu);
		eval 'sub CPU_IS_PRIMARY {
		    my($ci) = @_;
    		    eval q((($ci)-> &ci_primary != 0));
		}' unless defined(&CPU_IS_PRIMARY);
	    } else {
		eval 'sub curcpu () {
		    eval q(( $m88k_cpus[0]));
		}' unless defined(&curcpu);
		eval 'sub CPU_IS_PRIMARY {
		    my($ci) = @_;
    		    eval q(1);
		}' unless defined(&CPU_IS_PRIMARY);
	    }
	    if(!defined( &cpu_number)) {
		eval 'sub cpu_number () {
		    eval q( &curcpu()-> &ci_cpuid);
		}' unless defined(&cpu_number);
	    }
	    eval 'sub curpcb () { &curcpu()-> &ci_curpcb;}' unless defined(&curpcb);
	}
	eval 'sub cpu_exec {
	    my($p) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&cpu_exec);
	eval 'sub cpu_wait {
	    my($p) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&cpu_wait);
	if(defined( &MULTIPROCESSOR)) {
	    require 'sys/lock.ph';
	    require 'sys/mplock.ph';
	}
	eval 'sub CLKF_USERMODE {
	    my($framep) = @_;
    	    eval q(((($framep)-> ($tf->{tf_epsr}) &  &PSR_MODE) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($framep) = @_;
    	    eval q((($framep)-> ($tf->{tf_sxip}) &  &XIP_ADDR));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($framep) = @_;
    	    eval q(((($framep)-> ($tf->{tf_cpu}))-> &ci_intrdepth > 1));
	}' unless defined(&CLKF_INTR);
	require 'machine/intr.ph';
	eval 'sub SIR_NET () {1;}' unless defined(&SIR_NET);
	eval 'sub SIR_CLOCK () {2;}' unless defined(&SIR_CLOCK);
	if(defined(&MULTIPROCESSOR)) {
	} else {
	    eval 'sub setsoftint {
	        my($x) = @_;
    		eval q(( &ssir |= ($x)));
	    }' unless defined(&setsoftint);
	    eval 'sub clrsoftint {
	        my($x) = @_;
    		eval q(({ \'int\'  &tmpsir =  &ssir & ($x);  &ssir ^=  &tmpsir;  &tmpsir; }));
	    }' unless defined(&clrsoftint);
	}
	eval 'sub setsoftnet () {
	    eval q( &setsoftint( &SIR_NET));
	}' unless defined(&setsoftnet);
	eval 'sub setsoftclock () {
	    eval q( &setsoftint( &SIR_CLOCK));
	}' unless defined(&setsoftclock);
	eval 'sub aston {
	    my($p) = @_;
    	    eval q((($p)-> ($p_md->{md_astpending}) = 1));
	}' unless defined(&aston);
	eval 'sub PC_REGS {
	    my($regs) = @_;
    	    eval q(( &CPU_IS88110 ? (($regs)-> &exip &  &XIP_ADDR) : (($regs)-> &sxip &  &XIP_V ? ($regs)-> &sxip &  &XIP_ADDR : (($regs)-> &snip &  &NIP_V ? ($regs)-> &snip &  &NIP_ADDR : ($regs)-> &sfip &  &FIP_ADDR))));
	}' unless defined(&PC_REGS);
	eval 'sub PROC_PC {
	    my($p) = @_;
    	    eval q( &PC_REGS((($p)-> ($p_md->{md_tf}))));
	}' unless defined(&PROC_PC);
	eval 'sub need_resched {
	    my($ci) = @_;
    	    eval q( &do {  ($ci->{ci_want_resched}) = 1;  &if ( ($ci->{ci_curproc}) !=  &NULL)  &aston( ($ci->{ci_curproc})); }  &while (0));
	}' unless defined(&need_resched);
	eval 'sub need_proftick {
	    my($p) = @_;
    	    eval q((($p)-> &p_flag |=  &P_OWEUPC,  &aston($p)));
	}' unless defined(&need_proftick);
	eval 'sub signotify {
	    my($p) = @_;
    	    eval q( &aston($p));
	}' unless defined(&signotify);
    }
}
1;
