require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SPARC_DB_MACHDEP_H_)) {
    eval 'sub _SPARC_DB_MACHDEP_H_ () {1;}' unless defined(&_SPARC_DB_MACHDEP_H_);
    require 'uvm/uvm_extern.ph';
    require 'machine/frame.ph';
    require 'machine/psl.ph';
    require 'machine/trap.ph';
    require 'machine/reg.ph';
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub DDB_TF () {( ($ddb_regs->{db_tf}));}' unless defined(&DDB_TF);
    eval 'sub DDB_FR () {( ($ddb_regs->{db_fr}));}' unless defined(&DDB_FR);
    eval 'sub PC_REGS {
        local($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> ($db_tf->{tf_pc})));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        local($regs, $value) = @_;
	    eval q(-> ($db_tf->{tf_pc}) = ($value));
    }' unless defined(&SET_PC_REGS);
    eval 'sub PC_ADVANCE {
        local($regs) = @_;
	    eval q( &do { \'int\'  &n = ($regs)-> ($db_tf->{tf_npc}); ($regs)-> ($db_tf->{tf_pc}) =  &n; ($regs)-> ($db_tf->{tf_npc}) =  &n + 4; }  &while(0));
    }' unless defined(&PC_ADVANCE);
    eval 'sub BKPT_INST () {0x91d02001;}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {(4);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        local($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub db_clear_single_step {
        local($regs) = @_;
	    eval q(( &void) (0));
    }' unless defined(&db_clear_single_step);
    eval 'sub db_set_single_step {
        local($regs) = @_;
	    eval q(( &void) (0));
    }' unless defined(&db_set_single_step);
    eval 'sub IS_BREAKPOINT_TRAP {
        local($type, $code) = @_;
	    eval q((($type) ==  &T_BREAKPOINT || ($type) ==  &T_KGDB_EXEC));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        local($type, $code) = @_;
	    eval q((0));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub inst_trap_return {
        local($ins) = @_;
	    eval q((($ins)&0));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        local($ins) = @_;
	    eval q((($ins)&0));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        local($ins) = @_;
	    eval q((($ins)&0));
    }' unless defined(&inst_call);
    eval 'sub inst_load {
        local($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_load);
    eval 'sub inst_store {
        local($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_store);
    eval 'sub DB_MACHINE_COMMANDS () {1;}' unless defined(&DB_MACHINE_COMMANDS);
    eval 'sub DB_ELF_SYMBOLS () {1;}' unless defined(&DB_ELF_SYMBOLS);
    eval 'sub DB_ELFSIZE () {32;}' unless defined(&DB_ELFSIZE);
    eval 'sub KGDB_NUMREGS () {72;}' unless defined(&KGDB_NUMREGS);
    eval 'sub KGDB_BUFLEN () {1024;}' unless defined(&KGDB_BUFLEN);
    eval 'sub KGDB_PREPARE () { &fb_unblank();}' unless defined(&KGDB_PREPARE);
    eval 'sub KGDB_ENTER () { &__asm("ta %0" :: "n" ( &T_KGDB_EXEC));}' unless defined(&KGDB_ENTER);
}
1;
