/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class DelayedDirectEditHelper
implements Runnable {
    private EditPartViewer viewer;
    private EditPart part;
    private Request req;
    private FocusListener focus;
    private MouseListener mouse;
    private KeyListener key;
    private static DelayedDirectEditHelper activeHelper;

    public DelayedDirectEditHelper(EditPartViewer viewer, Request request, EditPart receiver) {
        this.req = request;
        this.viewer = viewer;
        this.part = receiver;
        if (activeHelper != null) {
            activeHelper = null;
        } else {
            this.hookControl(viewer.getControl());
            activeHelper = this;
            Display.getCurrent().timerExec(400, (Runnable)this);
        }
    }

    void abort() {
        activeHelper = null;
    }

    void hookControl(Control control) {
        this.focus = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DelayedDirectEditHelper.this.abort();
            }
        };
        control.addFocusListener(this.focus);
        this.key = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                DelayedDirectEditHelper.this.abort();
            }

            public void keyReleased(KeyEvent e) {
                DelayedDirectEditHelper.this.abort();
            }
        };
        control.addKeyListener(this.key);
        this.mouse = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DelayedDirectEditHelper.this.abort();
            }

            public void mouseDown(MouseEvent e) {
                DelayedDirectEditHelper.this.abort();
            }
        };
        control.addMouseListener(this.mouse);
    }

    public void run() {
        if (activeHelper == this && this.part.isActive() && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().removeFocusListener(this.focus);
            this.viewer.getControl().removeMouseListener(this.mouse);
            this.viewer.getControl().removeKeyListener(this.key);
            this.part.performRequest(this.req);
        }
        activeHelper = null;
    }
}

