/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#ifndef _ERL_INTERNAL_H
#define _ERL_INTERNAL_H
/* 
 * Copyright (C) 1996 Ericsson Telecom
 * Created:  11 May 1996 by tobbe@cslab.ericsson.se
 * Function: Some useful stuff not to be exported to users.
 */

#define HEAD(ep) ep->uval.lval.head
#define TAIL(ep) ep->uval.lval.tail
#define ERL_NO_REF(x) (ERL_COUNT(x) == 0)

#ifdef DEBUG
#define ASSERT(e) \
  if (e) { \
     ; \
  } else { \
     erl_assert_error(#e, __FILE__, __LINE__); \
  }
extern void erl_assert_error(char* expr, char* file, int line);
#else
#define ASSERT(e)
#endif

#endif
