/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.Artifact;
import org.eclipse.uml2.DataType;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Signal;
import org.eclipse.uml2.StructuredClassifier;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.util.UML2Switch;

class UML2Operations {
    protected static final String EMPTY_STRING = "";
    protected static final String PROPERTIES_FILE_EXTENSION = "properties";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    UML2Operations() {
    }

    protected static EAnnotation createEAnnotation(String source, EModelElement eModelElement) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.uml2.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(eModelElement)) {
            return ((Element)eModelElement).createEAnnotation(source);
        }
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource(source);
        eAnnotation.setEModelElement(eModelElement);
        return eAnnotation;
    }

    protected static EAnnotation getOrCreateEAnnotation(String source, EModelElement eModelElement) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(source);
        return eAnnotation == null ? UML2Operations.createEAnnotation(source, eModelElement) : eAnnotation;
    }

    protected static EAnnotation getEAnnotation(String source, EModelElement eModelElement) {
        EAnnotation eAnnotation;
        if (eModelElement != null && (eAnnotation = eModelElement.getEAnnotation(source)) != null) {
            return eAnnotation;
        }
        return EcoreFactory.eINSTANCE.createEAnnotation();
    }

    protected static boolean safeEquals(Object thisObject, Object thatObject) {
        return thisObject == null ? thatObject == null : thisObject.equals(thatObject);
    }

    protected static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    protected static EList getOwnedAttributes(Type type) {
        if (type == null) {
            return null;
        }
        return (EList)new UML2Switch(){

            public Object caseArtifact(Artifact object) {
                return object.getOwnedAttributes();
            }

            public Object caseDataType(DataType object) {
                return object.getOwnedAttributes();
            }

            public Object caseInterface(Interface object) {
                return object.getOwnedAttributes();
            }

            public Object caseSignal(Signal object) {
                return object.getOwnedAttributes();
            }

            public Object caseStructuredClassifier(StructuredClassifier object) {
                return object.getOwnedAttributes();
            }
        }.doSwitch((EObject)type);
    }

    private static String getMessageSubstitution(Map context, Object object) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.ecore.EObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(object)) {
            Resource resource;
            String qualifiedName;
            EObject eObject = (EObject)object;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.uml2.NamedElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isInstance(object) && !UML2Operations.isEmpty(qualifiedName = ((NamedElement)object).getQualifiedName())) {
                return qualifiedName;
            }
            if (context != null) {
                EValidator.SubstitutionLabelProvider substitutionLabelProvider;
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.emf.ecore.EValidator$SubstitutionLabelProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((substitutionLabelProvider = (EValidator.SubstitutionLabelProvider)context.get(clazz3)) != null) {
                    return substitutionLabelProvider.getObjectLabel(eObject);
                }
            }
            if ((resource = eObject.eResource()) != null) {
                return String.valueOf(resource.getURI().lastSegment()) + '#' + resource.getURIFragment(eObject);
            }
            return EcoreUtil.getIdentification((EObject)((EObject)object));
        }
        return String.valueOf(object);
    }

    protected static Object[] getMessageSubstitutions(Map context, Object object0) {
        return new Object[]{UML2Operations.getMessageSubstitution(context, object0)};
    }

    protected static Object[] getMessageSubstitutions(Map context, Object object0, Object object1) {
        return new Object[]{UML2Operations.getMessageSubstitution(context, object0), UML2Operations.getMessageSubstitution(context, object1)};
    }

    protected static Object[] getMessageSubstitutions(Map context, Object object0, Object object1, Object object2) {
        return new Object[]{UML2Operations.getMessageSubstitution(context, object0), UML2Operations.getMessageSubstitution(context, object1), UML2Operations.getMessageSubstitution(context, object2)};
    }

    protected static StringBuffer appendValidIdentifier(StringBuffer validIdentifier, String name) {
        if (!UML2Operations.isEmpty(name)) {
            char char_0 = name.charAt(0);
            if (Character.isJavaIdentifierStart(char_0)) {
                validIdentifier.append(char_0);
            } else {
                validIdentifier.append('_');
                if (Character.isJavaIdentifierPart(char_0)) {
                    validIdentifier.append(char_0);
                }
            }
            int i = 1;
            while (i < name.length()) {
                char char_i = name.charAt(i);
                if (Character.isJavaIdentifierPart(char_i)) {
                    validIdentifier.append(char_i);
                }
                ++i;
            }
        }
        return validIdentifier;
    }

    protected static String getValidIdentifier(String name) {
        return UML2Operations.appendValidIdentifier(new StringBuffer(), name).toString();
    }

    private static List getResourceBundleURIs(URI baseURI, String baseSegment, Locale locale) {
        ArrayList<URI> resourceBundleURIs = new ArrayList<URI>();
        String language = locale.getLanguage();
        if (language.length() > 0) {
            baseSegment = String.valueOf(baseSegment) + '_' + language;
            resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
            String country = locale.getCountry();
            if (country.length() > 0) {
                baseSegment = String.valueOf(baseSegment) + '_' + country;
                resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
                String variant = locale.getVariant();
                if (variant.length() > 0) {
                    baseSegment = String.valueOf(baseSegment) + '_' + variant;
                    resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
                }
            }
        }
        return resourceBundleURIs;
    }

    protected static List getResourceBundleURIs(URI uri, Locale locale) {
        ArrayList<URI> resourceBundleURIs = new ArrayList<URI>();
        URI baseURI = uri.trimSegments(1);
        String baseSegment = uri.trimFileExtension().lastSegment();
        resourceBundleURIs.add(baseURI.appendSegment(baseSegment).appendFileExtension(PROPERTIES_FILE_EXTENSION));
        Locale defaultLocale = Locale.getDefault();
        resourceBundleURIs.addAll(0, UML2Operations.getResourceBundleURIs(baseURI, baseSegment, defaultLocale));
        if (!defaultLocale.equals(locale)) {
            resourceBundleURIs.addAll(0, UML2Operations.getResourceBundleURIs(baseURI, baseSegment, defaultLocale));
        }
        return resourceBundleURIs;
    }

    protected static class FilteredECrossReferenceEList
    extends ECrossReferenceEList {
        private final FilteredUsageCrossReferencer.Filter filter;

        protected FilteredECrossReferenceEList(EObject eObject, FilteredUsageCrossReferencer.Filter filter) {
            super(eObject);
            this.filter = filter;
        }

        protected FilteredECrossReferenceEList(EObject eObject, EStructuralFeature[] eStructuralFeatures, FilteredUsageCrossReferencer.Filter filter) {
            super(eObject, eStructuralFeatures);
            this.filter = filter;
        }

        protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
            return super.isIncluded(eStructuralFeature) && this.filter.accept(eStructuralFeature);
        }

        protected ListIterator newListIterator() {
            return this.resolve() ? new FilteredResolvingFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter) : new FilteredFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter);
        }

        public List basicList() {
            return new FilteredECrossReferenceEList(this, this.eObject, this.eStructuralFeatures, this.filter){
                final /* synthetic */ FilteredECrossReferenceEList this$1;
                {
                    this.this$1 = filteredECrossReferenceEList;
                }

                protected boolean resolve() {
                    return false;
                }
            };
        }

        public Iterator basicIterator() {
            if (this.eStructuralFeatures == null) {
                return FilteredFeatureIteratorImpl.EMPTY_ITERATOR;
            }
            return new FilteredFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter);
        }

        public ListIterator basicListIterator() {
            if (this.eStructuralFeatures == null) {
                return ECrossReferenceEList.FeatureIteratorImpl.EMPTY_ITERATOR;
            }
            return new FilteredFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter);
        }

        public ListIterator basicListIterator(int index) {
            if (this.eStructuralFeatures == null) {
                if (index < 0 || 1 < index) {
                    throw new IndexOutOfBoundsException("index = " + index + ", size = 0");
                }
                return FilteredFeatureIteratorImpl.EMPTY_ITERATOR;
            }
            FilteredFeatureIteratorImpl result = new FilteredFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter);
            int i = 0;
            while (i < index) {
                result.next();
                ++i;
            }
            return result;
        }

        protected static class FilteredFeatureIteratorImpl
        extends ECrossReferenceEList.FeatureIteratorImpl {
            private final FilteredUsageCrossReferencer.Filter filter;

            public FilteredFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures, FilteredUsageCrossReferencer.Filter filter) {
                super(eObject, eStructuralFeatures);
                this.filter = filter;
            }

            protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
                return super.isIncluded(eStructuralFeature) && this.filter.accept(eStructuralFeature);
            }

            protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
                return super.isIncludedEntry(eStructuralFeature) && this.filter.accept(eStructuralFeature);
            }
        }

        protected static class FilteredResolvingFeatureIteratorImpl
        extends FilteredFeatureIteratorImpl {
            public FilteredResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures, FilteredUsageCrossReferencer.Filter filter) {
                super(eObject, eStructuralFeatures, filter);
            }

            protected boolean resolve() {
                return true;
            }
        }
    }

    protected static class FilteredUsageCrossReferencer
    extends EcoreUtil.UsageCrossReferencer {
        private final Filter filter;

        public static Collection find(EObject eObject, ResourceSet resourceSet, Filter filter) {
            return new FilteredUsageCrossReferencer(resourceSet, filter).findUsage(eObject);
        }

        protected static Collection find(EObject eObject, Resource resource, Filter filter) {
            return new FilteredUsageCrossReferencer(resource, filter).findUsage(eObject);
        }

        protected FilteredUsageCrossReferencer(ResourceSet resourceSet, Filter filter) {
            super(resourceSet);
            this.filter = filter;
        }

        protected FilteredUsageCrossReferencer(Resource resource, Filter filter) {
            super(resource);
            this.filter = filter;
        }

        protected void handleCrossReference(EObject eObject) {
            FilteredECrossReferenceEList filteredCrossReferences = new FilteredECrossReferenceEList(eObject, this.filter);
            EContentsEList.FeatureIterator crossReferences = (EContentsEList.FeatureIterator)(this.resolve() ? filteredCrossReferences.iterator() : filteredCrossReferences.basicIterator());
            while (crossReferences.hasNext()) {
                EObject crossReferencedEObject = (EObject)crossReferences.next();
                EReference eReference = (EReference)crossReferences.feature();
                if (!this.crossReference(eObject, eReference, crossReferencedEObject)) continue;
                this.getCollection(crossReferencedEObject).add(((InternalEObject)eObject).eSetting((EStructuralFeature)eReference));
            }
        }

        protected static interface Filter {
            public boolean accept(EStructuralFeature var1);
        }
    }
}

