/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.util.ImporterUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class ModelImporter {
    protected List fileExtensions;
    protected IPath originalGenModelPath;
    protected GenModel originalGenModel;
    protected IPath genModelProjectLocation;
    protected IPath genModelContainerPath;
    protected String genModelFileName;
    protected IPath genModelPath;
    protected GenModel genModel;
    protected List ePackages;
    protected Map ePackageToInfoMap;
    protected List referencedGenPackages;
    protected List modelLocationURIs;
    protected String modelLocation;
    protected String modelPluginID;
    protected String modelPluginDirectory;
    protected boolean usePlatformURI = true;
    protected IWorkspaceRoot workspaceRoot;
    protected ResourceSet externalGenModelResourceSet;
    protected List externalGenModelList;

    public void dispose() {
        this.genModel = null;
        this.originalGenModel = null;
        this.workspaceRoot = null;
        if (this.referencedGenPackages != null) {
            this.referencedGenPackages.clear();
            this.referencedGenPackages = null;
        }
        this.clearEPackagesCollections();
    }

    public abstract String getID();

    public List getFileExtensions() {
        if (this.fileExtensions == null) {
            this.fileExtensions = new ArrayList();
        }
        return this.fileExtensions;
    }

    public boolean usePlatformURI() {
        return this.usePlatformURI;
    }

    public void setUsePlatformURI(boolean usePlatformURI) {
        this.usePlatformURI = usePlatformURI;
    }

    public void defineOriginalGenModelPath(IPath path) {
        if (this.getOriginalGenModelPath() == null) {
            this.originalGenModelPath = path;
            if (this.getOriginalGenModelPath() != null) {
                URI genModelURI = this.createFileURI(this.getOriginalGenModelPath().toString());
                this.loadOriginalGenModel(genModelURI);
            }
        }
    }

    public IPath getOriginalGenModelPath() {
        return this.originalGenModelPath;
    }

    protected List computeEPackagesBeingReloaded() {
        if (this.getOriginalGenModel() != null) {
            EPackageList ePackages = new EPackageList();
            Iterator i = this.getOriginalGenModel().getGenPackages().iterator();
            block0: while (i.hasNext()) {
                GenPackage genPackage = (GenPackage)i.next();
                EPackage originalEPackage = genPackage.getEcorePackage();
                String nsURI = originalEPackage.getNsURI();
                if (nsURI == null) continue;
                Iterator j = this.getEPackages().iterator();
                while (j.hasNext()) {
                    EPackage ePackage = (EPackage)j.next();
                    if (!nsURI.equals(ePackage.getNsURI())) continue;
                    ePackages.add(ePackage);
                    continue block0;
                }
            }
            return ePackages;
        }
        return Collections.EMPTY_LIST;
    }

    public void setGenModelFileName(String name) {
        this.genModelFileName = name == null || name.trim().length() == 0 ? null : name;
        this.genModelPath = null;
    }

    public String getGenModelFileName() {
        return this.genModelFileName;
    }

    public String computeDefaultGenModelFileName() {
        List modelLocationURIs = this.getModelLocationURIs();
        if (!modelLocationURIs.isEmpty()) {
            URI modelURI = (URI)modelLocationURIs.get(0);
            String name = URI.decode((String)modelURI.lastSegment());
            int index = name.lastIndexOf(46);
            return String.valueOf(index >= 0 ? name.substring(0, index) : name) + ".genmodel";
        }
        return null;
    }

    public IStatus checkGenModelFileName() {
        String message = null;
        String name = this.getGenModelFileName();
        if (name == null || name.trim().length() == 0) {
            message = ImporterPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameCannotBeEmpty_message");
        } else if (!name.endsWith(".genmodel")) {
            message = ImporterPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameMustEndWithGenModel_message");
        }
        if (message == null) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.emf.importer", 0, message, null);
    }

    public IStatus checkEcoreModelFileName(String fileName, String packageName) {
        String message = null;
        if (fileName == null || fileName.equals("")) {
            message = packageName == null ? ImporterPlugin.INSTANCE.getString("_UI_EcoreModelFileNameCannotBeEmpty_message") : ImporterPlugin.INSTANCE.getString("_UI_EcoreModelFileNameForPackageCannotBeEmpty_message", new Object[]{packageName});
        } else if (!fileName.endsWith(".ecore")) {
            String string = message = packageName == null ? ImporterPlugin.INSTANCE.getString("_UI_EcoreModelFileNameMustEndWithEcore_message") : ImporterPlugin.INSTANCE.getString("_UI_EcoreModelFileNameForPackageMustEndWithEcore_message", new Object[]{packageName});
        }
        if (message == null) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.emf.importer", 0, message, null);
    }

    public void setGenModelProjectLocation(IPath genModelProjectLocation) {
        this.genModelProjectLocation = genModelProjectLocation;
    }

    public IPath getGenModelProjectLocation() {
        return this.genModelProjectLocation;
    }

    public void setGenModelContainerPath(IPath path) {
        this.genModelContainerPath = path;
        this.genModelPath = null;
    }

    public IPath getGenModelContainerPath() {
        return this.genModelContainerPath;
    }

    public IPath computeGenModelContainerPath(IPath projectPath) {
        return projectPath == null ? null : projectPath.append(this.getGenModelDefaultFolderPath());
    }

    protected IPath getGenModelDefaultFolderPath() {
        return new Path("model");
    }

    public IPath getGenModelPath() {
        if (this.genModelPath == null && this.getGenModelFileName() != null && this.getGenModelContainerPath() != null) {
            this.genModelPath = this.getGenModelContainerPath().append(this.getGenModelFileName());
        }
        return this.genModelPath;
    }

    public GenModel getGenModel() {
        if (this.genModel == null) {
            this.genModel = GenModelFactory.eINSTANCE.createGenModel();
            this.genModel.setImporterID(this.getID());
        }
        return this.genModel;
    }

    public boolean addGenModelToResource(boolean replace) {
        IPath genModelPath;
        GenModel genModel = this.getGenModel();
        if ((replace || genModel.eResource() == null) && (genModelPath = this.getGenModelPath()) != null) {
            URI genModelURI = this.createFileURI(genModelPath.toString());
            Resource genModelResource = this.createResourceSet().createResource(genModelURI);
            genModelResource.getContents().add((Object)genModel);
            return true;
        }
        return false;
    }

    public ResourceSet getGenModelResourceSet() {
        Resource resource = this.getGenModel().eResource();
        if (resource == null && this.addGenModelToResource(false)) {
            resource = this.getGenModel().eResource();
        }
        if (resource != null) {
            return resource.getResourceSet();
        }
        return null;
    }

    protected GenModel getOriginalGenModel() {
        return this.originalGenModel;
    }

    public List getEPackages() {
        if (this.ePackages == null) {
            this.ePackages = new EPackageList();
        }
        return this.ePackages;
    }

    protected Map getEPackageToInfoMap() {
        if (this.ePackageToInfoMap == null) {
            this.ePackageToInfoMap = new HashMap();
        }
        return this.ePackageToInfoMap;
    }

    public EPackageInfo getEPackageInfo(EPackage ePackage) {
        EPackageInfo ePackageInfo = (EPackageInfo)this.getEPackageToInfoMap().get(ePackage);
        if (ePackageInfo == null) {
            ePackageInfo = new EPackageInfo();
            this.getEPackageToInfoMap().put(ePackage, ePackageInfo);
        }
        return ePackageInfo;
    }

    public List getReferencedGenPackages() {
        if (this.referencedGenPackages == null) {
            this.referencedGenPackages = new GenPackageList();
        }
        return this.referencedGenPackages;
    }

    protected GenPackage getGenPackage(EPackage ePackage) {
        if (this.getOriginalGenModel() != null && !this.getOriginalGenModel().getGenPackages().isEmpty()) {
            Iterator i = this.getOriginalGenModel().getGenPackages().iterator();
            while (i.hasNext()) {
                GenPackage referencedGenPackage = (GenPackage)i.next();
                if (referencedGenPackage.getEcorePackage() == null || !referencedGenPackage.getEcorePackage().getNsURI().equals(ePackage.getNsURI())) continue;
                return referencedGenPackage;
            }
        }
        return null;
    }

    public void setModelLocation(String location) {
        this.modelLocation = location == null || location.trim().length() == 0 ? null : location;
        this.modelLocationURIs = null;
    }

    public String getModelLocation() {
        return this.modelLocation;
    }

    public List getModelLocationURIs() {
        if (this.getModelLocation() == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.modelLocationURIs == null) {
            this.modelLocationURIs = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(this.getModelLocation());
            while (stringTokenizer.hasMoreTokens()) {
                String uri = stringTokenizer.nextToken();
                this.modelLocationURIs.add(URI.createURI((String)uri));
            }
        }
        return this.modelLocationURIs;
    }

    public URI getFirstModelLocationURI(boolean resolve) {
        List modelLocationURIs = this.getModelLocationURIs();
        if (!modelLocationURIs.isEmpty()) {
            URI modelLocationURI = (URI)modelLocationURIs.get(0);
            return resolve ? CommonPlugin.resolve((URI)modelLocationURI) : modelLocationURI;
        }
        return null;
    }

    public void setModelFile(IFile file) {
        if (file != null) {
            URI modelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            this.setModelLocation(modelURI.toString());
        } else {
            this.setModelLocation(null);
        }
    }

    public EPackage getReferredEPackage(GenPackage genPackage) {
        String nsURI = genPackage.getEcorePackage().getNsURI();
        if (nsURI != null) {
            Iterator j = this.ePackages.iterator();
            while (j.hasNext()) {
                EPackage ePackage = (EPackage)j.next();
                if (!nsURI.equals(ePackage.getNsURI())) continue;
                return ePackage;
            }
        }
        return null;
    }

    public List filterReferencedEPackages(Collection ePackages) {
        if (ePackages.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.getReferencedGenPackages().isEmpty()) {
            return new ArrayList(ePackages);
        }
        EPackageList filteredEPackages = new EPackageList(ePackages);
        Iterator i = this.getReferencedGenPackages().iterator();
        while (i.hasNext()) {
            GenPackage genPackage = (GenPackage)i.next();
            EPackage ePackage = this.getReferredEPackage(genPackage);
            if (ePackage == null) continue;
            filteredEPackages.remove(ePackage);
        }
        return filteredEPackages;
    }

    public List getExternalGenModels() {
        if (this.externalGenModelList == null) {
            this.externalGenModelList = new UniqueEList.FastCompare();
            if (this.externalGenModelResourceSet == null) {
                this.externalGenModelResourceSet = this.getOriginalGenModel() != null ? this.getOriginalGenModel().eResource().getResourceSet() : this.createResourceSet();
            }
            Map ePackageToGenModelMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
            Iterator i = this.getEPackages().iterator();
            while (i.hasNext()) {
                EPackage ePackage = (EPackage)i.next();
                URI genModelURI = (URI)ePackageToGenModelMap.get(ePackage.getNsURI());
                if (genModelURI == null) continue;
                try {
                    Resource genModelResource = this.externalGenModelResourceSet.getResource(genModelURI, false);
                    if (genModelResource != null) continue;
                    genModelResource = this.externalGenModelResourceSet.getResource(genModelURI, true);
                    this.externalGenModelList.add(genModelResource.getContents().get(0));
                }
                catch (Exception exception) {
                    ImporterPlugin.INSTANCE.log(exception);
                }
            }
        }
        return this.externalGenModelList;
    }

    public ResourceSet createResourceSet() {
        return ImporterUtil.createResourceSet();
    }

    protected void loadOriginalGenModel(URI genModelURI) {
        Resource resource = this.createResourceSet().getResource(genModelURI, true);
        this.originalGenModel = (GenModel)resource.getContents().get(0);
        if (this.getOriginalGenModel() != null) {
            this.getOriginalGenModel().reconcile();
            this.setGenModelFileName(this.getOriginalGenModelPath().lastSegment());
            this.setGenModelContainerPath(this.getOriginalGenModelPath().removeLastSegments(1));
            this.genModelPath = this.getOriginalGenModelPath();
        }
        Iterator i = this.getOriginalGenModel().getUsedGenPackages().iterator();
        while (i.hasNext()) {
            GenPackage referencedGenPackage = (GenPackage)i.next();
            this.getReferencedGenPackages().add(referencedGenPackage);
        }
    }

    public IStatus computeEPackages(IProgressMonitor progressMonitor) throws Exception {
        this.clearEPackagesCollections();
        IStatus status = this.doComputeEPackages(progressMonitor);
        this.presetEPackagesToGenerate();
        return status;
    }

    protected void presetEPackagesToGenerate() {
        int size = this.getEPackages().size();
        if (size == 1) {
            this.getEPackageInfo((EPackage)this.getEPackages().get(0)).setGenerate(true);
        } else if (size > 1) {
            List ePackagesBeingReloaded = this.computeEPackagesBeingReloaded();
            Iterator i = ePackagesBeingReloaded.iterator();
            while (i.hasNext()) {
                this.getEPackageInfo((EPackage)i.next()).setGenerate(true);
            }
        }
    }

    protected IStatus doComputeEPackages(IProgressMonitor progressMonitor) throws Exception {
        return Status.OK_STATUS;
    }

    public void clearEPackagesCollections() {
        if (this.ePackages != null) {
            this.ePackages.clear();
            this.ePackages = null;
        }
        if (this.ePackageToInfoMap != null) {
            this.ePackageToInfoMap.clear();
            this.ePackageToInfoMap = null;
        }
        if (this.externalGenModelList != null) {
            this.externalGenModelList.clear();
            this.externalGenModelList = null;
        }
    }

    public void adjustEPackages(IProgressMonitor progressMonitor) {
        AbstractTreeIterator ePackagesIterator = new AbstractTreeIterator(this.getEPackages(), false){

            protected Iterator getChildren(Object object) {
                return object instanceof Collection ? ((Collection)object).iterator() : ((EPackage)object).getESubpackages().iterator();
            }
        };
        while (ePackagesIterator.hasNext()) {
            EPackage ePackage = (EPackage)ePackagesIterator.next();
            this.adjustEPackage(progressMonitor, ePackage);
        }
        this.makeEcoreFileNamesUnique();
    }

    protected void adjustEPackage(IProgressMonitor progressMonitor, EPackage ePackage) {
        EPackageInfo ePackageInfo = this.getEPackageInfo(ePackage);
        String name = ePackage.getName();
        int index = name.lastIndexOf(".");
        if (index != -1) {
            String basePackage = ePackageInfo.getBasePackage();
            String namePackage = name.substring(0, index);
            name = name.substring(index + 1);
            if (basePackage != null && !namePackage.startsWith(basePackage)) {
                namePackage = String.valueOf(basePackage) + "." + namePackage;
            }
            ePackageInfo.setBasePackage(namePackage);
            ePackage.setName(name);
        }
        if (ePackageInfo.getPrefix() == null) {
            ePackageInfo.setPrefix(CodeGenUtil.capName((String)name));
        }
        if (ePackageInfo.getEcoreFileName() == null) {
            String ecoreFileName = null;
            GenPackage genPackage = this.getGenPackage(ePackage);
            if (genPackage != null) {
                String ePackagePath = genPackage.getEcorePackage().eResource().getURI().lastSegment();
                ecoreFileName = URI.decode((String)ePackagePath);
            } else {
                ecoreFileName = ePackage.eResource() == null ? String.valueOf(name) + ".ecore" : ePackage.eResource().getURI().lastSegment();
            }
            ePackageInfo.setEcoreFileName(ecoreFileName);
        }
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        if (this.workspaceRoot == null) {
            this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
        return this.workspaceRoot;
    }

    public void prepareGenModelAndEPackages(IProgressMonitor progressMonitor) {
        ResourceSet resourceSet = this.getGenModelResourceSet();
        resourceSet.getURIConverter().getURIMap().remove(URI.createPlatformResourceURI((String)(String.valueOf(this.getModelProjectName()) + "/")));
        List ePackages = this.computeEPackagesToGenerate();
        Iterator i = ePackages.iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            this.addToResource(ePackage, resourceSet);
        }
        i = this.getReferencedGenPackages().iterator();
        while (i.hasNext()) {
            GenPackage genPackage = (GenPackage)i.next();
            EPackage realEPackage = genPackage.getEcorePackage();
            EPackage referredEPackage = this.getReferredEPackage(genPackage);
            if (referredEPackage == null) continue;
            URI ecoreURI = realEPackage.eResource().getURI();
            Resource resource = resourceSet.createResource(ecoreURI);
            resource.getContents().add((Object)referredEPackage);
        }
        this.getGenModel().initialize((Collection)ePackages);
        this.getGenModel().getUsedGenPackages().addAll((Collection)this.getReferencedGenPackages());
        this.traverseGenPackages((List)this.getGenModel().getGenPackages());
        this.adjustGenModel(progressMonitor);
        this.getGenModel().reconcile(this.getOriginalGenModel());
    }

    public void addToResource(EPackage ePackage, ResourceSet resourceSet) {
        EPackageInfo ePackageInfo;
        String fileName;
        if (ePackage.eResource() == null && (fileName = (ePackageInfo = this.getEPackageInfo(ePackage)).getEcoreFileName()) != null) {
            String baseLocation = String.valueOf(this.getGenModelPath().removeLastSegments(1).toString()) + "/";
            String ecoreFileName = String.valueOf(baseLocation) + fileName;
            URI ecoreURI = this.createFileURI(ecoreFileName);
            Resource resource = resourceSet.getResource(ecoreURI, false);
            if (resource == null) {
                resource = resourceSet.createResource(ecoreURI);
            }
            resource.getContents().add((Object)ePackage);
        }
    }

    public void saveGenModelAndEPackages(IProgressMonitor progressMonitor) throws Exception {
        List resources;
        String readOnlyFiles;
        String projectName = this.getModelProjectName();
        IProject project = this.getWorkspaceRoot().getProject(projectName);
        if (!project.exists()) {
            HashSet<GenModel> referencedGenModels = new HashSet<GenModel>();
            Iterator i = this.getGenModel().getUsedGenPackages().iterator();
            while (i.hasNext()) {
                GenPackage genPackage = (GenPackage)i.next();
                referencedGenModels.add(genPackage.getGenModel());
            }
            this.createProject(progressMonitor, project, referencedGenModels);
        }
        if ((readOnlyFiles = this.validateFiles(resources = this.computeResourcesToBeSaved())) != null) {
            throw new Exception(ImporterPlugin.INSTANCE.getString("_UI_ReadOnlyFiles_error", new String[]{readOnlyFiles}));
        }
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            resource.save(this.getGenmodelSaveOptions());
        }
    }

    protected List computeResourcesToBeSaved() {
        GenPackage genPackage;
        UniqueEList.FastCompare resources = new UniqueEList.FastCompare();
        Resource genModelResource = this.getGenModel().eResource();
        resources.add(genModelResource);
        Iterator i = this.getGenModel().getGenPackages().iterator();
        while (i.hasNext()) {
            genPackage = (GenPackage)i.next();
            resources.add(genPackage.getEcorePackage().eResource());
        }
        i = this.getGenModel().getUsedGenPackages().iterator();
        while (i.hasNext()) {
            genPackage = (GenPackage)i.next();
            if (genPackage.eResource() != genModelResource) continue;
            resources.add(genPackage.getEcorePackage().eResource());
        }
        return resources;
    }

    protected String validateFiles(List resources) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        ArrayList<IResource> workspaceFiles = new ArrayList<IResource>(resources.size());
        ArrayList<File> extenalFiles = new ArrayList<File>(resources.size());
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            String path;
            IResource workspaceResource;
            Resource resource = (Resource)i.next();
            URI uri = resource.getURI().trimFragment();
            if (uri.isFile()) {
                File file = new File(uri.toFileString());
                if (!file.isFile() || file.canWrite()) continue;
                extenalFiles.add(file);
                continue;
            }
            if (!uri.toString().startsWith("platform:/resource") || (workspaceResource = workspaceRoot.findMember((IPath)new Path(path = uri.toString().substring("platform:/resources".length())))) == null || workspaceResource.getType() != 1 || !workspaceResource.getResourceAttributes().isReadOnly()) continue;
            workspaceFiles.add(workspaceResource);
        }
        StringBuffer readOnlyFiles = new StringBuffer();
        if (!workspaceFiles.isEmpty()) {
            IFile[] files;
            IStatus status;
            Object context = null;
            if (Platform.getBundle((String)"org.eclipse.swt") != null) {
                context = new ShellFinder().getActiveShell();
            }
            if (!(status = workspace.validateEdit(files = workspaceFiles.toArray(new IFile[workspaceFiles.size()]), context)).isOK()) {
                int i2 = 0;
                while (i2 < files.length) {
                    if (files[i2].isReadOnly()) {
                        readOnlyFiles.append(", ").append(files[i2].getFullPath().toString());
                    }
                    ++i2;
                }
            }
        }
        if (!extenalFiles.isEmpty()) {
            Iterator i3 = extenalFiles.iterator();
            while (i3.hasNext()) {
                File file = (File)i3.next();
                readOnlyFiles.append(", ").append(file.getAbsolutePath());
            }
        }
        return readOnlyFiles.length() == 0 ? null : readOnlyFiles.deleteCharAt(0).deleteCharAt(0).toString();
    }

    protected void createProject(IProgressMonitor progressMonitor, IProject project, Collection referencedGenModels) {
        char firstChar;
        IWorkspaceRoot workspaceRoot = this.getWorkspaceRoot();
        ArrayList<IProject> referencedModelProjects = new ArrayList<IProject>();
        ArrayList<IProject> referencedEditProjects = new ArrayList<IProject>();
        Iterator i = referencedGenModels.iterator();
        while (i.hasNext()) {
            GenModel referencedGenModel = (GenModel)i.next();
            String modelDirectory = referencedGenModel.getModelDirectory();
            if (modelDirectory == null) continue;
            referencedModelProjects.add(workspaceRoot.getProject(new Path(modelDirectory).segment(0)));
            String editDirectory = referencedGenModel.getEditDirectory();
            if (editDirectory == null || modelDirectory.equals(editDirectory)) continue;
            referencedEditProjects.add(workspaceRoot.getProject(new Path(editDirectory).segment(0)));
        }
        String projectName = project.getName();
        String path = this.getGenModel().getModelDirectory();
        int index = path.indexOf(projectName);
        if (index >= 0) {
            path = path.substring(index);
        }
        if ((firstChar = path.charAt(0)) != '/' && firstChar != '\\') {
            path = "/" + path;
        }
        ArrayList referencedProjects = new ArrayList(referencedModelProjects);
        Generator.createEMFProject((IPath)new Path(path), (IPath)this.getGenModelProjectLocation(), referencedProjects, (IProgressMonitor)progressMonitor, (int)(Generator.EMF_MODEL_PROJECT_STYLE | Generator.EMF_EMPTY_PROJECT_STYLE));
    }

    protected void adjustGenModel(IProgressMonitor progressMonitor) {
        String modelName = URI.decode((String)this.getGenModelPath().removeFileExtension().lastSegment());
        int index = modelName.lastIndexOf(46);
        if (index != -1) {
            modelName = modelName.substring(0, index);
        }
        modelName = CodeGenUtil.capName((String)modelName);
        GenModel genModel = this.getGenModel();
        genModel.setModelName(modelName);
        genModel.setModelPluginID(this.getModelPluginID());
        genModel.setModelDirectory(this.getModelPluginDirectory());
        genModel.getUsedGenPackages().addAll((Collection)genModel.computeMissingUsedGenPackages());
    }

    protected List computeEPackagesToGenerate() {
        EPackageList ePackages = new EPackageList();
        Iterator i = this.getEPackages().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            EPackageInfo ePackageInfo = this.getEPackageInfo(ePackage);
            if (!ePackageInfo.isGenerate() || ePackageInfo.getEcoreFileName() == null) continue;
            ePackages.add(ePackage);
        }
        return this.filterReferencedEPackages((Collection)((Object)ePackages));
    }

    public void traverseGenPackages(List genPackages) {
        Iterator i = genPackages.iterator();
        while (i.hasNext()) {
            GenPackage genPackage = (GenPackage)i.next();
            EPackage ePackage = genPackage.getEcorePackage();
            EPackageInfo ePackageInfo = this.getEPackageInfo(ePackage);
            genPackage.setBasePackage(ePackageInfo.getBasePackage());
            genPackage.setPrefix(ePackageInfo.getPrefix());
            this.adjustGenPackageDuringTraverse(genPackage);
            this.traverseGenPackages((List)genPackage.getNestedGenPackages());
        }
    }

    protected void adjustGenPackageDuringTraverse(GenPackage genPackage) {
    }

    protected URI makeRelative(URI uri, URI relativeTo) {
        URI platformURI;
        URI result;
        IFile file;
        if ("file".equals(uri.scheme()) && (file = this.getWorkspaceRoot().getFileForLocation((IPath)new Path(uri.toFileString()))) != null && (result = (platformURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true)).deresolve(relativeTo, false, true, false)).isRelative()) {
            return result;
        }
        URI result2 = uri.deresolve(relativeTo, true, true, false);
        if (result2.isRelative()) {
            return result2;
        }
        return uri;
    }

    protected URI makeAbsolute(URI uri, URI relativeTo) {
        if (uri.isRelative()) {
            return uri.resolve(relativeTo);
        }
        return uri;
    }

    public URI createFileURI(String pathName) {
        return this.usePlatformURI() ? URI.createPlatformResourceURI((String)pathName, (boolean)true) : URI.createFileURI((String)pathName);
    }

    public String getModelPluginID() {
        return this.modelPluginID == null ? ImporterUtil.validPluginID(this.getModelProjectName()) : this.modelPluginID;
    }

    public void setModelPluginID(String modelPluginID) {
        this.modelPluginID = modelPluginID;
    }

    public String getModelPluginDirectory() {
        String result;
        if (this.modelPluginDirectory == null && (result = this.getModelProjectName()) != null) {
            if (result.charAt(0) != '/') {
                result = "/" + result;
            }
            return String.valueOf(result) + "/src";
        }
        return this.modelPluginDirectory;
    }

    public void setModelPluginDirectory(String modelPluginDirectory) {
        this.modelPluginDirectory = modelPluginDirectory;
    }

    public String getModelProjectName() {
        IPath path = this.getGenModelProjectLocation();
        if (path != null) {
            return URI.decode((String)path.lastSegment().toString());
        }
        IPath genModelPath = this.getGenModelPath();
        if (genModelPath != null) {
            return URI.decode((String)genModelPath.segment(0).toString());
        }
        return null;
    }

    public void makeEcoreFileNamesUnique() {
        if (this.ePackageToInfoMap != null) {
            HashMap<String, Integer> counterByEcoreName = new HashMap<String, Integer>();
            List ePackages = this.filterReferencedEPackages(this.ePackageToInfoMap.keySet());
            if (!ePackages.isEmpty()) {
                ArrayList<EPackageInfo> ePackageInfos = new ArrayList<EPackageInfo>(ePackages.size());
                Iterator i = ePackages.iterator();
                while (i.hasNext()) {
                    EPackage ePackage = (EPackage)i.next();
                    if (ePackage.getESuperPackage() != null && ePackages.contains(ePackage.getESuperPackage())) continue;
                    EPackageInfo ePackageInfo = (EPackageInfo)this.ePackageToInfoMap.get(ePackage);
                    ePackageInfos.add(ePackageInfo);
                    String fileName = ePackageInfo.getEcoreFileName();
                    if (fileName == null) continue;
                    counterByEcoreName.put(fileName, null);
                }
                i = ePackageInfos.iterator();
                while (i.hasNext()) {
                    EPackageInfo ePackageInfo = (EPackageInfo)i.next();
                    String fileName = ePackageInfo.getEcoreFileName();
                    if (fileName == null) continue;
                    Integer counterObject = (Integer)counterByEcoreName.get(fileName);
                    if (counterObject != null) {
                        int counter = counterObject;
                        int index = fileName.lastIndexOf(".");
                        StringBuffer newFileName = null;
                        while (counterByEcoreName.containsKey((newFileName = new StringBuffer(fileName).insert(index, counter++)).toString())) {
                        }
                        ePackageInfo.setEcoreFileName(newFileName.toString());
                        counterObject = new Integer(counter);
                        counterByEcoreName.put(newFileName.toString(), new Integer(1));
                    } else {
                        counterObject = new Integer(1);
                    }
                    counterByEcoreName.put(fileName, counterObject);
                }
            }
        }
    }

    protected Map getEcoreSaveOptions() {
        return Collections.EMPTY_MAP;
    }

    protected Map getGenmodelSaveOptions() {
        return Collections.EMPTY_MAP;
    }

    public static class EPackageList
    extends UniqueEList.FastCompare {
        public EPackageList() {
        }

        public EPackageList(Collection collection) {
            super(collection);
        }

        public EPackageList(int initialCapacity) {
            super(initialCapacity);
        }

        protected Object[] newData(int capacity) {
            return new EPackage[capacity];
        }
    }

    public static class GenPackageList
    extends UniqueEList.FastCompare {
        public GenPackageList() {
        }

        public GenPackageList(Collection collection) {
            super(collection);
        }

        public GenPackageList(int initialCapacity) {
            super(initialCapacity);
        }

        protected Object[] newData(int capacity) {
            return new GenPackage[capacity];
        }
    }

    public static class EPackageInfo {
        protected boolean generate = false;
        protected String ecoreFileName;
        protected String basePackage;
        protected String prefix;

        public String getBasePackage() {
            return this.basePackage;
        }

        public void setBasePackage(String basePackage) {
            this.basePackage = basePackage;
        }

        public String getEcoreFileName() {
            return this.ecoreFileName;
        }

        public void setEcoreFileName(String ecoreFileName) {
            this.ecoreFileName = ecoreFileName;
        }

        public boolean isGenerate() {
            return this.generate;
        }

        public void setGenerate(boolean generate) {
            this.generate = generate;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }

    protected static class ShellFinder {
        protected ShellFinder() {
        }

        public Object getActiveShell() {
            Shell shell = null;
            try {
                shell = Display.getCurrent().getActiveShell();
            }
            catch (Throwable throwable) {}
            return shell;
        }
    }
}

