/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BidiInfo;
import org.eclipse.draw2d.text.BidiProcessor;
import org.eclipse.draw2d.text.ContentBox;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;

public class FlowAdapter
extends FlowFigure {
    private FlowContext context;
    private FigureBox box = new FigureBox();

    protected void contributeBidi(BidiProcessor proc) {
        this.box.setBidiLevel(-1);
        proc.add((FlowFigure)this, '\ufffc');
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return null;
    }

    protected void layout() {
        int wHint = this.context.getRemainingLineWidth();
        if (wHint == Integer.MAX_VALUE) {
            wHint = -1;
        }
        Dimension prefSize = this.getPreferredSize(wHint, -1);
        if (this.context.isCurrentLineOccupied() && prefSize.width > this.context.getRemainingLineWidth()) {
            this.context.endLine();
            prefSize = this.getPreferredSize(this.context.getRemainingLineWidth(), -1);
        }
        this.box.setSize(prefSize);
        this.context.addToCurrentLine(this.box);
    }

    public void postValidate() {
        this.setBounds(new Rectangle(this.box.getX(), this.box.getBaseline() - this.box.ascent, this.box.width, this.box.ascent));
        super.layout();
        Iterator itr = this.getChildren().iterator();
        while (itr.hasNext()) {
            ((IFigure)itr.next()).validate();
        }
    }

    public void setBidiInfo(BidiInfo info) {
        this.box.setBidiLevel(info.levelInfo[0]);
    }

    public void setBounds(Rectangle rect) {
        boolean translate;
        int x = this.bounds.x;
        int y = this.bounds.y;
        boolean resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
        boolean bl = translate = rect.x != x || rect.y != y;
        if ((resize || translate) && this.isVisible()) {
            this.erase();
        }
        if (translate) {
            int dx = rect.x - x;
            int dy = rect.y - y;
            this.primTranslate(dx, dy);
        }
        this.bounds.width = rect.width;
        this.bounds.height = rect.height;
        if (translate || resize) {
            this.fireFigureMoved();
            this.repaint();
        }
    }

    public void setFlowContext(FlowContext flowContext) {
        this.context = flowContext;
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.setValid(true);
        this.layout();
    }

    private class FigureBox
    extends ContentBox {
        private int ascent;

        FigureBox() {
        }

        public boolean containsPoint(int x, int y) {
            return FlowAdapter.this.containsPoint(x, y);
        }

        public int getAscent() {
            return this.ascent;
        }

        public int getDescent() {
            return 0;
        }

        public void setSize(Dimension size) {
            this.ascent = size.height;
            this.width = size.width;
        }
    }
}

