/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.ExclusionSearch;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Handle;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelHelper;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.gef.ui.parts.DomainEventDispatcher;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class GraphicalViewerImpl
extends AbstractEditPartViewer
implements GraphicalViewer {
    private final LightweightSystem lws = this.createLightweightSystem();
    IFigure rootFigure;
    private DomainEventDispatcher eventDispatcher;
    private FocusListener lFocus;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public GraphicalViewerImpl() {
        this.createDefaultRoot();
        this.setProperty(MouseWheelHandler.KeyGenerator.getKey(0), MouseWheelDelegateHandler.SINGLETON);
    }

    public Control createControl(Composite composite) {
        this.setControl((Control)new Canvas(composite, 262144));
        return this.getControl();
    }

    protected void createDefaultRoot() {
        this.setRootEditPart(new ScalableRootEditPart());
    }

    protected LightweightSystem createLightweightSystem() {
        return new LightweightSystem();
    }

    protected void handleDispose(DisposeEvent e) {
        super.handleDispose(e);
        this.getLightweightSystem().getUpdateManager().dispose();
    }

    protected void handleFocusGained(FocusEvent fe) {
        if (this.focusPart != null) {
            this.focusPart.setFocus(true);
        }
    }

    protected void handleFocusLost(FocusEvent fe) {
        if (this.focusPart != null) {
            this.focusPart.setFocus(false);
        }
    }

    public Handle findHandleAt(Point p) {
        LayerManager layermanager = (LayerManager)this.getEditPartRegistry().get(LayerManager.ID);
        if (layermanager == null) {
            return null;
        }
        ArrayList<IFigure> list = new ArrayList<IFigure>(3);
        list.add(layermanager.getLayer("Primary Layer"));
        list.add(layermanager.getLayer("Connection Layer"));
        list.add(layermanager.getLayer("Feedback Layer"));
        IFigure handle = this.getLightweightSystem().getRootFigure().findFigureAtExcluding(p.x, p.y, list);
        if (handle instanceof Handle) {
            return (Handle)handle;
        }
        return null;
    }

    public EditPart findObjectAtExcluding(Point pt, Collection exclude, EditPartViewer.Conditional condition) {
        class ConditionalTreeSearch
        extends ExclusionSearch {
            final /* synthetic */ GraphicalViewerImpl this$0;
            private final /* synthetic */ EditPartViewer.Conditional val$condition;

            ConditionalTreeSearch(GraphicalViewerImpl graphicalViewerImpl, Collection coll, EditPartViewer.Conditional conditional) {
                super(coll);
                this.this$0 = graphicalViewerImpl;
                this.val$condition = conditional;
            }

            public boolean accept(IFigure figure) {
                EditPart editpart = null;
                while (editpart == null && figure != null) {
                    editpart = (EditPart)this.this$0.getVisualPartMap().get(figure);
                    figure = figure.getParent();
                }
                return editpart != null && (this.val$condition == null || this.val$condition.evaluate(editpart));
            }
        }
        IFigure figure = this.getLightweightSystem().getRootFigure().findFigureAt(pt.x, pt.y, (TreeSearch)new ConditionalTreeSearch(this, exclude, condition));
        EditPart part = null;
        while (part == null && figure != null) {
            part = (EditPart)this.getVisualPartMap().get(figure);
            figure = figure.getParent();
        }
        if (part == null) {
            return this.getContents();
        }
        return part;
    }

    public void flush() {
        this.getLightweightSystem().getUpdateManager().performUpdate();
    }

    protected DomainEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    protected LayerManager getLayerManager() {
        return (LayerManager)this.getEditPartRegistry().get(LayerManager.ID);
    }

    protected LightweightSystem getLightweightSystem() {
        return this.lws;
    }

    protected IFigure getRootFigure() {
        return this.rootFigure;
    }

    protected void hookDropTarget() {
        super.hookDropTarget();
        this.getDropTarget().addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                GraphicalViewerImpl.this.flush();
            }

            public void dragLeave(DropTargetEvent event) {
                GraphicalViewerImpl.this.flush();
            }

            public void dragOver(DropTargetEvent event) {
                GraphicalViewerImpl.this.flush();
            }
        });
    }

    protected void hookControl() {
        super.hookControl();
        this.getLightweightSystem().setControl((Canvas)this.getControl());
        this.lFocus = new FocusListener(){

            public void focusGained(FocusEvent e) {
                GraphicalViewerImpl.this.handleFocusGained(e);
            }

            public void focusLost(FocusEvent e) {
                GraphicalViewerImpl.this.handleFocusLost(e);
            }
        };
        this.getControl().addFocusListener(this.lFocus);
    }

    public void registerAccessibleEditPart(AccessibleEditPart acc) {
        Assert.isNotNull((Object)((Object)acc));
        this.getEventDispatcher().putAccessible(acc);
    }

    public void reveal(EditPart part) {
        AccessibleEditPart acc;
        if (part == null) {
            return;
        }
        EditPart current = part.getParent();
        while (current != null) {
            ExposeHelper helper;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.gef.ExposeHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((helper = (ExposeHelper)current.getAdapter(clazz)) != null) {
                helper.exposeDescendant(part);
            }
            current = current.getParent();
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.AccessibleEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((acc = (AccessibleEditPart)((Object)part.getAdapter(clazz))) != null) {
            this.getControl().getAccessible().setFocus(acc.getAccessibleID());
        }
    }

    public void setContextMenu(MenuManager contextMenu) {
        super.setContextMenu(contextMenu);
        if (contextMenu != null) {
            contextMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    GraphicalViewerImpl.this.flush();
                }
            });
        }
    }

    public void setCursor(Cursor newCursor) {
        if (this.getEventDispatcher() != null) {
            this.getEventDispatcher().setOverrideCursor(newCursor);
        }
    }

    protected void setDragSource(DragSource source) {
        super.setDragSource(source);
        if (source != null) {
            class TheLastListener
            extends DragSourceAdapter {
                final /* synthetic */ GraphicalViewerImpl this$0;

                TheLastListener(GraphicalViewerImpl graphicalViewerImpl) {
                    this.this$0 = graphicalViewerImpl;
                }

                public void dragStart(DragSourceEvent event) {
                    if (this.this$0.getEventDispatcher().isCaptured()) {
                        event.doit = false;
                    }
                    if (event.doit) {
                        this.this$0.getEventDispatcher().dispatchNativeDragStarted(event, this.this$0);
                        this.this$0.flush();
                    }
                }

                public void dragFinished(DragSourceEvent event) {
                    this.this$0.getEventDispatcher().dispatchNativeDragFinished(event, this.this$0);
                }
            }
            this.getDragSource().addDragListener((DragSourceListener)new TheLastListener(this));
        }
    }

    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.eventDispatcher = new DomainEventDispatcher(domain, this);
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)this.eventDispatcher);
    }

    public void setRootEditPart(RootEditPart editpart) {
        super.setRootEditPart(editpart);
        this.setRootFigure(((GraphicalEditPart)((Object)editpart)).getFigure());
    }

    protected void setRootFigure(IFigure figure) {
        this.rootFigure = figure;
        this.getLightweightSystem().setContents(this.rootFigure);
    }

    public void setRouteEventsToEditDomain(boolean value) {
        this.getEventDispatcher().setRouteEventsToEditor(value);
    }

    protected void unhookControl() {
        super.unhookControl();
        if (this.lFocus != null) {
            this.getControl().removeFocusListener(this.lFocus);
            this.lFocus = null;
        }
    }

    public void unregisterAccessibleEditPart(AccessibleEditPart acc) {
        Assert.isNotNull((Object)((Object)acc));
        this.getEventDispatcher().removeAccessible(acc);
    }

    private static class MouseWheelDelegateHandler
    implements MouseWheelHandler {
        private static final MouseWheelHandler SINGLETON = new MouseWheelDelegateHandler();
        static /* synthetic */ Class class$0;

        MouseWheelDelegateHandler() {
        }

        public void handleMouseWheel(Event event, EditPartViewer viewer) {
            EditPart part = viewer.getFocusEditPart();
            do {
                MouseWheelHelper helper;
                Class<?> clazz;
                if ((clazz = class$0) == null) {
                    try {
                        clazz = Class.forName("org.eclipse.gef.MouseWheelHelper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((helper = (MouseWheelHelper)part.getAdapter(clazz)) != null) {
                    helper.handleMouseWheelScrolled(event);
                }
                part = part.getParent();
            } while (event.doit && part != null);
        }
    }
}

