/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;

public class ComposedAdapterFactory
implements AdapterFactory,
ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected List adapterFactories = new ArrayList();
    protected ComposedAdapterFactory parentAdapterFactory;
    protected ChangeNotifier changeNotifier = new ChangeNotifier();
    protected Descriptor.Registry adapterFactoryDescriptorRegistry;

    public ComposedAdapterFactory() {
    }

    public ComposedAdapterFactory(Descriptor.Registry adapterFactoryDescriptorRegistry) {
        this.adapterFactoryDescriptorRegistry = adapterFactoryDescriptorRegistry;
    }

    public ComposedAdapterFactory(AdapterFactory adapterFactory) {
        this.addAdapterFactory(adapterFactory);
    }

    public ComposedAdapterFactory(AdapterFactory[] adapterFactories) {
        int i = 0;
        while (i < adapterFactories.length) {
            this.addAdapterFactory(adapterFactories[i]);
            ++i;
        }
    }

    public ComposedAdapterFactory(Collection adapterFactories) {
        Iterator factories = adapterFactories.iterator();
        while (factories.hasNext()) {
            this.addAdapterFactory((AdapterFactory)factories.next());
        }
    }

    public boolean isFactoryForType(Object type) {
        Iterator factories = this.adapterFactories.iterator();
        while (factories.hasNext()) {
            AdapterFactory adapterFactory = (AdapterFactory)factories.next();
            if (!adapterFactory.isFactoryForType(type)) continue;
            return true;
        }
        return false;
    }

    public AdapterFactory getFactoryForType(Object type) {
        return this.getFactoryForTypes(Collections.singleton(type));
    }

    public AdapterFactory getFactoryForTypes(Collection types) {
        Descriptor descriptor;
        Iterator factories = this.adapterFactories.iterator();
        block0: while (factories.hasNext()) {
            AdapterFactory factory = (AdapterFactory)factories.next();
            if (factory instanceof ComposedAdapterFactory) {
                if ((factory = ((ComposedAdapterFactory)factory).getFactoryForTypes(types)) == null) continue;
                return factory;
            }
            Iterator i = types.iterator();
            while (i.hasNext()) {
                if (!factory.isFactoryForType(i.next())) continue block0;
            }
            return factory;
        }
        if (this.adapterFactoryDescriptorRegistry != null && (descriptor = this.adapterFactoryDescriptorRegistry.getDescriptor(types)) != null) {
            AdapterFactory result = descriptor.createAdapterFactory();
            this.addAdapterFactory(result);
            return result;
        }
        return this.delegatedGetFactoryForTypes(types);
    }

    protected AdapterFactory delegatedGetFactoryForTypes(Collection types) {
        return null;
    }

    public Object adapt(Object target, Object type) {
        Object adapter = target;
        if (target instanceof Notifier) {
            adapter = this.adapt((Notifier)target, type);
        }
        if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
            return adapter;
        }
        return null;
    }

    public Adapter adapt(Notifier target, Object type) {
        Adapter result = null;
        if (target instanceof EObject) {
            EObject eObject = (EObject)target;
            EClass eClass = eObject.eClass();
            if (eClass != null) {
                AdapterFactory delegateAdapterFactory;
                EPackage ePackage = eClass.getEPackage();
                ArrayList<Object> types = new ArrayList<Object>();
                types.add(ePackage);
                if (type != null) {
                    types.add(type);
                }
                if ((delegateAdapterFactory = this.getFactoryForTypes(types)) != null) {
                    result = delegateAdapterFactory.adapt(target, type);
                }
                if (result == null) {
                    HashSet<EPackage> failedPackageSet = new HashSet<EPackage>();
                    failedPackageSet.add(ePackage);
                    Iterator supertypes = eClass.getEAllSuperTypes().iterator();
                    while (supertypes.hasNext()) {
                        EClass eSuperType = (EClass)supertypes.next();
                        EPackage eSupertypePackage = eSuperType.getEPackage();
                        if (!failedPackageSet.add(eSupertypePackage)) continue;
                        ArrayList<Object> superTypes = new ArrayList<Object>();
                        superTypes.add(ePackage);
                        if (type != null) {
                            superTypes.add(type);
                        }
                        if ((delegateAdapterFactory = this.getFactoryForTypes(superTypes)) == null || (result = delegateAdapterFactory.adapt(target, type)) == null) {
                            continue;
                        }
                        break;
                    }
                }
            }
        } else {
            result = this.adapt(target, type, new HashSet(), target.getClass());
        }
        return result;
    }

    protected Adapter adapt(Notifier target, Object type, Collection failedPackages, Class javaClass) {
        Adapter result = null;
        Package javaPackage = javaClass.getPackage();
        if (failedPackages.add(javaPackage)) {
            AdapterFactory delegateAdapterFactory;
            ArrayList<Object> types = new ArrayList<Object>();
            types.add(javaPackage);
            if (type != null) {
                types.add(type);
            }
            if ((delegateAdapterFactory = this.getFactoryForTypes(types)) != null) {
                result = delegateAdapterFactory.adapt(target, type);
            }
        }
        if (result == null) {
            Class superclass = javaClass.getSuperclass();
            if (superclass != null) {
                result = this.adapt(target, type, failedPackages, javaClass.getSuperclass());
            }
            if (result == null) {
                Class<?>[] interfaces = javaClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    result = this.adapt(target, type, failedPackages, interfaces[i]);
                    if (result != null) break;
                    ++i;
                }
            }
        }
        return result;
    }

    public Adapter adaptNew(Notifier target, Object type) {
        throw new RuntimeException(EMFEditPlugin.INSTANCE.getString("_EXC_Method_not_implemented", new Object[]{this.getClass() + "adaptNew(Notifier target, Object type)"}));
    }

    public void adaptAllNew(Notifier target) {
        Iterator factories = this.adapterFactories.iterator();
        while (factories.hasNext()) {
            AdapterFactory adapterFactory = (AdapterFactory)factories.next();
            if (!adapterFactory.isFactoryForType((Object)target)) continue;
            adapterFactory.adaptAllNew(target);
        }
    }

    public void insertAdapterFactory(AdapterFactory adapterFactory) {
        if (!this.adapterFactories.contains(adapterFactory)) {
            this.adapterFactories.add(0, adapterFactory);
            if (adapterFactory instanceof ComposeableAdapterFactory) {
                ((ComposeableAdapterFactory)adapterFactory).setParentAdapterFactory(this);
            }
        }
    }

    public void addAdapterFactory(AdapterFactory adapterFactory) {
        if (!this.adapterFactories.contains(adapterFactory)) {
            this.adapterFactories.add(adapterFactory);
            if (adapterFactory instanceof ComposeableAdapterFactory) {
                ((ComposeableAdapterFactory)adapterFactory).setParentAdapterFactory(this);
            }
        }
    }

    public void removeAdapterFactory(AdapterFactory adapterFactory) {
        if (this.adapterFactories.contains(adapterFactory)) {
            this.adapterFactories.remove(adapterFactory);
            if (adapterFactory instanceof ComposeableAdapterFactory) {
                ((ComposeableAdapterFactory)adapterFactory).setParentAdapterFactory(null);
            }
        }
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.add(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.remove(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        Iterator factories = this.adapterFactories.iterator();
        while (factories.hasNext()) {
            Object factory = factories.next();
            if (!(factory instanceof IDisposable)) continue;
            ((IDisposable)factory).dispose();
        }
    }

    public static interface Descriptor {
        public AdapterFactory createAdapterFactory();

        public static interface Registry {
            public static final Registry INSTANCE = EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();

            public Descriptor getDescriptor(Collection var1);

            public static class Impl
            extends HashMap
            implements Registry {
                protected Registry delegateRegistry;

                public Impl(Registry delegateRegistry) {
                    this.delegateRegistry = delegateRegistry;
                }

                public Descriptor getDescriptor(Collection types) {
                    Descriptor descriptor = (Descriptor)this.get(types);
                    return descriptor == null ? this.delegatedGetDescriptor(types) : descriptor;
                }

                protected Descriptor delegatedGetDescriptor(Collection types) {
                    if (this.delegateRegistry != null) {
                        return this.delegateRegistry.getDescriptor(types);
                    }
                    return null;
                }
            }
        }
    }
}

