#TRUSTED 0d6eec097713631ebd59626cdc6b7989e2032a69ec80410eebecdc5df14d58525441bfc8bf75332d464f531efbe140b61bf12b96fe3e6663c3952b6ee15441b45d8b5c0dc4fb5fce54343441de71c01ed55ffd008efcaad82d0aaf836184beff59622d48eb7e3422dd2fe833b1478a3b4cf1d3589f8fb761b8e7e57a8958d7cbe8fde318cf6eef8f7bbaefd910117ef7a3a9ed51ff0194671b93f0071424d7031e4673dfceac596578d9568ad1a64bc32d00440bf3ca35c6bb4e0071fd16be9a13dd1059ebdf8de93873bf9713de52bbe416bf7353046de8ff16f3c05f9f3c8f8526d1a90d0d82b862fb75ea80b93b63b38909222ea6ed0925ac9b0c6b4aee349b34ec1615866abaea35a29018ffa02b3d75a676f6c555e6f3776ef3ea7afb25fcefae28efbe5542b8317b3a1accb17604d6487436f7c13e727f86b9707cd2e64459c501b2f25d4279ae2a331eacfa0e2b589a7ea8b40e7b11b394ee7f803915c07318a45cbfd7749d44a4b6f642301716c0847afffb0f7f63eb8a35b28db8f932f20e2dcccf3747a2b03603bf468303b578ecc0ae9395d5175717affc8c89249c225ea8a96a5aaf5fa40ac72d9c2987161e64b80f9c21e5be25ce1d6ce92ae9beb4269018227cc9c88590a11f227d2694a5d3de0b1508950168aac5885f01b2f6ee48421308e60a6387c0c2a86da00e0009892feb69c4466cbb064ec32d2c19
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15877);
 script_version ("1.2");
 name["english"] = "Hydra: LDAP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find LDAP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force LDAP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_add_preference(name: "DN : ", type: "entry", value: "");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/ldap", 389);
 # find_service does not detect LDAP yet, so we rely upon amap
 # However find_services will detect the SSL layer for LDAPS
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl", "external_svc_ident.nasl");
 exit(0);
}

#

thorough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< thorough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/ldap");
if (! port) port = 389;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

dn = script_get_preference("DN : ");
if (! dn) exit(0);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "ldap";
argv[i++] = dn;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/ldap/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the LDAP server:\n' + report);
