/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.ElementImport;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Namespace;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PackageImport;
import org.eclipse.uml2.PackageableElement;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.VisibilityKind;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class NamespaceOperations
extends UML2Operations {
    private NamespaceOperations() {
    }

    public static Set excludeCollisions(Namespace namespace, Set imps) {
        HashSet<PackageableElement> excludeCollisions = new HashSet<PackageableElement>();
        Iterator imps1 = imps.iterator();
        block0: while (imps1.hasNext()) {
            PackageableElement imp1 = (PackageableElement)imps1.next();
            Iterator imps2 = imps.iterator();
            while (imps2.hasNext()) {
                PackageableElement imp2 = (PackageableElement)imps2.next();
                if (imp1 != imp2 && !imp1.isDistinguishableFrom(imp2, namespace)) continue block0;
            }
            excludeCollisions.add(imp1);
        }
        return excludeCollisions;
    }

    public static Set getNamesOfMember(Namespace namespace, NamedElement element) {
        HashSet<String> namesOfMember = new HashSet<String>();
        if (namespace.getOwnedMembers().contains((Object)element)) {
            if (!UML2Operations.isEmpty(element.getName())) {
                namesOfMember.add(element.getName());
            }
        } else {
            Iterator elementImports = namespace.getElementImports().iterator();
            while (elementImports.hasNext()) {
                ElementImport elementImport = (ElementImport)elementImports.next();
                if (!element.equals(elementImport.getImportedElement()) || UML2Operations.isEmpty(elementImport.getName())) continue;
                namesOfMember.add(elementImport.getName());
            }
            if (namesOfMember.isEmpty()) {
                Iterator packageImports = namespace.getPackageImports().iterator();
                while (packageImports.hasNext()) {
                    PackageImport packageImport = (PackageImport)packageImports.next();
                    if (packageImport.getImportedPackage() == null || !packageImport.getImportedPackage().visibleMembers().contains(element)) continue;
                    namesOfMember.addAll(packageImport.getImportedPackage().getNamesOfMember(element));
                }
            }
        }
        return namesOfMember;
    }

    public static Set importedMember(Namespace namespace) {
        HashSet<PackageableElement> importedMember = new HashSet<PackageableElement>();
        Iterator elementImports = namespace.getElementImports().iterator();
        while (elementImports.hasNext()) {
            PackageableElement importedElement = ((ElementImport)elementImports.next()).getImportedElement();
            if (importedElement == null) continue;
            importedMember.add(importedElement);
        }
        Iterator packageImports = namespace.getPackageImports().iterator();
        while (packageImports.hasNext()) {
            Package importedPackage = ((PackageImport)packageImports.next()).getImportedPackage();
            if (importedPackage == null) continue;
            importedMember.addAll(importedPackage.visibleMembers());
        }
        return importedMember;
    }

    public static Set importMembers(Namespace namespace, Set imps) {
        HashSet<PackageableElement> importMembers = new HashSet<PackageableElement>();
        Iterator excludeCollisions = namespace.excludeCollisions(imps).iterator();
        block0: while (excludeCollisions.hasNext()) {
            PackageableElement excludeCollision = (PackageableElement)excludeCollisions.next();
            Iterator ownedMembers = namespace.getOwnedMembers().iterator();
            while (ownedMembers.hasNext()) {
                PackageableElement ownedMember = (PackageableElement)ownedMembers.next();
                if (!excludeCollision.isDistinguishableFrom(ownedMember, namespace)) continue block0;
            }
            importMembers.add(excludeCollision);
        }
        return importMembers;
    }

    public static boolean membersAreDistinguishable(Namespace namespace) {
        EList namespaceMembers = namespace.getMembers();
        Iterator members = namespaceMembers.iterator();
        while (members.hasNext()) {
            NamedElement member = (NamedElement)members.next();
            Iterator otherMembers = namespaceMembers.iterator();
            while (otherMembers.hasNext()) {
                NamedElement otherMember = (NamedElement)otherMembers.next();
                if (member == otherMember || member.isDistinguishableFrom(otherMember, namespace)) continue;
                return false;
            }
        }
        return true;
    }

    public static void importElement(Namespace namespace, VisibilityKind visibility, PackageableElement element) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.valueOf(namespace));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.valueOf((Object)visibility));
        }
        if (element == null || NamespaceOperations.importedMember(namespace).contains(element)) {
            throw new IllegalArgumentException(String.valueOf(element));
        }
        ElementImport elementImport = namespace.createElementImport(UML2Package.eINSTANCE.getElementImport());
        elementImport.setVisibility(visibility);
        elementImport.setImportedElement(element);
    }

    public static Set getImportedPackages(Namespace namespace) {
        HashSet<Package> importedPackages = new HashSet<Package>();
        if (namespace == null) {
            return importedPackages;
        }
        Iterator packageImports = namespace.getPackageImports().iterator();
        while (packageImports.hasNext()) {
            PackageImport packageImport = (PackageImport)packageImports.next();
            if (packageImport.getImportedPackage() == null) continue;
            importedPackages.add(packageImport.getImportedPackage());
        }
        return importedPackages;
    }

    public static void importPackage(Namespace namespace, VisibilityKind visibility, Package package_) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.valueOf(namespace));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.valueOf((Object)visibility));
        }
        if (package_ == null || namespace.getImportedPackages().contains(package_)) {
            throw new IllegalArgumentException(String.valueOf(package_));
        }
        PackageImport packageImport = namespace.createPackageImport(UML2Package.eINSTANCE.getPackageImport());
        packageImport.setVisibility(visibility);
        packageImport.setImportedPackage(package_);
    }

    public static boolean validateMembersAreDistinguishable(Namespace namespace, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (!namespace.membersAreDistinguishable()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 11, UML2Plugin.INSTANCE.getString("_UI_Namespace_MembersAreDistinguishable_diagnostic", UML2Operations.getMessageSubstitutions(context, namespace)), new Object[]{namespace}));
            }
        }
        return result;
    }

    public static boolean validateImportedMemberDerived(Namespace namespace, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        HashSet<PackageableElement> importedMember = new HashSet<PackageableElement>();
        Iterator elementImports = namespace.getElementImports().iterator();
        while (elementImports.hasNext()) {
            ElementImport elementImport = (ElementImport)elementImports.next();
            if (elementImport.getImportedElement() == null) continue;
            importedMember.add(elementImport.getImportedElement());
        }
        Iterator packageImports = namespace.getPackageImports().iterator();
        while (packageImports.hasNext()) {
            PackageImport packageImport = (PackageImport)packageImports.next();
            if (packageImport.getImportedPackage() == null) continue;
            importedMember.addAll(packageImport.getImportedPackage().visibleMembers());
        }
        if (!namespace.getImportedMembers().containsAll((Collection)namespace.importMembers(importedMember))) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 12, UML2Plugin.INSTANCE.getString("_UI_Namespace_ImportedMemberDerived_diagnostic", UML2Operations.getMessageSubstitutions(context, namespace)), new Object[]{namespace}));
            }
        }
        return result;
    }
}

