%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
-module(application).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/free/1').
-author('mbj@erlang.ericsson.se').

-export([start/1, start/2, stop/1, load/1, load/2, unload/1, takeover/2,
	 which_applications/0, loaded_applications/0, permit/2]).
-export([get_env/1, get_env/2, get_all_env/0, get_all_env/1]).
-export([get_key/1, get_key/2, get_all_key/0, get_all_key/1]).
-export([get_application/0, get_application/1, info/0]).
-export([start_type/0]).

%%%-----------------------------------------------------------------
%%% This module is API towards application_controller and
%%% application_master.
%%%-----------------------------------------------------------------
load(Application) ->
    load(Application, []).

load(Application, DistNodes) ->
    case application_controller:load_application(Application) of
	ok when DistNodes /= [] ->
	    AppName = get_appl_name(Application),
	    case dist_ac:load_application(AppName, DistNodes) of
		ok ->
		    ok;
		{error, R} ->
		    application_controller:unload_application(AppName),
		    {error, R}
	    end;
	Else ->
	    Else
    end.

unload(Application) ->
    application_controller:unload_application(Application).

start(Application) ->
    start(Application, temporary).

start(Application, RestartType) ->
    case load(Application) of
	ok ->
	    Name = name(Application),
	    application_controller:start_application(Name, RestartType);
	{error, {already_loaded, Name}} ->
	    application_controller:start_application(Name, RestartType);
	Error ->
	    Error
    end.

takeover(Application, RestartType) ->
    dist_ac:takeover_application(Application, RestartType).

permit(Application, Bool) ->
    case Bool of
	true -> ok;
	false -> ok;
	Bad -> exit({badarg, {?MODULE, permit, [Application, Bad]}})
    end,
    case application_controller:permit_application(Application, Bool) of
	distributed_application ->
	    dist_ac:permit_application(Application, Bool);
	LocalResult ->
	    LocalResult
    end.


name({application, Name, _}) -> Name;
name(Name) -> Name.

stop(Application) ->
    application_controller:stop_application(Application).

which_applications() -> application_controller:which_applications().

loaded_applications() -> application_controller:loaded_applications().

info() -> application_controller:info().

get_env(Key) -> application_controller:get_pid_env(group_leader(), Key).
get_env(Application, Key) -> application_controller:get_env(Application, Key).

get_all_env() -> application_controller:get_pid_all_env(group_leader()).
get_all_env(Application) -> application_controller:get_all_env(Application).

get_key(Key) -> application_controller:get_pid_key(group_leader(), Key).
get_key(Application, Key) -> application_controller:get_key(Application, Key).

get_all_key() -> application_controller:get_pid_all_key(group_leader()).
get_all_key(Application) -> application_controller:get_all_key(Application).

get_application() -> application_controller:get_application(group_leader()).
get_application(Pid) when pid(Pid) ->
    case process_info(Pid, group_leader) of
	{group_leader, Gl} ->
	    application_controller:get_application(Gl);
	undefined ->
	    undefined
    end;
get_application(Module) when atom(Module) ->
    application_controller:get_application_module(Module).

start_type() ->
    application_controller:start_type(group_leader()).


%% Internal
get_appl_name(Name) when atom(Name) -> Name;
get_appl_name({application, Name, _}) when atom(Name) -> Name.
