/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;

public final class ShortestPathConnectionRouter
extends AbstractRouter {
    private Map constraintMap = new HashMap();
    private Map figuresToBounds;
    private Map connectionToPaths;
    private boolean isDirty = false;
    private ShortestPathRouter algorithm = new ShortestPathRouter();
    private IFigure container;
    private Set staleConnections = new HashSet();
    private LayoutListener listener = new LayoutTracker();
    private FigureListener figureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            Rectangle newBounds = source.getBounds().getCopy();
            if (ShortestPathConnectionRouter.this.algorithm.updateObstacle((Rectangle)ShortestPathConnectionRouter.this.figuresToBounds.get(source), newBounds)) {
                ShortestPathConnectionRouter.this.queueSomeRouting();
                ShortestPathConnectionRouter.this.isDirty = true;
            }
            ShortestPathConnectionRouter.this.figuresToBounds.put(source, newBounds);
        }
    };
    private boolean ignoreInvalidate;

    public ShortestPathConnectionRouter(IFigure container) {
        this.algorithm = new ShortestPathRouter();
        this.container = container;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void queueSomeRouting() {
        if (this.connectionToPaths == null) return;
        if (this.connectionToPaths.isEmpty()) {
            return;
        }
        try {
            this.ignoreInvalidate = true;
            ((Connection)this.connectionToPaths.keySet().iterator().next()).revalidate();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.ignoreInvalidate = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.ignoreInvalidate = false;
            return;
        }
    }

    void addChild(IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        if (this.figuresToBounds.containsKey(child)) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        this.algorithm.addObstacle(bounds);
        this.figuresToBounds.put(child, bounds);
        child.addFigureListener(this.figureListener);
        this.isDirty = true;
    }

    void removeChild(IFigure child) {
        if (this.connectionToPaths == null) {
            return;
        }
        Rectangle bounds = child.getBounds().getCopy();
        boolean change = this.algorithm.removeObstacle(bounds);
        this.figuresToBounds.remove(child);
        child.removeFigureListener(this.figureListener);
        if (change) {
            this.isDirty = true;
            this.queueSomeRouting();
        }
    }

    private void hookAll() {
        this.figuresToBounds = new HashMap();
        int i = 0;
        while (i < this.container.getChildren().size()) {
            this.addChild((IFigure)this.container.getChildren().get(i));
            ++i;
        }
        this.container.addLayoutListener(this.listener);
    }

    private void unhookAll() {
        this.container.removeLayoutListener(this.listener);
        if (this.figuresToBounds != null) {
            Iterator figureItr = this.figuresToBounds.keySet().iterator();
            while (figureItr.hasNext()) {
                IFigure child = (IFigure)figureItr.next();
                figureItr.remove();
                this.removeChild(child);
            }
            this.figuresToBounds = null;
        }
    }

    public Object getConstraint(Connection connection) {
        return this.constraintMap.get(connection);
    }

    public void invalidate(Connection connection) {
        if (this.ignoreInvalidate) {
            return;
        }
        this.staleConnections.add(connection);
        this.isDirty = true;
    }

    public void remove(Connection connection) {
        Path path = (Path)this.connectionToPaths.remove(connection);
        this.staleConnections.remove(connection);
        this.constraintMap.remove(connection);
        this.algorithm.removePath(path);
        this.isDirty = true;
        if (this.connectionToPaths.isEmpty()) {
            this.unhookAll();
            this.connectionToPaths = null;
        } else {
            this.queueSomeRouting();
        }
    }

    private void processLayout() {
        if (this.staleConnections.isEmpty()) {
            return;
        }
        ((Connection)this.staleConnections.iterator().next()).revalidate();
    }

    public void route(Connection conn) {
        if (this.isDirty) {
            this.ignoreInvalidate = true;
            this.processStaleConnections();
            this.isDirty = false;
            List updated = this.algorithm.solve();
            int i = 0;
            while (i < updated.size()) {
                Path path = (Path)updated.get(i);
                Connection current = (Connection)path.data;
                current.revalidate();
                PointList points = path.getPoints().getCopy();
                PrecisionPoint ref1 = new PrecisionPoint(points.getPoint(1));
                PrecisionPoint ref2 = new PrecisionPoint(points.getPoint(points.size() - 2));
                current.translateToAbsolute(ref1);
                current.translateToAbsolute(ref2);
                Point start = current.getSourceAnchor().getLocation(ref1).getCopy();
                Point end = current.getTargetAnchor().getLocation(ref2).getCopy();
                current.translateToRelative(start);
                current.translateToRelative(end);
                points.setPoint(start, 0);
                points.setPoint(end, points.size() - 1);
                current.setPoints(points);
                ++i;
            }
            this.ignoreInvalidate = false;
        }
    }

    private void processStaleConnections() {
        Iterator iter = this.staleConnections.iterator();
        if (iter.hasNext() && this.connectionToPaths == null) {
            this.connectionToPaths = new HashMap();
            this.hookAll();
        }
        while (iter.hasNext()) {
            List constraint;
            Connection conn = (Connection)iter.next();
            Path path = (Path)this.connectionToPaths.get(conn);
            if (path == null) {
                path = new Path(conn);
                this.connectionToPaths.put(conn, path);
                this.algorithm.addPath(path);
            }
            if ((constraint = (List)this.getConstraint(conn)) == null) {
                constraint = Collections.EMPTY_LIST;
            }
            Point start = conn.getSourceAnchor().getReferencePoint().getCopy();
            Point end = conn.getTargetAnchor().getReferencePoint().getCopy();
            this.container.translateToRelative(start);
            this.container.translateToRelative(end);
            path.setStartPoint(start);
            path.setEndPoint(end);
            if (!constraint.isEmpty()) {
                PointList bends = new PointList(constraint.size());
                int i = 0;
                while (i < constraint.size()) {
                    Bendpoint bp = (Bendpoint)constraint.get(i);
                    bends.addPoint(bp.getLocation());
                    ++i;
                }
                path.setBendPoints(bends);
            } else {
                path.setBendPoints(null);
            }
            this.isDirty |= path.isDirty;
        }
        this.staleConnections.clear();
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.staleConnections.add(connection);
        this.constraintMap.put(connection, constraint);
        this.isDirty = true;
    }

    private class LayoutTracker
    extends LayoutListener.Stub {
        LayoutTracker() {
        }

        public void postLayout(IFigure container) {
            ShortestPathConnectionRouter.this.processLayout();
        }

        public void remove(IFigure child) {
            ShortestPathConnectionRouter.this.removeChild(child);
        }

        public void setConstraint(IFigure child, Object constraint) {
            ShortestPathConnectionRouter.this.addChild(child);
        }
    }
}

