require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_M68K_PARAM_H_)) {
    eval 'sub _M68K_PARAM_H_ () {1;}' unless defined(&_M68K_PARAM_H_);
    eval 'sub _MACHINE_ARCH () { &m68k;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"m68k";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_M68K;}' unless defined(&MID_MACHINE);
    eval 'sub ALIGNBYTES () {($sizeof{\'int\'} - 1);}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        local($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        local($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub NPTEPG () {( &NBPG/($sizeof{ &pt_entry_t}));}' unless defined(&NPTEPG);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    unless(defined(&SEGSHIFT)) {
	if(defined( &M68040) || defined( &M68060)) {
	    eval 'sub SEGSHIFT () {(( &mmutype <=  &MMU_68040) ? 18: (34-  &PGSHIFT));}' unless defined(&SEGSHIFT);
	} else {
	    eval 'sub SEGSHIFT () {(34-  &PGSHIFT);}' unless defined(&SEGSHIFT);
	}
	eval 'sub NBSEG () {(1<<  &SEGSHIFT);}' unless defined(&NBSEG);
	eval 'sub SEGOFSET () {( &NBSEG - 1);}' unless defined(&SEGOFSET);
    }
    unless(defined(&UPAGES)) {
	eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    }
    eval 'sub USPACE () {( &UPAGES *  &NBPG);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((64* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    unless(defined(&MCLSHIFT)) {
	eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    }
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
    eval 'sub ctod {
        local($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        local($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        local($x) = @_;
	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        local($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        local($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub bdbtofsb {
        local($bn) = @_;
	    eval q((($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE)));
    }' unless defined(&bdbtofsb);
    eval 'sub m68k_round_seg {
        local($x) = @_;
	    eval q((((($x)) +  &SEGOFSET) & ~ &SEGOFSET));
    }' unless defined(&m68k_round_seg);
    eval 'sub m68k_trunc_seg {
        local($x) = @_;
	    eval q((($x) & ~ &SEGOFSET));
    }' unless defined(&m68k_trunc_seg);
    eval 'sub m68k_page_offset {
        local($x) = @_;
	    eval q((($x) &  &PGOFSET));
    }' unless defined(&m68k_page_offset);
    if(defined(&COMPAT_HPUX)) {
	eval 'sub HPMMMASK () {0xf0000000;}' unless defined(&HPMMMASK);
	eval 'sub ISHPMMADDR {
	    local($p, $v) = @_;
    	    eval q(((-> ($p_md->{md_flags}) &  &MDP_HPUXMMAP)  && ( &  &HPMMMASK)  && (($v) &  &HPMMMASK) !=  &HPMMMASK));
	}' unless defined(&ISHPMMADDR);
	eval 'sub HPMMBASEADDR {
	    local($v) = @_;
    	    eval q((($v) & ~ &HPMMMASK));
	}' unless defined(&HPMMBASEADDR);
    }
}
1;
