require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&ATU_CONFIG_NO)) {
    sub ATU_CONFIG_NO () {	1;}
}
unless(defined(&ATU_IFACE_IDX)) {
    sub ATU_IFACE_IDX () {	0;}
}
unless(defined(&ATU_RX_LIST_CNT)) {
    sub ATU_RX_LIST_CNT () {	1;}
}
unless(defined(&ATU_TX_LIST_CNT)) {
    sub ATU_TX_LIST_CNT () {	8;}
}
unless(defined(&ATU_RX_BUFSZ)) {
    sub ATU_RX_BUFSZ () {	( &ATU_RX_HDRLEN + $sizeof{'struct ieee80211_frame_addr4'} + 2312+ 4);}
}
unless(defined(&ATU_TX_BUFSZ)) {
    sub ATU_TX_BUFSZ () {	( &ATU_TX_HDRLEN + $sizeof{'struct ieee80211_frame_addr4'} + 2312);}
}
unless(defined(&ATU_MIN_FRAMELEN)) {
    sub ATU_MIN_FRAMELEN () {	60;}
}
unless(defined(&ATU_DEFAULT_MTU)) {
    sub ATU_DEFAULT_MTU () {	1500;}
}
unless(defined(&ATU_MAX_MTU)) {
    sub ATU_MAX_MTU () {	(2312- 2);}
}
unless(defined(&ATU_ENDPT_RX)) {
    sub ATU_ENDPT_RX () {	0x;}
}
unless(defined(&ATU_ENDPT_TX)) {
    sub ATU_ENDPT_TX () {	0x1;}
}
unless(defined(&ATU_ENDPT_MAX)) {
    sub ATU_ENDPT_MAX () {	0x2;}
}
unless(defined(&ATU_TX_TIMEOUT)) {
    sub ATU_TX_TIMEOUT () {	10000;}
}
unless(defined(&ATU_JOIN_TIMEOUT)) {
    sub ATU_JOIN_TIMEOUT () {	2000;}
}
unless(defined(&ATU_NO_QUIRK)) {
    sub ATU_NO_QUIRK () {	0x;}
}
unless(defined(&ATU_QUIRK_NO_REMAP)) {
    sub ATU_QUIRK_NO_REMAP () {	0x1;}
}
unless(defined(&ATU_QUIRK_FW_DELAY)) {
    sub ATU_QUIRK_FW_DELAY () {	0x2;}
}
unless(defined(&ATU_DEFAULT_SSID)) {
    sub ATU_DEFAULT_SSID () {	"";}
}
unless(defined(&ATU_DEFAULT_CHANNEL)) {
    sub ATU_DEFAULT_CHANNEL () {	10;}
}
eval("sub RadioRFMD () { 0; }") unless defined(&RadioRFMD);
eval("sub RadioRFMD2958 () { 1; }") unless defined(&RadioRFMD2958);
eval("sub RadioRFMD2958_SMC () { 2; }") unless defined(&RadioRFMD2958_SMC);
eval("sub RadioIntersil () { 3; }") unless defined(&RadioIntersil);
eval("sub AT76C503_i3863 () { 4; }") unless defined(&AT76C503_i3863);
eval("sub AT76C503_rfmd_acc () { 5; }") unless defined(&AT76C503_rfmd_acc);
eval("sub AT76C505_rfmd () { 6; }") unless defined(&AT76C505_rfmd);
unless(defined(&ATU_RX_RADIOTAP_PRESENT)) {
    sub ATU_RX_RADIOTAP_PRESENT () {	((1<<  &IEEE80211_RADIOTAP_TSFT) | (1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_RATE) | (1<<  &IEEE80211_RADIOTAP_CHANNEL) | (1<<  &IEEE80211_RADIOTAP_LOCK_QUALITY) | (1<<  &IEEE80211_RADIOTAP_DB_ANTSIGNAL) | 0);}
}
unless(defined(&ATU_TX_RADIOTAP_PRESENT)) {
    sub ATU_TX_RADIOTAP_PRESENT () {	((1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_RATE) | (1<<  &IEEE80211_RADIOTAP_CHANNEL) | 0);}
}
unless(defined(&MAX_SSID_LEN)) {
    sub MAX_SSID_LEN () {	32;}
}
unless(defined(&ATU_AVG_TIME)) {
    sub ATU_AVG_TIME () {	20;}
}
unless(defined(&ATU_S_DEAD)) {
    sub ATU_S_DEAD () {	0;}
}
unless(defined(&ATU_S_OK)) {
    sub ATU_S_OK () {	1;}
}
unless(defined(&ATU_S_UNCONFIG)) {
    sub ATU_S_UNCONFIG () {	2;}
}
unless(defined(&ATU_C_NONE)) {
    sub ATU_C_NONE () {	0;}
}
unless(defined(&ATU_C_SCAN)) {
    sub ATU_C_SCAN () {	1;}
}
unless(defined(&ATU_C_JOIN)) {
    sub ATU_C_JOIN () {	2;}
}
unless(defined(&NO_MODE_YET)) {
    sub NO_MODE_YET () {	0;}
}
unless(defined(&AD_HOC_MODE)) {
    sub AD_HOC_MODE () {	1;}
}
unless(defined(&INFRASTRUCTURE_MODE)) {
    sub INFRASTRUCTURE_MODE () {	2;}
}
unless(defined(&sc_rxtap)) {
    sub sc_rxtap () {	 ($sc_rxtapu->{tap});}
}
unless(defined(&sc_txtap)) {
    sub sc_txtap () {	 ($sc_txtapu->{tap});}
}
unless(defined(&DFU_DNLOAD)) {
    sub DFU_DNLOAD () {	 &UT_WRITE_CLASS_INTERFACE, 0x1;}
}
unless(defined(&DFU_GETSTATUS)) {
    sub DFU_GETSTATUS () {	 &UT_READ_CLASS_INTERFACE, 0x3;}
}
unless(defined(&DFU_GETSTATE)) {
    sub DFU_GETSTATE () {	 &UT_READ_CLASS_INTERFACE, 0x5;}
}
unless(defined(&DFU_REMAP)) {
    sub DFU_REMAP () {	 &UT_WRITE_VENDOR_INTERFACE, 0xa;}
}
unless(defined(&DFUState_AppIdle)) {
    sub DFUState_AppIdle () {	0;}
}
unless(defined(&DFUState_AppDetach)) {
    sub DFUState_AppDetach () {	1;}
}
unless(defined(&DFUState_DFUIdle)) {
    sub DFUState_DFUIdle () {	2;}
}
unless(defined(&DFUState_DnLoadSync)) {
    sub DFUState_DnLoadSync () {	3;}
}
unless(defined(&DFUState_DnLoadBusy)) {
    sub DFUState_DnLoadBusy () {	4;}
}
unless(defined(&DFUState_DnLoadIdle)) {
    sub DFUState_DnLoadIdle () {	5;}
}
unless(defined(&DFUState_ManifestSync)) {
    sub DFUState_ManifestSync () {	6;}
}
unless(defined(&DFUState_Manifest)) {
    sub DFUState_Manifest () {	7;}
}
unless(defined(&DFUState_ManifestWait)) {
    sub DFUState_ManifestWait () {	8;}
}
unless(defined(&DFUState_UploadIdle)) {
    sub DFUState_UploadIdle () {	9;}
}
unless(defined(&DFUState_DFUError)) {
    sub DFUState_DFUError () {	10;}
}
unless(defined(&DFU_MaxBlockSize)) {
    sub DFU_MaxBlockSize () {	1024;}
}
unless(defined(&MODE_NONE)) {
    sub MODE_NONE () {	0x;}
}
unless(defined(&MODE_NETCARD)) {
    sub MODE_NETCARD () {	0x1;}
}
unless(defined(&MODE_CONFIG)) {
    sub MODE_CONFIG () {	0x2;}
}
unless(defined(&MODE_DFU)) {
    sub MODE_DFU () {	0x3;}
}
unless(defined(&MODE_NOFLASHNETCARD)) {
    sub MODE_NOFLASHNETCARD () {	0x4;}
}
unless(defined(&CMD_SET_MIB)) {
    sub CMD_SET_MIB () {	0x1;}
}
unless(defined(&CMD_START_SCAN)) {
    sub CMD_START_SCAN () {	0x3;}
}
unless(defined(&CMD_JOIN)) {
    sub CMD_JOIN () {	0x4;}
}
unless(defined(&CMD_START_IBSS)) {
    sub CMD_START_IBSS () {	0x5;}
}
unless(defined(&CMD_RADIO)) {
    sub CMD_RADIO () {	0x6;}
}
unless(defined(&CMD_RADIO_ON)) {
    sub CMD_RADIO_ON () {	0x6;}
}
unless(defined(&CMD_RADIO_OFF)) {
    sub CMD_RADIO_OFF () {	0x7;}
}
unless(defined(&CMD_STARTUP)) {
    sub CMD_STARTUP () {	0xb;}
}
unless(defined(&STATUS_IDLE)) {
    sub STATUS_IDLE () {	0x;}
}
unless(defined(&STATUS_COMPLETE)) {
    sub STATUS_COMPLETE () {	0x1;}
}
unless(defined(&STATUS_UNKNOWN)) {
    sub STATUS_UNKNOWN () {	0x2;}
}
unless(defined(&STATUS_INVALID_PARAMETER)) {
    sub STATUS_INVALID_PARAMETER () {	0x3;}
}
unless(defined(&STATUS_FUNCTION_NOT_SUPPORTED)) {
    sub STATUS_FUNCTION_NOT_SUPPORTED () {	0x4;}
}
unless(defined(&STATUS_TIME_OUT)) {
    sub STATUS_TIME_OUT () {	0x7;}
}
unless(defined(&STATUS_IN_PROGRESS)) {
    sub STATUS_IN_PROGRESS () {	0x8;}
}
unless(defined(&STATUS_HOST_FAILURE)) {
    sub STATUS_HOST_FAILURE () {	0xff;}
}
unless(defined(&STATUS_SCAN_FAILED)) {
    sub STATUS_SCAN_FAILED () {	0xf0;}
}
unless(defined(&ATU_SCAN_ACTIVE)) {
    sub ATU_SCAN_ACTIVE () {	0x;}
}
unless(defined(&ATU_SCAN_PASSIVE)) {
    sub ATU_SCAN_PASSIVE () {	0x1;}
}
unless(defined(&ATU_RX_HDRLEN)) {
    sub ATU_RX_HDRLEN () {	$sizeof{'struct atu_rx_hdr'};}
}
unless(defined(&ATU_TX_HDRLEN)) {
    sub ATU_TX_HDRLEN () {	$sizeof{'struct atu_tx_hdr'};}
}
unless(defined(&NR)) {
    sub NR {
	local($x) = @_;
	eval q(( &void *)($x));
    }
}
unless(defined(&MIB_LOCAL)) {
    sub MIB_LOCAL () {	0x1;}
}
unless(defined(&MIB_LOCAL__BEACON_ENABLE)) {
    sub MIB_LOCAL__BEACON_ENABLE () {	 &MIB_LOCAL, 1, 2;}
}
unless(defined(&MIB_LOCAL__AUTO_RATE_FALLBACK)) {
    sub MIB_LOCAL__AUTO_RATE_FALLBACK () {	 &MIB_LOCAL, 1, 3;}
}
unless(defined(&MIB_LOCAL__SSID_SIZE)) {
    sub MIB_LOCAL__SSID_SIZE () {	 &MIB_LOCAL, 1, 5;}
}
unless(defined(&MIB_LOCAL__PREAMBLE)) {
    sub MIB_LOCAL__PREAMBLE () {	 &MIB_LOCAL, 1, 9;}
}
unless(defined(&MIB_MAC_ADDR)) {
    sub MIB_MAC_ADDR () {	0x2;}
}
unless(defined(&MIB_MAC_ADDR__ADDR)) {
    sub MIB_MAC_ADDR__ADDR () {	 &MIB_MAC_ADDR, 6, 0;}
}
unless(defined(&MIB_MAC)) {
    sub MIB_MAC () {	0x3;}
}
unless(defined(&MIB_MAC__FRAG)) {
    sub MIB_MAC__FRAG () {	 &MIB_MAC, 2, 8;}
}
unless(defined(&MIB_MAC__RTS)) {
    sub MIB_MAC__RTS () {	 &MIB_MAC, 2, 10;}
}
unless(defined(&MIB_MAC__DESIRED_SSID)) {
    sub MIB_MAC__DESIRED_SSID () {	 &MIB_MAC, 32, 28;}
}
unless(defined(&MIB_MAC_MGMT)) {
    sub MIB_MAC_MGMT () {	0x5;}
}
unless(defined(&MIB_MAC_MGMT__BEACON_PERIOD)) {
    sub MIB_MAC_MGMT__BEACON_PERIOD () {	 &MIB_MAC_MGMT, 2, 0;}
}
unless(defined(&MIB_MAC_MGMT__CURRENT_BSSID)) {
    sub MIB_MAC_MGMT__CURRENT_BSSID () {	 &MIB_MAC_MGMT, 6, 14;}
}
unless(defined(&MIB_MAC_MGMT__CURRENT_ESSID)) {
    sub MIB_MAC_MGMT__CURRENT_ESSID () {	 &MIB_MAC_MGMT, 32, 20;}
}
unless(defined(&MIB_MAC_MGMT__POWER_MODE)) {
    sub MIB_MAC_MGMT__POWER_MODE () {	 &MIB_MAC_MGMT, 1, 53;}
}
unless(defined(&MIB_MAC_MGMT__IBSS_CHANGE)) {
    sub MIB_MAC_MGMT__IBSS_CHANGE () {	 &MIB_MAC_MGMT, 1, 54;}
}
unless(defined(&MIB_MAC_WEP)) {
    sub MIB_MAC_WEP () {	0x6;}
}
unless(defined(&MIB_MAC_WEP__PRIVACY_INVOKED)) {
    sub MIB_MAC_WEP__PRIVACY_INVOKED () {	 &MIB_MAC_WEP, 1, 0;}
}
unless(defined(&MIB_MAC_WEP__KEY_ID)) {
    sub MIB_MAC_WEP__KEY_ID () {	 &MIB_MAC_WEP, 1, 1;}
}
unless(defined(&MIB_MAC_WEP__ICV_ERROR_COUNT)) {
    sub MIB_MAC_WEP__ICV_ERROR_COUNT () {	 &MIB_MAC_WEP, 4, 4;}
}
unless(defined(&MIB_MAC_WEP__EXCLUDED_COUNT)) {
    sub MIB_MAC_WEP__EXCLUDED_COUNT () {	 &MIB_MAC_WEP, 4, 8;}
}
unless(defined(&MIB_MAC_WEP__KEYS)) {
    sub MIB_MAC_WEP__KEYS {
	local($nr) = @_;
	eval q( &MIB_MAC_WEP, 13, 12+($nr)*13);
    }
}
unless(defined(&MIB_MAC_WEP__ENCR_LEVEL)) {
    sub MIB_MAC_WEP__ENCR_LEVEL () {	 &MIB_MAC_WEP, 1, 64;}
}
unless(defined(&MIB_PHY)) {
    sub MIB_PHY () {	0x7;}
}
unless(defined(&MIB_PHY__CHANNEL)) {
    sub MIB_PHY__CHANNEL () {	 &MIB_PHY, 1, 20;}
}
unless(defined(&MIB_PHY__REG_DOMAIN)) {
    sub MIB_PHY__REG_DOMAIN () {	 &MIB_PHY, 1, 23;}
}
unless(defined(&MIB_FW_VERSION)) {
    sub MIB_FW_VERSION () {	0x8;}
}
unless(defined(&MIB_DOMAIN)) {
    sub MIB_DOMAIN () {	0x9;}
}
unless(defined(&MIB_DOMAIN__POWER_LEVELS)) {
    sub MIB_DOMAIN__POWER_LEVELS () {	 &MIB_DOMAIN, 14, 0;}
}
unless(defined(&MIB_DOMAIN__CHANNELS)) {
    sub MIB_DOMAIN__CHANNELS () {	 &MIB_DOMAIN, 14, 14;}
}
unless(defined(&ATU_WEP_OFF)) {
    sub ATU_WEP_OFF () {	0;}
}
unless(defined(&ATU_WEP_40BITS)) {
    sub ATU_WEP_40BITS () {	1;}
}
unless(defined(&ATU_WEP_104BITS)) {
    sub ATU_WEP_104BITS () {	2;}
}
unless(defined(&POWER_MODE_ACTIVE)) {
    sub POWER_MODE_ACTIVE () {	1;}
}
unless(defined(&POWER_MODE_SAVE)) {
    sub POWER_MODE_SAVE () {	2;}
}
unless(defined(&POWER_MODE_SMART)) {
    sub POWER_MODE_SMART () {	3;}
}
unless(defined(&PREAMBLE_SHORT)) {
    sub PREAMBLE_SHORT () {	1;}
}
unless(defined(&PREAMBLE_LONG)) {
    sub PREAMBLE_LONG () {	0;}
}
1;
