require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_POWERPC_CPU_H_)) {
    eval 'sub _POWERPC_CPU_H_ () {1;}' unless defined(&_POWERPC_CPU_H_);
    require 'machine/frame.ph';
    require 'machine/psl.ph';
    eval 'sub CLKF_USERMODE {
        local($frame) = @_;
	    eval q(((($frame)-> &srr1 &  &PSL_PR) != 0));
    }' unless defined(&CLKF_USERMODE);
    eval 'sub CLKF_PC {
        local($frame) = @_;
	    eval q((($frame)-> &srr0));
    }' unless defined(&CLKF_PC);
    eval 'sub CLKF_INTR {
        local($frame) = @_;
	    eval q((($frame)-> &depth != 0));
    }' unless defined(&CLKF_INTR);
    eval 'sub cpu_swapout {
        local($p) = @_;
	    eval q();
    }' unless defined(&cpu_swapout);
    eval 'sub cpu_wait {
        local($p) = @_;
	    eval q();
    }' unless defined(&cpu_wait);
    eval 'sub DELAY {
        local($n) = @_;
	    eval q( &delay($n));
    }' unless defined(&DELAY);
    eval 'sub need_resched {
        local($ci) = @_;
	    eval q(( &want_resched = 1,  &astpending = 1));
    }' unless defined(&need_resched);
    eval 'sub need_proftick {
        local($p) = @_;
	    eval q((($p)-> &p_flag |=  &P_OWEUPC,  &astpending = 1));
    }' unless defined(&need_proftick);
    eval 'sub signotify {
        local($p) = @_;
	    eval q(( &astpending = 1));
    }' unless defined(&signotify);
    unless(defined(&CACHELINESIZE)) {
	eval 'sub CACHELINESIZE () {32;}' unless defined(&CACHELINESIZE);
    }
    eval 'sub syncicache {
        local($from,$len) = @_;
	    eval q({ \'int\'  &l; \'char\' * &p = $from; $len = $len + ((( &u_int32_t) $from) & ( &CACHELINESIZE - 1));  &l = $len;  &do {  &__asm  &__volatile (\\"dcbst 0,%0\\" :: \\"r\\"( &p));  &p +=  &CACHELINESIZE; }  &while (( &l -=  &CACHELINESIZE) > 0);  &__asm  &__volatile (\\"sync\\");  &p = $from;  &l = $len;  &do {  &__asm  &__volatile (\\"icbi 0,%0\\" :: \\"r\\"( &p));  &p +=  &CACHELINESIZE; }  &while (( &l -=  &CACHELINESIZE) > 0);  &__asm  &__volatile (\\"isync\\"); });
    }' unless defined(&syncicache);
    eval 'sub invdcache {
        local($from,$len) = @_;
	    eval q({ \'int\'  &l; \'char\' * &p = $from; $len = $len + ((( &u_int32_t) $from) & ( &CACHELINESIZE - 1));  &l = $len;  &do {  &__asm  &__volatile (\\"dcbi 0,%0\\" :: \\"r\\"( &p));  &p +=  &CACHELINESIZE; }  &while (( &l -=  &CACHELINESIZE) > 0);  &__asm  &__volatile (\\"sync\\"); });
    }' unless defined(&invdcache);
    eval 'sub FUNC_SPR {
        local($n, $name) = @_;
	    eval q( &static  &__inline  &u_int32_t  &ppc_mf  $name ( &void) {  &u_int32_t  &ret;  &__asm  &__volatile (\\"mfspr %0,\\"  $n : \\"=r\\" ( &ret));  &return  &ret; }  &static  &__inline  &void  &ppc_mt  $name ( &u_int32_t  &val) {  &__asm  &__volatile (\\"mtspr \\" $n \\",%0\\" :: \\"r\\" ( &val)); });
    }' unless defined(&FUNC_SPR);
    eval 'sub ppc_mftbl {
        local($void) = @_;
	    eval q({ \'int\'  &ret;  &__asm  &__volatile (\\"mftb %0\\" : \\"=r\\" ( &ret));  &ret; });
    }' unless defined(&ppc_mftbl);
    eval 'sub ppc_mftb {
        local($void) = @_;
	    eval q({ my $scratch;  &u_int64_t  &tb;  &__asm  &__volatile (\\"1: mftbu %0; mftb %0+1; mftbu %1;\\" \\" cmpw 0,%0,%1; bne 1b\\" : \\"=r\\"( &tb), \\"=r\\"( $scratch));  &tb; });
    }' unless defined(&ppc_mftb);
    eval 'sub ppc_mfmsr {
        local($void) = @_;
	    eval q({ \'int\'  &ret;  &__asm  &__volatile (\\"mfmsr %0\\" : \\"=r\\" ( &ret));  &ret; });
    }' unless defined(&ppc_mfmsr);
    eval 'sub ppc_mtmsr {
        local($val) = @_;
	    eval q({  &__asm  &__volatile (\\"mtmsr %0\\" :: \\"r\\" ($val)); });
    }' unless defined(&ppc_mtmsr);
    eval 'sub ppc_mtsrin {
        local($val,$sn_shifted) = @_;
	    eval q({  &__asm  &__volatile (\\"mtsrin %0,%1\\" :: \\"r\\"($val), \\"r\\"($sn_shifted)); });
    }' unless defined(&ppc_mtsrin);
    eval 'sub ppc_intr_disable {
        local($void) = @_;
	    eval q({  &u_int32_t  &emsr,  &dmsr;  &emsr =  &ppc_mfmsr();  &dmsr =  &emsr & ~ &PSL_EE;  &ppc_mtmsr( &dmsr); ( &emsr &  &PSL_EE); });
    }' unless defined(&ppc_intr_disable);
    eval 'sub PPC_CPU_MPC601 () {1;}' unless defined(&PPC_CPU_MPC601);
    eval 'sub PPC_CPU_MPC603 () {3;}' unless defined(&PPC_CPU_MPC603);
    eval 'sub PPC_CPU_MPC604 () {4;}' unless defined(&PPC_CPU_MPC604);
    eval 'sub PPC_CPU_MPC603e () {6;}' unless defined(&PPC_CPU_MPC603e);
    eval 'sub PPC_CPU_MPC603ev () {7;}' unless defined(&PPC_CPU_MPC603ev);
    eval 'sub PPC_CPU_MPC750 () {8;}' unless defined(&PPC_CPU_MPC750);
    eval 'sub PPC_CPU_MPC604ev () {9;}' unless defined(&PPC_CPU_MPC604ev);
    eval 'sub PPC_CPU_MPC7400 () {12;}' unless defined(&PPC_CPU_MPC7400);
    eval 'sub PPC_CPU_IBM970FX () {0x3c;}' unless defined(&PPC_CPU_IBM970FX);
    eval 'sub PPC_CPU_IBM970MP () {0x44;}' unless defined(&PPC_CPU_IBM970MP);
    eval 'sub PPC_CPU_IBM750FX () {0x7000;}' unless defined(&PPC_CPU_IBM750FX);
    eval 'sub PPC_CPU_MPC7410 () {0x800c;}' unless defined(&PPC_CPU_MPC7410);
    eval 'sub PPC_CPU_MPC7447A () {0x8003;}' unless defined(&PPC_CPU_MPC7447A);
    eval 'sub PPC_CPU_MPC7448 () {0x8004;}' unless defined(&PPC_CPU_MPC7448);
    eval 'sub PPC_CPU_MPC7450 () {0x8000;}' unless defined(&PPC_CPU_MPC7450);
    eval 'sub PPC_CPU_MPC7455 () {0x8001;}' unless defined(&PPC_CPU_MPC7455);
    eval 'sub PPC_CPU_MPC7457 () {0x8002;}' unless defined(&PPC_CPU_MPC7457);
}
1;
