require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&HEADER_SAFESTACK_H)) {
    eval 'sub HEADER_SAFESTACK_H () {1;}' unless defined(&HEADER_SAFESTACK_H);
    require 'openssl/stack.ph';
    if(defined(&DEBUG_SAFESTACK)) {
	eval 'sub STACK_OF {
	    local($type) = @_;
    	    eval q(\'struct stack_st_\'$type);
	}' unless defined(&STACK_OF);
	eval 'sub PREDECLARE_STACK_OF {
	    local($type) = @_;
    	    eval q( &STACK_OF($type););
	}' unless defined(&PREDECLARE_STACK_OF);
	eval 'sub DECLARE_STACK_OF {
	    local($type) = @_;
    	    eval q( &STACK_OF($type) {  &STACK  &stack; };);
	}' unless defined(&DECLARE_STACK_OF);
	eval 'sub IMPLEMENT_STACK_OF {
	    local($type) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_STACK_OF);
	eval 'sub SKM_sk_new {
	    local($type, $cmp) = @_;
    	    eval q((( &STACK_OF($type) * (*)( &int (*)( &const $type *  &const *,  &const $type *  &const *))) &sk_new)($cmp));
	}' unless defined(&SKM_sk_new);
	eval 'sub SKM_sk_new_null {
	    local($type) = @_;
    	    eval q((( &STACK_OF($type) * (*)( &void)) &sk_new_null)());
	}' unless defined(&SKM_sk_new_null);
	eval 'sub SKM_sk_free {
	    local($type, $st) = @_;
    	    eval q((( &void (*)( &STACK_OF($type) *)) &sk_free)($st));
	}' unless defined(&SKM_sk_free);
	eval 'sub SKM_sk_num {
	    local($type, $st) = @_;
    	    eval q((( &int (*)( &const  &STACK_OF($type) *)) &sk_num)($st));
	}' unless defined(&SKM_sk_num);
	eval 'sub SKM_sk_value {
	    local($type, $st,$i) = @_;
    	    eval q((($type * (*)( &const  &STACK_OF($type) *, \'int\')) &sk_value)($st, $i));
	}' unless defined(&SKM_sk_value);
	eval 'sub SKM_sk_set {
	    local($type, $st,$i,$val) = @_;
    	    eval q((($type * (*)( &STACK_OF($type) *, \'int\', $type *)) &sk_set)($st, $i, $val));
	}' unless defined(&SKM_sk_set);
	eval 'sub SKM_sk_zero {
	    local($type, $st) = @_;
    	    eval q((( &void (*)( &STACK_OF($type) *)) &sk_zero)($st));
	}' unless defined(&SKM_sk_zero);
	eval 'sub SKM_sk_push {
	    local($type, $st,$val) = @_;
    	    eval q((( &int (*)( &STACK_OF($type) *, $type *)) &sk_push)($st, $val));
	}' unless defined(&SKM_sk_push);
	eval 'sub SKM_sk_unshift {
	    local($type, $st,$val) = @_;
    	    eval q((( &int (*)( &STACK_OF($type) *, $type *)) &sk_unshift)($st, $val));
	}' unless defined(&SKM_sk_unshift);
	eval 'sub SKM_sk_find {
	    local($type, $st,$val) = @_;
    	    eval q((( &int (*)( &STACK_OF($type) *, $type *)) &sk_find)($st, $val));
	}' unless defined(&SKM_sk_find);
	eval 'sub SKM_sk_delete {
	    local($type, $st,$i) = @_;
    	    eval q((($type * (*)( &STACK_OF($type) *, \'int\')) &sk_delete)($st, $i));
	}' unless defined(&SKM_sk_delete);
	eval 'sub SKM_sk_delete_ptr {
	    local($type, $st,$ptr) = @_;
    	    eval q((($type * (*)( &STACK_OF($type) *, $type *)) &sk_delete_ptr)($st, $ptr));
	}' unless defined(&SKM_sk_delete_ptr);
	eval 'sub SKM_sk_insert {
	    local($type, $st,$val,$i) = @_;
    	    eval q((( &int (*)( &STACK_OF($type) *, $type *, \'int\')) &sk_insert)($st, $val, $i));
	}' unless defined(&SKM_sk_insert);
	eval 'sub SKM_sk_set_cmp_func {
	    local($type, $st,$cmp) = @_;
    	    eval q((( &int (*(*)( &STACK_OF($type) *,  &int (*)( &const $type *  &const *,  &const $type *  &const *))) ( &const $type *  &const *,  &const $type *  &const *)) &sk_set_cmp_func) ($st, $cmp));
	}' unless defined(&SKM_sk_set_cmp_func);
	eval 'sub SKM_sk_dup {
	    local($type, $st) = @_;
    	    eval q((( &STACK_OF($type) *(*)( &STACK_OF($type) *)) &sk_dup)($st));
	}' unless defined(&SKM_sk_dup);
	eval 'sub SKM_sk_pop_free {
	    local($type, $st,$free_func) = @_;
    	    eval q((( &void (*)( &STACK_OF($type) *,  &void (*)($type *))) &sk_pop_free) ($st, $free_func));
	}' unless defined(&SKM_sk_pop_free);
	eval 'sub SKM_sk_shift {
	    local($type, $st) = @_;
    	    eval q((($type * (*)( &STACK_OF($type) *)) &sk_shift)($st));
	}' unless defined(&SKM_sk_shift);
	eval 'sub SKM_sk_pop {
	    local($type, $st) = @_;
    	    eval q((($type * (*)( &STACK_OF($type) *)) &sk_pop)($st));
	}' unless defined(&SKM_sk_pop);
	eval 'sub SKM_sk_sort {
	    local($type, $st) = @_;
    	    eval q((( &void (*)( &STACK_OF($type) *)) &sk_sort)($st));
	}' unless defined(&SKM_sk_sort);
	eval 'sub SKM_sk_is_sorted {
	    local($type, $st) = @_;
    	    eval q((( &int (*)( &const  &STACK_OF($type) *)) &sk_is_sorted)($st));
	}' unless defined(&SKM_sk_is_sorted);
	eval 'sub SKM_ASN1_SET_OF_d2i {
	    local($type, $st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
    	    eval q((( &STACK_OF($type) * (*) ( &STACK_OF($type) **,\'unsigned char\' **, \'long\' , $type *(*)($type **, \'unsigned char\' **,\'long\'),  &void (*)($type *), \'int\' ,\'int\' ))  &d2i_ASN1_SET) ($st,$pp,$length, $d2i_func, $free_func, $ex_tag,$ex_class));
	}' unless defined(&SKM_ASN1_SET_OF_d2i);
	eval 'sub SKM_ASN1_SET_OF_i2d {
	    local($type, $st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
    	    eval q((( &int (*)( &STACK_OF($type) *,\'unsigned char\' **,  &int (*)($type *,\'unsigned char\' **), \'int\' , \'int\' , \'int\'))  &i2d_ASN1_SET) ($st,$pp,$i2d_func,$ex_tag,$ex_class,$is_set));
	}' unless defined(&SKM_ASN1_SET_OF_i2d);
	eval 'sub SKM_ASN1_seq_pack {
	    local($type, $st, $i2d_func, $buf, $len) = @_;
    	    eval q(((\'unsigned char\' *(*)( &STACK_OF($type) *,  &int (*)($type *,\'unsigned char\' **), \'unsigned char\' **,\'int\' *))  &ASN1_seq_pack) ($st, $i2d_func, $buf, $len));
	}' unless defined(&SKM_ASN1_seq_pack);
	eval 'sub SKM_ASN1_seq_unpack {
	    local($type, $buf, $len, $d2i_func, $free_func) = @_;
    	    eval q((( &STACK_OF($type) * (*)(\'unsigned char\' *,\'int\', $type *(*)($type **,\'unsigned char\' **, \'long\'),  &void (*)($type *))) &ASN1_seq_unpack) ($buf,$len,$d2i_func, $free_func));
	}' unless defined(&SKM_ASN1_seq_unpack);
	eval 'sub SKM_PKCS12_decrypt_d2i {
	    local($type, $algor, $d2i_func, $free_func, $pass, $passlen, $oct, $seq) = @_;
    	    eval q((( &STACK_OF($type) * (*)( &X509_ALGOR *, $type *(*)($type **, \'unsigned char\' **, \'long\'),  &void (*)($type *),  &const \'char\' *, \'int\',  &ASN1_STRING *, \'int\')) &PKCS12_decrypt_d2i) ($algor,$d2i_func,$free_func,$pass,$passlen,$oct,$seq));
	}' unless defined(&SKM_PKCS12_decrypt_d2i);
    } else {
	eval 'sub STACK_OF {
	    local($type) = @_;
    	    eval q( &STACK);
	}' unless defined(&STACK_OF);
	eval 'sub PREDECLARE_STACK_OF {
	    local($type) = @_;
    	    eval q();
	}' unless defined(&PREDECLARE_STACK_OF);
	eval 'sub DECLARE_STACK_OF {
	    local($type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_STACK_OF);
	eval 'sub IMPLEMENT_STACK_OF {
	    local($type) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_STACK_OF);
	eval 'sub SKM_sk_new {
	    local($type, $cmp) = @_;
    	    eval q( &sk_new(( &int (*)( &const \'char\' *  &const *,  &const \'char\' *  &const *))($cmp)));
	}' unless defined(&SKM_sk_new);
	eval 'sub SKM_sk_new_null {
	    local($type) = @_;
    	    eval q( &sk_new_null());
	}' unless defined(&SKM_sk_new_null);
	eval 'sub SKM_sk_free {
	    local($type, $st) = @_;
    	    eval q( &sk_free($st));
	}' unless defined(&SKM_sk_free);
	eval 'sub SKM_sk_num {
	    local($type, $st) = @_;
    	    eval q( &sk_num($st));
	}' unless defined(&SKM_sk_num);
	eval 'sub SKM_sk_value {
	    local($type, $st,$i) = @_;
    	    eval q((($type *) &sk_value($st, $i)));
	}' unless defined(&SKM_sk_value);
	eval 'sub SKM_sk_set {
	    local($type, $st,$i,$val) = @_;
    	    eval q((($type *) &sk_set($st, $i,$val)));
	}' unless defined(&SKM_sk_set);
	eval 'sub SKM_sk_zero {
	    local($type, $st) = @_;
    	    eval q( &sk_zero($st));
	}' unless defined(&SKM_sk_zero);
	eval 'sub SKM_sk_push {
	    local($type, $st,$val) = @_;
    	    eval q( &sk_push($st, $val));
	}' unless defined(&SKM_sk_push);
	eval 'sub SKM_sk_unshift {
	    local($type, $st,$val) = @_;
    	    eval q( &sk_unshift($st, $val));
	}' unless defined(&SKM_sk_unshift);
	eval 'sub SKM_sk_find {
	    local($type, $st,$val) = @_;
    	    eval q( &sk_find($st, $val));
	}' unless defined(&SKM_sk_find);
	eval 'sub SKM_sk_delete {
	    local($type, $st,$i) = @_;
    	    eval q((($type *) &sk_delete($st, $i)));
	}' unless defined(&SKM_sk_delete);
	eval 'sub SKM_sk_delete_ptr {
	    local($type, $st,$ptr) = @_;
    	    eval q((($type *) &sk_delete_ptr($st,$ptr)));
	}' unless defined(&SKM_sk_delete_ptr);
	eval 'sub SKM_sk_insert {
	    local($type, $st,$val,$i) = @_;
    	    eval q( &sk_insert($st, $val, $i));
	}' unless defined(&SKM_sk_insert);
	eval 'sub SKM_sk_set_cmp_func {
	    local($type, $st,$cmp) = @_;
    	    eval q((( &int (*)( &const $type *  &const *, &const $type *  &const *))  &sk_set_cmp_func($st, ( &int (*)( &const \'char\' *  &const *,  &const \'char\' *  &const *))($cmp))));
	}' unless defined(&SKM_sk_set_cmp_func);
	eval 'sub SKM_sk_dup {
	    local($type, $st) = @_;
    	    eval q( &sk_dup($st));
	}' unless defined(&SKM_sk_dup);
	eval 'sub SKM_sk_pop_free {
	    local($type, $st,$free_func) = @_;
    	    eval q( &sk_pop_free($st, ( &void (*)( &void *))$free_func));
	}' unless defined(&SKM_sk_pop_free);
	eval 'sub SKM_sk_shift {
	    local($type, $st) = @_;
    	    eval q((($type *) &sk_shift($st)));
	}' unless defined(&SKM_sk_shift);
	eval 'sub SKM_sk_pop {
	    local($type, $st) = @_;
    	    eval q((($type *) &sk_pop($st)));
	}' unless defined(&SKM_sk_pop);
	eval 'sub SKM_sk_sort {
	    local($type, $st) = @_;
    	    eval q( &sk_sort($st));
	}' unless defined(&SKM_sk_sort);
	eval 'sub SKM_sk_is_sorted {
	    local($type, $st) = @_;
    	    eval q( &sk_is_sorted($st));
	}' unless defined(&SKM_sk_is_sorted);
	eval 'sub SKM_ASN1_SET_OF_d2i {
	    local($type, $st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
    	    eval q( &d2i_ASN1_SET($st,$pp,$length, (\'char\' *(*)())$d2i_func, ( &void (*)( &void *))$free_func, $ex_tag,$ex_class));
	}' unless defined(&SKM_ASN1_SET_OF_d2i);
	eval 'sub SKM_ASN1_SET_OF_i2d {
	    local($type, $st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
    	    eval q( &i2d_ASN1_SET($st,$pp,$i2d_func,$ex_tag,$ex_class,$is_set));
	}' unless defined(&SKM_ASN1_SET_OF_i2d);
	eval 'sub SKM_ASN1_seq_pack {
	    local($type, $st, $i2d_func, $buf, $len) = @_;
    	    eval q( &ASN1_seq_pack($st, $i2d_func, $buf, $len));
	}' unless defined(&SKM_ASN1_seq_pack);
	eval 'sub SKM_ASN1_seq_unpack {
	    local($type, $buf, $len, $d2i_func, $free_func) = @_;
    	    eval q( &ASN1_seq_unpack($buf,$len,(\'char\' *(*)())$d2i_func, ( &void(*)( &void *))$free_func));
	}' unless defined(&SKM_ASN1_seq_unpack);
	eval 'sub SKM_PKCS12_decrypt_d2i {
	    local($type, $algor, $d2i_func, $free_func, $pass, $passlen, $oct, $seq) = @_;
    	    eval q((( &STACK *) &PKCS12_decrypt_d2i($algor,(\'char\' *(*)())$d2i_func, ( &void(*)( &void *))$free_func,$pass,$passlen,$oct,$seq)));
	}' unless defined(&SKM_PKCS12_decrypt_d2i);
    }
    eval 'sub sk_ACCESS_DESCRIPTION_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &ACCESS_DESCRIPTION, ($st)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_new);
    eval 'sub sk_ACCESS_DESCRIPTION_new_null () {
        eval q( &SKM_sk_new_null( &ACCESS_DESCRIPTION));
    }' unless defined(&sk_ACCESS_DESCRIPTION_new_null);
    eval 'sub sk_ACCESS_DESCRIPTION_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &ACCESS_DESCRIPTION, ($st)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_free);
    eval 'sub sk_ACCESS_DESCRIPTION_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &ACCESS_DESCRIPTION, ($st)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_num);
    eval 'sub sk_ACCESS_DESCRIPTION_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &ACCESS_DESCRIPTION, ($st), ($i)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_value);
    eval 'sub sk_ACCESS_DESCRIPTION_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &ACCESS_DESCRIPTION, ($st), ($i), ($val)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_set);
    eval 'sub sk_ACCESS_DESCRIPTION_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &ACCESS_DESCRIPTION, ($st)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_zero);
    eval 'sub sk_ACCESS_DESCRIPTION_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &ACCESS_DESCRIPTION, ($st), ($val)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_push);
    eval 'sub sk_ACCESS_DESCRIPTION_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &ACCESS_DESCRIPTION, ($st), ($val)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_unshift);
    eval 'sub sk_ACCESS_DESCRIPTION_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &ACCESS_DESCRIPTION, ($st), ($val)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_find);
    eval 'sub sk_ACCESS_DESCRIPTION_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &ACCESS_DESCRIPTION, ($st), ($i)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_delete);
    eval 'sub sk_ACCESS_DESCRIPTION_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &ACCESS_DESCRIPTION, ($st), ($ptr)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_delete_ptr);
    eval 'sub sk_ACCESS_DESCRIPTION_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &ACCESS_DESCRIPTION, ($st), ($val), ($i)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_insert);
    eval 'sub sk_ACCESS_DESCRIPTION_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &ACCESS_DESCRIPTION, ($st), ($cmp)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_set_cmp_func);
    eval 'sub sk_ACCESS_DESCRIPTION_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &ACCESS_DESCRIPTION, $st));
    }' unless defined(&sk_ACCESS_DESCRIPTION_dup);
    eval 'sub sk_ACCESS_DESCRIPTION_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &ACCESS_DESCRIPTION, ($st), ($free_func)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_pop_free);
    eval 'sub sk_ACCESS_DESCRIPTION_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &ACCESS_DESCRIPTION, ($st)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_shift);
    eval 'sub sk_ACCESS_DESCRIPTION_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &ACCESS_DESCRIPTION, ($st)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_pop);
    eval 'sub sk_ACCESS_DESCRIPTION_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &ACCESS_DESCRIPTION, ($st)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_sort);
    eval 'sub sk_ACCESS_DESCRIPTION_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &ACCESS_DESCRIPTION, ($st)));
    }' unless defined(&sk_ACCESS_DESCRIPTION_is_sorted);
    eval 'sub sk_ASN1_GENERALSTRING_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &ASN1_GENERALSTRING, ($st)));
    }' unless defined(&sk_ASN1_GENERALSTRING_new);
    eval 'sub sk_ASN1_GENERALSTRING_new_null () {
        eval q( &SKM_sk_new_null( &ASN1_GENERALSTRING));
    }' unless defined(&sk_ASN1_GENERALSTRING_new_null);
    eval 'sub sk_ASN1_GENERALSTRING_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &ASN1_GENERALSTRING, ($st)));
    }' unless defined(&sk_ASN1_GENERALSTRING_free);
    eval 'sub sk_ASN1_GENERALSTRING_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &ASN1_GENERALSTRING, ($st)));
    }' unless defined(&sk_ASN1_GENERALSTRING_num);
    eval 'sub sk_ASN1_GENERALSTRING_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &ASN1_GENERALSTRING, ($st), ($i)));
    }' unless defined(&sk_ASN1_GENERALSTRING_value);
    eval 'sub sk_ASN1_GENERALSTRING_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &ASN1_GENERALSTRING, ($st), ($i), ($val)));
    }' unless defined(&sk_ASN1_GENERALSTRING_set);
    eval 'sub sk_ASN1_GENERALSTRING_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &ASN1_GENERALSTRING, ($st)));
    }' unless defined(&sk_ASN1_GENERALSTRING_zero);
    eval 'sub sk_ASN1_GENERALSTRING_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &ASN1_GENERALSTRING, ($st), ($val)));
    }' unless defined(&sk_ASN1_GENERALSTRING_push);
    eval 'sub sk_ASN1_GENERALSTRING_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &ASN1_GENERALSTRING, ($st), ($val)));
    }' unless defined(&sk_ASN1_GENERALSTRING_unshift);
    eval 'sub sk_ASN1_GENERALSTRING_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &ASN1_GENERALSTRING, ($st), ($val)));
    }' unless defined(&sk_ASN1_GENERALSTRING_find);
    eval 'sub sk_ASN1_GENERALSTRING_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &ASN1_GENERALSTRING, ($st), ($i)));
    }' unless defined(&sk_ASN1_GENERALSTRING_delete);
    eval 'sub sk_ASN1_GENERALSTRING_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &ASN1_GENERALSTRING, ($st), ($ptr)));
    }' unless defined(&sk_ASN1_GENERALSTRING_delete_ptr);
    eval 'sub sk_ASN1_GENERALSTRING_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &ASN1_GENERALSTRING, ($st), ($val), ($i)));
    }' unless defined(&sk_ASN1_GENERALSTRING_insert);
    eval 'sub sk_ASN1_GENERALSTRING_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &ASN1_GENERALSTRING, ($st), ($cmp)));
    }' unless defined(&sk_ASN1_GENERALSTRING_set_cmp_func);
    eval 'sub sk_ASN1_GENERALSTRING_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &ASN1_GENERALSTRING, $st));
    }' unless defined(&sk_ASN1_GENERALSTRING_dup);
    eval 'sub sk_ASN1_GENERALSTRING_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &ASN1_GENERALSTRING, ($st), ($free_func)));
    }' unless defined(&sk_ASN1_GENERALSTRING_pop_free);
    eval 'sub sk_ASN1_GENERALSTRING_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &ASN1_GENERALSTRING, ($st)));
    }' unless defined(&sk_ASN1_GENERALSTRING_shift);
    eval 'sub sk_ASN1_GENERALSTRING_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &ASN1_GENERALSTRING, ($st)));
    }' unless defined(&sk_ASN1_GENERALSTRING_pop);
    eval 'sub sk_ASN1_GENERALSTRING_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &ASN1_GENERALSTRING, ($st)));
    }' unless defined(&sk_ASN1_GENERALSTRING_sort);
    eval 'sub sk_ASN1_GENERALSTRING_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &ASN1_GENERALSTRING, ($st)));
    }' unless defined(&sk_ASN1_GENERALSTRING_is_sorted);
    eval 'sub sk_ASN1_INTEGER_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &ASN1_INTEGER, ($st)));
    }' unless defined(&sk_ASN1_INTEGER_new);
    eval 'sub sk_ASN1_INTEGER_new_null () {
        eval q( &SKM_sk_new_null( &ASN1_INTEGER));
    }' unless defined(&sk_ASN1_INTEGER_new_null);
    eval 'sub sk_ASN1_INTEGER_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &ASN1_INTEGER, ($st)));
    }' unless defined(&sk_ASN1_INTEGER_free);
    eval 'sub sk_ASN1_INTEGER_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &ASN1_INTEGER, ($st)));
    }' unless defined(&sk_ASN1_INTEGER_num);
    eval 'sub sk_ASN1_INTEGER_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &ASN1_INTEGER, ($st), ($i)));
    }' unless defined(&sk_ASN1_INTEGER_value);
    eval 'sub sk_ASN1_INTEGER_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &ASN1_INTEGER, ($st), ($i), ($val)));
    }' unless defined(&sk_ASN1_INTEGER_set);
    eval 'sub sk_ASN1_INTEGER_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &ASN1_INTEGER, ($st)));
    }' unless defined(&sk_ASN1_INTEGER_zero);
    eval 'sub sk_ASN1_INTEGER_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &ASN1_INTEGER, ($st), ($val)));
    }' unless defined(&sk_ASN1_INTEGER_push);
    eval 'sub sk_ASN1_INTEGER_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &ASN1_INTEGER, ($st), ($val)));
    }' unless defined(&sk_ASN1_INTEGER_unshift);
    eval 'sub sk_ASN1_INTEGER_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &ASN1_INTEGER, ($st), ($val)));
    }' unless defined(&sk_ASN1_INTEGER_find);
    eval 'sub sk_ASN1_INTEGER_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &ASN1_INTEGER, ($st), ($i)));
    }' unless defined(&sk_ASN1_INTEGER_delete);
    eval 'sub sk_ASN1_INTEGER_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &ASN1_INTEGER, ($st), ($ptr)));
    }' unless defined(&sk_ASN1_INTEGER_delete_ptr);
    eval 'sub sk_ASN1_INTEGER_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &ASN1_INTEGER, ($st), ($val), ($i)));
    }' unless defined(&sk_ASN1_INTEGER_insert);
    eval 'sub sk_ASN1_INTEGER_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &ASN1_INTEGER, ($st), ($cmp)));
    }' unless defined(&sk_ASN1_INTEGER_set_cmp_func);
    eval 'sub sk_ASN1_INTEGER_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &ASN1_INTEGER, $st));
    }' unless defined(&sk_ASN1_INTEGER_dup);
    eval 'sub sk_ASN1_INTEGER_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &ASN1_INTEGER, ($st), ($free_func)));
    }' unless defined(&sk_ASN1_INTEGER_pop_free);
    eval 'sub sk_ASN1_INTEGER_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &ASN1_INTEGER, ($st)));
    }' unless defined(&sk_ASN1_INTEGER_shift);
    eval 'sub sk_ASN1_INTEGER_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &ASN1_INTEGER, ($st)));
    }' unless defined(&sk_ASN1_INTEGER_pop);
    eval 'sub sk_ASN1_INTEGER_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &ASN1_INTEGER, ($st)));
    }' unless defined(&sk_ASN1_INTEGER_sort);
    eval 'sub sk_ASN1_INTEGER_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &ASN1_INTEGER, ($st)));
    }' unless defined(&sk_ASN1_INTEGER_is_sorted);
    eval 'sub sk_ASN1_OBJECT_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &ASN1_OBJECT, ($st)));
    }' unless defined(&sk_ASN1_OBJECT_new);
    eval 'sub sk_ASN1_OBJECT_new_null () {
        eval q( &SKM_sk_new_null( &ASN1_OBJECT));
    }' unless defined(&sk_ASN1_OBJECT_new_null);
    eval 'sub sk_ASN1_OBJECT_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &ASN1_OBJECT, ($st)));
    }' unless defined(&sk_ASN1_OBJECT_free);
    eval 'sub sk_ASN1_OBJECT_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &ASN1_OBJECT, ($st)));
    }' unless defined(&sk_ASN1_OBJECT_num);
    eval 'sub sk_ASN1_OBJECT_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &ASN1_OBJECT, ($st), ($i)));
    }' unless defined(&sk_ASN1_OBJECT_value);
    eval 'sub sk_ASN1_OBJECT_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &ASN1_OBJECT, ($st), ($i), ($val)));
    }' unless defined(&sk_ASN1_OBJECT_set);
    eval 'sub sk_ASN1_OBJECT_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &ASN1_OBJECT, ($st)));
    }' unless defined(&sk_ASN1_OBJECT_zero);
    eval 'sub sk_ASN1_OBJECT_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &ASN1_OBJECT, ($st), ($val)));
    }' unless defined(&sk_ASN1_OBJECT_push);
    eval 'sub sk_ASN1_OBJECT_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &ASN1_OBJECT, ($st), ($val)));
    }' unless defined(&sk_ASN1_OBJECT_unshift);
    eval 'sub sk_ASN1_OBJECT_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &ASN1_OBJECT, ($st), ($val)));
    }' unless defined(&sk_ASN1_OBJECT_find);
    eval 'sub sk_ASN1_OBJECT_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &ASN1_OBJECT, ($st), ($i)));
    }' unless defined(&sk_ASN1_OBJECT_delete);
    eval 'sub sk_ASN1_OBJECT_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &ASN1_OBJECT, ($st), ($ptr)));
    }' unless defined(&sk_ASN1_OBJECT_delete_ptr);
    eval 'sub sk_ASN1_OBJECT_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &ASN1_OBJECT, ($st), ($val), ($i)));
    }' unless defined(&sk_ASN1_OBJECT_insert);
    eval 'sub sk_ASN1_OBJECT_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &ASN1_OBJECT, ($st), ($cmp)));
    }' unless defined(&sk_ASN1_OBJECT_set_cmp_func);
    eval 'sub sk_ASN1_OBJECT_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &ASN1_OBJECT, $st));
    }' unless defined(&sk_ASN1_OBJECT_dup);
    eval 'sub sk_ASN1_OBJECT_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &ASN1_OBJECT, ($st), ($free_func)));
    }' unless defined(&sk_ASN1_OBJECT_pop_free);
    eval 'sub sk_ASN1_OBJECT_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &ASN1_OBJECT, ($st)));
    }' unless defined(&sk_ASN1_OBJECT_shift);
    eval 'sub sk_ASN1_OBJECT_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &ASN1_OBJECT, ($st)));
    }' unless defined(&sk_ASN1_OBJECT_pop);
    eval 'sub sk_ASN1_OBJECT_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &ASN1_OBJECT, ($st)));
    }' unless defined(&sk_ASN1_OBJECT_sort);
    eval 'sub sk_ASN1_OBJECT_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &ASN1_OBJECT, ($st)));
    }' unless defined(&sk_ASN1_OBJECT_is_sorted);
    eval 'sub sk_ASN1_STRING_TABLE_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &ASN1_STRING_TABLE, ($st)));
    }' unless defined(&sk_ASN1_STRING_TABLE_new);
    eval 'sub sk_ASN1_STRING_TABLE_new_null () {
        eval q( &SKM_sk_new_null( &ASN1_STRING_TABLE));
    }' unless defined(&sk_ASN1_STRING_TABLE_new_null);
    eval 'sub sk_ASN1_STRING_TABLE_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &ASN1_STRING_TABLE, ($st)));
    }' unless defined(&sk_ASN1_STRING_TABLE_free);
    eval 'sub sk_ASN1_STRING_TABLE_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &ASN1_STRING_TABLE, ($st)));
    }' unless defined(&sk_ASN1_STRING_TABLE_num);
    eval 'sub sk_ASN1_STRING_TABLE_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &ASN1_STRING_TABLE, ($st), ($i)));
    }' unless defined(&sk_ASN1_STRING_TABLE_value);
    eval 'sub sk_ASN1_STRING_TABLE_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &ASN1_STRING_TABLE, ($st), ($i), ($val)));
    }' unless defined(&sk_ASN1_STRING_TABLE_set);
    eval 'sub sk_ASN1_STRING_TABLE_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &ASN1_STRING_TABLE, ($st)));
    }' unless defined(&sk_ASN1_STRING_TABLE_zero);
    eval 'sub sk_ASN1_STRING_TABLE_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &ASN1_STRING_TABLE, ($st), ($val)));
    }' unless defined(&sk_ASN1_STRING_TABLE_push);
    eval 'sub sk_ASN1_STRING_TABLE_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &ASN1_STRING_TABLE, ($st), ($val)));
    }' unless defined(&sk_ASN1_STRING_TABLE_unshift);
    eval 'sub sk_ASN1_STRING_TABLE_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &ASN1_STRING_TABLE, ($st), ($val)));
    }' unless defined(&sk_ASN1_STRING_TABLE_find);
    eval 'sub sk_ASN1_STRING_TABLE_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &ASN1_STRING_TABLE, ($st), ($i)));
    }' unless defined(&sk_ASN1_STRING_TABLE_delete);
    eval 'sub sk_ASN1_STRING_TABLE_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &ASN1_STRING_TABLE, ($st), ($ptr)));
    }' unless defined(&sk_ASN1_STRING_TABLE_delete_ptr);
    eval 'sub sk_ASN1_STRING_TABLE_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &ASN1_STRING_TABLE, ($st), ($val), ($i)));
    }' unless defined(&sk_ASN1_STRING_TABLE_insert);
    eval 'sub sk_ASN1_STRING_TABLE_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &ASN1_STRING_TABLE, ($st), ($cmp)));
    }' unless defined(&sk_ASN1_STRING_TABLE_set_cmp_func);
    eval 'sub sk_ASN1_STRING_TABLE_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &ASN1_STRING_TABLE, $st));
    }' unless defined(&sk_ASN1_STRING_TABLE_dup);
    eval 'sub sk_ASN1_STRING_TABLE_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &ASN1_STRING_TABLE, ($st), ($free_func)));
    }' unless defined(&sk_ASN1_STRING_TABLE_pop_free);
    eval 'sub sk_ASN1_STRING_TABLE_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &ASN1_STRING_TABLE, ($st)));
    }' unless defined(&sk_ASN1_STRING_TABLE_shift);
    eval 'sub sk_ASN1_STRING_TABLE_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &ASN1_STRING_TABLE, ($st)));
    }' unless defined(&sk_ASN1_STRING_TABLE_pop);
    eval 'sub sk_ASN1_STRING_TABLE_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &ASN1_STRING_TABLE, ($st)));
    }' unless defined(&sk_ASN1_STRING_TABLE_sort);
    eval 'sub sk_ASN1_STRING_TABLE_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &ASN1_STRING_TABLE, ($st)));
    }' unless defined(&sk_ASN1_STRING_TABLE_is_sorted);
    eval 'sub sk_ASN1_TYPE_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &ASN1_TYPE, ($st)));
    }' unless defined(&sk_ASN1_TYPE_new);
    eval 'sub sk_ASN1_TYPE_new_null () {
        eval q( &SKM_sk_new_null( &ASN1_TYPE));
    }' unless defined(&sk_ASN1_TYPE_new_null);
    eval 'sub sk_ASN1_TYPE_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &ASN1_TYPE, ($st)));
    }' unless defined(&sk_ASN1_TYPE_free);
    eval 'sub sk_ASN1_TYPE_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &ASN1_TYPE, ($st)));
    }' unless defined(&sk_ASN1_TYPE_num);
    eval 'sub sk_ASN1_TYPE_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &ASN1_TYPE, ($st), ($i)));
    }' unless defined(&sk_ASN1_TYPE_value);
    eval 'sub sk_ASN1_TYPE_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &ASN1_TYPE, ($st), ($i), ($val)));
    }' unless defined(&sk_ASN1_TYPE_set);
    eval 'sub sk_ASN1_TYPE_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &ASN1_TYPE, ($st)));
    }' unless defined(&sk_ASN1_TYPE_zero);
    eval 'sub sk_ASN1_TYPE_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &ASN1_TYPE, ($st), ($val)));
    }' unless defined(&sk_ASN1_TYPE_push);
    eval 'sub sk_ASN1_TYPE_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &ASN1_TYPE, ($st), ($val)));
    }' unless defined(&sk_ASN1_TYPE_unshift);
    eval 'sub sk_ASN1_TYPE_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &ASN1_TYPE, ($st), ($val)));
    }' unless defined(&sk_ASN1_TYPE_find);
    eval 'sub sk_ASN1_TYPE_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &ASN1_TYPE, ($st), ($i)));
    }' unless defined(&sk_ASN1_TYPE_delete);
    eval 'sub sk_ASN1_TYPE_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &ASN1_TYPE, ($st), ($ptr)));
    }' unless defined(&sk_ASN1_TYPE_delete_ptr);
    eval 'sub sk_ASN1_TYPE_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &ASN1_TYPE, ($st), ($val), ($i)));
    }' unless defined(&sk_ASN1_TYPE_insert);
    eval 'sub sk_ASN1_TYPE_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &ASN1_TYPE, ($st), ($cmp)));
    }' unless defined(&sk_ASN1_TYPE_set_cmp_func);
    eval 'sub sk_ASN1_TYPE_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &ASN1_TYPE, $st));
    }' unless defined(&sk_ASN1_TYPE_dup);
    eval 'sub sk_ASN1_TYPE_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &ASN1_TYPE, ($st), ($free_func)));
    }' unless defined(&sk_ASN1_TYPE_pop_free);
    eval 'sub sk_ASN1_TYPE_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &ASN1_TYPE, ($st)));
    }' unless defined(&sk_ASN1_TYPE_shift);
    eval 'sub sk_ASN1_TYPE_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &ASN1_TYPE, ($st)));
    }' unless defined(&sk_ASN1_TYPE_pop);
    eval 'sub sk_ASN1_TYPE_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &ASN1_TYPE, ($st)));
    }' unless defined(&sk_ASN1_TYPE_sort);
    eval 'sub sk_ASN1_TYPE_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &ASN1_TYPE, ($st)));
    }' unless defined(&sk_ASN1_TYPE_is_sorted);
    eval 'sub sk_ASN1_VALUE_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &ASN1_VALUE, ($st)));
    }' unless defined(&sk_ASN1_VALUE_new);
    eval 'sub sk_ASN1_VALUE_new_null () {
        eval q( &SKM_sk_new_null( &ASN1_VALUE));
    }' unless defined(&sk_ASN1_VALUE_new_null);
    eval 'sub sk_ASN1_VALUE_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &ASN1_VALUE, ($st)));
    }' unless defined(&sk_ASN1_VALUE_free);
    eval 'sub sk_ASN1_VALUE_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &ASN1_VALUE, ($st)));
    }' unless defined(&sk_ASN1_VALUE_num);
    eval 'sub sk_ASN1_VALUE_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &ASN1_VALUE, ($st), ($i)));
    }' unless defined(&sk_ASN1_VALUE_value);
    eval 'sub sk_ASN1_VALUE_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &ASN1_VALUE, ($st), ($i), ($val)));
    }' unless defined(&sk_ASN1_VALUE_set);
    eval 'sub sk_ASN1_VALUE_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &ASN1_VALUE, ($st)));
    }' unless defined(&sk_ASN1_VALUE_zero);
    eval 'sub sk_ASN1_VALUE_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &ASN1_VALUE, ($st), ($val)));
    }' unless defined(&sk_ASN1_VALUE_push);
    eval 'sub sk_ASN1_VALUE_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &ASN1_VALUE, ($st), ($val)));
    }' unless defined(&sk_ASN1_VALUE_unshift);
    eval 'sub sk_ASN1_VALUE_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &ASN1_VALUE, ($st), ($val)));
    }' unless defined(&sk_ASN1_VALUE_find);
    eval 'sub sk_ASN1_VALUE_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &ASN1_VALUE, ($st), ($i)));
    }' unless defined(&sk_ASN1_VALUE_delete);
    eval 'sub sk_ASN1_VALUE_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &ASN1_VALUE, ($st), ($ptr)));
    }' unless defined(&sk_ASN1_VALUE_delete_ptr);
    eval 'sub sk_ASN1_VALUE_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &ASN1_VALUE, ($st), ($val), ($i)));
    }' unless defined(&sk_ASN1_VALUE_insert);
    eval 'sub sk_ASN1_VALUE_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &ASN1_VALUE, ($st), ($cmp)));
    }' unless defined(&sk_ASN1_VALUE_set_cmp_func);
    eval 'sub sk_ASN1_VALUE_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &ASN1_VALUE, $st));
    }' unless defined(&sk_ASN1_VALUE_dup);
    eval 'sub sk_ASN1_VALUE_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &ASN1_VALUE, ($st), ($free_func)));
    }' unless defined(&sk_ASN1_VALUE_pop_free);
    eval 'sub sk_ASN1_VALUE_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &ASN1_VALUE, ($st)));
    }' unless defined(&sk_ASN1_VALUE_shift);
    eval 'sub sk_ASN1_VALUE_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &ASN1_VALUE, ($st)));
    }' unless defined(&sk_ASN1_VALUE_pop);
    eval 'sub sk_ASN1_VALUE_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &ASN1_VALUE, ($st)));
    }' unless defined(&sk_ASN1_VALUE_sort);
    eval 'sub sk_ASN1_VALUE_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &ASN1_VALUE, ($st)));
    }' unless defined(&sk_ASN1_VALUE_is_sorted);
    eval 'sub sk_BIO_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &BIO, ($st)));
    }' unless defined(&sk_BIO_new);
    eval 'sub sk_BIO_new_null () {
        eval q( &SKM_sk_new_null( &BIO));
    }' unless defined(&sk_BIO_new_null);
    eval 'sub sk_BIO_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &BIO, ($st)));
    }' unless defined(&sk_BIO_free);
    eval 'sub sk_BIO_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &BIO, ($st)));
    }' unless defined(&sk_BIO_num);
    eval 'sub sk_BIO_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &BIO, ($st), ($i)));
    }' unless defined(&sk_BIO_value);
    eval 'sub sk_BIO_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &BIO, ($st), ($i), ($val)));
    }' unless defined(&sk_BIO_set);
    eval 'sub sk_BIO_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &BIO, ($st)));
    }' unless defined(&sk_BIO_zero);
    eval 'sub sk_BIO_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &BIO, ($st), ($val)));
    }' unless defined(&sk_BIO_push);
    eval 'sub sk_BIO_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &BIO, ($st), ($val)));
    }' unless defined(&sk_BIO_unshift);
    eval 'sub sk_BIO_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &BIO, ($st), ($val)));
    }' unless defined(&sk_BIO_find);
    eval 'sub sk_BIO_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &BIO, ($st), ($i)));
    }' unless defined(&sk_BIO_delete);
    eval 'sub sk_BIO_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &BIO, ($st), ($ptr)));
    }' unless defined(&sk_BIO_delete_ptr);
    eval 'sub sk_BIO_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &BIO, ($st), ($val), ($i)));
    }' unless defined(&sk_BIO_insert);
    eval 'sub sk_BIO_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &BIO, ($st), ($cmp)));
    }' unless defined(&sk_BIO_set_cmp_func);
    eval 'sub sk_BIO_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &BIO, $st));
    }' unless defined(&sk_BIO_dup);
    eval 'sub sk_BIO_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &BIO, ($st), ($free_func)));
    }' unless defined(&sk_BIO_pop_free);
    eval 'sub sk_BIO_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &BIO, ($st)));
    }' unless defined(&sk_BIO_shift);
    eval 'sub sk_BIO_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &BIO, ($st)));
    }' unless defined(&sk_BIO_pop);
    eval 'sub sk_BIO_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &BIO, ($st)));
    }' unless defined(&sk_BIO_sort);
    eval 'sub sk_BIO_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &BIO, ($st)));
    }' unless defined(&sk_BIO_is_sorted);
    eval 'sub sk_CONF_IMODULE_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &CONF_IMODULE, ($st)));
    }' unless defined(&sk_CONF_IMODULE_new);
    eval 'sub sk_CONF_IMODULE_new_null () {
        eval q( &SKM_sk_new_null( &CONF_IMODULE));
    }' unless defined(&sk_CONF_IMODULE_new_null);
    eval 'sub sk_CONF_IMODULE_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &CONF_IMODULE, ($st)));
    }' unless defined(&sk_CONF_IMODULE_free);
    eval 'sub sk_CONF_IMODULE_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &CONF_IMODULE, ($st)));
    }' unless defined(&sk_CONF_IMODULE_num);
    eval 'sub sk_CONF_IMODULE_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &CONF_IMODULE, ($st), ($i)));
    }' unless defined(&sk_CONF_IMODULE_value);
    eval 'sub sk_CONF_IMODULE_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &CONF_IMODULE, ($st), ($i), ($val)));
    }' unless defined(&sk_CONF_IMODULE_set);
    eval 'sub sk_CONF_IMODULE_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &CONF_IMODULE, ($st)));
    }' unless defined(&sk_CONF_IMODULE_zero);
    eval 'sub sk_CONF_IMODULE_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &CONF_IMODULE, ($st), ($val)));
    }' unless defined(&sk_CONF_IMODULE_push);
    eval 'sub sk_CONF_IMODULE_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &CONF_IMODULE, ($st), ($val)));
    }' unless defined(&sk_CONF_IMODULE_unshift);
    eval 'sub sk_CONF_IMODULE_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &CONF_IMODULE, ($st), ($val)));
    }' unless defined(&sk_CONF_IMODULE_find);
    eval 'sub sk_CONF_IMODULE_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &CONF_IMODULE, ($st), ($i)));
    }' unless defined(&sk_CONF_IMODULE_delete);
    eval 'sub sk_CONF_IMODULE_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &CONF_IMODULE, ($st), ($ptr)));
    }' unless defined(&sk_CONF_IMODULE_delete_ptr);
    eval 'sub sk_CONF_IMODULE_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &CONF_IMODULE, ($st), ($val), ($i)));
    }' unless defined(&sk_CONF_IMODULE_insert);
    eval 'sub sk_CONF_IMODULE_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &CONF_IMODULE, ($st), ($cmp)));
    }' unless defined(&sk_CONF_IMODULE_set_cmp_func);
    eval 'sub sk_CONF_IMODULE_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &CONF_IMODULE, $st));
    }' unless defined(&sk_CONF_IMODULE_dup);
    eval 'sub sk_CONF_IMODULE_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &CONF_IMODULE, ($st), ($free_func)));
    }' unless defined(&sk_CONF_IMODULE_pop_free);
    eval 'sub sk_CONF_IMODULE_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &CONF_IMODULE, ($st)));
    }' unless defined(&sk_CONF_IMODULE_shift);
    eval 'sub sk_CONF_IMODULE_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &CONF_IMODULE, ($st)));
    }' unless defined(&sk_CONF_IMODULE_pop);
    eval 'sub sk_CONF_IMODULE_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &CONF_IMODULE, ($st)));
    }' unless defined(&sk_CONF_IMODULE_sort);
    eval 'sub sk_CONF_IMODULE_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &CONF_IMODULE, ($st)));
    }' unless defined(&sk_CONF_IMODULE_is_sorted);
    eval 'sub sk_CONF_MODULE_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &CONF_MODULE, ($st)));
    }' unless defined(&sk_CONF_MODULE_new);
    eval 'sub sk_CONF_MODULE_new_null () {
        eval q( &SKM_sk_new_null( &CONF_MODULE));
    }' unless defined(&sk_CONF_MODULE_new_null);
    eval 'sub sk_CONF_MODULE_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &CONF_MODULE, ($st)));
    }' unless defined(&sk_CONF_MODULE_free);
    eval 'sub sk_CONF_MODULE_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &CONF_MODULE, ($st)));
    }' unless defined(&sk_CONF_MODULE_num);
    eval 'sub sk_CONF_MODULE_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &CONF_MODULE, ($st), ($i)));
    }' unless defined(&sk_CONF_MODULE_value);
    eval 'sub sk_CONF_MODULE_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &CONF_MODULE, ($st), ($i), ($val)));
    }' unless defined(&sk_CONF_MODULE_set);
    eval 'sub sk_CONF_MODULE_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &CONF_MODULE, ($st)));
    }' unless defined(&sk_CONF_MODULE_zero);
    eval 'sub sk_CONF_MODULE_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &CONF_MODULE, ($st), ($val)));
    }' unless defined(&sk_CONF_MODULE_push);
    eval 'sub sk_CONF_MODULE_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &CONF_MODULE, ($st), ($val)));
    }' unless defined(&sk_CONF_MODULE_unshift);
    eval 'sub sk_CONF_MODULE_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &CONF_MODULE, ($st), ($val)));
    }' unless defined(&sk_CONF_MODULE_find);
    eval 'sub sk_CONF_MODULE_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &CONF_MODULE, ($st), ($i)));
    }' unless defined(&sk_CONF_MODULE_delete);
    eval 'sub sk_CONF_MODULE_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &CONF_MODULE, ($st), ($ptr)));
    }' unless defined(&sk_CONF_MODULE_delete_ptr);
    eval 'sub sk_CONF_MODULE_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &CONF_MODULE, ($st), ($val), ($i)));
    }' unless defined(&sk_CONF_MODULE_insert);
    eval 'sub sk_CONF_MODULE_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &CONF_MODULE, ($st), ($cmp)));
    }' unless defined(&sk_CONF_MODULE_set_cmp_func);
    eval 'sub sk_CONF_MODULE_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &CONF_MODULE, $st));
    }' unless defined(&sk_CONF_MODULE_dup);
    eval 'sub sk_CONF_MODULE_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &CONF_MODULE, ($st), ($free_func)));
    }' unless defined(&sk_CONF_MODULE_pop_free);
    eval 'sub sk_CONF_MODULE_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &CONF_MODULE, ($st)));
    }' unless defined(&sk_CONF_MODULE_shift);
    eval 'sub sk_CONF_MODULE_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &CONF_MODULE, ($st)));
    }' unless defined(&sk_CONF_MODULE_pop);
    eval 'sub sk_CONF_MODULE_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &CONF_MODULE, ($st)));
    }' unless defined(&sk_CONF_MODULE_sort);
    eval 'sub sk_CONF_MODULE_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &CONF_MODULE, ($st)));
    }' unless defined(&sk_CONF_MODULE_is_sorted);
    eval 'sub sk_CONF_VALUE_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &CONF_VALUE, ($st)));
    }' unless defined(&sk_CONF_VALUE_new);
    eval 'sub sk_CONF_VALUE_new_null () {
        eval q( &SKM_sk_new_null( &CONF_VALUE));
    }' unless defined(&sk_CONF_VALUE_new_null);
    eval 'sub sk_CONF_VALUE_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &CONF_VALUE, ($st)));
    }' unless defined(&sk_CONF_VALUE_free);
    eval 'sub sk_CONF_VALUE_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &CONF_VALUE, ($st)));
    }' unless defined(&sk_CONF_VALUE_num);
    eval 'sub sk_CONF_VALUE_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &CONF_VALUE, ($st), ($i)));
    }' unless defined(&sk_CONF_VALUE_value);
    eval 'sub sk_CONF_VALUE_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &CONF_VALUE, ($st), ($i), ($val)));
    }' unless defined(&sk_CONF_VALUE_set);
    eval 'sub sk_CONF_VALUE_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &CONF_VALUE, ($st)));
    }' unless defined(&sk_CONF_VALUE_zero);
    eval 'sub sk_CONF_VALUE_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &CONF_VALUE, ($st), ($val)));
    }' unless defined(&sk_CONF_VALUE_push);
    eval 'sub sk_CONF_VALUE_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &CONF_VALUE, ($st), ($val)));
    }' unless defined(&sk_CONF_VALUE_unshift);
    eval 'sub sk_CONF_VALUE_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &CONF_VALUE, ($st), ($val)));
    }' unless defined(&sk_CONF_VALUE_find);
    eval 'sub sk_CONF_VALUE_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &CONF_VALUE, ($st), ($i)));
    }' unless defined(&sk_CONF_VALUE_delete);
    eval 'sub sk_CONF_VALUE_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &CONF_VALUE, ($st), ($ptr)));
    }' unless defined(&sk_CONF_VALUE_delete_ptr);
    eval 'sub sk_CONF_VALUE_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &CONF_VALUE, ($st), ($val), ($i)));
    }' unless defined(&sk_CONF_VALUE_insert);
    eval 'sub sk_CONF_VALUE_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &CONF_VALUE, ($st), ($cmp)));
    }' unless defined(&sk_CONF_VALUE_set_cmp_func);
    eval 'sub sk_CONF_VALUE_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &CONF_VALUE, $st));
    }' unless defined(&sk_CONF_VALUE_dup);
    eval 'sub sk_CONF_VALUE_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &CONF_VALUE, ($st), ($free_func)));
    }' unless defined(&sk_CONF_VALUE_pop_free);
    eval 'sub sk_CONF_VALUE_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &CONF_VALUE, ($st)));
    }' unless defined(&sk_CONF_VALUE_shift);
    eval 'sub sk_CONF_VALUE_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &CONF_VALUE, ($st)));
    }' unless defined(&sk_CONF_VALUE_pop);
    eval 'sub sk_CONF_VALUE_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &CONF_VALUE, ($st)));
    }' unless defined(&sk_CONF_VALUE_sort);
    eval 'sub sk_CONF_VALUE_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &CONF_VALUE, ($st)));
    }' unless defined(&sk_CONF_VALUE_is_sorted);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &CRYPTO_EX_DATA_FUNCS, ($st)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_new);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_new_null () {
        eval q( &SKM_sk_new_null( &CRYPTO_EX_DATA_FUNCS));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_new_null);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &CRYPTO_EX_DATA_FUNCS, ($st)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_free);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &CRYPTO_EX_DATA_FUNCS, ($st)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_num);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &CRYPTO_EX_DATA_FUNCS, ($st), ($i)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_value);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &CRYPTO_EX_DATA_FUNCS, ($st), ($i), ($val)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_set);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &CRYPTO_EX_DATA_FUNCS, ($st)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_zero);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &CRYPTO_EX_DATA_FUNCS, ($st), ($val)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_push);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &CRYPTO_EX_DATA_FUNCS, ($st), ($val)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_unshift);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &CRYPTO_EX_DATA_FUNCS, ($st), ($val)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_find);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &CRYPTO_EX_DATA_FUNCS, ($st), ($i)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_delete);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &CRYPTO_EX_DATA_FUNCS, ($st), ($ptr)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_delete_ptr);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &CRYPTO_EX_DATA_FUNCS, ($st), ($val), ($i)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_insert);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &CRYPTO_EX_DATA_FUNCS, ($st), ($cmp)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_set_cmp_func);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &CRYPTO_EX_DATA_FUNCS, $st));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_dup);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &CRYPTO_EX_DATA_FUNCS, ($st), ($free_func)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_pop_free);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &CRYPTO_EX_DATA_FUNCS, ($st)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_shift);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &CRYPTO_EX_DATA_FUNCS, ($st)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_pop);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &CRYPTO_EX_DATA_FUNCS, ($st)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_sort);
    eval 'sub sk_CRYPTO_EX_DATA_FUNCS_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &CRYPTO_EX_DATA_FUNCS, ($st)));
    }' unless defined(&sk_CRYPTO_EX_DATA_FUNCS_is_sorted);
    eval 'sub sk_CRYPTO_dynlock_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &CRYPTO_dynlock, ($st)));
    }' unless defined(&sk_CRYPTO_dynlock_new);
    eval 'sub sk_CRYPTO_dynlock_new_null () {
        eval q( &SKM_sk_new_null( &CRYPTO_dynlock));
    }' unless defined(&sk_CRYPTO_dynlock_new_null);
    eval 'sub sk_CRYPTO_dynlock_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &CRYPTO_dynlock, ($st)));
    }' unless defined(&sk_CRYPTO_dynlock_free);
    eval 'sub sk_CRYPTO_dynlock_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &CRYPTO_dynlock, ($st)));
    }' unless defined(&sk_CRYPTO_dynlock_num);
    eval 'sub sk_CRYPTO_dynlock_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &CRYPTO_dynlock, ($st), ($i)));
    }' unless defined(&sk_CRYPTO_dynlock_value);
    eval 'sub sk_CRYPTO_dynlock_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &CRYPTO_dynlock, ($st), ($i), ($val)));
    }' unless defined(&sk_CRYPTO_dynlock_set);
    eval 'sub sk_CRYPTO_dynlock_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &CRYPTO_dynlock, ($st)));
    }' unless defined(&sk_CRYPTO_dynlock_zero);
    eval 'sub sk_CRYPTO_dynlock_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &CRYPTO_dynlock, ($st), ($val)));
    }' unless defined(&sk_CRYPTO_dynlock_push);
    eval 'sub sk_CRYPTO_dynlock_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &CRYPTO_dynlock, ($st), ($val)));
    }' unless defined(&sk_CRYPTO_dynlock_unshift);
    eval 'sub sk_CRYPTO_dynlock_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &CRYPTO_dynlock, ($st), ($val)));
    }' unless defined(&sk_CRYPTO_dynlock_find);
    eval 'sub sk_CRYPTO_dynlock_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &CRYPTO_dynlock, ($st), ($i)));
    }' unless defined(&sk_CRYPTO_dynlock_delete);
    eval 'sub sk_CRYPTO_dynlock_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &CRYPTO_dynlock, ($st), ($ptr)));
    }' unless defined(&sk_CRYPTO_dynlock_delete_ptr);
    eval 'sub sk_CRYPTO_dynlock_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &CRYPTO_dynlock, ($st), ($val), ($i)));
    }' unless defined(&sk_CRYPTO_dynlock_insert);
    eval 'sub sk_CRYPTO_dynlock_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &CRYPTO_dynlock, ($st), ($cmp)));
    }' unless defined(&sk_CRYPTO_dynlock_set_cmp_func);
    eval 'sub sk_CRYPTO_dynlock_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &CRYPTO_dynlock, $st));
    }' unless defined(&sk_CRYPTO_dynlock_dup);
    eval 'sub sk_CRYPTO_dynlock_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &CRYPTO_dynlock, ($st), ($free_func)));
    }' unless defined(&sk_CRYPTO_dynlock_pop_free);
    eval 'sub sk_CRYPTO_dynlock_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &CRYPTO_dynlock, ($st)));
    }' unless defined(&sk_CRYPTO_dynlock_shift);
    eval 'sub sk_CRYPTO_dynlock_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &CRYPTO_dynlock, ($st)));
    }' unless defined(&sk_CRYPTO_dynlock_pop);
    eval 'sub sk_CRYPTO_dynlock_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &CRYPTO_dynlock, ($st)));
    }' unless defined(&sk_CRYPTO_dynlock_sort);
    eval 'sub sk_CRYPTO_dynlock_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &CRYPTO_dynlock, ($st)));
    }' unless defined(&sk_CRYPTO_dynlock_is_sorted);
    eval 'sub sk_DIST_POINT_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &DIST_POINT, ($st)));
    }' unless defined(&sk_DIST_POINT_new);
    eval 'sub sk_DIST_POINT_new_null () {
        eval q( &SKM_sk_new_null( &DIST_POINT));
    }' unless defined(&sk_DIST_POINT_new_null);
    eval 'sub sk_DIST_POINT_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &DIST_POINT, ($st)));
    }' unless defined(&sk_DIST_POINT_free);
    eval 'sub sk_DIST_POINT_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &DIST_POINT, ($st)));
    }' unless defined(&sk_DIST_POINT_num);
    eval 'sub sk_DIST_POINT_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &DIST_POINT, ($st), ($i)));
    }' unless defined(&sk_DIST_POINT_value);
    eval 'sub sk_DIST_POINT_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &DIST_POINT, ($st), ($i), ($val)));
    }' unless defined(&sk_DIST_POINT_set);
    eval 'sub sk_DIST_POINT_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &DIST_POINT, ($st)));
    }' unless defined(&sk_DIST_POINT_zero);
    eval 'sub sk_DIST_POINT_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &DIST_POINT, ($st), ($val)));
    }' unless defined(&sk_DIST_POINT_push);
    eval 'sub sk_DIST_POINT_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &DIST_POINT, ($st), ($val)));
    }' unless defined(&sk_DIST_POINT_unshift);
    eval 'sub sk_DIST_POINT_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &DIST_POINT, ($st), ($val)));
    }' unless defined(&sk_DIST_POINT_find);
    eval 'sub sk_DIST_POINT_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &DIST_POINT, ($st), ($i)));
    }' unless defined(&sk_DIST_POINT_delete);
    eval 'sub sk_DIST_POINT_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &DIST_POINT, ($st), ($ptr)));
    }' unless defined(&sk_DIST_POINT_delete_ptr);
    eval 'sub sk_DIST_POINT_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &DIST_POINT, ($st), ($val), ($i)));
    }' unless defined(&sk_DIST_POINT_insert);
    eval 'sub sk_DIST_POINT_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &DIST_POINT, ($st), ($cmp)));
    }' unless defined(&sk_DIST_POINT_set_cmp_func);
    eval 'sub sk_DIST_POINT_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &DIST_POINT, $st));
    }' unless defined(&sk_DIST_POINT_dup);
    eval 'sub sk_DIST_POINT_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &DIST_POINT, ($st), ($free_func)));
    }' unless defined(&sk_DIST_POINT_pop_free);
    eval 'sub sk_DIST_POINT_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &DIST_POINT, ($st)));
    }' unless defined(&sk_DIST_POINT_shift);
    eval 'sub sk_DIST_POINT_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &DIST_POINT, ($st)));
    }' unless defined(&sk_DIST_POINT_pop);
    eval 'sub sk_DIST_POINT_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &DIST_POINT, ($st)));
    }' unless defined(&sk_DIST_POINT_sort);
    eval 'sub sk_DIST_POINT_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &DIST_POINT, ($st)));
    }' unless defined(&sk_DIST_POINT_is_sorted);
    eval 'sub sk_ENGINE_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &ENGINE, ($st)));
    }' unless defined(&sk_ENGINE_new);
    eval 'sub sk_ENGINE_new_null () {
        eval q( &SKM_sk_new_null( &ENGINE));
    }' unless defined(&sk_ENGINE_new_null);
    eval 'sub sk_ENGINE_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &ENGINE, ($st)));
    }' unless defined(&sk_ENGINE_free);
    eval 'sub sk_ENGINE_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &ENGINE, ($st)));
    }' unless defined(&sk_ENGINE_num);
    eval 'sub sk_ENGINE_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &ENGINE, ($st), ($i)));
    }' unless defined(&sk_ENGINE_value);
    eval 'sub sk_ENGINE_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &ENGINE, ($st), ($i), ($val)));
    }' unless defined(&sk_ENGINE_set);
    eval 'sub sk_ENGINE_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &ENGINE, ($st)));
    }' unless defined(&sk_ENGINE_zero);
    eval 'sub sk_ENGINE_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &ENGINE, ($st), ($val)));
    }' unless defined(&sk_ENGINE_push);
    eval 'sub sk_ENGINE_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &ENGINE, ($st), ($val)));
    }' unless defined(&sk_ENGINE_unshift);
    eval 'sub sk_ENGINE_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &ENGINE, ($st), ($val)));
    }' unless defined(&sk_ENGINE_find);
    eval 'sub sk_ENGINE_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &ENGINE, ($st), ($i)));
    }' unless defined(&sk_ENGINE_delete);
    eval 'sub sk_ENGINE_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &ENGINE, ($st), ($ptr)));
    }' unless defined(&sk_ENGINE_delete_ptr);
    eval 'sub sk_ENGINE_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &ENGINE, ($st), ($val), ($i)));
    }' unless defined(&sk_ENGINE_insert);
    eval 'sub sk_ENGINE_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &ENGINE, ($st), ($cmp)));
    }' unless defined(&sk_ENGINE_set_cmp_func);
    eval 'sub sk_ENGINE_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &ENGINE, $st));
    }' unless defined(&sk_ENGINE_dup);
    eval 'sub sk_ENGINE_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &ENGINE, ($st), ($free_func)));
    }' unless defined(&sk_ENGINE_pop_free);
    eval 'sub sk_ENGINE_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &ENGINE, ($st)));
    }' unless defined(&sk_ENGINE_shift);
    eval 'sub sk_ENGINE_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &ENGINE, ($st)));
    }' unless defined(&sk_ENGINE_pop);
    eval 'sub sk_ENGINE_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &ENGINE, ($st)));
    }' unless defined(&sk_ENGINE_sort);
    eval 'sub sk_ENGINE_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &ENGINE, ($st)));
    }' unless defined(&sk_ENGINE_is_sorted);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &ENGINE_CLEANUP_ITEM, ($st)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_new);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_new_null () {
        eval q( &SKM_sk_new_null( &ENGINE_CLEANUP_ITEM));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_new_null);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &ENGINE_CLEANUP_ITEM, ($st)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_free);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &ENGINE_CLEANUP_ITEM, ($st)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_num);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &ENGINE_CLEANUP_ITEM, ($st), ($i)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_value);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &ENGINE_CLEANUP_ITEM, ($st), ($i), ($val)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_set);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &ENGINE_CLEANUP_ITEM, ($st)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_zero);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &ENGINE_CLEANUP_ITEM, ($st), ($val)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_push);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &ENGINE_CLEANUP_ITEM, ($st), ($val)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_unshift);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &ENGINE_CLEANUP_ITEM, ($st), ($val)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_find);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &ENGINE_CLEANUP_ITEM, ($st), ($i)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_delete);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &ENGINE_CLEANUP_ITEM, ($st), ($ptr)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_delete_ptr);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &ENGINE_CLEANUP_ITEM, ($st), ($val), ($i)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_insert);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &ENGINE_CLEANUP_ITEM, ($st), ($cmp)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_set_cmp_func);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &ENGINE_CLEANUP_ITEM, $st));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_dup);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &ENGINE_CLEANUP_ITEM, ($st), ($free_func)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_pop_free);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &ENGINE_CLEANUP_ITEM, ($st)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_shift);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &ENGINE_CLEANUP_ITEM, ($st)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_pop);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &ENGINE_CLEANUP_ITEM, ($st)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_sort);
    eval 'sub sk_ENGINE_CLEANUP_ITEM_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &ENGINE_CLEANUP_ITEM, ($st)));
    }' unless defined(&sk_ENGINE_CLEANUP_ITEM_is_sorted);
    eval 'sub sk_GENERAL_NAME_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &GENERAL_NAME, ($st)));
    }' unless defined(&sk_GENERAL_NAME_new);
    eval 'sub sk_GENERAL_NAME_new_null () {
        eval q( &SKM_sk_new_null( &GENERAL_NAME));
    }' unless defined(&sk_GENERAL_NAME_new_null);
    eval 'sub sk_GENERAL_NAME_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &GENERAL_NAME, ($st)));
    }' unless defined(&sk_GENERAL_NAME_free);
    eval 'sub sk_GENERAL_NAME_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &GENERAL_NAME, ($st)));
    }' unless defined(&sk_GENERAL_NAME_num);
    eval 'sub sk_GENERAL_NAME_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &GENERAL_NAME, ($st), ($i)));
    }' unless defined(&sk_GENERAL_NAME_value);
    eval 'sub sk_GENERAL_NAME_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &GENERAL_NAME, ($st), ($i), ($val)));
    }' unless defined(&sk_GENERAL_NAME_set);
    eval 'sub sk_GENERAL_NAME_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &GENERAL_NAME, ($st)));
    }' unless defined(&sk_GENERAL_NAME_zero);
    eval 'sub sk_GENERAL_NAME_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &GENERAL_NAME, ($st), ($val)));
    }' unless defined(&sk_GENERAL_NAME_push);
    eval 'sub sk_GENERAL_NAME_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &GENERAL_NAME, ($st), ($val)));
    }' unless defined(&sk_GENERAL_NAME_unshift);
    eval 'sub sk_GENERAL_NAME_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &GENERAL_NAME, ($st), ($val)));
    }' unless defined(&sk_GENERAL_NAME_find);
    eval 'sub sk_GENERAL_NAME_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &GENERAL_NAME, ($st), ($i)));
    }' unless defined(&sk_GENERAL_NAME_delete);
    eval 'sub sk_GENERAL_NAME_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &GENERAL_NAME, ($st), ($ptr)));
    }' unless defined(&sk_GENERAL_NAME_delete_ptr);
    eval 'sub sk_GENERAL_NAME_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &GENERAL_NAME, ($st), ($val), ($i)));
    }' unless defined(&sk_GENERAL_NAME_insert);
    eval 'sub sk_GENERAL_NAME_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &GENERAL_NAME, ($st), ($cmp)));
    }' unless defined(&sk_GENERAL_NAME_set_cmp_func);
    eval 'sub sk_GENERAL_NAME_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &GENERAL_NAME, $st));
    }' unless defined(&sk_GENERAL_NAME_dup);
    eval 'sub sk_GENERAL_NAME_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &GENERAL_NAME, ($st), ($free_func)));
    }' unless defined(&sk_GENERAL_NAME_pop_free);
    eval 'sub sk_GENERAL_NAME_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &GENERAL_NAME, ($st)));
    }' unless defined(&sk_GENERAL_NAME_shift);
    eval 'sub sk_GENERAL_NAME_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &GENERAL_NAME, ($st)));
    }' unless defined(&sk_GENERAL_NAME_pop);
    eval 'sub sk_GENERAL_NAME_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &GENERAL_NAME, ($st)));
    }' unless defined(&sk_GENERAL_NAME_sort);
    eval 'sub sk_GENERAL_NAME_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &GENERAL_NAME, ($st)));
    }' unless defined(&sk_GENERAL_NAME_is_sorted);
    eval 'sub sk_KRB5_APREQBODY_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &KRB5_APREQBODY, ($st)));
    }' unless defined(&sk_KRB5_APREQBODY_new);
    eval 'sub sk_KRB5_APREQBODY_new_null () {
        eval q( &SKM_sk_new_null( &KRB5_APREQBODY));
    }' unless defined(&sk_KRB5_APREQBODY_new_null);
    eval 'sub sk_KRB5_APREQBODY_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &KRB5_APREQBODY, ($st)));
    }' unless defined(&sk_KRB5_APREQBODY_free);
    eval 'sub sk_KRB5_APREQBODY_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &KRB5_APREQBODY, ($st)));
    }' unless defined(&sk_KRB5_APREQBODY_num);
    eval 'sub sk_KRB5_APREQBODY_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &KRB5_APREQBODY, ($st), ($i)));
    }' unless defined(&sk_KRB5_APREQBODY_value);
    eval 'sub sk_KRB5_APREQBODY_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &KRB5_APREQBODY, ($st), ($i), ($val)));
    }' unless defined(&sk_KRB5_APREQBODY_set);
    eval 'sub sk_KRB5_APREQBODY_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &KRB5_APREQBODY, ($st)));
    }' unless defined(&sk_KRB5_APREQBODY_zero);
    eval 'sub sk_KRB5_APREQBODY_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &KRB5_APREQBODY, ($st), ($val)));
    }' unless defined(&sk_KRB5_APREQBODY_push);
    eval 'sub sk_KRB5_APREQBODY_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &KRB5_APREQBODY, ($st), ($val)));
    }' unless defined(&sk_KRB5_APREQBODY_unshift);
    eval 'sub sk_KRB5_APREQBODY_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &KRB5_APREQBODY, ($st), ($val)));
    }' unless defined(&sk_KRB5_APREQBODY_find);
    eval 'sub sk_KRB5_APREQBODY_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &KRB5_APREQBODY, ($st), ($i)));
    }' unless defined(&sk_KRB5_APREQBODY_delete);
    eval 'sub sk_KRB5_APREQBODY_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &KRB5_APREQBODY, ($st), ($ptr)));
    }' unless defined(&sk_KRB5_APREQBODY_delete_ptr);
    eval 'sub sk_KRB5_APREQBODY_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &KRB5_APREQBODY, ($st), ($val), ($i)));
    }' unless defined(&sk_KRB5_APREQBODY_insert);
    eval 'sub sk_KRB5_APREQBODY_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &KRB5_APREQBODY, ($st), ($cmp)));
    }' unless defined(&sk_KRB5_APREQBODY_set_cmp_func);
    eval 'sub sk_KRB5_APREQBODY_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &KRB5_APREQBODY, $st));
    }' unless defined(&sk_KRB5_APREQBODY_dup);
    eval 'sub sk_KRB5_APREQBODY_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &KRB5_APREQBODY, ($st), ($free_func)));
    }' unless defined(&sk_KRB5_APREQBODY_pop_free);
    eval 'sub sk_KRB5_APREQBODY_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &KRB5_APREQBODY, ($st)));
    }' unless defined(&sk_KRB5_APREQBODY_shift);
    eval 'sub sk_KRB5_APREQBODY_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &KRB5_APREQBODY, ($st)));
    }' unless defined(&sk_KRB5_APREQBODY_pop);
    eval 'sub sk_KRB5_APREQBODY_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &KRB5_APREQBODY, ($st)));
    }' unless defined(&sk_KRB5_APREQBODY_sort);
    eval 'sub sk_KRB5_APREQBODY_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &KRB5_APREQBODY, ($st)));
    }' unless defined(&sk_KRB5_APREQBODY_is_sorted);
    eval 'sub sk_KRB5_AUTHDATA_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &KRB5_AUTHDATA, ($st)));
    }' unless defined(&sk_KRB5_AUTHDATA_new);
    eval 'sub sk_KRB5_AUTHDATA_new_null () {
        eval q( &SKM_sk_new_null( &KRB5_AUTHDATA));
    }' unless defined(&sk_KRB5_AUTHDATA_new_null);
    eval 'sub sk_KRB5_AUTHDATA_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &KRB5_AUTHDATA, ($st)));
    }' unless defined(&sk_KRB5_AUTHDATA_free);
    eval 'sub sk_KRB5_AUTHDATA_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &KRB5_AUTHDATA, ($st)));
    }' unless defined(&sk_KRB5_AUTHDATA_num);
    eval 'sub sk_KRB5_AUTHDATA_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &KRB5_AUTHDATA, ($st), ($i)));
    }' unless defined(&sk_KRB5_AUTHDATA_value);
    eval 'sub sk_KRB5_AUTHDATA_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &KRB5_AUTHDATA, ($st), ($i), ($val)));
    }' unless defined(&sk_KRB5_AUTHDATA_set);
    eval 'sub sk_KRB5_AUTHDATA_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &KRB5_AUTHDATA, ($st)));
    }' unless defined(&sk_KRB5_AUTHDATA_zero);
    eval 'sub sk_KRB5_AUTHDATA_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &KRB5_AUTHDATA, ($st), ($val)));
    }' unless defined(&sk_KRB5_AUTHDATA_push);
    eval 'sub sk_KRB5_AUTHDATA_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &KRB5_AUTHDATA, ($st), ($val)));
    }' unless defined(&sk_KRB5_AUTHDATA_unshift);
    eval 'sub sk_KRB5_AUTHDATA_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &KRB5_AUTHDATA, ($st), ($val)));
    }' unless defined(&sk_KRB5_AUTHDATA_find);
    eval 'sub sk_KRB5_AUTHDATA_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &KRB5_AUTHDATA, ($st), ($i)));
    }' unless defined(&sk_KRB5_AUTHDATA_delete);
    eval 'sub sk_KRB5_AUTHDATA_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &KRB5_AUTHDATA, ($st), ($ptr)));
    }' unless defined(&sk_KRB5_AUTHDATA_delete_ptr);
    eval 'sub sk_KRB5_AUTHDATA_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &KRB5_AUTHDATA, ($st), ($val), ($i)));
    }' unless defined(&sk_KRB5_AUTHDATA_insert);
    eval 'sub sk_KRB5_AUTHDATA_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &KRB5_AUTHDATA, ($st), ($cmp)));
    }' unless defined(&sk_KRB5_AUTHDATA_set_cmp_func);
    eval 'sub sk_KRB5_AUTHDATA_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &KRB5_AUTHDATA, $st));
    }' unless defined(&sk_KRB5_AUTHDATA_dup);
    eval 'sub sk_KRB5_AUTHDATA_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &KRB5_AUTHDATA, ($st), ($free_func)));
    }' unless defined(&sk_KRB5_AUTHDATA_pop_free);
    eval 'sub sk_KRB5_AUTHDATA_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &KRB5_AUTHDATA, ($st)));
    }' unless defined(&sk_KRB5_AUTHDATA_shift);
    eval 'sub sk_KRB5_AUTHDATA_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &KRB5_AUTHDATA, ($st)));
    }' unless defined(&sk_KRB5_AUTHDATA_pop);
    eval 'sub sk_KRB5_AUTHDATA_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &KRB5_AUTHDATA, ($st)));
    }' unless defined(&sk_KRB5_AUTHDATA_sort);
    eval 'sub sk_KRB5_AUTHDATA_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &KRB5_AUTHDATA, ($st)));
    }' unless defined(&sk_KRB5_AUTHDATA_is_sorted);
    eval 'sub sk_KRB5_AUTHENTBODY_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &KRB5_AUTHENTBODY, ($st)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_new);
    eval 'sub sk_KRB5_AUTHENTBODY_new_null () {
        eval q( &SKM_sk_new_null( &KRB5_AUTHENTBODY));
    }' unless defined(&sk_KRB5_AUTHENTBODY_new_null);
    eval 'sub sk_KRB5_AUTHENTBODY_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &KRB5_AUTHENTBODY, ($st)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_free);
    eval 'sub sk_KRB5_AUTHENTBODY_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &KRB5_AUTHENTBODY, ($st)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_num);
    eval 'sub sk_KRB5_AUTHENTBODY_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &KRB5_AUTHENTBODY, ($st), ($i)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_value);
    eval 'sub sk_KRB5_AUTHENTBODY_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &KRB5_AUTHENTBODY, ($st), ($i), ($val)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_set);
    eval 'sub sk_KRB5_AUTHENTBODY_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &KRB5_AUTHENTBODY, ($st)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_zero);
    eval 'sub sk_KRB5_AUTHENTBODY_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &KRB5_AUTHENTBODY, ($st), ($val)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_push);
    eval 'sub sk_KRB5_AUTHENTBODY_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &KRB5_AUTHENTBODY, ($st), ($val)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_unshift);
    eval 'sub sk_KRB5_AUTHENTBODY_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &KRB5_AUTHENTBODY, ($st), ($val)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_find);
    eval 'sub sk_KRB5_AUTHENTBODY_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &KRB5_AUTHENTBODY, ($st), ($i)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_delete);
    eval 'sub sk_KRB5_AUTHENTBODY_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &KRB5_AUTHENTBODY, ($st), ($ptr)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_delete_ptr);
    eval 'sub sk_KRB5_AUTHENTBODY_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &KRB5_AUTHENTBODY, ($st), ($val), ($i)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_insert);
    eval 'sub sk_KRB5_AUTHENTBODY_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &KRB5_AUTHENTBODY, ($st), ($cmp)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_set_cmp_func);
    eval 'sub sk_KRB5_AUTHENTBODY_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &KRB5_AUTHENTBODY, $st));
    }' unless defined(&sk_KRB5_AUTHENTBODY_dup);
    eval 'sub sk_KRB5_AUTHENTBODY_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &KRB5_AUTHENTBODY, ($st), ($free_func)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_pop_free);
    eval 'sub sk_KRB5_AUTHENTBODY_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &KRB5_AUTHENTBODY, ($st)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_shift);
    eval 'sub sk_KRB5_AUTHENTBODY_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &KRB5_AUTHENTBODY, ($st)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_pop);
    eval 'sub sk_KRB5_AUTHENTBODY_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &KRB5_AUTHENTBODY, ($st)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_sort);
    eval 'sub sk_KRB5_AUTHENTBODY_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &KRB5_AUTHENTBODY, ($st)));
    }' unless defined(&sk_KRB5_AUTHENTBODY_is_sorted);
    eval 'sub sk_KRB5_CHECKSUM_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &KRB5_CHECKSUM, ($st)));
    }' unless defined(&sk_KRB5_CHECKSUM_new);
    eval 'sub sk_KRB5_CHECKSUM_new_null () {
        eval q( &SKM_sk_new_null( &KRB5_CHECKSUM));
    }' unless defined(&sk_KRB5_CHECKSUM_new_null);
    eval 'sub sk_KRB5_CHECKSUM_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &KRB5_CHECKSUM, ($st)));
    }' unless defined(&sk_KRB5_CHECKSUM_free);
    eval 'sub sk_KRB5_CHECKSUM_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &KRB5_CHECKSUM, ($st)));
    }' unless defined(&sk_KRB5_CHECKSUM_num);
    eval 'sub sk_KRB5_CHECKSUM_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &KRB5_CHECKSUM, ($st), ($i)));
    }' unless defined(&sk_KRB5_CHECKSUM_value);
    eval 'sub sk_KRB5_CHECKSUM_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &KRB5_CHECKSUM, ($st), ($i), ($val)));
    }' unless defined(&sk_KRB5_CHECKSUM_set);
    eval 'sub sk_KRB5_CHECKSUM_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &KRB5_CHECKSUM, ($st)));
    }' unless defined(&sk_KRB5_CHECKSUM_zero);
    eval 'sub sk_KRB5_CHECKSUM_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &KRB5_CHECKSUM, ($st), ($val)));
    }' unless defined(&sk_KRB5_CHECKSUM_push);
    eval 'sub sk_KRB5_CHECKSUM_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &KRB5_CHECKSUM, ($st), ($val)));
    }' unless defined(&sk_KRB5_CHECKSUM_unshift);
    eval 'sub sk_KRB5_CHECKSUM_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &KRB5_CHECKSUM, ($st), ($val)));
    }' unless defined(&sk_KRB5_CHECKSUM_find);
    eval 'sub sk_KRB5_CHECKSUM_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &KRB5_CHECKSUM, ($st), ($i)));
    }' unless defined(&sk_KRB5_CHECKSUM_delete);
    eval 'sub sk_KRB5_CHECKSUM_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &KRB5_CHECKSUM, ($st), ($ptr)));
    }' unless defined(&sk_KRB5_CHECKSUM_delete_ptr);
    eval 'sub sk_KRB5_CHECKSUM_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &KRB5_CHECKSUM, ($st), ($val), ($i)));
    }' unless defined(&sk_KRB5_CHECKSUM_insert);
    eval 'sub sk_KRB5_CHECKSUM_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &KRB5_CHECKSUM, ($st), ($cmp)));
    }' unless defined(&sk_KRB5_CHECKSUM_set_cmp_func);
    eval 'sub sk_KRB5_CHECKSUM_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &KRB5_CHECKSUM, $st));
    }' unless defined(&sk_KRB5_CHECKSUM_dup);
    eval 'sub sk_KRB5_CHECKSUM_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &KRB5_CHECKSUM, ($st), ($free_func)));
    }' unless defined(&sk_KRB5_CHECKSUM_pop_free);
    eval 'sub sk_KRB5_CHECKSUM_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &KRB5_CHECKSUM, ($st)));
    }' unless defined(&sk_KRB5_CHECKSUM_shift);
    eval 'sub sk_KRB5_CHECKSUM_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &KRB5_CHECKSUM, ($st)));
    }' unless defined(&sk_KRB5_CHECKSUM_pop);
    eval 'sub sk_KRB5_CHECKSUM_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &KRB5_CHECKSUM, ($st)));
    }' unless defined(&sk_KRB5_CHECKSUM_sort);
    eval 'sub sk_KRB5_CHECKSUM_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &KRB5_CHECKSUM, ($st)));
    }' unless defined(&sk_KRB5_CHECKSUM_is_sorted);
    eval 'sub sk_KRB5_ENCDATA_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &KRB5_ENCDATA, ($st)));
    }' unless defined(&sk_KRB5_ENCDATA_new);
    eval 'sub sk_KRB5_ENCDATA_new_null () {
        eval q( &SKM_sk_new_null( &KRB5_ENCDATA));
    }' unless defined(&sk_KRB5_ENCDATA_new_null);
    eval 'sub sk_KRB5_ENCDATA_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &KRB5_ENCDATA, ($st)));
    }' unless defined(&sk_KRB5_ENCDATA_free);
    eval 'sub sk_KRB5_ENCDATA_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &KRB5_ENCDATA, ($st)));
    }' unless defined(&sk_KRB5_ENCDATA_num);
    eval 'sub sk_KRB5_ENCDATA_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &KRB5_ENCDATA, ($st), ($i)));
    }' unless defined(&sk_KRB5_ENCDATA_value);
    eval 'sub sk_KRB5_ENCDATA_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &KRB5_ENCDATA, ($st), ($i), ($val)));
    }' unless defined(&sk_KRB5_ENCDATA_set);
    eval 'sub sk_KRB5_ENCDATA_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &KRB5_ENCDATA, ($st)));
    }' unless defined(&sk_KRB5_ENCDATA_zero);
    eval 'sub sk_KRB5_ENCDATA_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &KRB5_ENCDATA, ($st), ($val)));
    }' unless defined(&sk_KRB5_ENCDATA_push);
    eval 'sub sk_KRB5_ENCDATA_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &KRB5_ENCDATA, ($st), ($val)));
    }' unless defined(&sk_KRB5_ENCDATA_unshift);
    eval 'sub sk_KRB5_ENCDATA_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &KRB5_ENCDATA, ($st), ($val)));
    }' unless defined(&sk_KRB5_ENCDATA_find);
    eval 'sub sk_KRB5_ENCDATA_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &KRB5_ENCDATA, ($st), ($i)));
    }' unless defined(&sk_KRB5_ENCDATA_delete);
    eval 'sub sk_KRB5_ENCDATA_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &KRB5_ENCDATA, ($st), ($ptr)));
    }' unless defined(&sk_KRB5_ENCDATA_delete_ptr);
    eval 'sub sk_KRB5_ENCDATA_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &KRB5_ENCDATA, ($st), ($val), ($i)));
    }' unless defined(&sk_KRB5_ENCDATA_insert);
    eval 'sub sk_KRB5_ENCDATA_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &KRB5_ENCDATA, ($st), ($cmp)));
    }' unless defined(&sk_KRB5_ENCDATA_set_cmp_func);
    eval 'sub sk_KRB5_ENCDATA_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &KRB5_ENCDATA, $st));
    }' unless defined(&sk_KRB5_ENCDATA_dup);
    eval 'sub sk_KRB5_ENCDATA_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &KRB5_ENCDATA, ($st), ($free_func)));
    }' unless defined(&sk_KRB5_ENCDATA_pop_free);
    eval 'sub sk_KRB5_ENCDATA_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &KRB5_ENCDATA, ($st)));
    }' unless defined(&sk_KRB5_ENCDATA_shift);
    eval 'sub sk_KRB5_ENCDATA_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &KRB5_ENCDATA, ($st)));
    }' unless defined(&sk_KRB5_ENCDATA_pop);
    eval 'sub sk_KRB5_ENCDATA_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &KRB5_ENCDATA, ($st)));
    }' unless defined(&sk_KRB5_ENCDATA_sort);
    eval 'sub sk_KRB5_ENCDATA_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &KRB5_ENCDATA, ($st)));
    }' unless defined(&sk_KRB5_ENCDATA_is_sorted);
    eval 'sub sk_KRB5_ENCKEY_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &KRB5_ENCKEY, ($st)));
    }' unless defined(&sk_KRB5_ENCKEY_new);
    eval 'sub sk_KRB5_ENCKEY_new_null () {
        eval q( &SKM_sk_new_null( &KRB5_ENCKEY));
    }' unless defined(&sk_KRB5_ENCKEY_new_null);
    eval 'sub sk_KRB5_ENCKEY_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &KRB5_ENCKEY, ($st)));
    }' unless defined(&sk_KRB5_ENCKEY_free);
    eval 'sub sk_KRB5_ENCKEY_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &KRB5_ENCKEY, ($st)));
    }' unless defined(&sk_KRB5_ENCKEY_num);
    eval 'sub sk_KRB5_ENCKEY_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &KRB5_ENCKEY, ($st), ($i)));
    }' unless defined(&sk_KRB5_ENCKEY_value);
    eval 'sub sk_KRB5_ENCKEY_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &KRB5_ENCKEY, ($st), ($i), ($val)));
    }' unless defined(&sk_KRB5_ENCKEY_set);
    eval 'sub sk_KRB5_ENCKEY_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &KRB5_ENCKEY, ($st)));
    }' unless defined(&sk_KRB5_ENCKEY_zero);
    eval 'sub sk_KRB5_ENCKEY_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &KRB5_ENCKEY, ($st), ($val)));
    }' unless defined(&sk_KRB5_ENCKEY_push);
    eval 'sub sk_KRB5_ENCKEY_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &KRB5_ENCKEY, ($st), ($val)));
    }' unless defined(&sk_KRB5_ENCKEY_unshift);
    eval 'sub sk_KRB5_ENCKEY_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &KRB5_ENCKEY, ($st), ($val)));
    }' unless defined(&sk_KRB5_ENCKEY_find);
    eval 'sub sk_KRB5_ENCKEY_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &KRB5_ENCKEY, ($st), ($i)));
    }' unless defined(&sk_KRB5_ENCKEY_delete);
    eval 'sub sk_KRB5_ENCKEY_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &KRB5_ENCKEY, ($st), ($ptr)));
    }' unless defined(&sk_KRB5_ENCKEY_delete_ptr);
    eval 'sub sk_KRB5_ENCKEY_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &KRB5_ENCKEY, ($st), ($val), ($i)));
    }' unless defined(&sk_KRB5_ENCKEY_insert);
    eval 'sub sk_KRB5_ENCKEY_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &KRB5_ENCKEY, ($st), ($cmp)));
    }' unless defined(&sk_KRB5_ENCKEY_set_cmp_func);
    eval 'sub sk_KRB5_ENCKEY_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &KRB5_ENCKEY, $st));
    }' unless defined(&sk_KRB5_ENCKEY_dup);
    eval 'sub sk_KRB5_ENCKEY_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &KRB5_ENCKEY, ($st), ($free_func)));
    }' unless defined(&sk_KRB5_ENCKEY_pop_free);
    eval 'sub sk_KRB5_ENCKEY_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &KRB5_ENCKEY, ($st)));
    }' unless defined(&sk_KRB5_ENCKEY_shift);
    eval 'sub sk_KRB5_ENCKEY_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &KRB5_ENCKEY, ($st)));
    }' unless defined(&sk_KRB5_ENCKEY_pop);
    eval 'sub sk_KRB5_ENCKEY_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &KRB5_ENCKEY, ($st)));
    }' unless defined(&sk_KRB5_ENCKEY_sort);
    eval 'sub sk_KRB5_ENCKEY_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &KRB5_ENCKEY, ($st)));
    }' unless defined(&sk_KRB5_ENCKEY_is_sorted);
    eval 'sub sk_KRB5_PRINCNAME_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &KRB5_PRINCNAME, ($st)));
    }' unless defined(&sk_KRB5_PRINCNAME_new);
    eval 'sub sk_KRB5_PRINCNAME_new_null () {
        eval q( &SKM_sk_new_null( &KRB5_PRINCNAME));
    }' unless defined(&sk_KRB5_PRINCNAME_new_null);
    eval 'sub sk_KRB5_PRINCNAME_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &KRB5_PRINCNAME, ($st)));
    }' unless defined(&sk_KRB5_PRINCNAME_free);
    eval 'sub sk_KRB5_PRINCNAME_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &KRB5_PRINCNAME, ($st)));
    }' unless defined(&sk_KRB5_PRINCNAME_num);
    eval 'sub sk_KRB5_PRINCNAME_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &KRB5_PRINCNAME, ($st), ($i)));
    }' unless defined(&sk_KRB5_PRINCNAME_value);
    eval 'sub sk_KRB5_PRINCNAME_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &KRB5_PRINCNAME, ($st), ($i), ($val)));
    }' unless defined(&sk_KRB5_PRINCNAME_set);
    eval 'sub sk_KRB5_PRINCNAME_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &KRB5_PRINCNAME, ($st)));
    }' unless defined(&sk_KRB5_PRINCNAME_zero);
    eval 'sub sk_KRB5_PRINCNAME_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &KRB5_PRINCNAME, ($st), ($val)));
    }' unless defined(&sk_KRB5_PRINCNAME_push);
    eval 'sub sk_KRB5_PRINCNAME_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &KRB5_PRINCNAME, ($st), ($val)));
    }' unless defined(&sk_KRB5_PRINCNAME_unshift);
    eval 'sub sk_KRB5_PRINCNAME_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &KRB5_PRINCNAME, ($st), ($val)));
    }' unless defined(&sk_KRB5_PRINCNAME_find);
    eval 'sub sk_KRB5_PRINCNAME_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &KRB5_PRINCNAME, ($st), ($i)));
    }' unless defined(&sk_KRB5_PRINCNAME_delete);
    eval 'sub sk_KRB5_PRINCNAME_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &KRB5_PRINCNAME, ($st), ($ptr)));
    }' unless defined(&sk_KRB5_PRINCNAME_delete_ptr);
    eval 'sub sk_KRB5_PRINCNAME_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &KRB5_PRINCNAME, ($st), ($val), ($i)));
    }' unless defined(&sk_KRB5_PRINCNAME_insert);
    eval 'sub sk_KRB5_PRINCNAME_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &KRB5_PRINCNAME, ($st), ($cmp)));
    }' unless defined(&sk_KRB5_PRINCNAME_set_cmp_func);
    eval 'sub sk_KRB5_PRINCNAME_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &KRB5_PRINCNAME, $st));
    }' unless defined(&sk_KRB5_PRINCNAME_dup);
    eval 'sub sk_KRB5_PRINCNAME_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &KRB5_PRINCNAME, ($st), ($free_func)));
    }' unless defined(&sk_KRB5_PRINCNAME_pop_free);
    eval 'sub sk_KRB5_PRINCNAME_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &KRB5_PRINCNAME, ($st)));
    }' unless defined(&sk_KRB5_PRINCNAME_shift);
    eval 'sub sk_KRB5_PRINCNAME_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &KRB5_PRINCNAME, ($st)));
    }' unless defined(&sk_KRB5_PRINCNAME_pop);
    eval 'sub sk_KRB5_PRINCNAME_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &KRB5_PRINCNAME, ($st)));
    }' unless defined(&sk_KRB5_PRINCNAME_sort);
    eval 'sub sk_KRB5_PRINCNAME_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &KRB5_PRINCNAME, ($st)));
    }' unless defined(&sk_KRB5_PRINCNAME_is_sorted);
    eval 'sub sk_KRB5_TKTBODY_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &KRB5_TKTBODY, ($st)));
    }' unless defined(&sk_KRB5_TKTBODY_new);
    eval 'sub sk_KRB5_TKTBODY_new_null () {
        eval q( &SKM_sk_new_null( &KRB5_TKTBODY));
    }' unless defined(&sk_KRB5_TKTBODY_new_null);
    eval 'sub sk_KRB5_TKTBODY_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &KRB5_TKTBODY, ($st)));
    }' unless defined(&sk_KRB5_TKTBODY_free);
    eval 'sub sk_KRB5_TKTBODY_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &KRB5_TKTBODY, ($st)));
    }' unless defined(&sk_KRB5_TKTBODY_num);
    eval 'sub sk_KRB5_TKTBODY_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &KRB5_TKTBODY, ($st), ($i)));
    }' unless defined(&sk_KRB5_TKTBODY_value);
    eval 'sub sk_KRB5_TKTBODY_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &KRB5_TKTBODY, ($st), ($i), ($val)));
    }' unless defined(&sk_KRB5_TKTBODY_set);
    eval 'sub sk_KRB5_TKTBODY_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &KRB5_TKTBODY, ($st)));
    }' unless defined(&sk_KRB5_TKTBODY_zero);
    eval 'sub sk_KRB5_TKTBODY_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &KRB5_TKTBODY, ($st), ($val)));
    }' unless defined(&sk_KRB5_TKTBODY_push);
    eval 'sub sk_KRB5_TKTBODY_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &KRB5_TKTBODY, ($st), ($val)));
    }' unless defined(&sk_KRB5_TKTBODY_unshift);
    eval 'sub sk_KRB5_TKTBODY_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &KRB5_TKTBODY, ($st), ($val)));
    }' unless defined(&sk_KRB5_TKTBODY_find);
    eval 'sub sk_KRB5_TKTBODY_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &KRB5_TKTBODY, ($st), ($i)));
    }' unless defined(&sk_KRB5_TKTBODY_delete);
    eval 'sub sk_KRB5_TKTBODY_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &KRB5_TKTBODY, ($st), ($ptr)));
    }' unless defined(&sk_KRB5_TKTBODY_delete_ptr);
    eval 'sub sk_KRB5_TKTBODY_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &KRB5_TKTBODY, ($st), ($val), ($i)));
    }' unless defined(&sk_KRB5_TKTBODY_insert);
    eval 'sub sk_KRB5_TKTBODY_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &KRB5_TKTBODY, ($st), ($cmp)));
    }' unless defined(&sk_KRB5_TKTBODY_set_cmp_func);
    eval 'sub sk_KRB5_TKTBODY_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &KRB5_TKTBODY, $st));
    }' unless defined(&sk_KRB5_TKTBODY_dup);
    eval 'sub sk_KRB5_TKTBODY_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &KRB5_TKTBODY, ($st), ($free_func)));
    }' unless defined(&sk_KRB5_TKTBODY_pop_free);
    eval 'sub sk_KRB5_TKTBODY_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &KRB5_TKTBODY, ($st)));
    }' unless defined(&sk_KRB5_TKTBODY_shift);
    eval 'sub sk_KRB5_TKTBODY_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &KRB5_TKTBODY, ($st)));
    }' unless defined(&sk_KRB5_TKTBODY_pop);
    eval 'sub sk_KRB5_TKTBODY_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &KRB5_TKTBODY, ($st)));
    }' unless defined(&sk_KRB5_TKTBODY_sort);
    eval 'sub sk_KRB5_TKTBODY_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &KRB5_TKTBODY, ($st)));
    }' unless defined(&sk_KRB5_TKTBODY_is_sorted);
    eval 'sub sk_MIME_HEADER_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &MIME_HEADER, ($st)));
    }' unless defined(&sk_MIME_HEADER_new);
    eval 'sub sk_MIME_HEADER_new_null () {
        eval q( &SKM_sk_new_null( &MIME_HEADER));
    }' unless defined(&sk_MIME_HEADER_new_null);
    eval 'sub sk_MIME_HEADER_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &MIME_HEADER, ($st)));
    }' unless defined(&sk_MIME_HEADER_free);
    eval 'sub sk_MIME_HEADER_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &MIME_HEADER, ($st)));
    }' unless defined(&sk_MIME_HEADER_num);
    eval 'sub sk_MIME_HEADER_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &MIME_HEADER, ($st), ($i)));
    }' unless defined(&sk_MIME_HEADER_value);
    eval 'sub sk_MIME_HEADER_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &MIME_HEADER, ($st), ($i), ($val)));
    }' unless defined(&sk_MIME_HEADER_set);
    eval 'sub sk_MIME_HEADER_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &MIME_HEADER, ($st)));
    }' unless defined(&sk_MIME_HEADER_zero);
    eval 'sub sk_MIME_HEADER_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &MIME_HEADER, ($st), ($val)));
    }' unless defined(&sk_MIME_HEADER_push);
    eval 'sub sk_MIME_HEADER_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &MIME_HEADER, ($st), ($val)));
    }' unless defined(&sk_MIME_HEADER_unshift);
    eval 'sub sk_MIME_HEADER_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &MIME_HEADER, ($st), ($val)));
    }' unless defined(&sk_MIME_HEADER_find);
    eval 'sub sk_MIME_HEADER_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &MIME_HEADER, ($st), ($i)));
    }' unless defined(&sk_MIME_HEADER_delete);
    eval 'sub sk_MIME_HEADER_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &MIME_HEADER, ($st), ($ptr)));
    }' unless defined(&sk_MIME_HEADER_delete_ptr);
    eval 'sub sk_MIME_HEADER_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &MIME_HEADER, ($st), ($val), ($i)));
    }' unless defined(&sk_MIME_HEADER_insert);
    eval 'sub sk_MIME_HEADER_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &MIME_HEADER, ($st), ($cmp)));
    }' unless defined(&sk_MIME_HEADER_set_cmp_func);
    eval 'sub sk_MIME_HEADER_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &MIME_HEADER, $st));
    }' unless defined(&sk_MIME_HEADER_dup);
    eval 'sub sk_MIME_HEADER_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &MIME_HEADER, ($st), ($free_func)));
    }' unless defined(&sk_MIME_HEADER_pop_free);
    eval 'sub sk_MIME_HEADER_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &MIME_HEADER, ($st)));
    }' unless defined(&sk_MIME_HEADER_shift);
    eval 'sub sk_MIME_HEADER_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &MIME_HEADER, ($st)));
    }' unless defined(&sk_MIME_HEADER_pop);
    eval 'sub sk_MIME_HEADER_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &MIME_HEADER, ($st)));
    }' unless defined(&sk_MIME_HEADER_sort);
    eval 'sub sk_MIME_HEADER_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &MIME_HEADER, ($st)));
    }' unless defined(&sk_MIME_HEADER_is_sorted);
    eval 'sub sk_MIME_PARAM_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &MIME_PARAM, ($st)));
    }' unless defined(&sk_MIME_PARAM_new);
    eval 'sub sk_MIME_PARAM_new_null () {
        eval q( &SKM_sk_new_null( &MIME_PARAM));
    }' unless defined(&sk_MIME_PARAM_new_null);
    eval 'sub sk_MIME_PARAM_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &MIME_PARAM, ($st)));
    }' unless defined(&sk_MIME_PARAM_free);
    eval 'sub sk_MIME_PARAM_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &MIME_PARAM, ($st)));
    }' unless defined(&sk_MIME_PARAM_num);
    eval 'sub sk_MIME_PARAM_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &MIME_PARAM, ($st), ($i)));
    }' unless defined(&sk_MIME_PARAM_value);
    eval 'sub sk_MIME_PARAM_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &MIME_PARAM, ($st), ($i), ($val)));
    }' unless defined(&sk_MIME_PARAM_set);
    eval 'sub sk_MIME_PARAM_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &MIME_PARAM, ($st)));
    }' unless defined(&sk_MIME_PARAM_zero);
    eval 'sub sk_MIME_PARAM_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &MIME_PARAM, ($st), ($val)));
    }' unless defined(&sk_MIME_PARAM_push);
    eval 'sub sk_MIME_PARAM_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &MIME_PARAM, ($st), ($val)));
    }' unless defined(&sk_MIME_PARAM_unshift);
    eval 'sub sk_MIME_PARAM_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &MIME_PARAM, ($st), ($val)));
    }' unless defined(&sk_MIME_PARAM_find);
    eval 'sub sk_MIME_PARAM_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &MIME_PARAM, ($st), ($i)));
    }' unless defined(&sk_MIME_PARAM_delete);
    eval 'sub sk_MIME_PARAM_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &MIME_PARAM, ($st), ($ptr)));
    }' unless defined(&sk_MIME_PARAM_delete_ptr);
    eval 'sub sk_MIME_PARAM_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &MIME_PARAM, ($st), ($val), ($i)));
    }' unless defined(&sk_MIME_PARAM_insert);
    eval 'sub sk_MIME_PARAM_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &MIME_PARAM, ($st), ($cmp)));
    }' unless defined(&sk_MIME_PARAM_set_cmp_func);
    eval 'sub sk_MIME_PARAM_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &MIME_PARAM, $st));
    }' unless defined(&sk_MIME_PARAM_dup);
    eval 'sub sk_MIME_PARAM_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &MIME_PARAM, ($st), ($free_func)));
    }' unless defined(&sk_MIME_PARAM_pop_free);
    eval 'sub sk_MIME_PARAM_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &MIME_PARAM, ($st)));
    }' unless defined(&sk_MIME_PARAM_shift);
    eval 'sub sk_MIME_PARAM_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &MIME_PARAM, ($st)));
    }' unless defined(&sk_MIME_PARAM_pop);
    eval 'sub sk_MIME_PARAM_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &MIME_PARAM, ($st)));
    }' unless defined(&sk_MIME_PARAM_sort);
    eval 'sub sk_MIME_PARAM_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &MIME_PARAM, ($st)));
    }' unless defined(&sk_MIME_PARAM_is_sorted);
    eval 'sub sk_NAME_FUNCS_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &NAME_FUNCS, ($st)));
    }' unless defined(&sk_NAME_FUNCS_new);
    eval 'sub sk_NAME_FUNCS_new_null () {
        eval q( &SKM_sk_new_null( &NAME_FUNCS));
    }' unless defined(&sk_NAME_FUNCS_new_null);
    eval 'sub sk_NAME_FUNCS_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &NAME_FUNCS, ($st)));
    }' unless defined(&sk_NAME_FUNCS_free);
    eval 'sub sk_NAME_FUNCS_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &NAME_FUNCS, ($st)));
    }' unless defined(&sk_NAME_FUNCS_num);
    eval 'sub sk_NAME_FUNCS_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &NAME_FUNCS, ($st), ($i)));
    }' unless defined(&sk_NAME_FUNCS_value);
    eval 'sub sk_NAME_FUNCS_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &NAME_FUNCS, ($st), ($i), ($val)));
    }' unless defined(&sk_NAME_FUNCS_set);
    eval 'sub sk_NAME_FUNCS_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &NAME_FUNCS, ($st)));
    }' unless defined(&sk_NAME_FUNCS_zero);
    eval 'sub sk_NAME_FUNCS_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &NAME_FUNCS, ($st), ($val)));
    }' unless defined(&sk_NAME_FUNCS_push);
    eval 'sub sk_NAME_FUNCS_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &NAME_FUNCS, ($st), ($val)));
    }' unless defined(&sk_NAME_FUNCS_unshift);
    eval 'sub sk_NAME_FUNCS_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &NAME_FUNCS, ($st), ($val)));
    }' unless defined(&sk_NAME_FUNCS_find);
    eval 'sub sk_NAME_FUNCS_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &NAME_FUNCS, ($st), ($i)));
    }' unless defined(&sk_NAME_FUNCS_delete);
    eval 'sub sk_NAME_FUNCS_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &NAME_FUNCS, ($st), ($ptr)));
    }' unless defined(&sk_NAME_FUNCS_delete_ptr);
    eval 'sub sk_NAME_FUNCS_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &NAME_FUNCS, ($st), ($val), ($i)));
    }' unless defined(&sk_NAME_FUNCS_insert);
    eval 'sub sk_NAME_FUNCS_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &NAME_FUNCS, ($st), ($cmp)));
    }' unless defined(&sk_NAME_FUNCS_set_cmp_func);
    eval 'sub sk_NAME_FUNCS_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &NAME_FUNCS, $st));
    }' unless defined(&sk_NAME_FUNCS_dup);
    eval 'sub sk_NAME_FUNCS_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &NAME_FUNCS, ($st), ($free_func)));
    }' unless defined(&sk_NAME_FUNCS_pop_free);
    eval 'sub sk_NAME_FUNCS_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &NAME_FUNCS, ($st)));
    }' unless defined(&sk_NAME_FUNCS_shift);
    eval 'sub sk_NAME_FUNCS_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &NAME_FUNCS, ($st)));
    }' unless defined(&sk_NAME_FUNCS_pop);
    eval 'sub sk_NAME_FUNCS_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &NAME_FUNCS, ($st)));
    }' unless defined(&sk_NAME_FUNCS_sort);
    eval 'sub sk_NAME_FUNCS_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &NAME_FUNCS, ($st)));
    }' unless defined(&sk_NAME_FUNCS_is_sorted);
    eval 'sub sk_OCSP_CERTID_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &OCSP_CERTID, ($st)));
    }' unless defined(&sk_OCSP_CERTID_new);
    eval 'sub sk_OCSP_CERTID_new_null () {
        eval q( &SKM_sk_new_null( &OCSP_CERTID));
    }' unless defined(&sk_OCSP_CERTID_new_null);
    eval 'sub sk_OCSP_CERTID_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &OCSP_CERTID, ($st)));
    }' unless defined(&sk_OCSP_CERTID_free);
    eval 'sub sk_OCSP_CERTID_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &OCSP_CERTID, ($st)));
    }' unless defined(&sk_OCSP_CERTID_num);
    eval 'sub sk_OCSP_CERTID_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &OCSP_CERTID, ($st), ($i)));
    }' unless defined(&sk_OCSP_CERTID_value);
    eval 'sub sk_OCSP_CERTID_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &OCSP_CERTID, ($st), ($i), ($val)));
    }' unless defined(&sk_OCSP_CERTID_set);
    eval 'sub sk_OCSP_CERTID_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &OCSP_CERTID, ($st)));
    }' unless defined(&sk_OCSP_CERTID_zero);
    eval 'sub sk_OCSP_CERTID_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &OCSP_CERTID, ($st), ($val)));
    }' unless defined(&sk_OCSP_CERTID_push);
    eval 'sub sk_OCSP_CERTID_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &OCSP_CERTID, ($st), ($val)));
    }' unless defined(&sk_OCSP_CERTID_unshift);
    eval 'sub sk_OCSP_CERTID_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &OCSP_CERTID, ($st), ($val)));
    }' unless defined(&sk_OCSP_CERTID_find);
    eval 'sub sk_OCSP_CERTID_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &OCSP_CERTID, ($st), ($i)));
    }' unless defined(&sk_OCSP_CERTID_delete);
    eval 'sub sk_OCSP_CERTID_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &OCSP_CERTID, ($st), ($ptr)));
    }' unless defined(&sk_OCSP_CERTID_delete_ptr);
    eval 'sub sk_OCSP_CERTID_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &OCSP_CERTID, ($st), ($val), ($i)));
    }' unless defined(&sk_OCSP_CERTID_insert);
    eval 'sub sk_OCSP_CERTID_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &OCSP_CERTID, ($st), ($cmp)));
    }' unless defined(&sk_OCSP_CERTID_set_cmp_func);
    eval 'sub sk_OCSP_CERTID_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &OCSP_CERTID, $st));
    }' unless defined(&sk_OCSP_CERTID_dup);
    eval 'sub sk_OCSP_CERTID_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &OCSP_CERTID, ($st), ($free_func)));
    }' unless defined(&sk_OCSP_CERTID_pop_free);
    eval 'sub sk_OCSP_CERTID_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &OCSP_CERTID, ($st)));
    }' unless defined(&sk_OCSP_CERTID_shift);
    eval 'sub sk_OCSP_CERTID_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &OCSP_CERTID, ($st)));
    }' unless defined(&sk_OCSP_CERTID_pop);
    eval 'sub sk_OCSP_CERTID_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &OCSP_CERTID, ($st)));
    }' unless defined(&sk_OCSP_CERTID_sort);
    eval 'sub sk_OCSP_CERTID_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &OCSP_CERTID, ($st)));
    }' unless defined(&sk_OCSP_CERTID_is_sorted);
    eval 'sub sk_OCSP_ONEREQ_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &OCSP_ONEREQ, ($st)));
    }' unless defined(&sk_OCSP_ONEREQ_new);
    eval 'sub sk_OCSP_ONEREQ_new_null () {
        eval q( &SKM_sk_new_null( &OCSP_ONEREQ));
    }' unless defined(&sk_OCSP_ONEREQ_new_null);
    eval 'sub sk_OCSP_ONEREQ_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &OCSP_ONEREQ, ($st)));
    }' unless defined(&sk_OCSP_ONEREQ_free);
    eval 'sub sk_OCSP_ONEREQ_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &OCSP_ONEREQ, ($st)));
    }' unless defined(&sk_OCSP_ONEREQ_num);
    eval 'sub sk_OCSP_ONEREQ_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &OCSP_ONEREQ, ($st), ($i)));
    }' unless defined(&sk_OCSP_ONEREQ_value);
    eval 'sub sk_OCSP_ONEREQ_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &OCSP_ONEREQ, ($st), ($i), ($val)));
    }' unless defined(&sk_OCSP_ONEREQ_set);
    eval 'sub sk_OCSP_ONEREQ_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &OCSP_ONEREQ, ($st)));
    }' unless defined(&sk_OCSP_ONEREQ_zero);
    eval 'sub sk_OCSP_ONEREQ_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &OCSP_ONEREQ, ($st), ($val)));
    }' unless defined(&sk_OCSP_ONEREQ_push);
    eval 'sub sk_OCSP_ONEREQ_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &OCSP_ONEREQ, ($st), ($val)));
    }' unless defined(&sk_OCSP_ONEREQ_unshift);
    eval 'sub sk_OCSP_ONEREQ_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &OCSP_ONEREQ, ($st), ($val)));
    }' unless defined(&sk_OCSP_ONEREQ_find);
    eval 'sub sk_OCSP_ONEREQ_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &OCSP_ONEREQ, ($st), ($i)));
    }' unless defined(&sk_OCSP_ONEREQ_delete);
    eval 'sub sk_OCSP_ONEREQ_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &OCSP_ONEREQ, ($st), ($ptr)));
    }' unless defined(&sk_OCSP_ONEREQ_delete_ptr);
    eval 'sub sk_OCSP_ONEREQ_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &OCSP_ONEREQ, ($st), ($val), ($i)));
    }' unless defined(&sk_OCSP_ONEREQ_insert);
    eval 'sub sk_OCSP_ONEREQ_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &OCSP_ONEREQ, ($st), ($cmp)));
    }' unless defined(&sk_OCSP_ONEREQ_set_cmp_func);
    eval 'sub sk_OCSP_ONEREQ_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &OCSP_ONEREQ, $st));
    }' unless defined(&sk_OCSP_ONEREQ_dup);
    eval 'sub sk_OCSP_ONEREQ_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &OCSP_ONEREQ, ($st), ($free_func)));
    }' unless defined(&sk_OCSP_ONEREQ_pop_free);
    eval 'sub sk_OCSP_ONEREQ_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &OCSP_ONEREQ, ($st)));
    }' unless defined(&sk_OCSP_ONEREQ_shift);
    eval 'sub sk_OCSP_ONEREQ_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &OCSP_ONEREQ, ($st)));
    }' unless defined(&sk_OCSP_ONEREQ_pop);
    eval 'sub sk_OCSP_ONEREQ_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &OCSP_ONEREQ, ($st)));
    }' unless defined(&sk_OCSP_ONEREQ_sort);
    eval 'sub sk_OCSP_ONEREQ_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &OCSP_ONEREQ, ($st)));
    }' unless defined(&sk_OCSP_ONEREQ_is_sorted);
    eval 'sub sk_OCSP_SINGLERESP_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &OCSP_SINGLERESP, ($st)));
    }' unless defined(&sk_OCSP_SINGLERESP_new);
    eval 'sub sk_OCSP_SINGLERESP_new_null () {
        eval q( &SKM_sk_new_null( &OCSP_SINGLERESP));
    }' unless defined(&sk_OCSP_SINGLERESP_new_null);
    eval 'sub sk_OCSP_SINGLERESP_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &OCSP_SINGLERESP, ($st)));
    }' unless defined(&sk_OCSP_SINGLERESP_free);
    eval 'sub sk_OCSP_SINGLERESP_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &OCSP_SINGLERESP, ($st)));
    }' unless defined(&sk_OCSP_SINGLERESP_num);
    eval 'sub sk_OCSP_SINGLERESP_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &OCSP_SINGLERESP, ($st), ($i)));
    }' unless defined(&sk_OCSP_SINGLERESP_value);
    eval 'sub sk_OCSP_SINGLERESP_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &OCSP_SINGLERESP, ($st), ($i), ($val)));
    }' unless defined(&sk_OCSP_SINGLERESP_set);
    eval 'sub sk_OCSP_SINGLERESP_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &OCSP_SINGLERESP, ($st)));
    }' unless defined(&sk_OCSP_SINGLERESP_zero);
    eval 'sub sk_OCSP_SINGLERESP_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &OCSP_SINGLERESP, ($st), ($val)));
    }' unless defined(&sk_OCSP_SINGLERESP_push);
    eval 'sub sk_OCSP_SINGLERESP_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &OCSP_SINGLERESP, ($st), ($val)));
    }' unless defined(&sk_OCSP_SINGLERESP_unshift);
    eval 'sub sk_OCSP_SINGLERESP_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &OCSP_SINGLERESP, ($st), ($val)));
    }' unless defined(&sk_OCSP_SINGLERESP_find);
    eval 'sub sk_OCSP_SINGLERESP_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &OCSP_SINGLERESP, ($st), ($i)));
    }' unless defined(&sk_OCSP_SINGLERESP_delete);
    eval 'sub sk_OCSP_SINGLERESP_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &OCSP_SINGLERESP, ($st), ($ptr)));
    }' unless defined(&sk_OCSP_SINGLERESP_delete_ptr);
    eval 'sub sk_OCSP_SINGLERESP_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &OCSP_SINGLERESP, ($st), ($val), ($i)));
    }' unless defined(&sk_OCSP_SINGLERESP_insert);
    eval 'sub sk_OCSP_SINGLERESP_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &OCSP_SINGLERESP, ($st), ($cmp)));
    }' unless defined(&sk_OCSP_SINGLERESP_set_cmp_func);
    eval 'sub sk_OCSP_SINGLERESP_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &OCSP_SINGLERESP, $st));
    }' unless defined(&sk_OCSP_SINGLERESP_dup);
    eval 'sub sk_OCSP_SINGLERESP_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &OCSP_SINGLERESP, ($st), ($free_func)));
    }' unless defined(&sk_OCSP_SINGLERESP_pop_free);
    eval 'sub sk_OCSP_SINGLERESP_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &OCSP_SINGLERESP, ($st)));
    }' unless defined(&sk_OCSP_SINGLERESP_shift);
    eval 'sub sk_OCSP_SINGLERESP_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &OCSP_SINGLERESP, ($st)));
    }' unless defined(&sk_OCSP_SINGLERESP_pop);
    eval 'sub sk_OCSP_SINGLERESP_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &OCSP_SINGLERESP, ($st)));
    }' unless defined(&sk_OCSP_SINGLERESP_sort);
    eval 'sub sk_OCSP_SINGLERESP_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &OCSP_SINGLERESP, ($st)));
    }' unless defined(&sk_OCSP_SINGLERESP_is_sorted);
    eval 'sub sk_PKCS12_SAFEBAG_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &PKCS12_SAFEBAG, ($st)));
    }' unless defined(&sk_PKCS12_SAFEBAG_new);
    eval 'sub sk_PKCS12_SAFEBAG_new_null () {
        eval q( &SKM_sk_new_null( &PKCS12_SAFEBAG));
    }' unless defined(&sk_PKCS12_SAFEBAG_new_null);
    eval 'sub sk_PKCS12_SAFEBAG_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &PKCS12_SAFEBAG, ($st)));
    }' unless defined(&sk_PKCS12_SAFEBAG_free);
    eval 'sub sk_PKCS12_SAFEBAG_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &PKCS12_SAFEBAG, ($st)));
    }' unless defined(&sk_PKCS12_SAFEBAG_num);
    eval 'sub sk_PKCS12_SAFEBAG_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &PKCS12_SAFEBAG, ($st), ($i)));
    }' unless defined(&sk_PKCS12_SAFEBAG_value);
    eval 'sub sk_PKCS12_SAFEBAG_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &PKCS12_SAFEBAG, ($st), ($i), ($val)));
    }' unless defined(&sk_PKCS12_SAFEBAG_set);
    eval 'sub sk_PKCS12_SAFEBAG_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &PKCS12_SAFEBAG, ($st)));
    }' unless defined(&sk_PKCS12_SAFEBAG_zero);
    eval 'sub sk_PKCS12_SAFEBAG_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &PKCS12_SAFEBAG, ($st), ($val)));
    }' unless defined(&sk_PKCS12_SAFEBAG_push);
    eval 'sub sk_PKCS12_SAFEBAG_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &PKCS12_SAFEBAG, ($st), ($val)));
    }' unless defined(&sk_PKCS12_SAFEBAG_unshift);
    eval 'sub sk_PKCS12_SAFEBAG_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &PKCS12_SAFEBAG, ($st), ($val)));
    }' unless defined(&sk_PKCS12_SAFEBAG_find);
    eval 'sub sk_PKCS12_SAFEBAG_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &PKCS12_SAFEBAG, ($st), ($i)));
    }' unless defined(&sk_PKCS12_SAFEBAG_delete);
    eval 'sub sk_PKCS12_SAFEBAG_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &PKCS12_SAFEBAG, ($st), ($ptr)));
    }' unless defined(&sk_PKCS12_SAFEBAG_delete_ptr);
    eval 'sub sk_PKCS12_SAFEBAG_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &PKCS12_SAFEBAG, ($st), ($val), ($i)));
    }' unless defined(&sk_PKCS12_SAFEBAG_insert);
    eval 'sub sk_PKCS12_SAFEBAG_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &PKCS12_SAFEBAG, ($st), ($cmp)));
    }' unless defined(&sk_PKCS12_SAFEBAG_set_cmp_func);
    eval 'sub sk_PKCS12_SAFEBAG_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &PKCS12_SAFEBAG, $st));
    }' unless defined(&sk_PKCS12_SAFEBAG_dup);
    eval 'sub sk_PKCS12_SAFEBAG_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &PKCS12_SAFEBAG, ($st), ($free_func)));
    }' unless defined(&sk_PKCS12_SAFEBAG_pop_free);
    eval 'sub sk_PKCS12_SAFEBAG_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &PKCS12_SAFEBAG, ($st)));
    }' unless defined(&sk_PKCS12_SAFEBAG_shift);
    eval 'sub sk_PKCS12_SAFEBAG_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &PKCS12_SAFEBAG, ($st)));
    }' unless defined(&sk_PKCS12_SAFEBAG_pop);
    eval 'sub sk_PKCS12_SAFEBAG_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &PKCS12_SAFEBAG, ($st)));
    }' unless defined(&sk_PKCS12_SAFEBAG_sort);
    eval 'sub sk_PKCS12_SAFEBAG_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &PKCS12_SAFEBAG, ($st)));
    }' unless defined(&sk_PKCS12_SAFEBAG_is_sorted);
    eval 'sub sk_PKCS7_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &PKCS7, ($st)));
    }' unless defined(&sk_PKCS7_new);
    eval 'sub sk_PKCS7_new_null () {
        eval q( &SKM_sk_new_null( &PKCS7));
    }' unless defined(&sk_PKCS7_new_null);
    eval 'sub sk_PKCS7_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &PKCS7, ($st)));
    }' unless defined(&sk_PKCS7_free);
    eval 'sub sk_PKCS7_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &PKCS7, ($st)));
    }' unless defined(&sk_PKCS7_num);
    eval 'sub sk_PKCS7_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &PKCS7, ($st), ($i)));
    }' unless defined(&sk_PKCS7_value);
    eval 'sub sk_PKCS7_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &PKCS7, ($st), ($i), ($val)));
    }' unless defined(&sk_PKCS7_set);
    eval 'sub sk_PKCS7_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &PKCS7, ($st)));
    }' unless defined(&sk_PKCS7_zero);
    eval 'sub sk_PKCS7_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &PKCS7, ($st), ($val)));
    }' unless defined(&sk_PKCS7_push);
    eval 'sub sk_PKCS7_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &PKCS7, ($st), ($val)));
    }' unless defined(&sk_PKCS7_unshift);
    eval 'sub sk_PKCS7_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &PKCS7, ($st), ($val)));
    }' unless defined(&sk_PKCS7_find);
    eval 'sub sk_PKCS7_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &PKCS7, ($st), ($i)));
    }' unless defined(&sk_PKCS7_delete);
    eval 'sub sk_PKCS7_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &PKCS7, ($st), ($ptr)));
    }' unless defined(&sk_PKCS7_delete_ptr);
    eval 'sub sk_PKCS7_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &PKCS7, ($st), ($val), ($i)));
    }' unless defined(&sk_PKCS7_insert);
    eval 'sub sk_PKCS7_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &PKCS7, ($st), ($cmp)));
    }' unless defined(&sk_PKCS7_set_cmp_func);
    eval 'sub sk_PKCS7_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &PKCS7, $st));
    }' unless defined(&sk_PKCS7_dup);
    eval 'sub sk_PKCS7_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &PKCS7, ($st), ($free_func)));
    }' unless defined(&sk_PKCS7_pop_free);
    eval 'sub sk_PKCS7_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &PKCS7, ($st)));
    }' unless defined(&sk_PKCS7_shift);
    eval 'sub sk_PKCS7_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &PKCS7, ($st)));
    }' unless defined(&sk_PKCS7_pop);
    eval 'sub sk_PKCS7_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &PKCS7, ($st)));
    }' unless defined(&sk_PKCS7_sort);
    eval 'sub sk_PKCS7_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &PKCS7, ($st)));
    }' unless defined(&sk_PKCS7_is_sorted);
    eval 'sub sk_PKCS7_RECIP_INFO_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &PKCS7_RECIP_INFO, ($st)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_new);
    eval 'sub sk_PKCS7_RECIP_INFO_new_null () {
        eval q( &SKM_sk_new_null( &PKCS7_RECIP_INFO));
    }' unless defined(&sk_PKCS7_RECIP_INFO_new_null);
    eval 'sub sk_PKCS7_RECIP_INFO_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &PKCS7_RECIP_INFO, ($st)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_free);
    eval 'sub sk_PKCS7_RECIP_INFO_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &PKCS7_RECIP_INFO, ($st)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_num);
    eval 'sub sk_PKCS7_RECIP_INFO_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &PKCS7_RECIP_INFO, ($st), ($i)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_value);
    eval 'sub sk_PKCS7_RECIP_INFO_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &PKCS7_RECIP_INFO, ($st), ($i), ($val)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_set);
    eval 'sub sk_PKCS7_RECIP_INFO_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &PKCS7_RECIP_INFO, ($st)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_zero);
    eval 'sub sk_PKCS7_RECIP_INFO_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &PKCS7_RECIP_INFO, ($st), ($val)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_push);
    eval 'sub sk_PKCS7_RECIP_INFO_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &PKCS7_RECIP_INFO, ($st), ($val)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_unshift);
    eval 'sub sk_PKCS7_RECIP_INFO_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &PKCS7_RECIP_INFO, ($st), ($val)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_find);
    eval 'sub sk_PKCS7_RECIP_INFO_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &PKCS7_RECIP_INFO, ($st), ($i)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_delete);
    eval 'sub sk_PKCS7_RECIP_INFO_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &PKCS7_RECIP_INFO, ($st), ($ptr)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_delete_ptr);
    eval 'sub sk_PKCS7_RECIP_INFO_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &PKCS7_RECIP_INFO, ($st), ($val), ($i)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_insert);
    eval 'sub sk_PKCS7_RECIP_INFO_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &PKCS7_RECIP_INFO, ($st), ($cmp)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_set_cmp_func);
    eval 'sub sk_PKCS7_RECIP_INFO_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &PKCS7_RECIP_INFO, $st));
    }' unless defined(&sk_PKCS7_RECIP_INFO_dup);
    eval 'sub sk_PKCS7_RECIP_INFO_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &PKCS7_RECIP_INFO, ($st), ($free_func)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_pop_free);
    eval 'sub sk_PKCS7_RECIP_INFO_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &PKCS7_RECIP_INFO, ($st)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_shift);
    eval 'sub sk_PKCS7_RECIP_INFO_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &PKCS7_RECIP_INFO, ($st)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_pop);
    eval 'sub sk_PKCS7_RECIP_INFO_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &PKCS7_RECIP_INFO, ($st)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_sort);
    eval 'sub sk_PKCS7_RECIP_INFO_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &PKCS7_RECIP_INFO, ($st)));
    }' unless defined(&sk_PKCS7_RECIP_INFO_is_sorted);
    eval 'sub sk_PKCS7_SIGNER_INFO_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &PKCS7_SIGNER_INFO, ($st)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_new);
    eval 'sub sk_PKCS7_SIGNER_INFO_new_null () {
        eval q( &SKM_sk_new_null( &PKCS7_SIGNER_INFO));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_new_null);
    eval 'sub sk_PKCS7_SIGNER_INFO_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &PKCS7_SIGNER_INFO, ($st)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_free);
    eval 'sub sk_PKCS7_SIGNER_INFO_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &PKCS7_SIGNER_INFO, ($st)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_num);
    eval 'sub sk_PKCS7_SIGNER_INFO_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &PKCS7_SIGNER_INFO, ($st), ($i)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_value);
    eval 'sub sk_PKCS7_SIGNER_INFO_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &PKCS7_SIGNER_INFO, ($st), ($i), ($val)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_set);
    eval 'sub sk_PKCS7_SIGNER_INFO_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &PKCS7_SIGNER_INFO, ($st)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_zero);
    eval 'sub sk_PKCS7_SIGNER_INFO_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &PKCS7_SIGNER_INFO, ($st), ($val)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_push);
    eval 'sub sk_PKCS7_SIGNER_INFO_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &PKCS7_SIGNER_INFO, ($st), ($val)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_unshift);
    eval 'sub sk_PKCS7_SIGNER_INFO_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &PKCS7_SIGNER_INFO, ($st), ($val)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_find);
    eval 'sub sk_PKCS7_SIGNER_INFO_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &PKCS7_SIGNER_INFO, ($st), ($i)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_delete);
    eval 'sub sk_PKCS7_SIGNER_INFO_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &PKCS7_SIGNER_INFO, ($st), ($ptr)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_delete_ptr);
    eval 'sub sk_PKCS7_SIGNER_INFO_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &PKCS7_SIGNER_INFO, ($st), ($val), ($i)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_insert);
    eval 'sub sk_PKCS7_SIGNER_INFO_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &PKCS7_SIGNER_INFO, ($st), ($cmp)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_set_cmp_func);
    eval 'sub sk_PKCS7_SIGNER_INFO_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &PKCS7_SIGNER_INFO, $st));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_dup);
    eval 'sub sk_PKCS7_SIGNER_INFO_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &PKCS7_SIGNER_INFO, ($st), ($free_func)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_pop_free);
    eval 'sub sk_PKCS7_SIGNER_INFO_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &PKCS7_SIGNER_INFO, ($st)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_shift);
    eval 'sub sk_PKCS7_SIGNER_INFO_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &PKCS7_SIGNER_INFO, ($st)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_pop);
    eval 'sub sk_PKCS7_SIGNER_INFO_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &PKCS7_SIGNER_INFO, ($st)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_sort);
    eval 'sub sk_PKCS7_SIGNER_INFO_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &PKCS7_SIGNER_INFO, ($st)));
    }' unless defined(&sk_PKCS7_SIGNER_INFO_is_sorted);
    eval 'sub sk_POLICYINFO_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &POLICYINFO, ($st)));
    }' unless defined(&sk_POLICYINFO_new);
    eval 'sub sk_POLICYINFO_new_null () {
        eval q( &SKM_sk_new_null( &POLICYINFO));
    }' unless defined(&sk_POLICYINFO_new_null);
    eval 'sub sk_POLICYINFO_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &POLICYINFO, ($st)));
    }' unless defined(&sk_POLICYINFO_free);
    eval 'sub sk_POLICYINFO_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &POLICYINFO, ($st)));
    }' unless defined(&sk_POLICYINFO_num);
    eval 'sub sk_POLICYINFO_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &POLICYINFO, ($st), ($i)));
    }' unless defined(&sk_POLICYINFO_value);
    eval 'sub sk_POLICYINFO_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &POLICYINFO, ($st), ($i), ($val)));
    }' unless defined(&sk_POLICYINFO_set);
    eval 'sub sk_POLICYINFO_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &POLICYINFO, ($st)));
    }' unless defined(&sk_POLICYINFO_zero);
    eval 'sub sk_POLICYINFO_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &POLICYINFO, ($st), ($val)));
    }' unless defined(&sk_POLICYINFO_push);
    eval 'sub sk_POLICYINFO_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &POLICYINFO, ($st), ($val)));
    }' unless defined(&sk_POLICYINFO_unshift);
    eval 'sub sk_POLICYINFO_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &POLICYINFO, ($st), ($val)));
    }' unless defined(&sk_POLICYINFO_find);
    eval 'sub sk_POLICYINFO_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &POLICYINFO, ($st), ($i)));
    }' unless defined(&sk_POLICYINFO_delete);
    eval 'sub sk_POLICYINFO_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &POLICYINFO, ($st), ($ptr)));
    }' unless defined(&sk_POLICYINFO_delete_ptr);
    eval 'sub sk_POLICYINFO_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &POLICYINFO, ($st), ($val), ($i)));
    }' unless defined(&sk_POLICYINFO_insert);
    eval 'sub sk_POLICYINFO_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &POLICYINFO, ($st), ($cmp)));
    }' unless defined(&sk_POLICYINFO_set_cmp_func);
    eval 'sub sk_POLICYINFO_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &POLICYINFO, $st));
    }' unless defined(&sk_POLICYINFO_dup);
    eval 'sub sk_POLICYINFO_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &POLICYINFO, ($st), ($free_func)));
    }' unless defined(&sk_POLICYINFO_pop_free);
    eval 'sub sk_POLICYINFO_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &POLICYINFO, ($st)));
    }' unless defined(&sk_POLICYINFO_shift);
    eval 'sub sk_POLICYINFO_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &POLICYINFO, ($st)));
    }' unless defined(&sk_POLICYINFO_pop);
    eval 'sub sk_POLICYINFO_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &POLICYINFO, ($st)));
    }' unless defined(&sk_POLICYINFO_sort);
    eval 'sub sk_POLICYINFO_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &POLICYINFO, ($st)));
    }' unless defined(&sk_POLICYINFO_is_sorted);
    eval 'sub sk_POLICYQUALINFO_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &POLICYQUALINFO, ($st)));
    }' unless defined(&sk_POLICYQUALINFO_new);
    eval 'sub sk_POLICYQUALINFO_new_null () {
        eval q( &SKM_sk_new_null( &POLICYQUALINFO));
    }' unless defined(&sk_POLICYQUALINFO_new_null);
    eval 'sub sk_POLICYQUALINFO_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &POLICYQUALINFO, ($st)));
    }' unless defined(&sk_POLICYQUALINFO_free);
    eval 'sub sk_POLICYQUALINFO_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &POLICYQUALINFO, ($st)));
    }' unless defined(&sk_POLICYQUALINFO_num);
    eval 'sub sk_POLICYQUALINFO_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &POLICYQUALINFO, ($st), ($i)));
    }' unless defined(&sk_POLICYQUALINFO_value);
    eval 'sub sk_POLICYQUALINFO_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &POLICYQUALINFO, ($st), ($i), ($val)));
    }' unless defined(&sk_POLICYQUALINFO_set);
    eval 'sub sk_POLICYQUALINFO_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &POLICYQUALINFO, ($st)));
    }' unless defined(&sk_POLICYQUALINFO_zero);
    eval 'sub sk_POLICYQUALINFO_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &POLICYQUALINFO, ($st), ($val)));
    }' unless defined(&sk_POLICYQUALINFO_push);
    eval 'sub sk_POLICYQUALINFO_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &POLICYQUALINFO, ($st), ($val)));
    }' unless defined(&sk_POLICYQUALINFO_unshift);
    eval 'sub sk_POLICYQUALINFO_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &POLICYQUALINFO, ($st), ($val)));
    }' unless defined(&sk_POLICYQUALINFO_find);
    eval 'sub sk_POLICYQUALINFO_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &POLICYQUALINFO, ($st), ($i)));
    }' unless defined(&sk_POLICYQUALINFO_delete);
    eval 'sub sk_POLICYQUALINFO_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &POLICYQUALINFO, ($st), ($ptr)));
    }' unless defined(&sk_POLICYQUALINFO_delete_ptr);
    eval 'sub sk_POLICYQUALINFO_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &POLICYQUALINFO, ($st), ($val), ($i)));
    }' unless defined(&sk_POLICYQUALINFO_insert);
    eval 'sub sk_POLICYQUALINFO_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &POLICYQUALINFO, ($st), ($cmp)));
    }' unless defined(&sk_POLICYQUALINFO_set_cmp_func);
    eval 'sub sk_POLICYQUALINFO_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &POLICYQUALINFO, $st));
    }' unless defined(&sk_POLICYQUALINFO_dup);
    eval 'sub sk_POLICYQUALINFO_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &POLICYQUALINFO, ($st), ($free_func)));
    }' unless defined(&sk_POLICYQUALINFO_pop_free);
    eval 'sub sk_POLICYQUALINFO_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &POLICYQUALINFO, ($st)));
    }' unless defined(&sk_POLICYQUALINFO_shift);
    eval 'sub sk_POLICYQUALINFO_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &POLICYQUALINFO, ($st)));
    }' unless defined(&sk_POLICYQUALINFO_pop);
    eval 'sub sk_POLICYQUALINFO_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &POLICYQUALINFO, ($st)));
    }' unless defined(&sk_POLICYQUALINFO_sort);
    eval 'sub sk_POLICYQUALINFO_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &POLICYQUALINFO, ($st)));
    }' unless defined(&sk_POLICYQUALINFO_is_sorted);
    eval 'sub sk_SSL_CIPHER_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &SSL_CIPHER, ($st)));
    }' unless defined(&sk_SSL_CIPHER_new);
    eval 'sub sk_SSL_CIPHER_new_null () {
        eval q( &SKM_sk_new_null( &SSL_CIPHER));
    }' unless defined(&sk_SSL_CIPHER_new_null);
    eval 'sub sk_SSL_CIPHER_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &SSL_CIPHER, ($st)));
    }' unless defined(&sk_SSL_CIPHER_free);
    eval 'sub sk_SSL_CIPHER_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &SSL_CIPHER, ($st)));
    }' unless defined(&sk_SSL_CIPHER_num);
    eval 'sub sk_SSL_CIPHER_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &SSL_CIPHER, ($st), ($i)));
    }' unless defined(&sk_SSL_CIPHER_value);
    eval 'sub sk_SSL_CIPHER_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &SSL_CIPHER, ($st), ($i), ($val)));
    }' unless defined(&sk_SSL_CIPHER_set);
    eval 'sub sk_SSL_CIPHER_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &SSL_CIPHER, ($st)));
    }' unless defined(&sk_SSL_CIPHER_zero);
    eval 'sub sk_SSL_CIPHER_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &SSL_CIPHER, ($st), ($val)));
    }' unless defined(&sk_SSL_CIPHER_push);
    eval 'sub sk_SSL_CIPHER_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &SSL_CIPHER, ($st), ($val)));
    }' unless defined(&sk_SSL_CIPHER_unshift);
    eval 'sub sk_SSL_CIPHER_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &SSL_CIPHER, ($st), ($val)));
    }' unless defined(&sk_SSL_CIPHER_find);
    eval 'sub sk_SSL_CIPHER_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &SSL_CIPHER, ($st), ($i)));
    }' unless defined(&sk_SSL_CIPHER_delete);
    eval 'sub sk_SSL_CIPHER_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &SSL_CIPHER, ($st), ($ptr)));
    }' unless defined(&sk_SSL_CIPHER_delete_ptr);
    eval 'sub sk_SSL_CIPHER_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &SSL_CIPHER, ($st), ($val), ($i)));
    }' unless defined(&sk_SSL_CIPHER_insert);
    eval 'sub sk_SSL_CIPHER_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &SSL_CIPHER, ($st), ($cmp)));
    }' unless defined(&sk_SSL_CIPHER_set_cmp_func);
    eval 'sub sk_SSL_CIPHER_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &SSL_CIPHER, $st));
    }' unless defined(&sk_SSL_CIPHER_dup);
    eval 'sub sk_SSL_CIPHER_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &SSL_CIPHER, ($st), ($free_func)));
    }' unless defined(&sk_SSL_CIPHER_pop_free);
    eval 'sub sk_SSL_CIPHER_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &SSL_CIPHER, ($st)));
    }' unless defined(&sk_SSL_CIPHER_shift);
    eval 'sub sk_SSL_CIPHER_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &SSL_CIPHER, ($st)));
    }' unless defined(&sk_SSL_CIPHER_pop);
    eval 'sub sk_SSL_CIPHER_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &SSL_CIPHER, ($st)));
    }' unless defined(&sk_SSL_CIPHER_sort);
    eval 'sub sk_SSL_CIPHER_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &SSL_CIPHER, ($st)));
    }' unless defined(&sk_SSL_CIPHER_is_sorted);
    eval 'sub sk_SSL_COMP_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &SSL_COMP, ($st)));
    }' unless defined(&sk_SSL_COMP_new);
    eval 'sub sk_SSL_COMP_new_null () {
        eval q( &SKM_sk_new_null( &SSL_COMP));
    }' unless defined(&sk_SSL_COMP_new_null);
    eval 'sub sk_SSL_COMP_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &SSL_COMP, ($st)));
    }' unless defined(&sk_SSL_COMP_free);
    eval 'sub sk_SSL_COMP_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &SSL_COMP, ($st)));
    }' unless defined(&sk_SSL_COMP_num);
    eval 'sub sk_SSL_COMP_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &SSL_COMP, ($st), ($i)));
    }' unless defined(&sk_SSL_COMP_value);
    eval 'sub sk_SSL_COMP_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &SSL_COMP, ($st), ($i), ($val)));
    }' unless defined(&sk_SSL_COMP_set);
    eval 'sub sk_SSL_COMP_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &SSL_COMP, ($st)));
    }' unless defined(&sk_SSL_COMP_zero);
    eval 'sub sk_SSL_COMP_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &SSL_COMP, ($st), ($val)));
    }' unless defined(&sk_SSL_COMP_push);
    eval 'sub sk_SSL_COMP_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &SSL_COMP, ($st), ($val)));
    }' unless defined(&sk_SSL_COMP_unshift);
    eval 'sub sk_SSL_COMP_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &SSL_COMP, ($st), ($val)));
    }' unless defined(&sk_SSL_COMP_find);
    eval 'sub sk_SSL_COMP_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &SSL_COMP, ($st), ($i)));
    }' unless defined(&sk_SSL_COMP_delete);
    eval 'sub sk_SSL_COMP_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &SSL_COMP, ($st), ($ptr)));
    }' unless defined(&sk_SSL_COMP_delete_ptr);
    eval 'sub sk_SSL_COMP_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &SSL_COMP, ($st), ($val), ($i)));
    }' unless defined(&sk_SSL_COMP_insert);
    eval 'sub sk_SSL_COMP_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &SSL_COMP, ($st), ($cmp)));
    }' unless defined(&sk_SSL_COMP_set_cmp_func);
    eval 'sub sk_SSL_COMP_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &SSL_COMP, $st));
    }' unless defined(&sk_SSL_COMP_dup);
    eval 'sub sk_SSL_COMP_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &SSL_COMP, ($st), ($free_func)));
    }' unless defined(&sk_SSL_COMP_pop_free);
    eval 'sub sk_SSL_COMP_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &SSL_COMP, ($st)));
    }' unless defined(&sk_SSL_COMP_shift);
    eval 'sub sk_SSL_COMP_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &SSL_COMP, ($st)));
    }' unless defined(&sk_SSL_COMP_pop);
    eval 'sub sk_SSL_COMP_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &SSL_COMP, ($st)));
    }' unless defined(&sk_SSL_COMP_sort);
    eval 'sub sk_SSL_COMP_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &SSL_COMP, ($st)));
    }' unless defined(&sk_SSL_COMP_is_sorted);
    eval 'sub sk_SXNETID_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &SXNETID, ($st)));
    }' unless defined(&sk_SXNETID_new);
    eval 'sub sk_SXNETID_new_null () {
        eval q( &SKM_sk_new_null( &SXNETID));
    }' unless defined(&sk_SXNETID_new_null);
    eval 'sub sk_SXNETID_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &SXNETID, ($st)));
    }' unless defined(&sk_SXNETID_free);
    eval 'sub sk_SXNETID_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &SXNETID, ($st)));
    }' unless defined(&sk_SXNETID_num);
    eval 'sub sk_SXNETID_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &SXNETID, ($st), ($i)));
    }' unless defined(&sk_SXNETID_value);
    eval 'sub sk_SXNETID_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &SXNETID, ($st), ($i), ($val)));
    }' unless defined(&sk_SXNETID_set);
    eval 'sub sk_SXNETID_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &SXNETID, ($st)));
    }' unless defined(&sk_SXNETID_zero);
    eval 'sub sk_SXNETID_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &SXNETID, ($st), ($val)));
    }' unless defined(&sk_SXNETID_push);
    eval 'sub sk_SXNETID_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &SXNETID, ($st), ($val)));
    }' unless defined(&sk_SXNETID_unshift);
    eval 'sub sk_SXNETID_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &SXNETID, ($st), ($val)));
    }' unless defined(&sk_SXNETID_find);
    eval 'sub sk_SXNETID_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &SXNETID, ($st), ($i)));
    }' unless defined(&sk_SXNETID_delete);
    eval 'sub sk_SXNETID_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &SXNETID, ($st), ($ptr)));
    }' unless defined(&sk_SXNETID_delete_ptr);
    eval 'sub sk_SXNETID_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &SXNETID, ($st), ($val), ($i)));
    }' unless defined(&sk_SXNETID_insert);
    eval 'sub sk_SXNETID_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &SXNETID, ($st), ($cmp)));
    }' unless defined(&sk_SXNETID_set_cmp_func);
    eval 'sub sk_SXNETID_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &SXNETID, $st));
    }' unless defined(&sk_SXNETID_dup);
    eval 'sub sk_SXNETID_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &SXNETID, ($st), ($free_func)));
    }' unless defined(&sk_SXNETID_pop_free);
    eval 'sub sk_SXNETID_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &SXNETID, ($st)));
    }' unless defined(&sk_SXNETID_shift);
    eval 'sub sk_SXNETID_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &SXNETID, ($st)));
    }' unless defined(&sk_SXNETID_pop);
    eval 'sub sk_SXNETID_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &SXNETID, ($st)));
    }' unless defined(&sk_SXNETID_sort);
    eval 'sub sk_SXNETID_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &SXNETID, ($st)));
    }' unless defined(&sk_SXNETID_is_sorted);
    eval 'sub sk_UI_STRING_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &UI_STRING, ($st)));
    }' unless defined(&sk_UI_STRING_new);
    eval 'sub sk_UI_STRING_new_null () {
        eval q( &SKM_sk_new_null( &UI_STRING));
    }' unless defined(&sk_UI_STRING_new_null);
    eval 'sub sk_UI_STRING_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &UI_STRING, ($st)));
    }' unless defined(&sk_UI_STRING_free);
    eval 'sub sk_UI_STRING_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &UI_STRING, ($st)));
    }' unless defined(&sk_UI_STRING_num);
    eval 'sub sk_UI_STRING_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &UI_STRING, ($st), ($i)));
    }' unless defined(&sk_UI_STRING_value);
    eval 'sub sk_UI_STRING_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &UI_STRING, ($st), ($i), ($val)));
    }' unless defined(&sk_UI_STRING_set);
    eval 'sub sk_UI_STRING_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &UI_STRING, ($st)));
    }' unless defined(&sk_UI_STRING_zero);
    eval 'sub sk_UI_STRING_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &UI_STRING, ($st), ($val)));
    }' unless defined(&sk_UI_STRING_push);
    eval 'sub sk_UI_STRING_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &UI_STRING, ($st), ($val)));
    }' unless defined(&sk_UI_STRING_unshift);
    eval 'sub sk_UI_STRING_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &UI_STRING, ($st), ($val)));
    }' unless defined(&sk_UI_STRING_find);
    eval 'sub sk_UI_STRING_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &UI_STRING, ($st), ($i)));
    }' unless defined(&sk_UI_STRING_delete);
    eval 'sub sk_UI_STRING_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &UI_STRING, ($st), ($ptr)));
    }' unless defined(&sk_UI_STRING_delete_ptr);
    eval 'sub sk_UI_STRING_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &UI_STRING, ($st), ($val), ($i)));
    }' unless defined(&sk_UI_STRING_insert);
    eval 'sub sk_UI_STRING_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &UI_STRING, ($st), ($cmp)));
    }' unless defined(&sk_UI_STRING_set_cmp_func);
    eval 'sub sk_UI_STRING_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &UI_STRING, $st));
    }' unless defined(&sk_UI_STRING_dup);
    eval 'sub sk_UI_STRING_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &UI_STRING, ($st), ($free_func)));
    }' unless defined(&sk_UI_STRING_pop_free);
    eval 'sub sk_UI_STRING_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &UI_STRING, ($st)));
    }' unless defined(&sk_UI_STRING_shift);
    eval 'sub sk_UI_STRING_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &UI_STRING, ($st)));
    }' unless defined(&sk_UI_STRING_pop);
    eval 'sub sk_UI_STRING_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &UI_STRING, ($st)));
    }' unless defined(&sk_UI_STRING_sort);
    eval 'sub sk_UI_STRING_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &UI_STRING, ($st)));
    }' unless defined(&sk_UI_STRING_is_sorted);
    eval 'sub sk_X509_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509, ($st)));
    }' unless defined(&sk_X509_new);
    eval 'sub sk_X509_new_null () {
        eval q( &SKM_sk_new_null( &X509));
    }' unless defined(&sk_X509_new_null);
    eval 'sub sk_X509_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509, ($st)));
    }' unless defined(&sk_X509_free);
    eval 'sub sk_X509_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509, ($st)));
    }' unless defined(&sk_X509_num);
    eval 'sub sk_X509_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509, ($st), ($i)));
    }' unless defined(&sk_X509_value);
    eval 'sub sk_X509_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_set);
    eval 'sub sk_X509_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509, ($st)));
    }' unless defined(&sk_X509_zero);
    eval 'sub sk_X509_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509, ($st), ($val)));
    }' unless defined(&sk_X509_push);
    eval 'sub sk_X509_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509, ($st), ($val)));
    }' unless defined(&sk_X509_unshift);
    eval 'sub sk_X509_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509, ($st), ($val)));
    }' unless defined(&sk_X509_find);
    eval 'sub sk_X509_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509, ($st), ($i)));
    }' unless defined(&sk_X509_delete);
    eval 'sub sk_X509_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509, ($st), ($ptr)));
    }' unless defined(&sk_X509_delete_ptr);
    eval 'sub sk_X509_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_insert);
    eval 'sub sk_X509_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509, ($st), ($cmp)));
    }' unless defined(&sk_X509_set_cmp_func);
    eval 'sub sk_X509_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509, $st));
    }' unless defined(&sk_X509_dup);
    eval 'sub sk_X509_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509, ($st), ($free_func)));
    }' unless defined(&sk_X509_pop_free);
    eval 'sub sk_X509_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509, ($st)));
    }' unless defined(&sk_X509_shift);
    eval 'sub sk_X509_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509, ($st)));
    }' unless defined(&sk_X509_pop);
    eval 'sub sk_X509_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509, ($st)));
    }' unless defined(&sk_X509_sort);
    eval 'sub sk_X509_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509, ($st)));
    }' unless defined(&sk_X509_is_sorted);
    eval 'sub sk_X509V3_EXT_METHOD_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509V3_EXT_METHOD, ($st)));
    }' unless defined(&sk_X509V3_EXT_METHOD_new);
    eval 'sub sk_X509V3_EXT_METHOD_new_null () {
        eval q( &SKM_sk_new_null( &X509V3_EXT_METHOD));
    }' unless defined(&sk_X509V3_EXT_METHOD_new_null);
    eval 'sub sk_X509V3_EXT_METHOD_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509V3_EXT_METHOD, ($st)));
    }' unless defined(&sk_X509V3_EXT_METHOD_free);
    eval 'sub sk_X509V3_EXT_METHOD_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509V3_EXT_METHOD, ($st)));
    }' unless defined(&sk_X509V3_EXT_METHOD_num);
    eval 'sub sk_X509V3_EXT_METHOD_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509V3_EXT_METHOD, ($st), ($i)));
    }' unless defined(&sk_X509V3_EXT_METHOD_value);
    eval 'sub sk_X509V3_EXT_METHOD_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509V3_EXT_METHOD, ($st), ($i), ($val)));
    }' unless defined(&sk_X509V3_EXT_METHOD_set);
    eval 'sub sk_X509V3_EXT_METHOD_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509V3_EXT_METHOD, ($st)));
    }' unless defined(&sk_X509V3_EXT_METHOD_zero);
    eval 'sub sk_X509V3_EXT_METHOD_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509V3_EXT_METHOD, ($st), ($val)));
    }' unless defined(&sk_X509V3_EXT_METHOD_push);
    eval 'sub sk_X509V3_EXT_METHOD_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509V3_EXT_METHOD, ($st), ($val)));
    }' unless defined(&sk_X509V3_EXT_METHOD_unshift);
    eval 'sub sk_X509V3_EXT_METHOD_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509V3_EXT_METHOD, ($st), ($val)));
    }' unless defined(&sk_X509V3_EXT_METHOD_find);
    eval 'sub sk_X509V3_EXT_METHOD_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509V3_EXT_METHOD, ($st), ($i)));
    }' unless defined(&sk_X509V3_EXT_METHOD_delete);
    eval 'sub sk_X509V3_EXT_METHOD_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509V3_EXT_METHOD, ($st), ($ptr)));
    }' unless defined(&sk_X509V3_EXT_METHOD_delete_ptr);
    eval 'sub sk_X509V3_EXT_METHOD_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509V3_EXT_METHOD, ($st), ($val), ($i)));
    }' unless defined(&sk_X509V3_EXT_METHOD_insert);
    eval 'sub sk_X509V3_EXT_METHOD_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509V3_EXT_METHOD, ($st), ($cmp)));
    }' unless defined(&sk_X509V3_EXT_METHOD_set_cmp_func);
    eval 'sub sk_X509V3_EXT_METHOD_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509V3_EXT_METHOD, $st));
    }' unless defined(&sk_X509V3_EXT_METHOD_dup);
    eval 'sub sk_X509V3_EXT_METHOD_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509V3_EXT_METHOD, ($st), ($free_func)));
    }' unless defined(&sk_X509V3_EXT_METHOD_pop_free);
    eval 'sub sk_X509V3_EXT_METHOD_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509V3_EXT_METHOD, ($st)));
    }' unless defined(&sk_X509V3_EXT_METHOD_shift);
    eval 'sub sk_X509V3_EXT_METHOD_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509V3_EXT_METHOD, ($st)));
    }' unless defined(&sk_X509V3_EXT_METHOD_pop);
    eval 'sub sk_X509V3_EXT_METHOD_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509V3_EXT_METHOD, ($st)));
    }' unless defined(&sk_X509V3_EXT_METHOD_sort);
    eval 'sub sk_X509V3_EXT_METHOD_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509V3_EXT_METHOD, ($st)));
    }' unless defined(&sk_X509V3_EXT_METHOD_is_sorted);
    eval 'sub sk_X509_ALGOR_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_ALGOR, ($st)));
    }' unless defined(&sk_X509_ALGOR_new);
    eval 'sub sk_X509_ALGOR_new_null () {
        eval q( &SKM_sk_new_null( &X509_ALGOR));
    }' unless defined(&sk_X509_ALGOR_new_null);
    eval 'sub sk_X509_ALGOR_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_ALGOR, ($st)));
    }' unless defined(&sk_X509_ALGOR_free);
    eval 'sub sk_X509_ALGOR_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_ALGOR, ($st)));
    }' unless defined(&sk_X509_ALGOR_num);
    eval 'sub sk_X509_ALGOR_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_ALGOR, ($st), ($i)));
    }' unless defined(&sk_X509_ALGOR_value);
    eval 'sub sk_X509_ALGOR_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_ALGOR, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_ALGOR_set);
    eval 'sub sk_X509_ALGOR_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_ALGOR, ($st)));
    }' unless defined(&sk_X509_ALGOR_zero);
    eval 'sub sk_X509_ALGOR_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_ALGOR, ($st), ($val)));
    }' unless defined(&sk_X509_ALGOR_push);
    eval 'sub sk_X509_ALGOR_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_ALGOR, ($st), ($val)));
    }' unless defined(&sk_X509_ALGOR_unshift);
    eval 'sub sk_X509_ALGOR_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_ALGOR, ($st), ($val)));
    }' unless defined(&sk_X509_ALGOR_find);
    eval 'sub sk_X509_ALGOR_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_ALGOR, ($st), ($i)));
    }' unless defined(&sk_X509_ALGOR_delete);
    eval 'sub sk_X509_ALGOR_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_ALGOR, ($st), ($ptr)));
    }' unless defined(&sk_X509_ALGOR_delete_ptr);
    eval 'sub sk_X509_ALGOR_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_ALGOR, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_ALGOR_insert);
    eval 'sub sk_X509_ALGOR_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_ALGOR, ($st), ($cmp)));
    }' unless defined(&sk_X509_ALGOR_set_cmp_func);
    eval 'sub sk_X509_ALGOR_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_ALGOR, $st));
    }' unless defined(&sk_X509_ALGOR_dup);
    eval 'sub sk_X509_ALGOR_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_ALGOR, ($st), ($free_func)));
    }' unless defined(&sk_X509_ALGOR_pop_free);
    eval 'sub sk_X509_ALGOR_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_ALGOR, ($st)));
    }' unless defined(&sk_X509_ALGOR_shift);
    eval 'sub sk_X509_ALGOR_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_ALGOR, ($st)));
    }' unless defined(&sk_X509_ALGOR_pop);
    eval 'sub sk_X509_ALGOR_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_ALGOR, ($st)));
    }' unless defined(&sk_X509_ALGOR_sort);
    eval 'sub sk_X509_ALGOR_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_ALGOR, ($st)));
    }' unless defined(&sk_X509_ALGOR_is_sorted);
    eval 'sub sk_X509_ATTRIBUTE_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_ATTRIBUTE, ($st)));
    }' unless defined(&sk_X509_ATTRIBUTE_new);
    eval 'sub sk_X509_ATTRIBUTE_new_null () {
        eval q( &SKM_sk_new_null( &X509_ATTRIBUTE));
    }' unless defined(&sk_X509_ATTRIBUTE_new_null);
    eval 'sub sk_X509_ATTRIBUTE_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_ATTRIBUTE, ($st)));
    }' unless defined(&sk_X509_ATTRIBUTE_free);
    eval 'sub sk_X509_ATTRIBUTE_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_ATTRIBUTE, ($st)));
    }' unless defined(&sk_X509_ATTRIBUTE_num);
    eval 'sub sk_X509_ATTRIBUTE_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_ATTRIBUTE, ($st), ($i)));
    }' unless defined(&sk_X509_ATTRIBUTE_value);
    eval 'sub sk_X509_ATTRIBUTE_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_ATTRIBUTE, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_ATTRIBUTE_set);
    eval 'sub sk_X509_ATTRIBUTE_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_ATTRIBUTE, ($st)));
    }' unless defined(&sk_X509_ATTRIBUTE_zero);
    eval 'sub sk_X509_ATTRIBUTE_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_ATTRIBUTE, ($st), ($val)));
    }' unless defined(&sk_X509_ATTRIBUTE_push);
    eval 'sub sk_X509_ATTRIBUTE_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_ATTRIBUTE, ($st), ($val)));
    }' unless defined(&sk_X509_ATTRIBUTE_unshift);
    eval 'sub sk_X509_ATTRIBUTE_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_ATTRIBUTE, ($st), ($val)));
    }' unless defined(&sk_X509_ATTRIBUTE_find);
    eval 'sub sk_X509_ATTRIBUTE_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_ATTRIBUTE, ($st), ($i)));
    }' unless defined(&sk_X509_ATTRIBUTE_delete);
    eval 'sub sk_X509_ATTRIBUTE_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_ATTRIBUTE, ($st), ($ptr)));
    }' unless defined(&sk_X509_ATTRIBUTE_delete_ptr);
    eval 'sub sk_X509_ATTRIBUTE_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_ATTRIBUTE, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_ATTRIBUTE_insert);
    eval 'sub sk_X509_ATTRIBUTE_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_ATTRIBUTE, ($st), ($cmp)));
    }' unless defined(&sk_X509_ATTRIBUTE_set_cmp_func);
    eval 'sub sk_X509_ATTRIBUTE_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_ATTRIBUTE, $st));
    }' unless defined(&sk_X509_ATTRIBUTE_dup);
    eval 'sub sk_X509_ATTRIBUTE_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_ATTRIBUTE, ($st), ($free_func)));
    }' unless defined(&sk_X509_ATTRIBUTE_pop_free);
    eval 'sub sk_X509_ATTRIBUTE_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_ATTRIBUTE, ($st)));
    }' unless defined(&sk_X509_ATTRIBUTE_shift);
    eval 'sub sk_X509_ATTRIBUTE_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_ATTRIBUTE, ($st)));
    }' unless defined(&sk_X509_ATTRIBUTE_pop);
    eval 'sub sk_X509_ATTRIBUTE_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_ATTRIBUTE, ($st)));
    }' unless defined(&sk_X509_ATTRIBUTE_sort);
    eval 'sub sk_X509_ATTRIBUTE_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_ATTRIBUTE, ($st)));
    }' unless defined(&sk_X509_ATTRIBUTE_is_sorted);
    eval 'sub sk_X509_CRL_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_CRL, ($st)));
    }' unless defined(&sk_X509_CRL_new);
    eval 'sub sk_X509_CRL_new_null () {
        eval q( &SKM_sk_new_null( &X509_CRL));
    }' unless defined(&sk_X509_CRL_new_null);
    eval 'sub sk_X509_CRL_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_CRL, ($st)));
    }' unless defined(&sk_X509_CRL_free);
    eval 'sub sk_X509_CRL_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_CRL, ($st)));
    }' unless defined(&sk_X509_CRL_num);
    eval 'sub sk_X509_CRL_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_CRL, ($st), ($i)));
    }' unless defined(&sk_X509_CRL_value);
    eval 'sub sk_X509_CRL_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_CRL, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_CRL_set);
    eval 'sub sk_X509_CRL_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_CRL, ($st)));
    }' unless defined(&sk_X509_CRL_zero);
    eval 'sub sk_X509_CRL_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_CRL, ($st), ($val)));
    }' unless defined(&sk_X509_CRL_push);
    eval 'sub sk_X509_CRL_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_CRL, ($st), ($val)));
    }' unless defined(&sk_X509_CRL_unshift);
    eval 'sub sk_X509_CRL_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_CRL, ($st), ($val)));
    }' unless defined(&sk_X509_CRL_find);
    eval 'sub sk_X509_CRL_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_CRL, ($st), ($i)));
    }' unless defined(&sk_X509_CRL_delete);
    eval 'sub sk_X509_CRL_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_CRL, ($st), ($ptr)));
    }' unless defined(&sk_X509_CRL_delete_ptr);
    eval 'sub sk_X509_CRL_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_CRL, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_CRL_insert);
    eval 'sub sk_X509_CRL_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_CRL, ($st), ($cmp)));
    }' unless defined(&sk_X509_CRL_set_cmp_func);
    eval 'sub sk_X509_CRL_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_CRL, $st));
    }' unless defined(&sk_X509_CRL_dup);
    eval 'sub sk_X509_CRL_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_CRL, ($st), ($free_func)));
    }' unless defined(&sk_X509_CRL_pop_free);
    eval 'sub sk_X509_CRL_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_CRL, ($st)));
    }' unless defined(&sk_X509_CRL_shift);
    eval 'sub sk_X509_CRL_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_CRL, ($st)));
    }' unless defined(&sk_X509_CRL_pop);
    eval 'sub sk_X509_CRL_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_CRL, ($st)));
    }' unless defined(&sk_X509_CRL_sort);
    eval 'sub sk_X509_CRL_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_CRL, ($st)));
    }' unless defined(&sk_X509_CRL_is_sorted);
    eval 'sub sk_X509_EXTENSION_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_EXTENSION, ($st)));
    }' unless defined(&sk_X509_EXTENSION_new);
    eval 'sub sk_X509_EXTENSION_new_null () {
        eval q( &SKM_sk_new_null( &X509_EXTENSION));
    }' unless defined(&sk_X509_EXTENSION_new_null);
    eval 'sub sk_X509_EXTENSION_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_EXTENSION, ($st)));
    }' unless defined(&sk_X509_EXTENSION_free);
    eval 'sub sk_X509_EXTENSION_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_EXTENSION, ($st)));
    }' unless defined(&sk_X509_EXTENSION_num);
    eval 'sub sk_X509_EXTENSION_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_EXTENSION, ($st), ($i)));
    }' unless defined(&sk_X509_EXTENSION_value);
    eval 'sub sk_X509_EXTENSION_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_EXTENSION, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_EXTENSION_set);
    eval 'sub sk_X509_EXTENSION_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_EXTENSION, ($st)));
    }' unless defined(&sk_X509_EXTENSION_zero);
    eval 'sub sk_X509_EXTENSION_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_EXTENSION, ($st), ($val)));
    }' unless defined(&sk_X509_EXTENSION_push);
    eval 'sub sk_X509_EXTENSION_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_EXTENSION, ($st), ($val)));
    }' unless defined(&sk_X509_EXTENSION_unshift);
    eval 'sub sk_X509_EXTENSION_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_EXTENSION, ($st), ($val)));
    }' unless defined(&sk_X509_EXTENSION_find);
    eval 'sub sk_X509_EXTENSION_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_EXTENSION, ($st), ($i)));
    }' unless defined(&sk_X509_EXTENSION_delete);
    eval 'sub sk_X509_EXTENSION_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_EXTENSION, ($st), ($ptr)));
    }' unless defined(&sk_X509_EXTENSION_delete_ptr);
    eval 'sub sk_X509_EXTENSION_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_EXTENSION, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_EXTENSION_insert);
    eval 'sub sk_X509_EXTENSION_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_EXTENSION, ($st), ($cmp)));
    }' unless defined(&sk_X509_EXTENSION_set_cmp_func);
    eval 'sub sk_X509_EXTENSION_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_EXTENSION, $st));
    }' unless defined(&sk_X509_EXTENSION_dup);
    eval 'sub sk_X509_EXTENSION_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_EXTENSION, ($st), ($free_func)));
    }' unless defined(&sk_X509_EXTENSION_pop_free);
    eval 'sub sk_X509_EXTENSION_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_EXTENSION, ($st)));
    }' unless defined(&sk_X509_EXTENSION_shift);
    eval 'sub sk_X509_EXTENSION_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_EXTENSION, ($st)));
    }' unless defined(&sk_X509_EXTENSION_pop);
    eval 'sub sk_X509_EXTENSION_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_EXTENSION, ($st)));
    }' unless defined(&sk_X509_EXTENSION_sort);
    eval 'sub sk_X509_EXTENSION_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_EXTENSION, ($st)));
    }' unless defined(&sk_X509_EXTENSION_is_sorted);
    eval 'sub sk_X509_INFO_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_INFO, ($st)));
    }' unless defined(&sk_X509_INFO_new);
    eval 'sub sk_X509_INFO_new_null () {
        eval q( &SKM_sk_new_null( &X509_INFO));
    }' unless defined(&sk_X509_INFO_new_null);
    eval 'sub sk_X509_INFO_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_INFO, ($st)));
    }' unless defined(&sk_X509_INFO_free);
    eval 'sub sk_X509_INFO_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_INFO, ($st)));
    }' unless defined(&sk_X509_INFO_num);
    eval 'sub sk_X509_INFO_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_INFO, ($st), ($i)));
    }' unless defined(&sk_X509_INFO_value);
    eval 'sub sk_X509_INFO_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_INFO, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_INFO_set);
    eval 'sub sk_X509_INFO_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_INFO, ($st)));
    }' unless defined(&sk_X509_INFO_zero);
    eval 'sub sk_X509_INFO_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_INFO, ($st), ($val)));
    }' unless defined(&sk_X509_INFO_push);
    eval 'sub sk_X509_INFO_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_INFO, ($st), ($val)));
    }' unless defined(&sk_X509_INFO_unshift);
    eval 'sub sk_X509_INFO_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_INFO, ($st), ($val)));
    }' unless defined(&sk_X509_INFO_find);
    eval 'sub sk_X509_INFO_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_INFO, ($st), ($i)));
    }' unless defined(&sk_X509_INFO_delete);
    eval 'sub sk_X509_INFO_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_INFO, ($st), ($ptr)));
    }' unless defined(&sk_X509_INFO_delete_ptr);
    eval 'sub sk_X509_INFO_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_INFO, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_INFO_insert);
    eval 'sub sk_X509_INFO_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_INFO, ($st), ($cmp)));
    }' unless defined(&sk_X509_INFO_set_cmp_func);
    eval 'sub sk_X509_INFO_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_INFO, $st));
    }' unless defined(&sk_X509_INFO_dup);
    eval 'sub sk_X509_INFO_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_INFO, ($st), ($free_func)));
    }' unless defined(&sk_X509_INFO_pop_free);
    eval 'sub sk_X509_INFO_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_INFO, ($st)));
    }' unless defined(&sk_X509_INFO_shift);
    eval 'sub sk_X509_INFO_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_INFO, ($st)));
    }' unless defined(&sk_X509_INFO_pop);
    eval 'sub sk_X509_INFO_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_INFO, ($st)));
    }' unless defined(&sk_X509_INFO_sort);
    eval 'sub sk_X509_INFO_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_INFO, ($st)));
    }' unless defined(&sk_X509_INFO_is_sorted);
    eval 'sub sk_X509_LOOKUP_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_LOOKUP, ($st)));
    }' unless defined(&sk_X509_LOOKUP_new);
    eval 'sub sk_X509_LOOKUP_new_null () {
        eval q( &SKM_sk_new_null( &X509_LOOKUP));
    }' unless defined(&sk_X509_LOOKUP_new_null);
    eval 'sub sk_X509_LOOKUP_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_LOOKUP, ($st)));
    }' unless defined(&sk_X509_LOOKUP_free);
    eval 'sub sk_X509_LOOKUP_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_LOOKUP, ($st)));
    }' unless defined(&sk_X509_LOOKUP_num);
    eval 'sub sk_X509_LOOKUP_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_LOOKUP, ($st), ($i)));
    }' unless defined(&sk_X509_LOOKUP_value);
    eval 'sub sk_X509_LOOKUP_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_LOOKUP, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_LOOKUP_set);
    eval 'sub sk_X509_LOOKUP_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_LOOKUP, ($st)));
    }' unless defined(&sk_X509_LOOKUP_zero);
    eval 'sub sk_X509_LOOKUP_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_LOOKUP, ($st), ($val)));
    }' unless defined(&sk_X509_LOOKUP_push);
    eval 'sub sk_X509_LOOKUP_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_LOOKUP, ($st), ($val)));
    }' unless defined(&sk_X509_LOOKUP_unshift);
    eval 'sub sk_X509_LOOKUP_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_LOOKUP, ($st), ($val)));
    }' unless defined(&sk_X509_LOOKUP_find);
    eval 'sub sk_X509_LOOKUP_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_LOOKUP, ($st), ($i)));
    }' unless defined(&sk_X509_LOOKUP_delete);
    eval 'sub sk_X509_LOOKUP_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_LOOKUP, ($st), ($ptr)));
    }' unless defined(&sk_X509_LOOKUP_delete_ptr);
    eval 'sub sk_X509_LOOKUP_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_LOOKUP, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_LOOKUP_insert);
    eval 'sub sk_X509_LOOKUP_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_LOOKUP, ($st), ($cmp)));
    }' unless defined(&sk_X509_LOOKUP_set_cmp_func);
    eval 'sub sk_X509_LOOKUP_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_LOOKUP, $st));
    }' unless defined(&sk_X509_LOOKUP_dup);
    eval 'sub sk_X509_LOOKUP_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_LOOKUP, ($st), ($free_func)));
    }' unless defined(&sk_X509_LOOKUP_pop_free);
    eval 'sub sk_X509_LOOKUP_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_LOOKUP, ($st)));
    }' unless defined(&sk_X509_LOOKUP_shift);
    eval 'sub sk_X509_LOOKUP_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_LOOKUP, ($st)));
    }' unless defined(&sk_X509_LOOKUP_pop);
    eval 'sub sk_X509_LOOKUP_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_LOOKUP, ($st)));
    }' unless defined(&sk_X509_LOOKUP_sort);
    eval 'sub sk_X509_LOOKUP_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_LOOKUP, ($st)));
    }' unless defined(&sk_X509_LOOKUP_is_sorted);
    eval 'sub sk_X509_NAME_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_NAME, ($st)));
    }' unless defined(&sk_X509_NAME_new);
    eval 'sub sk_X509_NAME_new_null () {
        eval q( &SKM_sk_new_null( &X509_NAME));
    }' unless defined(&sk_X509_NAME_new_null);
    eval 'sub sk_X509_NAME_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_NAME, ($st)));
    }' unless defined(&sk_X509_NAME_free);
    eval 'sub sk_X509_NAME_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_NAME, ($st)));
    }' unless defined(&sk_X509_NAME_num);
    eval 'sub sk_X509_NAME_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_NAME, ($st), ($i)));
    }' unless defined(&sk_X509_NAME_value);
    eval 'sub sk_X509_NAME_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_NAME, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_NAME_set);
    eval 'sub sk_X509_NAME_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_NAME, ($st)));
    }' unless defined(&sk_X509_NAME_zero);
    eval 'sub sk_X509_NAME_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_NAME, ($st), ($val)));
    }' unless defined(&sk_X509_NAME_push);
    eval 'sub sk_X509_NAME_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_NAME, ($st), ($val)));
    }' unless defined(&sk_X509_NAME_unshift);
    eval 'sub sk_X509_NAME_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_NAME, ($st), ($val)));
    }' unless defined(&sk_X509_NAME_find);
    eval 'sub sk_X509_NAME_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_NAME, ($st), ($i)));
    }' unless defined(&sk_X509_NAME_delete);
    eval 'sub sk_X509_NAME_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_NAME, ($st), ($ptr)));
    }' unless defined(&sk_X509_NAME_delete_ptr);
    eval 'sub sk_X509_NAME_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_NAME, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_NAME_insert);
    eval 'sub sk_X509_NAME_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_NAME, ($st), ($cmp)));
    }' unless defined(&sk_X509_NAME_set_cmp_func);
    eval 'sub sk_X509_NAME_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_NAME, $st));
    }' unless defined(&sk_X509_NAME_dup);
    eval 'sub sk_X509_NAME_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_NAME, ($st), ($free_func)));
    }' unless defined(&sk_X509_NAME_pop_free);
    eval 'sub sk_X509_NAME_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_NAME, ($st)));
    }' unless defined(&sk_X509_NAME_shift);
    eval 'sub sk_X509_NAME_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_NAME, ($st)));
    }' unless defined(&sk_X509_NAME_pop);
    eval 'sub sk_X509_NAME_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_NAME, ($st)));
    }' unless defined(&sk_X509_NAME_sort);
    eval 'sub sk_X509_NAME_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_NAME, ($st)));
    }' unless defined(&sk_X509_NAME_is_sorted);
    eval 'sub sk_X509_NAME_ENTRY_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_NAME_ENTRY, ($st)));
    }' unless defined(&sk_X509_NAME_ENTRY_new);
    eval 'sub sk_X509_NAME_ENTRY_new_null () {
        eval q( &SKM_sk_new_null( &X509_NAME_ENTRY));
    }' unless defined(&sk_X509_NAME_ENTRY_new_null);
    eval 'sub sk_X509_NAME_ENTRY_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_NAME_ENTRY, ($st)));
    }' unless defined(&sk_X509_NAME_ENTRY_free);
    eval 'sub sk_X509_NAME_ENTRY_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_NAME_ENTRY, ($st)));
    }' unless defined(&sk_X509_NAME_ENTRY_num);
    eval 'sub sk_X509_NAME_ENTRY_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_NAME_ENTRY, ($st), ($i)));
    }' unless defined(&sk_X509_NAME_ENTRY_value);
    eval 'sub sk_X509_NAME_ENTRY_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_NAME_ENTRY, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_NAME_ENTRY_set);
    eval 'sub sk_X509_NAME_ENTRY_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_NAME_ENTRY, ($st)));
    }' unless defined(&sk_X509_NAME_ENTRY_zero);
    eval 'sub sk_X509_NAME_ENTRY_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_NAME_ENTRY, ($st), ($val)));
    }' unless defined(&sk_X509_NAME_ENTRY_push);
    eval 'sub sk_X509_NAME_ENTRY_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_NAME_ENTRY, ($st), ($val)));
    }' unless defined(&sk_X509_NAME_ENTRY_unshift);
    eval 'sub sk_X509_NAME_ENTRY_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_NAME_ENTRY, ($st), ($val)));
    }' unless defined(&sk_X509_NAME_ENTRY_find);
    eval 'sub sk_X509_NAME_ENTRY_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_NAME_ENTRY, ($st), ($i)));
    }' unless defined(&sk_X509_NAME_ENTRY_delete);
    eval 'sub sk_X509_NAME_ENTRY_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_NAME_ENTRY, ($st), ($ptr)));
    }' unless defined(&sk_X509_NAME_ENTRY_delete_ptr);
    eval 'sub sk_X509_NAME_ENTRY_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_NAME_ENTRY, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_NAME_ENTRY_insert);
    eval 'sub sk_X509_NAME_ENTRY_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_NAME_ENTRY, ($st), ($cmp)));
    }' unless defined(&sk_X509_NAME_ENTRY_set_cmp_func);
    eval 'sub sk_X509_NAME_ENTRY_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_NAME_ENTRY, $st));
    }' unless defined(&sk_X509_NAME_ENTRY_dup);
    eval 'sub sk_X509_NAME_ENTRY_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_NAME_ENTRY, ($st), ($free_func)));
    }' unless defined(&sk_X509_NAME_ENTRY_pop_free);
    eval 'sub sk_X509_NAME_ENTRY_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_NAME_ENTRY, ($st)));
    }' unless defined(&sk_X509_NAME_ENTRY_shift);
    eval 'sub sk_X509_NAME_ENTRY_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_NAME_ENTRY, ($st)));
    }' unless defined(&sk_X509_NAME_ENTRY_pop);
    eval 'sub sk_X509_NAME_ENTRY_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_NAME_ENTRY, ($st)));
    }' unless defined(&sk_X509_NAME_ENTRY_sort);
    eval 'sub sk_X509_NAME_ENTRY_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_NAME_ENTRY, ($st)));
    }' unless defined(&sk_X509_NAME_ENTRY_is_sorted);
    eval 'sub sk_X509_OBJECT_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_OBJECT, ($st)));
    }' unless defined(&sk_X509_OBJECT_new);
    eval 'sub sk_X509_OBJECT_new_null () {
        eval q( &SKM_sk_new_null( &X509_OBJECT));
    }' unless defined(&sk_X509_OBJECT_new_null);
    eval 'sub sk_X509_OBJECT_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_OBJECT, ($st)));
    }' unless defined(&sk_X509_OBJECT_free);
    eval 'sub sk_X509_OBJECT_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_OBJECT, ($st)));
    }' unless defined(&sk_X509_OBJECT_num);
    eval 'sub sk_X509_OBJECT_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_OBJECT, ($st), ($i)));
    }' unless defined(&sk_X509_OBJECT_value);
    eval 'sub sk_X509_OBJECT_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_OBJECT, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_OBJECT_set);
    eval 'sub sk_X509_OBJECT_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_OBJECT, ($st)));
    }' unless defined(&sk_X509_OBJECT_zero);
    eval 'sub sk_X509_OBJECT_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_OBJECT, ($st), ($val)));
    }' unless defined(&sk_X509_OBJECT_push);
    eval 'sub sk_X509_OBJECT_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_OBJECT, ($st), ($val)));
    }' unless defined(&sk_X509_OBJECT_unshift);
    eval 'sub sk_X509_OBJECT_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_OBJECT, ($st), ($val)));
    }' unless defined(&sk_X509_OBJECT_find);
    eval 'sub sk_X509_OBJECT_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_OBJECT, ($st), ($i)));
    }' unless defined(&sk_X509_OBJECT_delete);
    eval 'sub sk_X509_OBJECT_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_OBJECT, ($st), ($ptr)));
    }' unless defined(&sk_X509_OBJECT_delete_ptr);
    eval 'sub sk_X509_OBJECT_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_OBJECT, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_OBJECT_insert);
    eval 'sub sk_X509_OBJECT_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_OBJECT, ($st), ($cmp)));
    }' unless defined(&sk_X509_OBJECT_set_cmp_func);
    eval 'sub sk_X509_OBJECT_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_OBJECT, $st));
    }' unless defined(&sk_X509_OBJECT_dup);
    eval 'sub sk_X509_OBJECT_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_OBJECT, ($st), ($free_func)));
    }' unless defined(&sk_X509_OBJECT_pop_free);
    eval 'sub sk_X509_OBJECT_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_OBJECT, ($st)));
    }' unless defined(&sk_X509_OBJECT_shift);
    eval 'sub sk_X509_OBJECT_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_OBJECT, ($st)));
    }' unless defined(&sk_X509_OBJECT_pop);
    eval 'sub sk_X509_OBJECT_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_OBJECT, ($st)));
    }' unless defined(&sk_X509_OBJECT_sort);
    eval 'sub sk_X509_OBJECT_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_OBJECT, ($st)));
    }' unless defined(&sk_X509_OBJECT_is_sorted);
    eval 'sub sk_X509_PURPOSE_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_PURPOSE, ($st)));
    }' unless defined(&sk_X509_PURPOSE_new);
    eval 'sub sk_X509_PURPOSE_new_null () {
        eval q( &SKM_sk_new_null( &X509_PURPOSE));
    }' unless defined(&sk_X509_PURPOSE_new_null);
    eval 'sub sk_X509_PURPOSE_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_PURPOSE, ($st)));
    }' unless defined(&sk_X509_PURPOSE_free);
    eval 'sub sk_X509_PURPOSE_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_PURPOSE, ($st)));
    }' unless defined(&sk_X509_PURPOSE_num);
    eval 'sub sk_X509_PURPOSE_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_PURPOSE, ($st), ($i)));
    }' unless defined(&sk_X509_PURPOSE_value);
    eval 'sub sk_X509_PURPOSE_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_PURPOSE, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_PURPOSE_set);
    eval 'sub sk_X509_PURPOSE_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_PURPOSE, ($st)));
    }' unless defined(&sk_X509_PURPOSE_zero);
    eval 'sub sk_X509_PURPOSE_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_PURPOSE, ($st), ($val)));
    }' unless defined(&sk_X509_PURPOSE_push);
    eval 'sub sk_X509_PURPOSE_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_PURPOSE, ($st), ($val)));
    }' unless defined(&sk_X509_PURPOSE_unshift);
    eval 'sub sk_X509_PURPOSE_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_PURPOSE, ($st), ($val)));
    }' unless defined(&sk_X509_PURPOSE_find);
    eval 'sub sk_X509_PURPOSE_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_PURPOSE, ($st), ($i)));
    }' unless defined(&sk_X509_PURPOSE_delete);
    eval 'sub sk_X509_PURPOSE_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_PURPOSE, ($st), ($ptr)));
    }' unless defined(&sk_X509_PURPOSE_delete_ptr);
    eval 'sub sk_X509_PURPOSE_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_PURPOSE, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_PURPOSE_insert);
    eval 'sub sk_X509_PURPOSE_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_PURPOSE, ($st), ($cmp)));
    }' unless defined(&sk_X509_PURPOSE_set_cmp_func);
    eval 'sub sk_X509_PURPOSE_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_PURPOSE, $st));
    }' unless defined(&sk_X509_PURPOSE_dup);
    eval 'sub sk_X509_PURPOSE_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_PURPOSE, ($st), ($free_func)));
    }' unless defined(&sk_X509_PURPOSE_pop_free);
    eval 'sub sk_X509_PURPOSE_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_PURPOSE, ($st)));
    }' unless defined(&sk_X509_PURPOSE_shift);
    eval 'sub sk_X509_PURPOSE_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_PURPOSE, ($st)));
    }' unless defined(&sk_X509_PURPOSE_pop);
    eval 'sub sk_X509_PURPOSE_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_PURPOSE, ($st)));
    }' unless defined(&sk_X509_PURPOSE_sort);
    eval 'sub sk_X509_PURPOSE_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_PURPOSE, ($st)));
    }' unless defined(&sk_X509_PURPOSE_is_sorted);
    eval 'sub sk_X509_REVOKED_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_REVOKED, ($st)));
    }' unless defined(&sk_X509_REVOKED_new);
    eval 'sub sk_X509_REVOKED_new_null () {
        eval q( &SKM_sk_new_null( &X509_REVOKED));
    }' unless defined(&sk_X509_REVOKED_new_null);
    eval 'sub sk_X509_REVOKED_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_REVOKED, ($st)));
    }' unless defined(&sk_X509_REVOKED_free);
    eval 'sub sk_X509_REVOKED_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_REVOKED, ($st)));
    }' unless defined(&sk_X509_REVOKED_num);
    eval 'sub sk_X509_REVOKED_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_REVOKED, ($st), ($i)));
    }' unless defined(&sk_X509_REVOKED_value);
    eval 'sub sk_X509_REVOKED_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_REVOKED, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_REVOKED_set);
    eval 'sub sk_X509_REVOKED_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_REVOKED, ($st)));
    }' unless defined(&sk_X509_REVOKED_zero);
    eval 'sub sk_X509_REVOKED_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_REVOKED, ($st), ($val)));
    }' unless defined(&sk_X509_REVOKED_push);
    eval 'sub sk_X509_REVOKED_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_REVOKED, ($st), ($val)));
    }' unless defined(&sk_X509_REVOKED_unshift);
    eval 'sub sk_X509_REVOKED_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_REVOKED, ($st), ($val)));
    }' unless defined(&sk_X509_REVOKED_find);
    eval 'sub sk_X509_REVOKED_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_REVOKED, ($st), ($i)));
    }' unless defined(&sk_X509_REVOKED_delete);
    eval 'sub sk_X509_REVOKED_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_REVOKED, ($st), ($ptr)));
    }' unless defined(&sk_X509_REVOKED_delete_ptr);
    eval 'sub sk_X509_REVOKED_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_REVOKED, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_REVOKED_insert);
    eval 'sub sk_X509_REVOKED_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_REVOKED, ($st), ($cmp)));
    }' unless defined(&sk_X509_REVOKED_set_cmp_func);
    eval 'sub sk_X509_REVOKED_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_REVOKED, $st));
    }' unless defined(&sk_X509_REVOKED_dup);
    eval 'sub sk_X509_REVOKED_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_REVOKED, ($st), ($free_func)));
    }' unless defined(&sk_X509_REVOKED_pop_free);
    eval 'sub sk_X509_REVOKED_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_REVOKED, ($st)));
    }' unless defined(&sk_X509_REVOKED_shift);
    eval 'sub sk_X509_REVOKED_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_REVOKED, ($st)));
    }' unless defined(&sk_X509_REVOKED_pop);
    eval 'sub sk_X509_REVOKED_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_REVOKED, ($st)));
    }' unless defined(&sk_X509_REVOKED_sort);
    eval 'sub sk_X509_REVOKED_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_REVOKED, ($st)));
    }' unless defined(&sk_X509_REVOKED_is_sorted);
    eval 'sub sk_X509_TRUST_new {
        local($st) = @_;
	    eval q( &SKM_sk_new( &X509_TRUST, ($st)));
    }' unless defined(&sk_X509_TRUST_new);
    eval 'sub sk_X509_TRUST_new_null () {
        eval q( &SKM_sk_new_null( &X509_TRUST));
    }' unless defined(&sk_X509_TRUST_new_null);
    eval 'sub sk_X509_TRUST_free {
        local($st) = @_;
	    eval q( &SKM_sk_free( &X509_TRUST, ($st)));
    }' unless defined(&sk_X509_TRUST_free);
    eval 'sub sk_X509_TRUST_num {
        local($st) = @_;
	    eval q( &SKM_sk_num( &X509_TRUST, ($st)));
    }' unless defined(&sk_X509_TRUST_num);
    eval 'sub sk_X509_TRUST_value {
        local($st, $i) = @_;
	    eval q( &SKM_sk_value( &X509_TRUST, ($st), ($i)));
    }' unless defined(&sk_X509_TRUST_value);
    eval 'sub sk_X509_TRUST_set {
        local($st, $i, $val) = @_;
	    eval q( &SKM_sk_set( &X509_TRUST, ($st), ($i), ($val)));
    }' unless defined(&sk_X509_TRUST_set);
    eval 'sub sk_X509_TRUST_zero {
        local($st) = @_;
	    eval q( &SKM_sk_zero( &X509_TRUST, ($st)));
    }' unless defined(&sk_X509_TRUST_zero);
    eval 'sub sk_X509_TRUST_push {
        local($st, $val) = @_;
	    eval q( &SKM_sk_push( &X509_TRUST, ($st), ($val)));
    }' unless defined(&sk_X509_TRUST_push);
    eval 'sub sk_X509_TRUST_unshift {
        local($st, $val) = @_;
	    eval q( &SKM_sk_unshift( &X509_TRUST, ($st), ($val)));
    }' unless defined(&sk_X509_TRUST_unshift);
    eval 'sub sk_X509_TRUST_find {
        local($st, $val) = @_;
	    eval q( &SKM_sk_find( &X509_TRUST, ($st), ($val)));
    }' unless defined(&sk_X509_TRUST_find);
    eval 'sub sk_X509_TRUST_delete {
        local($st, $i) = @_;
	    eval q( &SKM_sk_delete( &X509_TRUST, ($st), ($i)));
    }' unless defined(&sk_X509_TRUST_delete);
    eval 'sub sk_X509_TRUST_delete_ptr {
        local($st, $ptr) = @_;
	    eval q( &SKM_sk_delete_ptr( &X509_TRUST, ($st), ($ptr)));
    }' unless defined(&sk_X509_TRUST_delete_ptr);
    eval 'sub sk_X509_TRUST_insert {
        local($st, $val, $i) = @_;
	    eval q( &SKM_sk_insert( &X509_TRUST, ($st), ($val), ($i)));
    }' unless defined(&sk_X509_TRUST_insert);
    eval 'sub sk_X509_TRUST_set_cmp_func {
        local($st, $cmp) = @_;
	    eval q( &SKM_sk_set_cmp_func( &X509_TRUST, ($st), ($cmp)));
    }' unless defined(&sk_X509_TRUST_set_cmp_func);
    eval 'sub sk_X509_TRUST_dup {
        local($st) = @_;
	    eval q( &SKM_sk_dup( &X509_TRUST, $st));
    }' unless defined(&sk_X509_TRUST_dup);
    eval 'sub sk_X509_TRUST_pop_free {
        local($st, $free_func) = @_;
	    eval q( &SKM_sk_pop_free( &X509_TRUST, ($st), ($free_func)));
    }' unless defined(&sk_X509_TRUST_pop_free);
    eval 'sub sk_X509_TRUST_shift {
        local($st) = @_;
	    eval q( &SKM_sk_shift( &X509_TRUST, ($st)));
    }' unless defined(&sk_X509_TRUST_shift);
    eval 'sub sk_X509_TRUST_pop {
        local($st) = @_;
	    eval q( &SKM_sk_pop( &X509_TRUST, ($st)));
    }' unless defined(&sk_X509_TRUST_pop);
    eval 'sub sk_X509_TRUST_sort {
        local($st) = @_;
	    eval q( &SKM_sk_sort( &X509_TRUST, ($st)));
    }' unless defined(&sk_X509_TRUST_sort);
    eval 'sub sk_X509_TRUST_is_sorted {
        local($st) = @_;
	    eval q( &SKM_sk_is_sorted( &X509_TRUST, ($st)));
    }' unless defined(&sk_X509_TRUST_is_sorted);
    eval 'sub d2i_ASN1_SET_OF_ACCESS_DESCRIPTION {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &ACCESS_DESCRIPTION, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_ACCESS_DESCRIPTION);
    eval 'sub i2d_ASN1_SET_OF_ACCESS_DESCRIPTION {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &ACCESS_DESCRIPTION, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_ACCESS_DESCRIPTION);
    eval 'sub ASN1_seq_pack_ACCESS_DESCRIPTION {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &ACCESS_DESCRIPTION, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_ACCESS_DESCRIPTION);
    eval 'sub ASN1_seq_unpack_ACCESS_DESCRIPTION {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &ACCESS_DESCRIPTION, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_ACCESS_DESCRIPTION);
    eval 'sub d2i_ASN1_SET_OF_ASN1_INTEGER {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &ASN1_INTEGER, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_ASN1_INTEGER);
    eval 'sub i2d_ASN1_SET_OF_ASN1_INTEGER {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &ASN1_INTEGER, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_ASN1_INTEGER);
    eval 'sub ASN1_seq_pack_ASN1_INTEGER {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &ASN1_INTEGER, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_ASN1_INTEGER);
    eval 'sub ASN1_seq_unpack_ASN1_INTEGER {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &ASN1_INTEGER, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_ASN1_INTEGER);
    eval 'sub d2i_ASN1_SET_OF_ASN1_OBJECT {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &ASN1_OBJECT, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_ASN1_OBJECT);
    eval 'sub i2d_ASN1_SET_OF_ASN1_OBJECT {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &ASN1_OBJECT, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_ASN1_OBJECT);
    eval 'sub ASN1_seq_pack_ASN1_OBJECT {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &ASN1_OBJECT, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_ASN1_OBJECT);
    eval 'sub ASN1_seq_unpack_ASN1_OBJECT {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &ASN1_OBJECT, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_ASN1_OBJECT);
    eval 'sub d2i_ASN1_SET_OF_ASN1_TYPE {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &ASN1_TYPE, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_ASN1_TYPE);
    eval 'sub i2d_ASN1_SET_OF_ASN1_TYPE {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &ASN1_TYPE, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_ASN1_TYPE);
    eval 'sub ASN1_seq_pack_ASN1_TYPE {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &ASN1_TYPE, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_ASN1_TYPE);
    eval 'sub ASN1_seq_unpack_ASN1_TYPE {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &ASN1_TYPE, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_ASN1_TYPE);
    eval 'sub d2i_ASN1_SET_OF_DIST_POINT {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &DIST_POINT, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_DIST_POINT);
    eval 'sub i2d_ASN1_SET_OF_DIST_POINT {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &DIST_POINT, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_DIST_POINT);
    eval 'sub ASN1_seq_pack_DIST_POINT {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &DIST_POINT, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_DIST_POINT);
    eval 'sub ASN1_seq_unpack_DIST_POINT {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &DIST_POINT, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_DIST_POINT);
    eval 'sub d2i_ASN1_SET_OF_GENERAL_NAME {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &GENERAL_NAME, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_GENERAL_NAME);
    eval 'sub i2d_ASN1_SET_OF_GENERAL_NAME {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &GENERAL_NAME, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_GENERAL_NAME);
    eval 'sub ASN1_seq_pack_GENERAL_NAME {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &GENERAL_NAME, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_GENERAL_NAME);
    eval 'sub ASN1_seq_unpack_GENERAL_NAME {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &GENERAL_NAME, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_GENERAL_NAME);
    eval 'sub d2i_ASN1_SET_OF_OCSP_ONEREQ {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &OCSP_ONEREQ, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_OCSP_ONEREQ);
    eval 'sub i2d_ASN1_SET_OF_OCSP_ONEREQ {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &OCSP_ONEREQ, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_OCSP_ONEREQ);
    eval 'sub ASN1_seq_pack_OCSP_ONEREQ {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &OCSP_ONEREQ, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_OCSP_ONEREQ);
    eval 'sub ASN1_seq_unpack_OCSP_ONEREQ {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &OCSP_ONEREQ, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_OCSP_ONEREQ);
    eval 'sub d2i_ASN1_SET_OF_OCSP_SINGLERESP {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &OCSP_SINGLERESP, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_OCSP_SINGLERESP);
    eval 'sub i2d_ASN1_SET_OF_OCSP_SINGLERESP {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &OCSP_SINGLERESP, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_OCSP_SINGLERESP);
    eval 'sub ASN1_seq_pack_OCSP_SINGLERESP {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &OCSP_SINGLERESP, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_OCSP_SINGLERESP);
    eval 'sub ASN1_seq_unpack_OCSP_SINGLERESP {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &OCSP_SINGLERESP, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_OCSP_SINGLERESP);
    eval 'sub d2i_ASN1_SET_OF_PKCS12_SAFEBAG {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &PKCS12_SAFEBAG, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_PKCS12_SAFEBAG);
    eval 'sub i2d_ASN1_SET_OF_PKCS12_SAFEBAG {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &PKCS12_SAFEBAG, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_PKCS12_SAFEBAG);
    eval 'sub ASN1_seq_pack_PKCS12_SAFEBAG {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &PKCS12_SAFEBAG, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_PKCS12_SAFEBAG);
    eval 'sub ASN1_seq_unpack_PKCS12_SAFEBAG {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &PKCS12_SAFEBAG, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_PKCS12_SAFEBAG);
    eval 'sub d2i_ASN1_SET_OF_PKCS7 {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &PKCS7, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_PKCS7);
    eval 'sub i2d_ASN1_SET_OF_PKCS7 {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &PKCS7, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_PKCS7);
    eval 'sub ASN1_seq_pack_PKCS7 {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &PKCS7, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_PKCS7);
    eval 'sub ASN1_seq_unpack_PKCS7 {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &PKCS7, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_PKCS7);
    eval 'sub d2i_ASN1_SET_OF_PKCS7_RECIP_INFO {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &PKCS7_RECIP_INFO, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_PKCS7_RECIP_INFO);
    eval 'sub i2d_ASN1_SET_OF_PKCS7_RECIP_INFO {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &PKCS7_RECIP_INFO, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_PKCS7_RECIP_INFO);
    eval 'sub ASN1_seq_pack_PKCS7_RECIP_INFO {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &PKCS7_RECIP_INFO, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_PKCS7_RECIP_INFO);
    eval 'sub ASN1_seq_unpack_PKCS7_RECIP_INFO {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &PKCS7_RECIP_INFO, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_PKCS7_RECIP_INFO);
    eval 'sub d2i_ASN1_SET_OF_PKCS7_SIGNER_INFO {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &PKCS7_SIGNER_INFO, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_PKCS7_SIGNER_INFO);
    eval 'sub i2d_ASN1_SET_OF_PKCS7_SIGNER_INFO {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &PKCS7_SIGNER_INFO, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_PKCS7_SIGNER_INFO);
    eval 'sub ASN1_seq_pack_PKCS7_SIGNER_INFO {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &PKCS7_SIGNER_INFO, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_PKCS7_SIGNER_INFO);
    eval 'sub ASN1_seq_unpack_PKCS7_SIGNER_INFO {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &PKCS7_SIGNER_INFO, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_PKCS7_SIGNER_INFO);
    eval 'sub d2i_ASN1_SET_OF_POLICYINFO {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &POLICYINFO, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_POLICYINFO);
    eval 'sub i2d_ASN1_SET_OF_POLICYINFO {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &POLICYINFO, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_POLICYINFO);
    eval 'sub ASN1_seq_pack_POLICYINFO {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &POLICYINFO, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_POLICYINFO);
    eval 'sub ASN1_seq_unpack_POLICYINFO {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &POLICYINFO, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_POLICYINFO);
    eval 'sub d2i_ASN1_SET_OF_POLICYQUALINFO {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &POLICYQUALINFO, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_POLICYQUALINFO);
    eval 'sub i2d_ASN1_SET_OF_POLICYQUALINFO {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &POLICYQUALINFO, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_POLICYQUALINFO);
    eval 'sub ASN1_seq_pack_POLICYQUALINFO {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &POLICYQUALINFO, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_POLICYQUALINFO);
    eval 'sub ASN1_seq_unpack_POLICYQUALINFO {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &POLICYQUALINFO, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_POLICYQUALINFO);
    eval 'sub d2i_ASN1_SET_OF_SXNETID {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &SXNETID, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_SXNETID);
    eval 'sub i2d_ASN1_SET_OF_SXNETID {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &SXNETID, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_SXNETID);
    eval 'sub ASN1_seq_pack_SXNETID {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &SXNETID, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_SXNETID);
    eval 'sub ASN1_seq_unpack_SXNETID {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &SXNETID, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_SXNETID);
    eval 'sub d2i_ASN1_SET_OF_X509 {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &X509, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_X509);
    eval 'sub i2d_ASN1_SET_OF_X509 {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &X509, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_X509);
    eval 'sub ASN1_seq_pack_X509 {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &X509, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_X509);
    eval 'sub ASN1_seq_unpack_X509 {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &X509, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_X509);
    eval 'sub d2i_ASN1_SET_OF_X509_ALGOR {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &X509_ALGOR, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_X509_ALGOR);
    eval 'sub i2d_ASN1_SET_OF_X509_ALGOR {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &X509_ALGOR, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_X509_ALGOR);
    eval 'sub ASN1_seq_pack_X509_ALGOR {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &X509_ALGOR, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_X509_ALGOR);
    eval 'sub ASN1_seq_unpack_X509_ALGOR {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &X509_ALGOR, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_X509_ALGOR);
    eval 'sub d2i_ASN1_SET_OF_X509_ATTRIBUTE {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &X509_ATTRIBUTE, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_X509_ATTRIBUTE);
    eval 'sub i2d_ASN1_SET_OF_X509_ATTRIBUTE {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &X509_ATTRIBUTE, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_X509_ATTRIBUTE);
    eval 'sub ASN1_seq_pack_X509_ATTRIBUTE {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &X509_ATTRIBUTE, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_X509_ATTRIBUTE);
    eval 'sub ASN1_seq_unpack_X509_ATTRIBUTE {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &X509_ATTRIBUTE, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_X509_ATTRIBUTE);
    eval 'sub d2i_ASN1_SET_OF_X509_CRL {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &X509_CRL, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_X509_CRL);
    eval 'sub i2d_ASN1_SET_OF_X509_CRL {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &X509_CRL, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_X509_CRL);
    eval 'sub ASN1_seq_pack_X509_CRL {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &X509_CRL, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_X509_CRL);
    eval 'sub ASN1_seq_unpack_X509_CRL {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &X509_CRL, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_X509_CRL);
    eval 'sub d2i_ASN1_SET_OF_X509_EXTENSION {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &X509_EXTENSION, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_X509_EXTENSION);
    eval 'sub i2d_ASN1_SET_OF_X509_EXTENSION {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &X509_EXTENSION, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_X509_EXTENSION);
    eval 'sub ASN1_seq_pack_X509_EXTENSION {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &X509_EXTENSION, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_X509_EXTENSION);
    eval 'sub ASN1_seq_unpack_X509_EXTENSION {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &X509_EXTENSION, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_X509_EXTENSION);
    eval 'sub d2i_ASN1_SET_OF_X509_NAME_ENTRY {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &X509_NAME_ENTRY, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_X509_NAME_ENTRY);
    eval 'sub i2d_ASN1_SET_OF_X509_NAME_ENTRY {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &X509_NAME_ENTRY, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_X509_NAME_ENTRY);
    eval 'sub ASN1_seq_pack_X509_NAME_ENTRY {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &X509_NAME_ENTRY, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_X509_NAME_ENTRY);
    eval 'sub ASN1_seq_unpack_X509_NAME_ENTRY {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &X509_NAME_ENTRY, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_X509_NAME_ENTRY);
    eval 'sub d2i_ASN1_SET_OF_X509_REVOKED {
        local($st, $pp, $length, $d2i_func, $free_func, $ex_tag, $ex_class) = @_;
	    eval q( &SKM_ASN1_SET_OF_d2i( &X509_REVOKED, ($st), ($pp), ($length), ($d2i_func), ($free_func), ($ex_tag), ($ex_class)));
    }' unless defined(&d2i_ASN1_SET_OF_X509_REVOKED);
    eval 'sub i2d_ASN1_SET_OF_X509_REVOKED {
        local($st, $pp, $i2d_func, $ex_tag, $ex_class, $is_set) = @_;
	    eval q( &SKM_ASN1_SET_OF_i2d( &X509_REVOKED, ($st), ($pp), ($i2d_func), ($ex_tag), ($ex_class), ($is_set)));
    }' unless defined(&i2d_ASN1_SET_OF_X509_REVOKED);
    eval 'sub ASN1_seq_pack_X509_REVOKED {
        local($st, $i2d_func, $buf, $len) = @_;
	    eval q( &SKM_ASN1_seq_pack( &X509_REVOKED, ($st), ($i2d_func), ($buf), ($len)));
    }' unless defined(&ASN1_seq_pack_X509_REVOKED);
    eval 'sub ASN1_seq_unpack_X509_REVOKED {
        local($buf, $len, $d2i_func, $free_func) = @_;
	    eval q( &SKM_ASN1_seq_unpack( &X509_REVOKED, ($buf), ($len), ($d2i_func), ($free_func)));
    }' unless defined(&ASN1_seq_unpack_X509_REVOKED);
    eval 'sub PKCS12_decrypt_d2i_PKCS12_SAFEBAG {
        local($algor, $d2i_func, $free_func, $pass, $passlen, $oct, $seq) = @_;
	    eval q( &SKM_PKCS12_decrypt_d2i( &PKCS12_SAFEBAG, ($algor), ($d2i_func), ($free_func), ($pass), ($passlen), ($oct), ($seq)));
    }' unless defined(&PKCS12_decrypt_d2i_PKCS12_SAFEBAG);
    eval 'sub PKCS12_decrypt_d2i_PKCS7 {
        local($algor, $d2i_func, $free_func, $pass, $passlen, $oct, $seq) = @_;
	    eval q( &SKM_PKCS12_decrypt_d2i( &PKCS7, ($algor), ($d2i_func), ($free_func), ($pass), ($passlen), ($oct), ($seq)));
    }' unless defined(&PKCS12_decrypt_d2i_PKCS7);
}
1;
