require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_BIT_TWIDDLE)) {
    eval 'sub _BIT_TWIDDLE () {1;}' unless defined(&_BIT_TWIDDLE);
    eval 'sub BIT {
        local($n) = @_;
	    eval q(((($n) == 32) ? 0: (( &u_int32_t) 1<< ($n))));
    }' unless defined(&BIT);
    eval 'sub BITS {
        local($m, $n) = @_;
	    eval q((( &BIT( &MAX(($m), ($n)) + 1) - 1) ^ ( &BIT( &MIN(($m), ($n))) - 1)));
    }' unless defined(&BITS);
    eval 'sub LOWEST_SET_BIT {
        local($x) = @_;
	    eval q((((($x) - 1) & ($x)) ^ ($x)));
    }' unless defined(&LOWEST_SET_BIT);
    eval 'sub GTEQ_POWER {
        local($x, $p) = @_;
	    eval q(((($x) >> ($p)) != 0));
    }' unless defined(&GTEQ_POWER);
    eval 'sub MASK_TO_SHIFT2 {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 1) ? 1: 0));
    }' unless defined(&MASK_TO_SHIFT2);
    eval 'sub MASK_TO_SHIFT4 {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 2) ? 2+  &MASK_TO_SHIFT2(($m) >> 2) :  &MASK_TO_SHIFT2(($m))));
    }' unless defined(&MASK_TO_SHIFT4);
    eval 'sub MASK_TO_SHIFT8 {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 4) ? 4+  &MASK_TO_SHIFT4(($m) >> 4) :  &MASK_TO_SHIFT4(($m))));
    }' unless defined(&MASK_TO_SHIFT8);
    eval 'sub MASK_TO_SHIFT16 {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 8) ? 8+  &MASK_TO_SHIFT8(($m) >> 8) :  &MASK_TO_SHIFT8(($m))));
    }' unless defined(&MASK_TO_SHIFT16);
    eval 'sub MASK_TO_SHIFT {
        local($m) = @_;
	    eval q(( &GTEQ_POWER( &LOWEST_SET_BIT(($m)), 16) ? 16+  &MASK_TO_SHIFT16(($m) >> 16) :  &MASK_TO_SHIFT16(($m))));
    }' unless defined(&MASK_TO_SHIFT);
    eval 'sub MASK_AND_RSHIFT {
        local($x, $mask) = @_;
	    eval q(((($x) & ($mask)) >>  &MASK_TO_SHIFT($mask)));
    }' unless defined(&MASK_AND_RSHIFT);
    eval 'sub LSHIFT {
        local($x, $mask) = @_;
	    eval q((($x) <<  &MASK_TO_SHIFT($mask)));
    }' unless defined(&LSHIFT);
    eval 'sub MASK_AND_REPLACE {
        local($reg, $val, $mask) = @_;
	    eval q((($reg & ~$mask) |  &LSHIFT($val, $mask)));
    }' unless defined(&MASK_AND_REPLACE);
    eval 'sub PRESHIFT {
        local($m) = @_;
	    eval q( &MASK_AND_RSHIFT(($m), ($m)));
    }' unless defined(&PRESHIFT);
}
unless(defined(&ATW_PAR)) {
    sub ATW_PAR () {	0x;}
}
unless(defined(&ATW_FRCTL)) {
    sub ATW_FRCTL () {	0x4;}
}
unless(defined(&ATW_TDR)) {
    sub ATW_TDR () {	0x8;}
}
unless(defined(&ATW_WTDP)) {
    sub ATW_WTDP () {	0xc;}
}
unless(defined(&ATW_RDR)) {
    sub ATW_RDR () {	0x10;}
}
unless(defined(&ATW_WRDP)) {
    sub ATW_WRDP () {	0x14;}
}
unless(defined(&ATW_RDB)) {
    sub ATW_RDB () {	0x18;}
}
unless(defined(&ATW_CSR3A)) {
    sub ATW_CSR3A () {	0x1c;}
}
unless(defined(&ATW_C_TDBH)) {
    sub ATW_C_TDBH () {	0x1c;}
}
unless(defined(&ATW_TDBD)) {
    sub ATW_TDBD () {	0x20;}
}
unless(defined(&ATW_TDBP)) {
    sub ATW_TDBP () {	0x24;}
}
unless(defined(&ATW_STSR)) {
    sub ATW_STSR () {	0x28;}
}
unless(defined(&ATW_CSR5A)) {
    sub ATW_CSR5A () {	0x2c;}
}
unless(defined(&ATW_C_TDBB)) {
    sub ATW_C_TDBB () {	0x2c;}
}
unless(defined(&ATW_NAR)) {
    sub ATW_NAR () {	0x30;}
}
unless(defined(&ATW_CSR6A)) {
    sub ATW_CSR6A () {	0x34;}
}
unless(defined(&ATW_IER)) {
    sub ATW_IER () {	0x38;}
}
unless(defined(&ATW_CSR7A)) {
    sub ATW_CSR7A () {	0x3c;}
}
unless(defined(&ATW_LPC)) {
    sub ATW_LPC () {	0x40;}
}
unless(defined(&ATW_TEST1)) {
    sub ATW_TEST1 () {	0x44;}
}
unless(defined(&ATW_SPR)) {
    sub ATW_SPR () {	0x48;}
}
unless(defined(&ATW_TEST0)) {
    sub ATW_TEST0 () {	0x4c;}
}
unless(defined(&ATW_WCSR)) {
    sub ATW_WCSR () {	0x50;}
}
unless(defined(&ATW_WPDR)) {
    sub ATW_WPDR () {	0x54;}
}
unless(defined(&ATW_GPTMR)) {
    sub ATW_GPTMR () {	0x58;}
}
unless(defined(&ATW_GPIO)) {
    sub ATW_GPIO () {	0x5c;}
}
unless(defined(&ATW_BBPCTL)) {
    sub ATW_BBPCTL () {	0x60;}
}
unless(defined(&ATW_SYNCTL)) {
    sub ATW_SYNCTL () {	0x64;}
}
unless(defined(&ATW_PLCPHD)) {
    sub ATW_PLCPHD () {	0x68;}
}
unless(defined(&ATW_MMIWADDR)) {
    sub ATW_MMIWADDR () {	0x6c;}
}
unless(defined(&ATW_MMIRADDR1)) {
    sub ATW_MMIRADDR1 () {	0x70;}
}
unless(defined(&ATW_MMIRADDR2)) {
    sub ATW_MMIRADDR2 () {	0x74;}
}
unless(defined(&ATW_TXBR)) {
    sub ATW_TXBR () {	0x78;}
}
unless(defined(&ATW_CSR15A)) {
    sub ATW_CSR15A () {	0x7c;}
}
unless(defined(&ATW_ALCSTAT)) {
    sub ATW_ALCSTAT () {	0x80;}
}
unless(defined(&ATW_TOFS2)) {
    sub ATW_TOFS2 () {	0x84;}
}
unless(defined(&ATW_CMDR)) {
    sub ATW_CMDR () {	0x88;}
}
unless(defined(&ATW_PCIC)) {
    sub ATW_PCIC () {	0x8c;}
}
unless(defined(&ATW_PMCSR)) {
    sub ATW_PMCSR () {	0x90;}
}
unless(defined(&ATW_PAR0)) {
    sub ATW_PAR0 () {	0x94;}
}
unless(defined(&ATW_PAR1)) {
    sub ATW_PAR1 () {	0x98;}
}
unless(defined(&ATW_MAR0)) {
    sub ATW_MAR0 () {	0x9c;}
}
unless(defined(&ATW_MAR1)) {
    sub ATW_MAR1 () {	0xa0;}
}
unless(defined(&ATW_ATIMDA0)) {
    sub ATW_ATIMDA0 () {	0xa4;}
}
unless(defined(&ATW_ABDA1)) {
    sub ATW_ABDA1 () {	0xa8;}
}
unless(defined(&ATW_BSSID0)) {
    sub ATW_BSSID0 () {	0xac;}
}
unless(defined(&ATW_TXLMT)) {
    sub ATW_TXLMT () {	0xb0;}
}
unless(defined(&ATW_MIBCNT)) {
    sub ATW_MIBCNT () {	0xb4;}
}
unless(defined(&ATW_BCNT)) {
    sub ATW_BCNT () {	0xb8;}
}
unless(defined(&ATW_TSFTH)) {
    sub ATW_TSFTH () {	0xbc;}
}
unless(defined(&ATW_TSC)) {
    sub ATW_TSC () {	0xc0;}
}
unless(defined(&ATW_SYNRF)) {
    sub ATW_SYNRF () {	0xc4;}
}
unless(defined(&ATW_BPLI)) {
    sub ATW_BPLI () {	0xc8;}
}
unless(defined(&ATW_CAP0)) {
    sub ATW_CAP0 () {	0xcc;}
}
unless(defined(&ATW_CAP1)) {
    sub ATW_CAP1 () {	0xd0;}
}
unless(defined(&ATW_RMD)) {
    sub ATW_RMD () {	0xd4;}
}
unless(defined(&ATW_CFPP)) {
    sub ATW_CFPP () {	0xd8;}
}
unless(defined(&ATW_TOFS0)) {
    sub ATW_TOFS0 () {	0xdc;}
}
unless(defined(&ATW_TOFS1)) {
    sub ATW_TOFS1 () {	0xe0;}
}
unless(defined(&ATW_IFST)) {
    sub ATW_IFST () {	0xe4;}
}
unless(defined(&ATW_RSPT)) {
    sub ATW_RSPT () {	0xe8;}
}
unless(defined(&ATW_TSFTL)) {
    sub ATW_TSFTL () {	0xec;}
}
unless(defined(&ATW_WEPCTL)) {
    sub ATW_WEPCTL () {	0xf0;}
}
unless(defined(&ATW_WESK)) {
    sub ATW_WESK () {	0xf4;}
}
unless(defined(&ATW_WEPCNT)) {
    sub ATW_WEPCNT () {	0xf8;}
}
unless(defined(&ATW_MACTEST)) {
    sub ATW_MACTEST () {	0xfc;}
}
unless(defined(&ATW_FER)) {
    sub ATW_FER () {	0x100;}
}
unless(defined(&ATW_FEMR)) {
    sub ATW_FEMR () {	0x104;}
}
unless(defined(&ATW_FPSR)) {
    sub ATW_FPSR () {	0x108;}
}
unless(defined(&ATW_FFER)) {
    sub ATW_FFER () {	0x10c;}
}
unless(defined(&ATW_PAR_MWIE)) {
    sub ATW_PAR_MWIE () {	 &BIT(24);}
}
unless(defined(&ATW_PAR_MRLE)) {
    sub ATW_PAR_MRLE () {	 &BIT(23);}
}
unless(defined(&ATW_PAR_MRME)) {
    sub ATW_PAR_MRME () {	 &BIT(21);}
}
unless(defined(&ATW_PAR_RAP_MASK)) {
    sub ATW_PAR_RAP_MASK () {	 &BITS(17, 18);}
}
unless(defined(&ATW_PAR_CAL_MASK)) {
    sub ATW_PAR_CAL_MASK () {	 &BITS(14, 15);}
}
unless(defined(&ATW_PAR_CAL_PBL)) {
    sub ATW_PAR_CAL_PBL () {	0x;}
}
unless(defined(&ATW_PAR_CAL_8DW)) {
    sub ATW_PAR_CAL_8DW () {	 &LSHIFT(0x1,  &ATW_PAR_CAL_MASK);}
}
unless(defined(&ATW_PAR_CAL_16DW)) {
    sub ATW_PAR_CAL_16DW () {	 &LSHIFT(0x2,  &ATW_PAR_CAL_MASK);}
}
unless(defined(&ATW_PAR_CAL_32DW)) {
    sub ATW_PAR_CAL_32DW () {	 &LSHIFT(0x3,  &ATW_PAR_CAL_MASK);}
}
unless(defined(&ATW_PAR_PBL_MASK)) {
    sub ATW_PAR_PBL_MASK () {	 &BITS(8, 13);}
}
unless(defined(&ATW_PAR_PBL_UNLIMITED)) {
    sub ATW_PAR_PBL_UNLIMITED () {	0x;}
}
unless(defined(&ATW_PAR_PBL_1DW)) {
    sub ATW_PAR_PBL_1DW () {	 &LSHIFT(0x1,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_2DW)) {
    sub ATW_PAR_PBL_2DW () {	 &LSHIFT(0x2,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_4DW)) {
    sub ATW_PAR_PBL_4DW () {	 &LSHIFT(0x4,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_8DW)) {
    sub ATW_PAR_PBL_8DW () {	 &LSHIFT(0x8,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_16DW)) {
    sub ATW_PAR_PBL_16DW () {	 &LSHIFT(0x16,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_PBL_32DW)) {
    sub ATW_PAR_PBL_32DW () {	 &LSHIFT(0x32,  &ATW_PAR_PBL_MASK);}
}
unless(defined(&ATW_PAR_BLE)) {
    sub ATW_PAR_BLE () {	 &BIT(7);}
}
unless(defined(&ATW_PAR_DSL_MASK)) {
    sub ATW_PAR_DSL_MASK () {	 &BITS(2, 6);}
}
unless(defined(&ATW_PAR_BAR)) {
    sub ATW_PAR_BAR () {	 &BIT(1);}
}
unless(defined(&ATW_PAR_SWR)) {
    sub ATW_PAR_SWR () {	 &BIT(0);}
}
unless(defined(&ATW_FRCTL_PWRMGMT)) {
    sub ATW_FRCTL_PWRMGMT () {	 &BIT(31);}
}
unless(defined(&ATW_FRCTL_VER_MASK)) {
    sub ATW_FRCTL_VER_MASK () {	 &BITS(29, 30);}
}
unless(defined(&ATW_FRCTL_ORDER)) {
    sub ATW_FRCTL_ORDER () {	 &BIT(28);}
}
unless(defined(&ATW_FRCTL_MAXPSP)) {
    sub ATW_FRCTL_MAXPSP () {	 &BIT(27);}
}
unless(defined(&ATW_C_FRCTL_PRSP)) {
    sub ATW_C_FRCTL_PRSP () {	 &BIT(26);}
}
unless(defined(&ATW_C_FRCTL_DRVBCON)) {
    sub ATW_C_FRCTL_DRVBCON () {	 &BIT(25);}
}
unless(defined(&ATW_C_FRCTL_DRVLINKCTRL)) {
    sub ATW_C_FRCTL_DRVLINKCTRL () {	 &BIT(24);}
}
unless(defined(&ATW_C_FRCTL_DRVLINKON)) {
    sub ATW_C_FRCTL_DRVLINKON () {	 &BIT(23);}
}
unless(defined(&ATW_C_FRCTL_CTX_DATA)) {
    sub ATW_C_FRCTL_CTX_DATA () {	 &BIT(22);}
}
unless(defined(&ATW_C_FRCTL_RSVFRM)) {
    sub ATW_C_FRCTL_RSVFRM () {	 &BIT(21);}
}
unless(defined(&ATW_C_FRCTL_CFEND)) {
    sub ATW_C_FRCTL_CFEND () {	 &BIT(19);}
}
unless(defined(&ATW_FRCTL_DOZEFRM)) {
    sub ATW_FRCTL_DOZEFRM () {	 &BIT(18);}
}
unless(defined(&ATW_FRCTL_PSAWAKE)) {
    sub ATW_FRCTL_PSAWAKE () {	 &BIT(17);}
}
unless(defined(&ATW_FRCTL_PSMODE)) {
    sub ATW_FRCTL_PSMODE () {	 &BIT(16);}
}
unless(defined(&ATW_FRCTL_AID_MASK)) {
    sub ATW_FRCTL_AID_MASK () {	 &BITS(0, 15);}
}
unless(defined(&ATW_INTR_PCF)) {
    sub ATW_INTR_PCF () {	 &BIT(31);}
}
unless(defined(&ATW_INTR_BCNTC)) {
    sub ATW_INTR_BCNTC () {	 &BIT(30);}
}
unless(defined(&ATW_INTR_GPINT)) {
    sub ATW_INTR_GPINT () {	 &BIT(29);}
}
unless(defined(&ATW_INTR_LINKOFF)) {
    sub ATW_INTR_LINKOFF () {	 &BIT(28);}
}
unless(defined(&ATW_INTR_ATIMTC)) {
    sub ATW_INTR_ATIMTC () {	 &BIT(27);}
}
unless(defined(&ATW_INTR_TSFTF)) {
    sub ATW_INTR_TSFTF () {	 &BIT(26);}
}
unless(defined(&ATW_INTR_TSCZ)) {
    sub ATW_INTR_TSCZ () {	 &BIT(25);}
}
unless(defined(&ATW_INTR_LINKON)) {
    sub ATW_INTR_LINKON () {	 &BIT(24);}
}
unless(defined(&ATW_INTR_SQL)) {
    sub ATW_INTR_SQL () {	 &BIT(23);}
}
unless(defined(&ATW_INTR_WEPTD)) {
    sub ATW_INTR_WEPTD () {	 &BIT(22);}
}
unless(defined(&ATW_INTR_ATIME)) {
    sub ATW_INTR_ATIME () {	 &BIT(21);}
}
unless(defined(&ATW_INTR_TBTT)) {
    sub ATW_INTR_TBTT () {	 &BIT(20);}
}
unless(defined(&ATW_INTR_NISS)) {
    sub ATW_INTR_NISS () {	 &BIT(16);}
}
unless(defined(&ATW_INTR_AISS)) {
    sub ATW_INTR_AISS () {	 &BIT(15);}
}
unless(defined(&ATW_INTR_TEIS)) {
    sub ATW_INTR_TEIS () {	 &BIT(14);}
}
unless(defined(&ATW_INTR_FBE)) {
    sub ATW_INTR_FBE () {	 &BIT(13);}
}
unless(defined(&ATW_INTR_REIS)) {
    sub ATW_INTR_REIS () {	 &BIT(12);}
}
unless(defined(&ATW_INTR_GPTT)) {
    sub ATW_INTR_GPTT () {	 &BIT(11);}
}
unless(defined(&ATW_INTR_RPS)) {
    sub ATW_INTR_RPS () {	 &BIT(8);}
}
unless(defined(&ATW_INTR_RDU)) {
    sub ATW_INTR_RDU () {	 &BIT(7);}
}
unless(defined(&ATW_INTR_RCI)) {
    sub ATW_INTR_RCI () {	 &BIT(6);}
}
unless(defined(&ATW_INTR_TUF)) {
    sub ATW_INTR_TUF () {	 &BIT(5);}
}
unless(defined(&ATW_INTR_TRT)) {
    sub ATW_INTR_TRT () {	 &BIT(4);}
}
unless(defined(&ATW_INTR_TLT)) {
    sub ATW_INTR_TLT () {	 &BIT(3);}
}
unless(defined(&ATW_INTR_TDU)) {
    sub ATW_INTR_TDU () {	 &BIT(2);}
}
unless(defined(&ATW_INTR_TPS)) {
    sub ATW_INTR_TPS () {	 &BIT(1);}
}
unless(defined(&ATW_INTR_TCI)) {
    sub ATW_INTR_TCI () {	 &BIT(0);}
}
unless(defined(&ATW_NAR_TXCF)) {
    sub ATW_NAR_TXCF () {	 &BIT(31);}
}
unless(defined(&ATW_NAR_HF)) {
    sub ATW_NAR_HF () {	 &BIT(30);}
}
unless(defined(&ATW_NAR_UTR)) {
    sub ATW_NAR_UTR () {	 &BIT(29);}
}
unless(defined(&ATW_NAR_PCF)) {
    sub ATW_NAR_PCF () {	 &BIT(28);}
}
unless(defined(&ATW_NAR_CFP)) {
    sub ATW_NAR_CFP () {	 &BIT(27);}
}
unless(defined(&ATW_C_NAR_APSTA)) {
    sub ATW_C_NAR_APSTA () {	 &BIT(26);}
}
unless(defined(&ATW_C_NAR_TDBBE)) {
    sub ATW_C_NAR_TDBBE () {	 &BIT(25);}
}
unless(defined(&ATW_C_NAR_TDBHE)) {
    sub ATW_C_NAR_TDBHE () {	 &BIT(24);}
}
unless(defined(&ATW_C_NAR_TDBHT)) {
    sub ATW_C_NAR_TDBHT () {	 &BIT(23);}
}
unless(defined(&ATW_NAR_SF)) {
    sub ATW_NAR_SF () {	 &BIT(21);}
}
unless(defined(&ATW_NAR_TR_MASK)) {
    sub ATW_NAR_TR_MASK () {	 &BITS(14, 15);}
}
unless(defined(&ATW_NAR_TR_L64)) {
    sub ATW_NAR_TR_L64 () {	 &LSHIFT(0x,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_L160)) {
    sub ATW_NAR_TR_L160 () {	 &LSHIFT(0x2,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_L192)) {
    sub ATW_NAR_TR_L192 () {	 &LSHIFT(0x3,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_H96)) {
    sub ATW_NAR_TR_H96 () {	 &LSHIFT(0x,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_H288)) {
    sub ATW_NAR_TR_H288 () {	 &LSHIFT(0x2,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_TR_H544)) {
    sub ATW_NAR_TR_H544 () {	 &LSHIFT(0x3,  &ATW_NAR_TR_MASK);}
}
unless(defined(&ATW_NAR_ST)) {
    sub ATW_NAR_ST () {	 &BIT(13);}
}
unless(defined(&ATW_NAR_OM_MASK)) {
    sub ATW_NAR_OM_MASK () {	 &BITS(10, 11);}
}
unless(defined(&ATW_NAR_OM_NORMAL)) {
    sub ATW_NAR_OM_NORMAL () {	0x;}
}
unless(defined(&ATW_NAR_OM_LOOPBACK)) {
    sub ATW_NAR_OM_LOOPBACK () {	 &LSHIFT(0x1,  &ATW_NAR_OM_MASK);}
}
unless(defined(&ATW_NAR_MM)) {
    sub ATW_NAR_MM () {	 &BIT(7);}
}
unless(defined(&ATW_NAR_PR)) {
    sub ATW_NAR_PR () {	 &BIT(6);}
}
unless(defined(&ATW_NAR_EA)) {
    sub ATW_NAR_EA () {	 &BIT(5);}
}
unless(defined(&ATW_NAR_DISPCF)) {
    sub ATW_NAR_DISPCF () {	 &BIT(4);}
}
unless(defined(&ATW_NAR_PB)) {
    sub ATW_NAR_PB () {	 &BIT(3);}
}
unless(defined(&ATW_NAR_STPDMA)) {
    sub ATW_NAR_STPDMA () {	 &BIT(2);}
}
unless(defined(&ATW_NAR_SR)) {
    sub ATW_NAR_SR () {	 &BIT(1);}
}
unless(defined(&ATW_NAR_CTX)) {
    sub ATW_NAR_CTX () {	 &BIT(0);}
}
if(0) {
    eval 'sub ATW_IER_NIE () { &BIT(16);}' unless defined(&ATW_IER_NIE);
    eval 'sub ATW_IER_AIE () { &BIT(15);}' unless defined(&ATW_IER_AIE);
    eval 'sub ATW_IER_PCFIE () { &BIT(31);}' unless defined(&ATW_IER_PCFIE);
    eval 'sub ATW_IER_BCNTCIE () { &BIT(30);}' unless defined(&ATW_IER_BCNTCIE);
    eval 'sub ATW_IER_ATIMTCIE () { &BIT(27);}' unless defined(&ATW_IER_ATIMTCIE);
    eval 'sub ATW_IER_LINKONIE () { &BIT(24);}' unless defined(&ATW_IER_LINKONIE);
    eval 'sub ATW_IER_ATIMIE () { &BIT(21);}' unless defined(&ATW_IER_ATIMIE);
    eval 'sub ATW_IER_TBTTIE () { &BIT(20);}' unless defined(&ATW_IER_TBTTIE);
    eval 'sub ATW_IER_TEIE () { &BIT(14);}' unless defined(&ATW_IER_TEIE);
    eval 'sub ATW_IER_REIE () { &BIT(12);}' unless defined(&ATW_IER_REIE);
    eval 'sub ATW_IER_RCIE () { &BIT(6);}' unless defined(&ATW_IER_RCIE);
    eval 'sub ATW_IER_TDUIE () { &BIT(2);}' unless defined(&ATW_IER_TDUIE);
    eval 'sub ATW_IER_TCIE () { &BIT(0);}' unless defined(&ATW_IER_TCIE);
    eval 'sub ATW_IER_GPIE () { &BIT(29);}' unless defined(&ATW_IER_GPIE);
    eval 'sub ATW_IER_LINKOFFIE () { &BIT(28);}' unless defined(&ATW_IER_LINKOFFIE);
    eval 'sub ATW_IER_TSFTFIE () { &BIT(26);}' unless defined(&ATW_IER_TSFTFIE);
    eval 'sub ATW_IER_TSCIE () { &BIT(25);}' unless defined(&ATW_IER_TSCIE);
    eval 'sub ATW_IER_SQLIE () { &BIT(23);}' unless defined(&ATW_IER_SQLIE);
    eval 'sub ATW_IER_WEPIE () { &BIT(22);}' unless defined(&ATW_IER_WEPIE);
    eval 'sub ATW_IER_FBEIE () { &BIT(13);}' unless defined(&ATW_IER_FBEIE);
    eval 'sub ATW_IER_GPTIE () { &BIT(11);}' unless defined(&ATW_IER_GPTIE);
    eval 'sub ATW_IER_RPSIE () { &BIT(8);}' unless defined(&ATW_IER_RPSIE);
    eval 'sub ATW_IER_RUIE () { &BIT(7);}' unless defined(&ATW_IER_RUIE);
    eval 'sub ATW_IER_TUIE () { &BIT(5);}' unless defined(&ATW_IER_TUIE);
    eval 'sub ATW_IER_TRTIE () { &BIT(4);}' unless defined(&ATW_IER_TRTIE);
    eval 'sub ATW_IER_TLTTIE () { &BIT(3);}' unless defined(&ATW_IER_TLTTIE);
    eval 'sub ATW_IER_TPSIE () { &BIT(1);}' unless defined(&ATW_IER_TPSIE);
}
unless(defined(&ATW_LPC_LPCO)) {
    sub ATW_LPC_LPCO () {	 &BIT(16);}
}
unless(defined(&ATW_LPC_LPC_MASK)) {
    sub ATW_LPC_LPC_MASK () {	 &BITS(0, 15);}
}
unless(defined(&ATW_TEST1_CONTROL)) {
    sub ATW_TEST1_CONTROL () {	 &BIT(31);}
}
unless(defined(&ATW_TEST1_DBGREAD_MASK)) {
    sub ATW_TEST1_DBGREAD_MASK () {	 &BITS(30,28);}
}
unless(defined(&ATW_TEST1_TXWP_MASK)) {
    sub ATW_TEST1_TXWP_MASK () {	 &BITS(27,25);}
}
unless(defined(&ATW_TEST1_TXWP_TDBD)) {
    sub ATW_TEST1_TXWP_TDBD () {	 &LSHIFT(0x,  &ATW_TEST1_TXWP_MASK);}
}
unless(defined(&ATW_TEST1_TXWP_TDBH)) {
    sub ATW_TEST1_TXWP_TDBH () {	 &LSHIFT(0x1,  &ATW_TEST1_TXWP_MASK);}
}
unless(defined(&ATW_TEST1_TXWP_TDBB)) {
    sub ATW_TEST1_TXWP_TDBB () {	 &LSHIFT(0x2,  &ATW_TEST1_TXWP_MASK);}
}
unless(defined(&ATW_TEST1_TXWP_TDBP)) {
    sub ATW_TEST1_TXWP_TDBP () {	 &LSHIFT(0x3,  &ATW_TEST1_TXWP_MASK);}
}
unless(defined(&ATW_TEST1_RSVD0_MASK)) {
    sub ATW_TEST1_RSVD0_MASK () {	 &BITS(24,6);}
}
unless(defined(&ATW_TEST1_TESTMODE_MASK)) {
    sub ATW_TEST1_TESTMODE_MASK () {	 &BITS(5,4);}
}
unless(defined(&ATW_TEST1_TESTMODE_NORMAL)) {
    sub ATW_TEST1_TESTMODE_NORMAL () {	 &LSHIFT(0x,  &ATW_TEST1_TESTMODE_MASK);}
}
unless(defined(&ATW_TEST1_TESTMODE_MACONLY)) {
    sub ATW_TEST1_TESTMODE_MACONLY () {	 &LSHIFT(0x1,  &ATW_TEST1_TESTMODE_MASK);}
}
unless(defined(&ATW_TEST1_TESTMODE_NORMAL2)) {
    sub ATW_TEST1_TESTMODE_NORMAL2 () {	 &LSHIFT(0x2,  &ATW_TEST1_TESTMODE_MASK);}
}
unless(defined(&ATW_TEST1_TESTMODE_MONITOR)) {
    sub ATW_TEST1_TESTMODE_MONITOR () {	 &LSHIFT(0x3,  &ATW_TEST1_TESTMODE_MASK);}
}
unless(defined(&ATW_TEST1_DUMP_MASK)) {
    sub ATW_TEST1_DUMP_MASK () {	 &BITS(3,0);}
}
unless(defined(&ATW_SPR_SRS)) {
    sub ATW_SPR_SRS () {	 &BIT(11);}
}
unless(defined(&ATW_SPR_SDO)) {
    sub ATW_SPR_SDO () {	 &BIT(3);}
}
unless(defined(&ATW_SPR_SDI)) {
    sub ATW_SPR_SDI () {	 &BIT(2);}
}
unless(defined(&ATW_SPR_SCLK)) {
    sub ATW_SPR_SCLK () {	 &BIT(1);}
}
unless(defined(&ATW_SPR_SCS)) {
    sub ATW_SPR_SCS () {	 &BIT(0);}
}
unless(defined(&ATW_TEST0_BE_MASK)) {
    sub ATW_TEST0_BE_MASK () {	 &BITS(31, 29);}
}
unless(defined(&ATW_TEST0_TS_MASK)) {
    sub ATW_TEST0_TS_MASK () {	 &BITS(28, 26);}
}
unless(defined(&ATW_TEST0_TS_STOPPED)) {
    sub ATW_TEST0_TS_STOPPED () {	 &LSHIFT(0,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_FETCH)) {
    sub ATW_TEST0_TS_FETCH () {	 &LSHIFT(1,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_WAIT)) {
    sub ATW_TEST0_TS_WAIT () {	 &LSHIFT(2,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_READING)) {
    sub ATW_TEST0_TS_READING () {	 &LSHIFT(3,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_RESERVED1)) {
    sub ATW_TEST0_TS_RESERVED1 () {	 &LSHIFT(4,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_RESERVED2)) {
    sub ATW_TEST0_TS_RESERVED2 () {	 &LSHIFT(5,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_SUSPENDED)) {
    sub ATW_TEST0_TS_SUSPENDED () {	 &LSHIFT(6,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_TS_CLOSE)) {
    sub ATW_TEST0_TS_CLOSE () {	 &LSHIFT(7,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_C_TEST0_TS_SUSPENDED)) {
    sub ATW_C_TEST0_TS_SUSPENDED () {	 &LSHIFT(4,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_C_TEST0_TS_CLOSE)) {
    sub ATW_C_TEST0_TS_CLOSE () {	 &LSHIFT(5,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_C_TEST0_TS_CLOSELAST)) {
    sub ATW_C_TEST0_TS_CLOSELAST () {	 &LSHIFT(6,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_C_TEST0_TS_FIFOFULL)) {
    sub ATW_C_TEST0_TS_FIFOFULL () {	 &LSHIFT(7,  &ATW_TEST0_TS_MASK);}
}
unless(defined(&ATW_TEST0_RS_MASK)) {
    sub ATW_TEST0_RS_MASK () {	 &BITS(25, 23);}
}
unless(defined(&ATW_TEST0_RS_STOPPED)) {
    sub ATW_TEST0_RS_STOPPED () {	 &LSHIFT(0,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_FETCH)) {
    sub ATW_TEST0_RS_FETCH () {	 &LSHIFT(1,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_CHECK)) {
    sub ATW_TEST0_RS_CHECK () {	 &LSHIFT(2,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_WAIT)) {
    sub ATW_TEST0_RS_WAIT () {	 &LSHIFT(3,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_SUSPENDED)) {
    sub ATW_TEST0_RS_SUSPENDED () {	 &LSHIFT(4,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_CLOSE)) {
    sub ATW_TEST0_RS_CLOSE () {	 &LSHIFT(5,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_FLUSH)) {
    sub ATW_TEST0_RS_FLUSH () {	 &LSHIFT(6,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_RS_QUEUE)) {
    sub ATW_TEST0_RS_QUEUE () {	 &LSHIFT(7,  &ATW_TEST0_RS_MASK);}
}
unless(defined(&ATW_TEST0_EPNE)) {
    sub ATW_TEST0_EPNE () {	 &BIT(18);}
}
unless(defined(&ATW_TEST0_EPSNM)) {
    sub ATW_TEST0_EPSNM () {	 &BIT(17);}
}
unless(defined(&ATW_TEST0_EPTYP_MASK)) {
    sub ATW_TEST0_EPTYP_MASK () {	 &BIT(16);}
}
unless(defined(&ATW_TEST0_EPTYP_93c66)) {
    sub ATW_TEST0_EPTYP_93c66 () {	 &ATW_TEST0_EPTYP_MASK;}
}
unless(defined(&ATW_TEST0_EPTYP_93c46)) {
    sub ATW_TEST0_EPTYP_93c46 () {	0;}
}
unless(defined(&ATW_TEST0_EPRLD)) {
    sub ATW_TEST0_EPRLD () {	 &BIT(15);}
}
unless(defined(&ATW_WCSR_CRCT)) {
    sub ATW_WCSR_CRCT () {	 &BIT(30);}
}
unless(defined(&ATW_WCSR_WP1E)) {
    sub ATW_WCSR_WP1E () {	 &BIT(29);}
}
unless(defined(&ATW_WCSR_WP2E)) {
    sub ATW_WCSR_WP2E () {	 &BIT(28);}
}
unless(defined(&ATW_WCSR_WP3E)) {
    sub ATW_WCSR_WP3E () {	 &BIT(27);}
}
unless(defined(&ATW_WCSR_WP4E)) {
    sub ATW_WCSR_WP4E () {	 &BIT(26);}
}
unless(defined(&ATW_WCSR_WP5E)) {
    sub ATW_WCSR_WP5E () {	 &BIT(25);}
}
unless(defined(&ATW_WCSR_BLN_MASK)) {
    sub ATW_WCSR_BLN_MASK () {	 &BITS(21, 23);}
}
unless(defined(&ATW_WCSR_TSFTWE)) {
    sub ATW_WCSR_TSFTWE () {	 &BIT(20);}
}
unless(defined(&ATW_WCSR_TIMWE)) {
    sub ATW_WCSR_TIMWE () {	 &BIT(19);}
}
unless(defined(&ATW_WCSR_ATIMWE)) {
    sub ATW_WCSR_ATIMWE () {	 &BIT(18);}
}
unless(defined(&ATW_WCSR_KEYWE)) {
    sub ATW_WCSR_KEYWE () {	 &BIT(17);}
}
unless(defined(&ATW_WCSR_WFRE)) {
    sub ATW_WCSR_WFRE () {	 &BIT(10);}
}
unless(defined(&ATW_WCSR_MPRE)) {
    sub ATW_WCSR_MPRE () {	 &BIT(9);}
}
unless(defined(&ATW_WCSR_LSOE)) {
    sub ATW_WCSR_LSOE () {	 &BIT(8);}
}
unless(defined(&ATW_WCSR_KEYUP)) {
    sub ATW_WCSR_KEYUP () {	 &BIT(6);}
}
unless(defined(&ATW_WCSR_TSFTW)) {
    sub ATW_WCSR_TSFTW () {	 &BIT(5);}
}
unless(defined(&ATW_WCSR_TIMW)) {
    sub ATW_WCSR_TIMW () {	 &BIT(4);}
}
unless(defined(&ATW_WCSR_ATIMW)) {
    sub ATW_WCSR_ATIMW () {	 &BIT(3);}
}
unless(defined(&ATW_WCSR_WFR)) {
    sub ATW_WCSR_WFR () {	 &BIT(2);}
}
unless(defined(&ATW_WCSR_MPR)) {
    sub ATW_WCSR_MPR () {	 &BIT(1);}
}
unless(defined(&ATW_WCSR_LSO)) {
    sub ATW_WCSR_LSO () {	 &BIT(0);}
}
unless(defined(&ATW_GPTMR_COM_MASK)) {
    sub ATW_GPTMR_COM_MASK () {	 &BIT(16);}
}
unless(defined(&ATW_GPTMR_GTV_MASK)) {
    sub ATW_GPTMR_GTV_MASK () {	 &BITS(0, 15);}
}
unless(defined(&ATW_GPIO_EC1_MASK)) {
    sub ATW_GPIO_EC1_MASK () {	 &BITS(25, 24);}
}
unless(defined(&ATW_GPIO_LAT_MASK)) {
    sub ATW_GPIO_LAT_MASK () {	 &BITS(21, 20);}
}
unless(defined(&ATW_GPIO_INTEN_MASK)) {
    sub ATW_GPIO_INTEN_MASK () {	 &BITS(19, 18);}
}
unless(defined(&ATW_GPIO_EN_MASK)) {
    sub ATW_GPIO_EN_MASK () {	 &BITS(17, 12);}
}
unless(defined(&ATW_GPIO_O_MASK)) {
    sub ATW_GPIO_O_MASK () {	 &BITS(11, 6);}
}
unless(defined(&ATW_GPIO_I_MASK)) {
    sub ATW_GPIO_I_MASK () {	 &BITS(5, 0);}
}
unless(defined(&ATW_BBPCTL_TWI)) {
    sub ATW_BBPCTL_TWI () {	 &BIT(31);}
}
unless(defined(&ATW_BBPCTL_RF3KADDR_MASK)) {
    sub ATW_BBPCTL_RF3KADDR_MASK () {	 &BITS(30, 24);}
}
unless(defined(&ATW_BBPCTL_RF3KADDR_ADDR)) {
    sub ATW_BBPCTL_RF3KADDR_ADDR () {	 &LSHIFT(0x20,  &ATW_BBPCTL_RF3KADDR_MASK);}
}
unless(defined(&ATW_BBPCTL_NEGEDGE_DO)) {
    sub ATW_BBPCTL_NEGEDGE_DO () {	 &BIT(23);}
}
unless(defined(&ATW_BBPCTL_NEGEDGE_DI)) {
    sub ATW_BBPCTL_NEGEDGE_DI () {	 &BIT(22);}
}
unless(defined(&ATW_BBPCTL_CCA_ACTLO)) {
    sub ATW_BBPCTL_CCA_ACTLO () {	 &BIT(21);}
}
unless(defined(&ATW_BBPCTL_TYPE_MASK)) {
    sub ATW_BBPCTL_TYPE_MASK () {	 &BITS(20, 18);}
}
unless(defined(&ATW_BBPCTL_WR)) {
    sub ATW_BBPCTL_WR () {	 &BIT(17);}
}
unless(defined(&ATW_BBPCTL_RD)) {
    sub ATW_BBPCTL_RD () {	 &BIT(16);}
}
unless(defined(&ATW_BBPCTL_ADDR_MASK)) {
    sub ATW_BBPCTL_ADDR_MASK () {	 &BITS(15, 8);}
}
unless(defined(&ATW_BBPCTL_DATA_MASK)) {
    sub ATW_BBPCTL_DATA_MASK () {	 &BITS(7, 0);}
}
unless(defined(&ATW_SYNCTL_WR)) {
    sub ATW_SYNCTL_WR () {	 &BIT(31);}
}
unless(defined(&ATW_SYNCTL_RD)) {
    sub ATW_SYNCTL_RD () {	 &BIT(30);}
}
unless(defined(&ATW_SYNCTL_CS0)) {
    sub ATW_SYNCTL_CS0 () {	 &BIT(29);}
}
unless(defined(&ATW_SYNCTL_CS1)) {
    sub ATW_SYNCTL_CS1 () {	 &BIT(28);}
}
unless(defined(&ATW_SYNCTL_CAL)) {
    sub ATW_SYNCTL_CAL () {	 &BIT(27);}
}
unless(defined(&ATW_SYNCTL_SELCAL)) {
    sub ATW_SYNCTL_SELCAL () {	 &BIT(26);}
}
unless(defined(&ATW_C_SYNCTL_MMICE)) {
    sub ATW_C_SYNCTL_MMICE () {	 &BIT(25);}
}
unless(defined(&ATW_SYNCTL_RFTYPE_MASK)) {
    sub ATW_SYNCTL_RFTYPE_MASK () {	 &BITS(24, 22);}
}
unless(defined(&ATW_SYNCTL_DATA_MASK)) {
    sub ATW_SYNCTL_DATA_MASK () {	 &BITS(21, 0);}
}
unless(defined(&ATW_PLCPHD_SIGNAL_MASK)) {
    sub ATW_PLCPHD_SIGNAL_MASK () {	 &BITS(31, 24);}
}
unless(defined(&ATW_PLCPHD_SERVICE_MASK)) {
    sub ATW_PLCPHD_SERVICE_MASK () {	 &BITS(23, 16);}
}
unless(defined(&ATW_PLCPHD_PMBL)) {
    sub ATW_PLCPHD_PMBL () {	 &BIT(15);}
}
unless(defined(&ATW_MMIWADDR_LENLO_MASK)) {
    sub ATW_MMIWADDR_LENLO_MASK () {	 &BITS(31,24);}
}
unless(defined(&ATW_MMIWADDR_LENHI_MASK)) {
    sub ATW_MMIWADDR_LENHI_MASK () {	 &BITS(23,16);}
}
unless(defined(&ATW_MMIWADDR_GAIN_MASK)) {
    sub ATW_MMIWADDR_GAIN_MASK () {	 &BITS(15,8);}
}
unless(defined(&ATW_MMIWADDR_RATE_MASK)) {
    sub ATW_MMIWADDR_RATE_MASK () {	 &BITS(7,0);}
}
unless(defined(&ATW_MMIWADDR_INTERSIL)) {
    sub ATW_MMIWADDR_INTERSIL () {	( &LSHIFT(0xc,  &ATW_MMIWADDR_GAIN_MASK) |  &LSHIFT(0xa,  &ATW_MMIWADDR_RATE_MASK) |  &LSHIFT(0xe,  &ATW_MMIWADDR_LENHI_MASK) |  &LSHIFT(0x10,  &ATW_MMIWADDR_LENLO_MASK));}
}
unless(defined(&ATW_MMIWADDR_RFMD)) {
    sub ATW_MMIWADDR_RFMD () {	( &LSHIFT( &RF3000_TWI_AI| &RF3000_GAINCTL,  &ATW_MMIWADDR_GAIN_MASK) |  &LSHIFT( &RF3000_CTL,  &ATW_MMIWADDR_RATE_MASK));}
}
unless(defined(&ATW_MMIRADDR1_RSVD_MASK)) {
    sub ATW_MMIRADDR1_RSVD_MASK () {	 &BITS(31, 24);}
}
unless(defined(&ATW_MMIRADDR1_PWRLVL_MASK)) {
    sub ATW_MMIRADDR1_PWRLVL_MASK () {	 &BITS(23, 16);}
}
unless(defined(&ATW_MMIRADDR1_RSSI_MASK)) {
    sub ATW_MMIRADDR1_RSSI_MASK () {	 &BITS(15, 8);}
}
unless(defined(&ATW_MMIRADDR1_RXSTAT_MASK)) {
    sub ATW_MMIRADDR1_RXSTAT_MASK () {	 &BITS(7, 0);}
}
unless(defined(&ATW_MMIRADDR1_INTERSIL)) {
    sub ATW_MMIRADDR1_INTERSIL () {	( &LSHIFT(0x7c,  &ATW_MMIRADDR1_RSSI_MASK) |  &LSHIFT(0x7e,  &ATW_MMIRADDR1_RXSTAT_MASK));}
}
unless(defined(&ATW_MMIRADDR1_RFMD)) {
    sub ATW_MMIRADDR1_RFMD () {	( &LSHIFT( &RF3000_RSSI,  &ATW_MMIRADDR1_RSSI_MASK) |  &LSHIFT( &RF3000_RXSTAT,  &ATW_MMIRADDR1_RXSTAT_MASK));}
}
unless(defined(&ATW_MMIRADDR2_INTERSIL)) {
    sub ATW_MMIRADDR2_INTERSIL () {	( &LSHIFT(0x,  &ATW_MMIRADDR2_ID_MASK) |  &LSHIFT(0x10,  &ATW_MMIRADDR2_RXPECNT_MASK));}
}
unless(defined(&ATW_MMIRADDR2_RFMD)) {
    sub ATW_MMIRADDR2_RFMD () {	( &LSHIFT(0x7e,  &ATW_MMIRADDR2_ID_MASK) |  &LSHIFT(0x10,  &ATW_MMIRADDR2_RXPECNT_MASK));}
}
unless(defined(&ATW_MMIRADDR2_ID_MASK)) {
    sub ATW_MMIRADDR2_ID_MASK () {	 &BITS(31, 24);}
}
unless(defined(&ATW_MMIRADDR2_RXPECNT_MASK)) {
    sub ATW_MMIRADDR2_RXPECNT_MASK () {	 &BITS(23, 16);}
}
unless(defined(&ATW_MMIRADDR2_PROREXT)) {
    sub ATW_MMIRADDR2_PROREXT () {	 &BIT(15);}
}
unless(defined(&ATW_MMIRADDR2_PRORLEN_MASK)) {
    sub ATW_MMIRADDR2_PRORLEN_MASK () {	 &BITS(14, 0);}
}
unless(defined(&ATW_TXBR_ALCUPDATE_MASK)) {
    sub ATW_TXBR_ALCUPDATE_MASK () {	 &BIT(31);}
}
unless(defined(&ATW_TXBR_TBCNT_MASK)) {
    sub ATW_TXBR_TBCNT_MASK () {	 &BITS(16, 20);}
}
unless(defined(&ATW_TXBR_ALCSET_MASK)) {
    sub ATW_TXBR_ALCSET_MASK () {	 &BITS(8, 15);}
}
unless(defined(&ATW_TXBR_ALCREF_MASK)) {
    sub ATW_TXBR_ALCREF_MASK () {	 &BITS(0, 7);}
}
unless(defined(&ATW_ALCSTAT_MCOV_MASK)) {
    sub ATW_ALCSTAT_MCOV_MASK () {	 &BIT(27);}
}
unless(defined(&ATW_ALCSTAT_ESOV_MASK)) {
    sub ATW_ALCSTAT_ESOV_MASK () {	 &BIT(26);}
}
unless(defined(&ATW_ALCSTAT_MCNT_MASK)) {
    sub ATW_ALCSTAT_MCNT_MASK () {	 &BITS(16, 25);}
}
unless(defined(&ATW_ALCSTAT_ERSUM_MASK)) {
    sub ATW_ALCSTAT_ERSUM_MASK () {	 &BITS(0, 15);}
}
unless(defined(&ATW_TOFS2_PWR1UP_MASK)) {
    sub ATW_TOFS2_PWR1UP_MASK () {	 &BITS(31, 28);}
}
unless(defined(&ATW_TOFS2_PWR0PAPE_MASK)) {
    sub ATW_TOFS2_PWR0PAPE_MASK () {	 &BITS(27, 24);}
}
unless(defined(&ATW_TOFS2_PWR1PAPE_MASK)) {
    sub ATW_TOFS2_PWR1PAPE_MASK () {	 &BITS(23, 20);}
}
unless(defined(&ATW_TOFS2_PWR0TRSW_MASK)) {
    sub ATW_TOFS2_PWR0TRSW_MASK () {	 &BITS(19, 16);}
}
unless(defined(&ATW_TOFS2_PWR1TRSW_MASK)) {
    sub ATW_TOFS2_PWR1TRSW_MASK () {	 &BITS(15, 12);}
}
unless(defined(&ATW_TOFS2_PWR0PE2_MASK)) {
    sub ATW_TOFS2_PWR0PE2_MASK () {	 &BITS(11, 8);}
}
unless(defined(&ATW_TOFS2_PWR1PE2_MASK)) {
    sub ATW_TOFS2_PWR1PE2_MASK () {	 &BITS(7, 4);}
}
unless(defined(&ATW_TOFS2_PWR0TXPE_MASK)) {
    sub ATW_TOFS2_PWR0TXPE_MASK () {	 &BITS(3, 0);}
}
unless(defined(&ATW_CMDR_PM)) {
    sub ATW_CMDR_PM () {	 &BIT(19);}
}
unless(defined(&ATW_CMDR_APM)) {
    sub ATW_CMDR_APM () {	 &BIT(18);}
}
unless(defined(&ATW_CMDR_RTE)) {
    sub ATW_CMDR_RTE () {	 &BIT(4);}
}
unless(defined(&ATW_CMDR_DRT_MASK)) {
    sub ATW_CMDR_DRT_MASK () {	 &BITS(3, 2);}
}
unless(defined(&ATW_CMDR_DRT_8DW)) {
    sub ATW_CMDR_DRT_8DW () {	 &LSHIFT(0x,  &ATW_CMDR_DRT_MASK);}
}
unless(defined(&ATW_CMDR_DRT_16DW)) {
    sub ATW_CMDR_DRT_16DW () {	 &LSHIFT(0x1,  &ATW_CMDR_DRT_MASK);}
}
unless(defined(&ATW_CMDR_DRT_SF)) {
    sub ATW_CMDR_DRT_SF () {	 &LSHIFT(0x2,  &ATW_CMDR_DRT_MASK);}
}
unless(defined(&ATW_CMDR_DRT_RSVD)) {
    sub ATW_CMDR_DRT_RSVD () {	 &LSHIFT(0x3,  &ATW_CMDR_DRT_MASK);}
}
unless(defined(&ATW_CMDR_SINT_MASK)) {
    sub ATW_CMDR_SINT_MASK () {	 &BIT(1);}
}
unless(defined(&ATW_PAR0_PAB0_MASK)) {
    sub ATW_PAR0_PAB0_MASK () {	 &BITS(0, 7);}
}
unless(defined(&ATW_PAR0_PAB1_MASK)) {
    sub ATW_PAR0_PAB1_MASK () {	 &BITS(8, 15);}
}
unless(defined(&ATW_PAR0_PAB2_MASK)) {
    sub ATW_PAR0_PAB2_MASK () {	 &BITS(16, 23);}
}
unless(defined(&ATW_PAR0_PAB3_MASK)) {
    sub ATW_PAR0_PAB3_MASK () {	 &BITS(24, 31);}
}
unless(defined(&ATW_C_PAR1_CTD)) {
    sub ATW_C_PAR1_CTD () {	 &BITS(16,31);}
}
unless(defined(&ATW_PAR1_PAB5_MASK)) {
    sub ATW_PAR1_PAB5_MASK () {	 &BITS(8, 15);}
}
unless(defined(&ATW_PAR1_PAB4_MASK)) {
    sub ATW_PAR1_PAB4_MASK () {	 &BITS(0, 7);}
}
unless(defined(&ATW_MAR0_MAB3_MASK)) {
    sub ATW_MAR0_MAB3_MASK () {	 &BITS(31, 24);}
}
unless(defined(&ATW_MAR0_MAB2_MASK)) {
    sub ATW_MAR0_MAB2_MASK () {	 &BITS(23, 16);}
}
unless(defined(&ATW_MAR0_MAB1_MASK)) {
    sub ATW_MAR0_MAB1_MASK () {	 &BITS(15, 8);}
}
unless(defined(&ATW_MAR0_MAB0_MASK)) {
    sub ATW_MAR0_MAB0_MASK () {	 &BITS(7, 0);}
}
unless(defined(&ATW_MAR1_MAB7_MASK)) {
    sub ATW_MAR1_MAB7_MASK () {	 &BITS(31, 24);}
}
unless(defined(&ATW_MAR1_MAB6_MASK)) {
    sub ATW_MAR1_MAB6_MASK () {	 &BITS(23, 16);}
}
unless(defined(&ATW_MAR1_MAB5_MASK)) {
    sub ATW_MAR1_MAB5_MASK () {	 &BITS(15, 8);}
}
unless(defined(&ATW_MAR1_MAB4_MASK)) {
    sub ATW_MAR1_MAB4_MASK () {	 &BITS(7, 0);}
}
unless(defined(&ATW_ATIMDA0_ATIMB3_MASK)) {
    sub ATW_ATIMDA0_ATIMB3_MASK () {	 &BITS(31,24);}
}
unless(defined(&ATW_ATIMDA0_ATIMB2_MASK)) {
    sub ATW_ATIMDA0_ATIMB2_MASK () {	 &BITS(23,16);}
}
unless(defined(&ATW_ATIMDA0_ATIMB1_MASK)) {
    sub ATW_ATIMDA0_ATIMB1_MASK () {	 &BITS(15,8);}
}
unless(defined(&ATW_ATIMDA0_ATIMB0_MASK)) {
    sub ATW_ATIMDA0_ATIMB0_MASK () {	 &BITS(7,0);}
}
unless(defined(&ATW_ABDA1_BSSIDB5_MASK)) {
    sub ATW_ABDA1_BSSIDB5_MASK () {	 &BITS(31,24);}
}
unless(defined(&ATW_ABDA1_BSSIDB4_MASK)) {
    sub ATW_ABDA1_BSSIDB4_MASK () {	 &BITS(23,16);}
}
unless(defined(&ATW_ABDA1_ATIMB5_MASK)) {
    sub ATW_ABDA1_ATIMB5_MASK () {	 &BITS(15,8);}
}
unless(defined(&ATW_ABDA1_ATIMB4_MASK)) {
    sub ATW_ABDA1_ATIMB4_MASK () {	 &BITS(7,0);}
}
unless(defined(&ATW_BSSID0_BSSIDB3_MASK)) {
    sub ATW_BSSID0_BSSIDB3_MASK () {	 &BITS(31,24);}
}
unless(defined(&ATW_BSSID0_BSSIDB2_MASK)) {
    sub ATW_BSSID0_BSSIDB2_MASK () {	 &BITS(23,16);}
}
unless(defined(&ATW_BSSID0_BSSIDB1_MASK)) {
    sub ATW_BSSID0_BSSIDB1_MASK () {	 &BITS(15,8);}
}
unless(defined(&ATW_BSSID0_BSSIDB0_MASK)) {
    sub ATW_BSSID0_BSSIDB0_MASK () {	 &BITS(7,0);}
}
unless(defined(&ATW_TXLMT_MTMLT_MASK)) {
    sub ATW_TXLMT_MTMLT_MASK () {	 &BITS(31,16);}
}
unless(defined(&ATW_TXLMT_SRTYLIM_MASK)) {
    sub ATW_TXLMT_SRTYLIM_MASK () {	 &BITS(7,0);}
}
unless(defined(&ATW_MIBCNT_FFCNT_MASK)) {
    sub ATW_MIBCNT_FFCNT_MASK () {	 &BITS(31,24);}
}
unless(defined(&ATW_MIBCNT_AFCNT_MASK)) {
    sub ATW_MIBCNT_AFCNT_MASK () {	 &BITS(23,16);}
}
unless(defined(&ATW_MIBCNT_RSCNT_MASK)) {
    sub ATW_MIBCNT_RSCNT_MASK () {	 &BITS(15,8);}
}
unless(defined(&ATW_MIBCNT_RFCNT_MASK)) {
    sub ATW_MIBCNT_RFCNT_MASK () {	 &BITS(7,0);}
}
unless(defined(&ATW_BCNT_PLCPH_MASK)) {
    sub ATW_BCNT_PLCPH_MASK () {	 &BITS(23,16);}
}
unless(defined(&ATW_BCNT_PLCPL_MASK)) {
    sub ATW_BCNT_PLCPL_MASK () {	 &BITS(15,8);}
}
unless(defined(&ATW_BCNT_BCNT_MASK)) {
    sub ATW_BCNT_BCNT_MASK () {	 &BITS(7,0);}
}
unless(defined(&ATW_C_BCNT_EXTEN1)) {
    sub ATW_C_BCNT_EXTEN1 () {	 &BIT(31);}
}
unless(defined(&ATW_C_BCNT_BEANLEN1)) {
    sub ATW_C_BCNT_BEANLEN1 () {	 &BITS(30,16);}
}
unless(defined(&ATW_C_BCNT_EXTEN0)) {
    sub ATW_C_BCNT_EXTEN0 () {	 &BIT(15);}
}
unless(defined(&ATW_C_BCNT_BEANLEN0)) {
    sub ATW_C_BCNT_BEANLEN0 () {	 &BIT(14,0);}
}
unless(defined(&ATW_C_TSC_TIMOFS)) {
    sub ATW_C_TSC_TIMOFS () {	 &BITS(31,24);}
}
unless(defined(&ATW_C_TSC_TIMLEN)) {
    sub ATW_C_TSC_TIMLEN () {	 &BITS(21,12);}
}
unless(defined(&ATW_C_TSC_TIMTABSEL)) {
    sub ATW_C_TSC_TIMTABSEL () {	 &BIT(4);}
}
unless(defined(&ATW_TSC_TSC_MASK)) {
    sub ATW_TSC_TSC_MASK () {	 &BITS(3,0);}
}
unless(defined(&ATW_SYNRF_SELSYN)) {
    sub ATW_SYNRF_SELSYN () {	 &BIT(31);}
}
unless(defined(&ATW_SYNRF_SELRF)) {
    sub ATW_SYNRF_SELRF () {	 &BIT(30);}
}
unless(defined(&ATW_SYNRF_LERF)) {
    sub ATW_SYNRF_LERF () {	 &BIT(29);}
}
unless(defined(&ATW_SYNRF_LEIF)) {
    sub ATW_SYNRF_LEIF () {	 &BIT(28);}
}
unless(defined(&ATW_SYNRF_SYNCLK)) {
    sub ATW_SYNRF_SYNCLK () {	 &BIT(27);}
}
unless(defined(&ATW_SYNRF_SYNDATA)) {
    sub ATW_SYNRF_SYNDATA () {	 &BIT(26);}
}
unless(defined(&ATW_SYNRF_PE1)) {
    sub ATW_SYNRF_PE1 () {	 &BIT(25);}
}
unless(defined(&ATW_SYNRF_PE2)) {
    sub ATW_SYNRF_PE2 () {	 &BIT(24);}
}
unless(defined(&ATW_SYNRF_PAPE)) {
    sub ATW_SYNRF_PAPE () {	 &BIT(23);}
}
unless(defined(&ATW_C_SYNRF_TRSW)) {
    sub ATW_C_SYNRF_TRSW () {	 &BIT(22);}
}
unless(defined(&ATW_C_SYNRF_TRSWN)) {
    sub ATW_C_SYNRF_TRSWN () {	 &BIT(21);}
}
unless(defined(&ATW_SYNRF_INTERSIL_EN)) {
    sub ATW_SYNRF_INTERSIL_EN () {	 &BIT(20);}
}
unless(defined(&ATW_SYNRF_PHYRST)) {
    sub ATW_SYNRF_PHYRST () {	 &BIT(18);}
}
unless(defined(&ATW_C_SYNRF_RF2958PD)) {
    sub ATW_C_SYNRF_RF2958PD () {	 &ATW_SYNRF_PHYRST;}
}
unless(defined(&ATW_BPLI_BP_MASK)) {
    sub ATW_BPLI_BP_MASK () {	 &BITS(31,16);}
}
unless(defined(&ATW_BPLI_LI_MASK)) {
    sub ATW_BPLI_LI_MASK () {	 &BITS(15,0);}
}
unless(defined(&ATW_C_CAP0_TIMLEN1)) {
    sub ATW_C_CAP0_TIMLEN1 () {	 &BITS(31,24);}
}
unless(defined(&ATW_C_CAP0_TIMLEN0)) {
    sub ATW_C_CAP0_TIMLEN0 () {	 &BITS(23,16);}
}
unless(defined(&ATW_C_CAP0_CWMAX)) {
    sub ATW_C_CAP0_CWMAX () {	 &BITS(11,8);}
}
unless(defined(&ATW_CAP0_RCVDTIM)) {
    sub ATW_CAP0_RCVDTIM () {	 &BIT(4);}
}
unless(defined(&ATW_CAP0_CHN_MASK)) {
    sub ATW_CAP0_CHN_MASK () {	 &BITS(3,0);}
}
unless(defined(&ATW_CAP1_CAPI_MASK)) {
    sub ATW_CAP1_CAPI_MASK () {	 &BITS(31,16);}
}
unless(defined(&ATW_CAP1_ATIMW_MASK)) {
    sub ATW_CAP1_ATIMW_MASK () {	 &BITS(15,0);}
}
unless(defined(&ATW_RMD_ATIMST)) {
    sub ATW_RMD_ATIMST () {	 &BIT(31);}
}
unless(defined(&ATW_RMD_CFP)) {
    sub ATW_RMD_CFP () {	 &BIT(30);}
}
unless(defined(&ATW_RMD_PCNT)) {
    sub ATW_RMD_PCNT () {	 &BITS(27,16);}
}
unless(defined(&ATW_RMD_RMRD_MASK)) {
    sub ATW_RMD_RMRD_MASK () {	 &BITS(15,0);}
}
unless(defined(&ATW_CFPP_CFPP)) {
    sub ATW_CFPP_CFPP () {	 &BITS(31,24);}
}
unless(defined(&ATW_CFPP_CFPMD)) {
    sub ATW_CFPP_CFPMD () {	 &BITS(23,8);}
}
unless(defined(&ATW_CFPP_DTIMP)) {
    sub ATW_CFPP_DTIMP () {	 &BITS(7,0);}
}
unless(defined(&ATW_TOFS0_USCNT_MASK)) {
    sub ATW_TOFS0_USCNT_MASK () {	 &BITS(29,24);}
}
unless(defined(&ATW_C_TOFS0_TUCNT_MASK)) {
    sub ATW_C_TOFS0_TUCNT_MASK () {	 &BITS(14,10);}
}
unless(defined(&ATW_TOFS0_TUCNT_MASK)) {
    sub ATW_TOFS0_TUCNT_MASK () {	 &BITS(9,0);}
}
unless(defined(&ATW_TOFS1_TSFTOFSR_MASK)) {
    sub ATW_TOFS1_TSFTOFSR_MASK () {	 &BITS(31,24);}
}
unless(defined(&ATW_TOFS1_TBTTPRE_MASK)) {
    sub ATW_TOFS1_TBTTPRE_MASK () {	 &BITS(23,8);}
}
unless(defined(&ATW_TBTTPRE_MASK)) {
    sub ATW_TBTTPRE_MASK () {	 &BITS(25, 10);}
}
unless(defined(&ATW_TOFS1_TBTTOFS_MASK)) {
    sub ATW_TOFS1_TBTTOFS_MASK () {	 &BITS(7,0);}
}
unless(defined(&ATW_IFST_SLOT_MASK)) {
    sub ATW_IFST_SLOT_MASK () {	 &BITS(27,23);}
}
unless(defined(&ATW_IFST_SIFS_MASK)) {
    sub ATW_IFST_SIFS_MASK () {	 &BITS(22,15);}
}
unless(defined(&ATW_IFST_DIFS_MASK)) {
    sub ATW_IFST_DIFS_MASK () {	 &BITS(14,9);}
}
unless(defined(&ATW_IFST_EIFS_MASK)) {
    sub ATW_IFST_EIFS_MASK () {	 &BITS(8,0);}
}
unless(defined(&ATW_RSPT_MART_MASK)) {
    sub ATW_RSPT_MART_MASK () {	 &BITS(31,16);}
}
unless(defined(&ATW_RSPT_MIRT_MASK)) {
    sub ATW_RSPT_MIRT_MASK () {	 &BITS(15,8);}
}
unless(defined(&ATW_RSPT_TSFTOFST_MASK)) {
    sub ATW_RSPT_TSFTOFST_MASK () {	 &BITS(7,0);}
}
unless(defined(&ATW_WEPCTL_WEPENABLE)) {
    sub ATW_WEPCTL_WEPENABLE () {	 &BIT(31);}
}
unless(defined(&ATW_WEPCTL_AUTOSWITCH)) {
    sub ATW_WEPCTL_AUTOSWITCH () {	 &BIT(30);}
}
unless(defined(&ATW_WEPCTL_CURTBL)) {
    sub ATW_WEPCTL_CURTBL () {	 &BIT(29);}
}
unless(defined(&ATW_WEPCTL_WR)) {
    sub ATW_WEPCTL_WR () {	 &BIT(28);}
}
unless(defined(&ATW_WEPCTL_RD)) {
    sub ATW_WEPCTL_RD () {	 &BIT(27);}
}
unless(defined(&ATW_WEPCTL_WEPRXBYP)) {
    sub ATW_WEPCTL_WEPRXBYP () {	 &BIT(25);}
}
unless(defined(&ATW_WEPCTL_SHKEY)) {
    sub ATW_WEPCTL_SHKEY () {	 &BIT(24);}
}
unless(defined(&ATW_WEPCTL_UNKNOWN0)) {
    sub ATW_WEPCTL_UNKNOWN0 () {	 &BIT(23);}
}
unless(defined(&ATW_WEPCTL_TBLADD_MASK)) {
    sub ATW_WEPCTL_TBLADD_MASK () {	 &BITS(8,0);}
}
unless(defined(&ATW_WEP_ENABLED)) {
    sub ATW_WEP_ENABLED () {	 &BIT(7);}
}
unless(defined(&ATW_WEP_104BIT)) {
    sub ATW_WEP_104BIT () {	 &BIT(6);}
}
unless(defined(&ATW_WESK_DATA_MASK)) {
    sub ATW_WESK_DATA_MASK () {	 &BITS(15,0);}
}
unless(defined(&ATW_WEPCNT_WIEC_MASK)) {
    sub ATW_WEPCNT_WIEC_MASK () {	 &BITS(15,0);}
}
unless(defined(&ATW_MACTEST_FORCE_IV)) {
    sub ATW_MACTEST_FORCE_IV () {	 &BIT(23);}
}
unless(defined(&ATW_MACTEST_FORCE_KEYID)) {
    sub ATW_MACTEST_FORCE_KEYID () {	 &BIT(22);}
}
unless(defined(&ATW_MACTEST_KEYID_MASK)) {
    sub ATW_MACTEST_KEYID_MASK () {	 &BITS(21,20);}
}
unless(defined(&ATW_MACTEST_MMI_USETXCLK)) {
    sub ATW_MACTEST_MMI_USETXCLK () {	 &BIT(11);}
}
unless(defined(&ATW_FER_INTR)) {
    sub ATW_FER_INTR () {	 &BIT(15);}
}
unless(defined(&ATW_FER_GWAKE)) {
    sub ATW_FER_GWAKE () {	 &BIT(4);}
}
unless(defined(&ATW_FEMR_INTR_EN)) {
    sub ATW_FEMR_INTR_EN () {	 &BIT(15);}
}
unless(defined(&ATW_FEMR_WAKEUP_EN)) {
    sub ATW_FEMR_WAKEUP_EN () {	 &BIT(14);}
}
unless(defined(&ATW_FEMR_GWAKE_EN)) {
    sub ATW_FEMR_GWAKE_EN () {	 &BIT(4);}
}
unless(defined(&ATW_FPSR_INTR_STATUS)) {
    sub ATW_FPSR_INTR_STATUS () {	 &BIT(15);}
}
unless(defined(&ATW_FPSR_WAKEUP_STATUS)) {
    sub ATW_FPSR_WAKEUP_STATUS () {	 &BIT(4);}
}
unless(defined(&ATW_FFER_INTA_FORCE)) {
    sub ATW_FFER_INTA_FORCE () {	 &BIT(15);}
}
unless(defined(&ATW_FFER_GWAKE_FORCE)) {
    sub ATW_FFER_GWAKE_FORCE () {	 &BIT(4);}
}
unless(defined(&ATW_SR_CLASS_CODE)) {
    sub ATW_SR_CLASS_CODE () {	(0x/2);}
}
unless(defined(&ATW_SR_FORMAT_VERSION)) {
    sub ATW_SR_FORMAT_VERSION () {	(0x2/2);}
}
unless(defined(&ATW_SR_MAJOR_MASK)) {
    sub ATW_SR_MAJOR_MASK () {	 &BITS(7, 0);}
}
unless(defined(&ATW_SR_MINOR_MASK)) {
    sub ATW_SR_MINOR_MASK () {	 &BITS(15,8);}
}
unless(defined(&ATW_SR_MAC00)) {
    sub ATW_SR_MAC00 () {	(0x8/2);}
}
unless(defined(&ATW_SR_MAC01)) {
    sub ATW_SR_MAC01 () {	(0xa/2);}
}
unless(defined(&ATW_SR_MAC10)) {
    sub ATW_SR_MAC10 () {	(0xc/2);}
}
unless(defined(&ATW_SR_CSR20)) {
    sub ATW_SR_CSR20 () {	(0x16/2);}
}
unless(defined(&ATW_SR_ANT_MASK)) {
    sub ATW_SR_ANT_MASK () {	 &BITS(12, 10);}
}
unless(defined(&ATW_SR_PWRSCALE_MASK)) {
    sub ATW_SR_PWRSCALE_MASK () {	 &BITS(9, 8);}
}
unless(defined(&ATW_SR_CLKSAVE_MASK)) {
    sub ATW_SR_CLKSAVE_MASK () {	 &BITS(7, 6);}
}
unless(defined(&ATW_SR_RFTYPE_MASK)) {
    sub ATW_SR_RFTYPE_MASK () {	 &BITS(5, 3);}
}
unless(defined(&ATW_SR_BBPTYPE_MASK)) {
    sub ATW_SR_BBPTYPE_MASK () {	 &BITS(2, 0);}
}
unless(defined(&ATW_SR_CR28_CR03)) {
    sub ATW_SR_CR28_CR03 () {	(0x18/2);}
}
unless(defined(&ATW_SR_CR28_MASK)) {
    sub ATW_SR_CR28_MASK () {	 &BITS(15,8);}
}
unless(defined(&ATW_SR_CR03_MASK)) {
    sub ATW_SR_CR03_MASK () {	 &BITS(7, 0);}
}
unless(defined(&ATW_SR_CTRY_CR29)) {
    sub ATW_SR_CTRY_CR29 () {	(0x1a/2);}
}
unless(defined(&ATW_SR_CTRY_MASK)) {
    sub ATW_SR_CTRY_MASK () {	 &BITS(15,8);}
}
unless(defined(&COUNTRY_FCC)) {
    sub COUNTRY_FCC () {	0;}
}
unless(defined(&COUNTRY_IC)) {
    sub COUNTRY_IC () {	1;}
}
unless(defined(&COUNTRY_ETSI)) {
    sub COUNTRY_ETSI () {	2;}
}
unless(defined(&COUNTRY_SPAIN)) {
    sub COUNTRY_SPAIN () {	3;}
}
unless(defined(&COUNTRY_FRANCE)) {
    sub COUNTRY_FRANCE () {	4;}
}
unless(defined(&COUNTRY_MMK)) {
    sub COUNTRY_MMK () {	5;}
}
unless(defined(&COUNTRY_MMK2)) {
    sub COUNTRY_MMK2 () {	6;}
}
unless(defined(&ATW_SR_CR29_MASK)) {
    sub ATW_SR_CR29_MASK () {	 &BITS(7, 0);}
}
unless(defined(&ATW_SR_PCI_DEVICE)) {
    sub ATW_SR_PCI_DEVICE () {	(0x20/2);}
}
unless(defined(&ATW_SR_PCI_VENDOR)) {
    sub ATW_SR_PCI_VENDOR () {	(0x22/2);}
}
unless(defined(&ATW_SR_SUB_DEVICE)) {
    sub ATW_SR_SUB_DEVICE () {	(0x24/2);}
}
unless(defined(&ATW_SR_SUB_VENDOR)) {
    sub ATW_SR_SUB_VENDOR () {	(0x26/2);}
}
unless(defined(&ATW_SR_CR15)) {
    sub ATW_SR_CR15 () {	(0x28/2);}
}
unless(defined(&ATW_SR_LOCISPTR)) {
    sub ATW_SR_LOCISPTR () {	(0x2a/2);}
}
unless(defined(&ATW_SR_HICISPTR)) {
    sub ATW_SR_HICISPTR () {	(0x2c/2);}
}
unless(defined(&ATW_SR_CSR18)) {
    sub ATW_SR_CSR18 () {	(0x2e/2);}
}
unless(defined(&ATW_SR_D0_D1_PWR)) {
    sub ATW_SR_D0_D1_PWR () {	(0x40/2);}
}
unless(defined(&ATW_SR_D2_D3_PWR)) {
    sub ATW_SR_D2_D3_PWR () {	(0x42/2);}
}
unless(defined(&ATW_SR_CIS_WORDS)) {
    sub ATW_SR_CIS_WORDS () {	(0x52/2);}
}
unless(defined(&ATW_SR_TXPOWER)) {
    sub ATW_SR_TXPOWER {
	local($chnl) = @_;
	eval q((0x54/2+ (($chnl) - 1)/2));
    }
}
unless(defined(&ATW_SR_LPF_CUTOFF)) {
    sub ATW_SR_LPF_CUTOFF {
	local($chnl) = @_;
	eval q((0x62/2+ (($chnl) - 1)/2));
    }
}
unless(defined(&ATW_SR_LNA_GS_THRESH)) {
    sub ATW_SR_LNA_GS_THRESH {
	local($chnl) = @_;
	eval q((0x70/2+ (($chnl) - 1)/2));
    }
}
unless(defined(&ATW_SR_CHECKSUM)) {
    sub ATW_SR_CHECKSUM () {	(0x7e/2);}
}
unless(defined(&ATW_SR_CIS)) {
    sub ATW_SR_CIS () {	(0x80/2);}
}
unless(defined(&at_stat)) {
    sub at_stat () {	 &at_ctl;}
}
unless(defined(&ATW_TXCTL_OWN)) {
    sub ATW_TXCTL_OWN () {	 &BIT(31);}
}
unless(defined(&ATW_TXCTL_DONE)) {
    sub ATW_TXCTL_DONE () {	 &BIT(30);}
}
unless(defined(&ATW_TXCTL_TXDR_MASK)) {
    sub ATW_TXCTL_TXDR_MASK () {	 &BITS(27,20);}
}
unless(defined(&ATW_TXCTL_TL_MASK)) {
    sub ATW_TXCTL_TL_MASK () {	 &BITS(19,0);}
}
unless(defined(&ATW_TXSTAT_OWN)) {
    sub ATW_TXSTAT_OWN () {	 &ATW_TXCTL_OWN;}
}
unless(defined(&ATW_TXSTAT_DONE)) {
    sub ATW_TXSTAT_DONE () {	 &ATW_TXCTL_DONE;}
}
unless(defined(&ATW_TXSTAT_ES)) {
    sub ATW_TXSTAT_ES () {	 &BIT(29);}
}
unless(defined(&ATW_TXSTAT_TLT)) {
    sub ATW_TXSTAT_TLT () {	 &BIT(28);}
}
unless(defined(&ATW_TXSTAT_TRT)) {
    sub ATW_TXSTAT_TRT () {	 &BIT(27);}
}
unless(defined(&ATW_TXSTAT_TUF)) {
    sub ATW_TXSTAT_TUF () {	 &BIT(26);}
}
unless(defined(&ATW_TXSTAT_TRO)) {
    sub ATW_TXSTAT_TRO () {	 &BIT(25);}
}
unless(defined(&ATW_TXSTAT_SOFBR)) {
    sub ATW_TXSTAT_SOFBR () {	 &BIT(24);}
}
unless(defined(&ATW_TXSTAT_ARC_MASK)) {
    sub ATW_TXSTAT_ARC_MASK () {	 &BITS(11,0);}
}
unless(defined(&ATW_TXFLAG_IC)) {
    sub ATW_TXFLAG_IC () {	 &BIT(31);}
}
unless(defined(&ATW_TXFLAG_LS)) {
    sub ATW_TXFLAG_LS () {	 &BIT(30);}
}
unless(defined(&ATW_TXFLAG_FS)) {
    sub ATW_TXFLAG_FS () {	 &BIT(29);}
}
unless(defined(&ATW_TXFLAG_TER)) {
    sub ATW_TXFLAG_TER () {	 &BIT(25);}
}
unless(defined(&ATW_TXFLAG_TCH)) {
    sub ATW_TXFLAG_TCH () {	 &BIT(24);}
}
unless(defined(&ATW_TXFLAG_TBS2_MASK)) {
    sub ATW_TXFLAG_TBS2_MASK () {	 &BITS(23,12);}
}
unless(defined(&ATW_TXFLAG_TBS1_MASK)) {
    sub ATW_TXFLAG_TBS1_MASK () {	 &BITS(11,0);}
}
unless(defined(&ar_rssi)) {
    sub ar_rssi () {	 &ar_ctl;}
}
unless(defined(&ATW_RXCTL_RER)) {
    sub ATW_RXCTL_RER () {	 &BIT(25);}
}
unless(defined(&ATW_RXCTL_RCH)) {
    sub ATW_RXCTL_RCH () {	 &BIT(24);}
}
unless(defined(&ATW_RXCTL_RBS2_MASK)) {
    sub ATW_RXCTL_RBS2_MASK () {	 &BITS(23,12);}
}
unless(defined(&ATW_RXCTL_RBS1_MASK)) {
    sub ATW_RXCTL_RBS1_MASK () {	 &BITS(11,0);}
}
unless(defined(&ATW_RXSTAT_OWN)) {
    sub ATW_RXSTAT_OWN () {	 &BIT(31);}
}
unless(defined(&ATW_RXSTAT_ES)) {
    sub ATW_RXSTAT_ES () {	 &BIT(30);}
}
unless(defined(&ATW_RXSTAT_SQL)) {
    sub ATW_RXSTAT_SQL () {	 &BIT(29);}
}
unless(defined(&ATW_RXSTAT_DE)) {
    sub ATW_RXSTAT_DE () {	 &BIT(28);}
}
unless(defined(&ATW_RXSTAT_FS)) {
    sub ATW_RXSTAT_FS () {	 &BIT(27);}
}
unless(defined(&ATW_RXSTAT_LS)) {
    sub ATW_RXSTAT_LS () {	 &BIT(26);}
}
unless(defined(&ATW_RXSTAT_PCF)) {
    sub ATW_RXSTAT_PCF () {	 &BIT(25);}
}
unless(defined(&ATW_RXSTAT_SFDE)) {
    sub ATW_RXSTAT_SFDE () {	 &BIT(24);}
}
unless(defined(&ATW_RXSTAT_SIGE)) {
    sub ATW_RXSTAT_SIGE () {	 &BIT(23);}
}
unless(defined(&ATW_RXSTAT_CRC16E)) {
    sub ATW_RXSTAT_CRC16E () {	 &BIT(22);}
}
unless(defined(&ATW_RXSTAT_RXTOE)) {
    sub ATW_RXSTAT_RXTOE () {	 &BIT(21);}
}
unless(defined(&ATW_RXSTAT_CRC32E)) {
    sub ATW_RXSTAT_CRC32E () {	 &BIT(20);}
}
unless(defined(&ATW_RXSTAT_ICVE)) {
    sub ATW_RXSTAT_ICVE () {	 &BIT(19);}
}
unless(defined(&ATW_RXSTAT_DA1)) {
    sub ATW_RXSTAT_DA1 () {	 &BIT(17);}
}
unless(defined(&ATW_RXSTAT_DA0)) {
    sub ATW_RXSTAT_DA0 () {	 &BIT(16);}
}
unless(defined(&ATW_RXSTAT_RXDR_MASK)) {
    sub ATW_RXSTAT_RXDR_MASK () {	 &BITS(15,12);}
}
unless(defined(&ATW_RXSTAT_FL_MASK)) {
    sub ATW_RXSTAT_FL_MASK () {	 &BITS(11,0);}
}
unless(defined(&ATW_SRAM_ADDR_INDIVL_KEY)) {
    sub ATW_SRAM_ADDR_INDIVL_KEY () {	0x;}
}
unless(defined(&ATW_SRAM_ADDR_SHARED_KEY)) {
    sub ATW_SRAM_ADDR_SHARED_KEY () {	(0x160 * 2);}
}
unless(defined(&ATW_SRAM_ADDR_SSID)) {
    sub ATW_SRAM_ADDR_SSID () {	(0x180 * 2);}
}
unless(defined(&ATW_SRAM_ADDR_SUPRATES)) {
    sub ATW_SRAM_ADDR_SUPRATES () {	(0x191 * 2);}
}
unless(defined(&ATW_SRAM_MAXSIZE)) {
    sub ATW_SRAM_MAXSIZE () {	(0x200 * 2);}
}
unless(defined(&ATW_SRAM_A_SIZE)) {
    sub ATW_SRAM_A_SIZE () {	 &ATW_SRAM_MAXSIZE;}
}
unless(defined(&ATW_SRAM_B_SIZE)) {
    sub ATW_SRAM_B_SIZE () {	(0x1c0 * 2);}
}
1;
