require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DEV_PCI_EMUXKIREG_H_)) {
    eval 'sub _DEV_PCI_EMUXKIREG_H_ () {1;}' unless defined(&_DEV_PCI_EMUXKIREG_H_);
    eval 'sub EMU_MKSUBREG {
        local($sz, $idx, $reg) = @_;
	    eval q(((($sz) << 24) | (($idx) << 16) | ($reg)));
    }' unless defined(&EMU_MKSUBREG);
    eval 'sub EMU_PTR () {0x;}' unless defined(&EMU_PTR);
    eval 'sub EMU_PTR_CHNO_MASK () {0x3f;}' unless defined(&EMU_PTR_CHNO_MASK);
    eval 'sub EMU_PTR_ADDR_MASK () {0x7ff0000;}' unless defined(&EMU_PTR_ADDR_MASK);
    eval 'sub EMU_A_PTR_ADDR_MASK () {0xfff0000;}' unless defined(&EMU_A_PTR_ADDR_MASK);
    eval 'sub EMU_DATA () {0x4;}' unless defined(&EMU_DATA);
    eval 'sub EMU_IPR () {0x8;}' unless defined(&EMU_IPR);
    eval 'sub EMU_IPR_RATETRCHANGE () {0x1000000;}' unless defined(&EMU_IPR_RATETRCHANGE);
    eval 'sub EMU_IPR_FXDSP () {0x800000;}' unless defined(&EMU_IPR_FXDSP);
    eval 'sub EMU_IPR_FORCEINT () {0x400000;}' unless defined(&EMU_IPR_FORCEINT);
    eval 'sub EMU_PCIERROR () {0x200000;}' unless defined(&EMU_PCIERROR);
    eval 'sub EMU_IPR_VOLINCR () {0x100000;}' unless defined(&EMU_IPR_VOLINCR);
    eval 'sub EMU_IPR_VOLDECR () {0x80000;}' unless defined(&EMU_IPR_VOLDECR);
    eval 'sub EMU_IPR_MUTE () {0x40000;}' unless defined(&EMU_IPR_MUTE);
    eval 'sub EMU_IPR_MICBUFFULL () {0x20000;}' unless defined(&EMU_IPR_MICBUFFULL);
    eval 'sub EMU_IPR_MICBUFHALFFULL () {0x10000;}' unless defined(&EMU_IPR_MICBUFHALFFULL);
    eval 'sub EMU_IPR_ADCBUFFULL () {0x8000;}' unless defined(&EMU_IPR_ADCBUFFULL);
    eval 'sub EMU_IPR_ADCBUFHALFFULL () {0x4000;}' unless defined(&EMU_IPR_ADCBUFHALFFULL);
    eval 'sub EMU_IPR_EFXBUFFULL () {0x2000;}' unless defined(&EMU_IPR_EFXBUFFULL);
    eval 'sub EMU_IPR_EFXBUFHALFFULL () {0x1000;}' unless defined(&EMU_IPR_EFXBUFHALFFULL);
    eval 'sub EMU_IPR_GPSPDIFSTCHANGE () {0x800;}' unless defined(&EMU_IPR_GPSPDIFSTCHANGE);
    eval 'sub EMU_IPR_CDROMSTCHANGE () {0x400;}' unless defined(&EMU_IPR_CDROMSTCHANGE);
    eval 'sub EMU_IPR_INTERVALTIMER () {0x200;}' unless defined(&EMU_IPR_INTERVALTIMER);
    eval 'sub EMU_IPR_MIDITRANSBUFE () {0x100;}' unless defined(&EMU_IPR_MIDITRANSBUFE);
    eval 'sub EMU_IPR_MIDIRECVBUFE () {0x80;}' unless defined(&EMU_IPR_MIDIRECVBUFE);
    eval 'sub EMU_IPR_A_MIDITRANSBUFE2 () {0x10000000;}' unless defined(&EMU_IPR_A_MIDITRANSBUFE2);
    eval 'sub EMU_IPR_A_MIDIRECBUFE2 () {0x8000000;}' unless defined(&EMU_IPR_A_MIDIRECBUFE2);
    eval 'sub EMU_IPR_CHANNELLOOP () {0x40;}' unless defined(&EMU_IPR_CHANNELLOOP);
    eval 'sub EMU_IPR_CHNOMASK () {0x3f;}' unless defined(&EMU_IPR_CHNOMASK);
    eval 'sub EMU_INTE () {0xc;}' unless defined(&EMU_INTE);
    eval 'sub EMU_INTE_VSB_MASK () {0xc0000000;}' unless defined(&EMU_INTE_VSB_MASK);
    eval 'sub EMU_INTE_VSB_220 () {0x;}' unless defined(&EMU_INTE_VSB_220);
    eval 'sub EMU_INTE_VSB_240 () {0x40000000;}' unless defined(&EMU_INTE_VSB_240);
    eval 'sub EMU_INTE_VSB_260 () {0x80000000;}' unless defined(&EMU_INTE_VSB_260);
    eval 'sub EMU_INTE_VSB_280 () {0xc0000000;}' unless defined(&EMU_INTE_VSB_280);
    eval 'sub EMU_INTE_VMPU_MASK () {0x30000000;}' unless defined(&EMU_INTE_VMPU_MASK);
    eval 'sub EMU_INTE_VMPU_300 () {0x;}' unless defined(&EMU_INTE_VMPU_300);
    eval 'sub EMU_INTE_VMPU_310 () {0x10000000;}' unless defined(&EMU_INTE_VMPU_310);
    eval 'sub EMU_INTE_VMPU_320 () {0x20000000;}' unless defined(&EMU_INTE_VMPU_320);
    eval 'sub EMU_INTE_VMPU_330 () {0x30000000;}' unless defined(&EMU_INTE_VMPU_330);
    eval 'sub EMU_INTE_MDMAENABLE () {0x8000000;}' unless defined(&EMU_INTE_MDMAENABLE);
    eval 'sub EMU_INTE_SDMAENABLE () {0x4000000;}' unless defined(&EMU_INTE_SDMAENABLE);
    eval 'sub EMU_INTE_MPICENABLE () {0x2000000;}' unless defined(&EMU_INTE_MPICENABLE);
    eval 'sub EMU_INTE_SPICENABLE () {0x1000000;}' unless defined(&EMU_INTE_SPICENABLE);
    eval 'sub EMU_INTE_VSBENABLE () {0x800000;}' unless defined(&EMU_INTE_VSBENABLE);
    eval 'sub EMU_INTE_ADLIBENABLE () {0x400000;}' unless defined(&EMU_INTE_ADLIBENABLE);
    eval 'sub EMU_INTE_MPUENABLE () {0x200000;}' unless defined(&EMU_INTE_MPUENABLE);
    eval 'sub EMU_INTE_FORCEINT () {0x100000;}' unless defined(&EMU_INTE_FORCEINT);
    eval 'sub EMU_INTE_MRHANDENABLE () {0x80000;}' unless defined(&EMU_INTE_MRHANDENABLE);
    eval 'sub EMU_INTE_SAMPLERATER () {0x2000;}' unless defined(&EMU_INTE_SAMPLERATER);
    eval 'sub EMU_INTE_FXDSPENABLE () {0x1000;}' unless defined(&EMU_INTE_FXDSPENABLE);
    eval 'sub EMU_INTE_PCIERRENABLE () {0x800;}' unless defined(&EMU_INTE_PCIERRENABLE);
    eval 'sub EMU_INTE_VOLINCRENABLE () {0x400;}' unless defined(&EMU_INTE_VOLINCRENABLE);
    eval 'sub EMU_INTE_VOLDECRENABLE () {0x200;}' unless defined(&EMU_INTE_VOLDECRENABLE);
    eval 'sub EMU_INTE_MUTEENABLE () {0x100;}' unless defined(&EMU_INTE_MUTEENABLE);
    eval 'sub EMU_INTE_MICBUFENABLE () {0x80;}' unless defined(&EMU_INTE_MICBUFENABLE);
    eval 'sub EMU_INTE_ADCBUFENABLE () {0x40;}' unless defined(&EMU_INTE_ADCBUFENABLE);
    eval 'sub EMU_INTE_EFXBUFENABLE () {0x20;}' unless defined(&EMU_INTE_EFXBUFENABLE);
    eval 'sub EMU_INTE_GPSPDIFENABLE () {0x10;}' unless defined(&EMU_INTE_GPSPDIFENABLE);
    eval 'sub EMU_INTE_CDSPDIFENABLE () {0x8;}' unless defined(&EMU_INTE_CDSPDIFENABLE);
    eval 'sub EMU_INTE_INTERTIMERENB () {0x4;}' unless defined(&EMU_INTE_INTERTIMERENB);
    eval 'sub EMU_INTE_MIDITXENABLE () {0x2;}' unless defined(&EMU_INTE_MIDITXENABLE);
    eval 'sub EMU_INTE_MIDIRXENABLE () {0x1;}' unless defined(&EMU_INTE_MIDIRXENABLE);
    eval 'sub EMU_INTE_A_MIDITXENABLE2 () {0x20000;}' unless defined(&EMU_INTE_A_MIDITXENABLE2);
    eval 'sub EMU_INTE_A_MIDIRXENABLE2 () {0x10000;}' unless defined(&EMU_INTE_A_MIDIRXENABLE2);
    eval 'sub EMU_WC () {0x10;}' unless defined(&EMU_WC);
    eval 'sub EMU_WC_SAMPLECOUNTER_MASK () {0x3ffffc0;}' unless defined(&EMU_WC_SAMPLECOUNTER_MASK);
    eval 'sub EMU_WC_SAMPLECOUNTER () { &EMU_MKSUBREG(20, 6,  &EMU_WC);}' unless defined(&EMU_WC_SAMPLECOUNTER);
    eval 'sub EMU_WC_CURRENTCHANNEL () {0x3f;}' unless defined(&EMU_WC_CURRENTCHANNEL);
    eval 'sub EMU_HCFG () {0x14;}' unless defined(&EMU_HCFG);
    eval 'sub EMU_HCFG_LEGACYFUNC_MASK () {0xe0000000;}' unless defined(&EMU_HCFG_LEGACYFUNC_MASK);
    eval 'sub EMU_HCFG_LEGACYFUNC_MPU () {0x;}' unless defined(&EMU_HCFG_LEGACYFUNC_MPU);
    eval 'sub EMU_HCFG_LEGACYFUNC_SB () {0x40000000;}' unless defined(&EMU_HCFG_LEGACYFUNC_SB);
    eval 'sub EMU_HCFG_LEGACYFUNC_AD () {0x60000000;}' unless defined(&EMU_HCFG_LEGACYFUNC_AD);
    eval 'sub EMU_HCFG_LEGACYFUNC_MPIC () {0x80000000;}' unless defined(&EMU_HCFG_LEGACYFUNC_MPIC);
    eval 'sub EMU_HCFG_LEGACYFUNC_MDMA () {0xa0000000;}' unless defined(&EMU_HCFG_LEGACYFUNC_MDMA);
    eval 'sub EMU_HCFG_LEGACYFUNC_SPCI () {0xc0000000;}' unless defined(&EMU_HCFG_LEGACYFUNC_SPCI);
    eval 'sub EMU_HCFG_LEGACYFUNC_SDMA () {0xe0000000;}' unless defined(&EMU_HCFG_LEGACYFUNC_SDMA);
    eval 'sub EMU_HCFG_IOCAPTUREADDR () {0x1f000000;}' unless defined(&EMU_HCFG_IOCAPTUREADDR);
    eval 'sub EMU_HCFG_LEGACYWRITE () {0x800000;}' unless defined(&EMU_HCFG_LEGACYWRITE);
    eval 'sub EMU_HCFG_LEGACYWORD () {0x400000;}' unless defined(&EMU_HCFG_LEGACYWORD);
    eval 'sub EMU_HCFG_LEGACYINT () {0x200000;}' unless defined(&EMU_HCFG_LEGACYINT);
    eval 'sub EMU_HCFG_CODECFMT_MASK () {0x70000;}' unless defined(&EMU_HCFG_CODECFMT_MASK);
    eval 'sub EMU_HCFG_CODECFMT_AC97 () {0x;}' unless defined(&EMU_HCFG_CODECFMT_AC97);
    eval 'sub EMU_HCFG_CODECFMT_I2S () {0x10000;}' unless defined(&EMU_HCFG_CODECFMT_I2S);
    eval 'sub EMU_HCFG_GPINPUT0 () {0x4000;}' unless defined(&EMU_HCFG_GPINPUT0);
    eval 'sub EMU_HCFG_GPINPUT1 () {0x2000;}' unless defined(&EMU_HCFG_GPINPUT1);
    eval 'sub EMU_HCFG_GPOUTPUT0 () {0x1000;}' unless defined(&EMU_HCFG_GPOUTPUT0);
    eval 'sub EMU_HCFG_GPOUTPUT1 () {0x800;}' unless defined(&EMU_HCFG_GPOUTPUT1);
    eval 'sub EMU_HCFG_GPOUTPUT2 () {0x400;}' unless defined(&EMU_HCFG_GPOUTPUT2);
    eval 'sub EMU_HCFG_GPOUTPUT_MASK () {0x1c00;}' unless defined(&EMU_HCFG_GPOUTPUT_MASK);
    eval 'sub EMU_HCFG_JOYENABLE () {0x200;}' unless defined(&EMU_HCFG_JOYENABLE);
    eval 'sub EMU_HCFG_PHASETRACKENABLE () {0x100;}' unless defined(&EMU_HCFG_PHASETRACKENABLE);
    eval 'sub EMU_HCFG_AC3ENABLE_MASK () {0xe0;}' unless defined(&EMU_HCFG_AC3ENABLE_MASK);
    eval 'sub EMU_HCFG_AC3ENABLE_ZVIDEO () {0x80;}' unless defined(&EMU_HCFG_AC3ENABLE_ZVIDEO);
    eval 'sub EMU_HCFG_AC3ENABLE_CDSPDIF () {0x40;}' unless defined(&EMU_HCFG_AC3ENABLE_CDSPDIF);
    eval 'sub EMU_HCFG_AC3ENABLE_GPSPDIF () {0x20;}' unless defined(&EMU_HCFG_AC3ENABLE_GPSPDIF);
    eval 'sub EMU_HCFG_AUTOMUTE () {0x10;}' unless defined(&EMU_HCFG_AUTOMUTE);
    eval 'sub EMU_HCFG_LOCKSOUNDCACHE () {0x8;}' unless defined(&EMU_HCFG_LOCKSOUNDCACHE);
    eval 'sub EMU_HCFG_LOCKTANKCACHE_MASK () {0x4;}' unless defined(&EMU_HCFG_LOCKTANKCACHE_MASK);
    eval 'sub EMU_HCFG_LOCKTANKCACHE () { &EMU_MKSUBREG(1, 2,  &EMU_HCFG);}' unless defined(&EMU_HCFG_LOCKTANKCACHE);
    eval 'sub EMU_HCFG_MUTEBUTTONENABLE () {0x2;}' unless defined(&EMU_HCFG_MUTEBUTTONENABLE);
    eval 'sub EMU_HCFG_AUDIOENABLE () {0x1;}' unless defined(&EMU_HCFG_AUDIOENABLE);
    eval 'sub EMU_MUDATA () {0x18;}' unless defined(&EMU_MUDATA);
    eval 'sub EMU_MUCMD () {0x19;}' unless defined(&EMU_MUCMD);
    eval 'sub EMU_MUCMD_RESET () {0xff;}' unless defined(&EMU_MUCMD_RESET);
    eval 'sub EMU_MUCMD_ENTERUARTMODE () {0x3f;}' unless defined(&EMU_MUCMD_ENTERUARTMODE);
    eval 'sub EMU_MUSTAT () { &EMU_MUCMD;}' unless defined(&EMU_MUSTAT);
    eval 'sub EMU_MUSTAT_IRDYN () {0x80;}' unless defined(&EMU_MUSTAT_IRDYN);
    eval 'sub EMU_MUSTAT_ORDYN () {0x40;}' unless defined(&EMU_MUSTAT_ORDYN);
    eval 'sub EMU_A_IOCFG () {0x18;}' unless defined(&EMU_A_IOCFG);
    eval 'sub EMU_A_GPINPUT_MASK () {0xff00;}' unless defined(&EMU_A_GPINPUT_MASK);
    eval 'sub EMU_A_GPOUTPUT_MASK () {0xff;}' unless defined(&EMU_A_GPOUTPUT_MASK);
    eval 'sub EMU_A_IOCFG_GPOUT0 () {0x40;}' unless defined(&EMU_A_IOCFG_GPOUT0);
    eval 'sub EMU_A_IOCFG_GPOUT1 () {0x4;}' unless defined(&EMU_A_IOCFG_GPOUT1);
    eval 'sub EMU_TIMER () {0x1a;}' unless defined(&EMU_TIMER);
    eval 'sub EMU_TIMER_RATE_MASK () {0x3ff;}' unless defined(&EMU_TIMER_RATE_MASK);
    eval 'sub EMU_TIMER_RATE () { &EMU_MKSUBREG(10, 0,  &EMU_TIMER);}' unless defined(&EMU_TIMER_RATE);
    eval 'sub EMU_AC97DATA () {0x1c;}' unless defined(&EMU_AC97DATA);
    eval 'sub EMU_AC97ADDR () {0x1e;}' unless defined(&EMU_AC97ADDR);
    eval 'sub EMU_AC97ADDR_RDY () {0x80;}' unless defined(&EMU_AC97ADDR_RDY);
    eval 'sub EMU_AC97ADDR_ADDR () {0x7f;}' unless defined(&EMU_AC97ADDR_ADDR);
    eval 'sub EMU_A2_PTR () {0x20;}' unless defined(&EMU_A2_PTR);
    eval 'sub EMU_A2_DATA () {0x24;}' unless defined(&EMU_A2_DATA);
    eval 'sub EMU_A2_SRCSEL () {0x600000;}' unless defined(&EMU_A2_SRCSEL);
    eval 'sub EMU_A2_SRCSEL_ENABLE_SPDIF () {0x4;}' unless defined(&EMU_A2_SRCSEL_ENABLE_SPDIF);
    eval 'sub EMU_A2_SRCSEL_ENABLE_SRCMULTI () {0x10;}' unless defined(&EMU_A2_SRCSEL_ENABLE_SRCMULTI);
    eval 'sub EMU_A2_SRCMULTI () {0x6e0000;}' unless defined(&EMU_A2_SRCMULTI);
    eval 'sub EMU_A2_SRCMULTI_ENABLE_INPUT () {0xff00ff00;}' unless defined(&EMU_A2_SRCMULTI_ENABLE_INPUT);
    eval 'sub EMU_CHAN_CPF () {0x;}' unless defined(&EMU_CHAN_CPF);
    eval 'sub EMU_CHAN_CPF_PITCH_MASK () {0xffff0000;}' unless defined(&EMU_CHAN_CPF_PITCH_MASK);
    eval 'sub EMU_CHAN_CPF_PITCH () { &EMU_MKSUBREG(16, 16,  &EMU_CHAN_CPF);}' unless defined(&EMU_CHAN_CPF_PITCH);
    eval 'sub EMU_CHAN_CPF_STEREO_MASK () {0x8000;}' unless defined(&EMU_CHAN_CPF_STEREO_MASK);
    eval 'sub EMU_CHAN_CPF_STEREO () { &EMU_MKSUBREG(1, 15,  &EMU_CHAN_CPF);}' unless defined(&EMU_CHAN_CPF_STEREO);
    eval 'sub EMU_CHAN_CPF_STOP_MASK () {0x4000;}' unless defined(&EMU_CHAN_CPF_STOP_MASK);
    eval 'sub EMU_CHAN_CPF_FRACADDRESS_MASK () {0x3fff;}' unless defined(&EMU_CHAN_CPF_FRACADDRESS_MASK);
    eval 'sub EMU_CHAN_PTRX () {0x1;}' unless defined(&EMU_CHAN_PTRX);
    eval 'sub EMU_CHAN_PTRX_PITCHTARGET_MASK () {0xffff0000;}' unless defined(&EMU_CHAN_PTRX_PITCHTARGET_MASK);
    eval 'sub EMU_CHAN_PTRX_PITCHTARGET () { &EMU_MKSUBREG(16, 16,  &EMU_CHAN_PTRX);}' unless defined(&EMU_CHAN_PTRX_PITCHTARGET);
    eval 'sub EMU_CHAN_PTRX_FXSENDAMOUNT_A_MASK () {0xff00;}' unless defined(&EMU_CHAN_PTRX_FXSENDAMOUNT_A_MASK);
    eval 'sub EMU_CHAN_PTRX_FXSENDAMOUNT_A () { &EMU_MKSUBREG(8, 8,  &EMU_CHAN_PTRX);}' unless defined(&EMU_CHAN_PTRX_FXSENDAMOUNT_A);
    eval 'sub EMU_CHAN_PTRX_FXSENDAMOUNT_B_MASK () {0xff;}' unless defined(&EMU_CHAN_PTRX_FXSENDAMOUNT_B_MASK);
    eval 'sub EMU_CHAN_PTRX_FXSENDAMOUNT_B () { &EMU_MKSUBREG(8, 0,  &EMU_CHAN_PTRX);}' unless defined(&EMU_CHAN_PTRX_FXSENDAMOUNT_B);
    eval 'sub EMU_CHAN_CVCF () {0x2;}' unless defined(&EMU_CHAN_CVCF);
    eval 'sub EMU_CHAN_CVCF_CURRVOL_MASK () {0xffff0000;}' unless defined(&EMU_CHAN_CVCF_CURRVOL_MASK);
    eval 'sub EMU_CHAN_CVCF_CURRVOL () { &EMU_MKSUBREG(16, 16,  &EMU_CHAN_CVCF);}' unless defined(&EMU_CHAN_CVCF_CURRVOL);
    eval 'sub EMU_CHAN_CVCF_CURRFILTER_MASK () {0xffff;}' unless defined(&EMU_CHAN_CVCF_CURRFILTER_MASK);
    eval 'sub EMU_CHAN_CVCF_CURRFILTER () { &EMU_MKSUBREG(16, 0,  &EMU_CHAN_CVCF);}' unless defined(&EMU_CHAN_CVCF_CURRFILTER);
    eval 'sub EMU_CHAN_VTFT () {0x3;}' unless defined(&EMU_CHAN_VTFT);
    eval 'sub EMU_CHAN_VTFT_VOLUMETARGET_MASK () {0xffff0000;}' unless defined(&EMU_CHAN_VTFT_VOLUMETARGET_MASK);
    eval 'sub EMU_CHAN_VTFT_VOLUMETARGET () { &EMU_MKSUBREG(16, 16,  &EMU_CHAN_VTFT);}' unless defined(&EMU_CHAN_VTFT_VOLUMETARGET);
    eval 'sub EMU_CHAN_VTFT_FILTERTARGET_MASK () {0xffff;}' unless defined(&EMU_CHAN_VTFT_FILTERTARGET_MASK);
    eval 'sub EMU_CHAN_VTFT_FILTERTARGET () { &EMU_MKSUBREG(16, 0,  &EMU_CHAN_VTFT);}' unless defined(&EMU_CHAN_VTFT_FILTERTARGET);
    eval 'sub EMU_CHAN_Z1 () {0x5;}' unless defined(&EMU_CHAN_Z1);
    eval 'sub EMU_CHAN_Z2 () {0x4;}' unless defined(&EMU_CHAN_Z2);
    eval 'sub EMU_CHAN_PSST () {0x6;}' unless defined(&EMU_CHAN_PSST);
    eval 'sub EMU_CHAN_PSST_FXSENDAMOUNT_C_MASK () {0xff000000;}' unless defined(&EMU_CHAN_PSST_FXSENDAMOUNT_C_MASK);
    eval 'sub EMU_CHAN_PSST_FXSENDAMOUNT_C () { &EMU_MKSUBREG(8, 24,  &EMU_CHAN_PSST);}' unless defined(&EMU_CHAN_PSST_FXSENDAMOUNT_C);
    eval 'sub EMU_CHAN_PSST_LOOPSTARTADDR_MASK () {0xffffff;}' unless defined(&EMU_CHAN_PSST_LOOPSTARTADDR_MASK);
    eval 'sub EMU_CHAN_PSST_LOOPSTARTADDR () { &EMU_MKSUBREG(24, 0,  &EMU_CHAN_PSST);}' unless defined(&EMU_CHAN_PSST_LOOPSTARTADDR);
    eval 'sub EMU_CHAN_DSL () {0x7;}' unless defined(&EMU_CHAN_DSL);
    eval 'sub EMU_CHAN_DSL_FXSENDAMOUNT_D_MASK () {0xff000000;}' unless defined(&EMU_CHAN_DSL_FXSENDAMOUNT_D_MASK);
    eval 'sub EMU_CHAN_DSL_FXSENDAMOUNT_D () { &EMU_MKSUBREG(8, 24,  &EMU_CHAN_DSL);}' unless defined(&EMU_CHAN_DSL_FXSENDAMOUNT_D);
    eval 'sub EMU_CHAN_DSL_LOOPENDADDR_MASK () {0xffffff;}' unless defined(&EMU_CHAN_DSL_LOOPENDADDR_MASK);
    eval 'sub EMU_CHAN_DSL_LOOPENDADDR () { &EMU_MKSUBREG(24, 0,  &EMU_CHAN_DSL);}' unless defined(&EMU_CHAN_DSL_LOOPENDADDR);
    eval 'sub EMU_CHAN_CCCA () {0x8;}' unless defined(&EMU_CHAN_CCCA);
    eval 'sub EMU_CHAN_CCCA_RESONANCE () {0xf0000000;}' unless defined(&EMU_CHAN_CCCA_RESONANCE);
    eval 'sub EMU_CHAN_CCCA_INTERPROMMASK () {0xe000000;}' unless defined(&EMU_CHAN_CCCA_INTERPROMMASK);
    eval 'sub EMU_CHAN_CCCA_INTERPROM_0 () {0x;}' unless defined(&EMU_CHAN_CCCA_INTERPROM_0);
    eval 'sub EMU_CHAN_CCCA_INTERPROM_1 () {0x2000000;}' unless defined(&EMU_CHAN_CCCA_INTERPROM_1);
    eval 'sub EMU_CHAN_CCCA_INTERPROM_2 () {0x4000000;}' unless defined(&EMU_CHAN_CCCA_INTERPROM_2);
    eval 'sub EMU_CHAN_CCCA_INTERPROM_3 () {0x6000000;}' unless defined(&EMU_CHAN_CCCA_INTERPROM_3);
    eval 'sub EMU_CHAN_CCCA_INTERPROM_4 () {0x8000000;}' unless defined(&EMU_CHAN_CCCA_INTERPROM_4);
    eval 'sub EMU_CHAN_CCCA_INTERPROM_5 () {0xa000000;}' unless defined(&EMU_CHAN_CCCA_INTERPROM_5);
    eval 'sub EMU_CHAN_CCCA_INTERPROM_6 () {0xc000000;}' unless defined(&EMU_CHAN_CCCA_INTERPROM_6);
    eval 'sub EMU_CHAN_CCCA_INTERPROM_7 () {0xe000000;}' unless defined(&EMU_CHAN_CCCA_INTERPROM_7);
    eval 'sub EMU_CHAN_CCCA_8BITSELECT () {0x1000000;}' unless defined(&EMU_CHAN_CCCA_8BITSELECT);
    eval 'sub EMU_CHAN_CCCA_CURRADDR_MASK () {0xffffff;}' unless defined(&EMU_CHAN_CCCA_CURRADDR_MASK);
    eval 'sub EMU_CHAN_CCCA_CURRADDR () { &EMU_MKSUBREG(24, 0,  &EMU_CHAN_CCCA);}' unless defined(&EMU_CHAN_CCCA_CURRADDR);
    eval 'sub EMU_CHAN_CCR () {0x9;}' unless defined(&EMU_CHAN_CCR);
    eval 'sub EMU_CHAN_CCR_CACHEINVALIDSIZE_MASK () {0xfe000000;}' unless defined(&EMU_CHAN_CCR_CACHEINVALIDSIZE_MASK);
    eval 'sub EMU_CHAN_CCR_CACHEINVALIDSIZE () { &EMU_MKSUBREG(7, 25,  &EMU_CHAN_CCR);}' unless defined(&EMU_CHAN_CCR_CACHEINVALIDSIZE);
    eval 'sub EMU_CHAN_CCR_CACHELOOPFLAG () {0x1000000;}' unless defined(&EMU_CHAN_CCR_CACHELOOPFLAG);
    eval 'sub EMU_CHAN_CCR_INTERLEAVEDSAMPLES () {0x800000;}' unless defined(&EMU_CHAN_CCR_INTERLEAVEDSAMPLES);
    eval 'sub EMU_CHAN_CCR_WORDSIZEDSAMPLES () {0x400000;}' unless defined(&EMU_CHAN_CCR_WORDSIZEDSAMPLES);
    eval 'sub EMU_CHAN_CCR_READADDRESS_MASK () {0x3f0000;}' unless defined(&EMU_CHAN_CCR_READADDRESS_MASK);
    eval 'sub EMU_CHAN_CCR_READADDRESS () { &EMU_MKSUBREG(6, 16,  &EMU_CHAN_CCR);}' unless defined(&EMU_CHAN_CCR_READADDRESS);
    eval 'sub EMU_CHAN_CCR_LOOPINVALSIZE () {0xfe00;}' unless defined(&EMU_CHAN_CCR_LOOPINVALSIZE);
    eval 'sub EMU_CHAN_CCR_LOOPFLAG () {0x100;}' unless defined(&EMU_CHAN_CCR_LOOPFLAG);
    eval 'sub EMU_CHAN_CCR_CACHELOOPADDRHI () {0xff;}' unless defined(&EMU_CHAN_CCR_CACHELOOPADDRHI);
    eval 'sub EMU_CHAN_CLP () {0xa;}' unless defined(&EMU_CHAN_CLP);
    eval 'sub EMU_CHAN_CLP_CACHELOOPADDR () {0xffff;}' unless defined(&EMU_CHAN_CLP_CACHELOOPADDR);
    eval 'sub EMU_CHAN_FXRT () {0xb;}' unless defined(&EMU_CHAN_FXRT);
    eval 'sub EMU_CHAN_FXRT_CHANNELA () {0xf0000;}' unless defined(&EMU_CHAN_FXRT_CHANNELA);
    eval 'sub EMU_CHAN_FXRT_CHANNELB () {0xf00000;}' unless defined(&EMU_CHAN_FXRT_CHANNELB);
    eval 'sub EMU_CHAN_FXRT_CHANNELC () {0xf000000;}' unless defined(&EMU_CHAN_FXRT_CHANNELC);
    eval 'sub EMU_CHAN_FXRT_CHANNELD () {0xf0000000;}' unless defined(&EMU_CHAN_FXRT_CHANNELD);
    eval 'sub EMU_CHAN_MAPA () {0xc;}' unless defined(&EMU_CHAN_MAPA);
    eval 'sub EMU_CHAN_MAPB () {0xd;}' unless defined(&EMU_CHAN_MAPB);
    eval 'sub EMU_CHAN_MAP_PTE_MASK () {0xffffe000;}' unless defined(&EMU_CHAN_MAP_PTE_MASK);
    eval 'sub EMU_CHAN_MAP_PTI_MASK () {0x1fff;}' unless defined(&EMU_CHAN_MAP_PTI_MASK);
    eval 'sub EMU_CHAN_ENVVOL () {0x10;}' unless defined(&EMU_CHAN_ENVVOL);
    eval 'sub EMU_CHAN_ENVVOL_MASK () {0xffff;}' unless defined(&EMU_CHAN_ENVVOL_MASK);
    eval 'sub EMU_CHAN_ATKHLDV () {0x11;}' unless defined(&EMU_CHAN_ATKHLDV);
    eval 'sub EMU_CHAN_ATKHLDV_PHASE0 () {0x8000;}' unless defined(&EMU_CHAN_ATKHLDV_PHASE0);
    eval 'sub EMU_CHAN_ATKHLDV_HOLDTIME_MASK () {0x7f00;}' unless defined(&EMU_CHAN_ATKHLDV_HOLDTIME_MASK);
    eval 'sub EMU_CHAN_ATKHLDV_ATTACKTIME_MASK () {0x7f;}' unless defined(&EMU_CHAN_ATKHLDV_ATTACKTIME_MASK);
    eval 'sub EMU_CHAN_DCYSUSV () {0x12;}' unless defined(&EMU_CHAN_DCYSUSV);
    eval 'sub EMU_CHAN_DCYSUSV_PHASE1_MASK () {0x8000;}' unless defined(&EMU_CHAN_DCYSUSV_PHASE1_MASK);
    eval 'sub EMU_CHAN_DCYSUSV_SUSTAINLEVEL_MASK () {0x7f00;}' unless defined(&EMU_CHAN_DCYSUSV_SUSTAINLEVEL_MASK);
    eval 'sub EMU_CHAN_DCYSUSV_CHANNELENABLE_MASK () {0x80;}' unless defined(&EMU_CHAN_DCYSUSV_CHANNELENABLE_MASK);
    eval 'sub EMU_CHAN_DCYSUSV_DECAYTIME_MASK () {0x7f;}' unless defined(&EMU_CHAN_DCYSUSV_DECAYTIME_MASK);
    eval 'sub EMU_CHAN_LFOVAL1 () {0x13;}' unless defined(&EMU_CHAN_LFOVAL1);
    eval 'sub EMU_CHAN_LFOVAL_MASK () {0xffff;}' unless defined(&EMU_CHAN_LFOVAL_MASK);
    eval 'sub EMU_CHAN_ENVVAL () {0x14;}' unless defined(&EMU_CHAN_ENVVAL);
    eval 'sub EMU_CHAN_ENVVAL_MASK () {0xffff;}' unless defined(&EMU_CHAN_ENVVAL_MASK);
    eval 'sub EMU_CHAN_ATKHLDM () {0x15;}' unless defined(&EMU_CHAN_ATKHLDM);
    eval 'sub EMU_CHAN_ATKHLDM_PHASE0 () {0x8000;}' unless defined(&EMU_CHAN_ATKHLDM_PHASE0);
    eval 'sub EMU_CHAN_ATKHLDM_HOLDTIME () {0x7f00;}' unless defined(&EMU_CHAN_ATKHLDM_HOLDTIME);
    eval 'sub EMU_CHAN_ATKHLDM_ATTACKTIME () {0x7f;}' unless defined(&EMU_CHAN_ATKHLDM_ATTACKTIME);
    eval 'sub EMU_CHAN_DCYSUSM () {0x16;}' unless defined(&EMU_CHAN_DCYSUSM);
    eval 'sub EMU_CHAN_DCYSUSM_PHASE1_MASK () {0x8000;}' unless defined(&EMU_CHAN_DCYSUSM_PHASE1_MASK);
    eval 'sub EMU_CHAN_DCYSUSM_SUSTAINLEVEL_MASK () {0x7f00;}' unless defined(&EMU_CHAN_DCYSUSM_SUSTAINLEVEL_MASK);
    eval 'sub EMU_CHAN_DCYSUSM_DECAYTIME_MASK () {0x7f;}' unless defined(&EMU_CHAN_DCYSUSM_DECAYTIME_MASK);
    eval 'sub EMU_CHAN_LFOVAL2 () {0x17;}' unless defined(&EMU_CHAN_LFOVAL2);
    eval 'sub EMU_CHAN_LFOVAL2_MASK () {0xffff;}' unless defined(&EMU_CHAN_LFOVAL2_MASK);
    eval 'sub EMU_CHAN_IP () {0x18;}' unless defined(&EMU_CHAN_IP);
    eval 'sub EMU_CHAN_IP_MASK () {0xffff;}' unless defined(&EMU_CHAN_IP_MASK);
    eval 'sub EMU_CHAN_IP_UNITY () {0xe000;}' unless defined(&EMU_CHAN_IP_UNITY);
    eval 'sub EMU_CHAN_IFATN () {0x19;}' unless defined(&EMU_CHAN_IFATN);
    eval 'sub EMU_CHAN_IFATN_FILTERCUTOFF_MASK () {0xff00;}' unless defined(&EMU_CHAN_IFATN_FILTERCUTOFF_MASK);
    eval 'sub EMU_CHAN_IFATN_FILTERCUTOFF () { &EMU_MKSUBREG(8, 8,  &EMU_CHAN_IFATN);}' unless defined(&EMU_CHAN_IFATN_FILTERCUTOFF);
    eval 'sub EMU_CHAN_IFATN_ATTENUATION_MASK () {0xff;}' unless defined(&EMU_CHAN_IFATN_ATTENUATION_MASK);
    eval 'sub EMU_CHAN_IFATN_ATTENUATION () { &EMU_MKSUBREG(8, 0,  &EMU_CHAN_IFATN);}' unless defined(&EMU_CHAN_IFATN_ATTENUATION);
    eval 'sub EMU_CHAN_PEFE () {0x1a;}' unless defined(&EMU_CHAN_PEFE);
    eval 'sub EMU_CHAN_PEFE_PITCHAMOUNT_MASK () {0xff00;}' unless defined(&EMU_CHAN_PEFE_PITCHAMOUNT_MASK);
    eval 'sub EMU_CHAN_PEFE_PITCHAMOUNT () { &EMU_MKSUBREG(8, 8,  &EMU_CHAN_PEFE);}' unless defined(&EMU_CHAN_PEFE_PITCHAMOUNT);
    eval 'sub EMU_CHAN_PEFE_FILTERAMOUNT_MASK () {0xff;}' unless defined(&EMU_CHAN_PEFE_FILTERAMOUNT_MASK);
    eval 'sub EMU_CHAN_PEFE_FILTERAMOUNT () { &EMU_MKSUBREG(8, 0,  &EMU_CHAN_PEFE);}' unless defined(&EMU_CHAN_PEFE_FILTERAMOUNT);
    eval 'sub EMU_CHAN_FMMOD () {0x1b;}' unless defined(&EMU_CHAN_FMMOD);
    eval 'sub EMU_CHAN_FMMOD_MODVIBRATO () {0xff00;}' unless defined(&EMU_CHAN_FMMOD_MODVIBRATO);
    eval 'sub EMU_CHAN_FMMOD_MOFILTER () {0xff;}' unless defined(&EMU_CHAN_FMMOD_MOFILTER);
    eval 'sub EMU_CHAN_TREMFRQ () {0x1c;}' unless defined(&EMU_CHAN_TREMFRQ);
    eval 'sub EMU_CHAN_TREMFRQ_DEPTH () {0xff00;}' unless defined(&EMU_CHAN_TREMFRQ_DEPTH);
    eval 'sub EMU_CHAN_FM2FRQ2 () {0x1d;}' unless defined(&EMU_CHAN_FM2FRQ2);
    eval 'sub EMU_CHAN_FM2FRQ2_DEPTH () {0xff00;}' unless defined(&EMU_CHAN_FM2FRQ2_DEPTH);
    eval 'sub EMU_CHAN_FM2FRQ2_FREQUENCY () {0xff;}' unless defined(&EMU_CHAN_FM2FRQ2_FREQUENCY);
    eval 'sub EMU_CHAN_TEMPENV () {0x1e;}' unless defined(&EMU_CHAN_TEMPENV);
    eval 'sub EMU_CHAN_TEMPENV_MASK () {0xffff;}' unless defined(&EMU_CHAN_TEMPENV_MASK);
    eval 'sub EMU_CHAN_CD0 () {0x20;}' unless defined(&EMU_CHAN_CD0);
    eval 'sub EMU_CHAN_CD1 () {0x21;}' unless defined(&EMU_CHAN_CD1);
    eval 'sub EMU_CHAN_CD2 () {0x22;}' unless defined(&EMU_CHAN_CD2);
    eval 'sub EMU_CHAN_CD3 () {0x23;}' unless defined(&EMU_CHAN_CD3);
    eval 'sub EMU_CHAN_CD4 () {0x24;}' unless defined(&EMU_CHAN_CD4);
    eval 'sub EMU_CHAN_CD5 () {0x25;}' unless defined(&EMU_CHAN_CD5);
    eval 'sub EMU_CHAN_CD6 () {0x26;}' unless defined(&EMU_CHAN_CD6);
    eval 'sub EMU_CHAN_CD7 () {0x27;}' unless defined(&EMU_CHAN_CD7);
    eval 'sub EMU_CHAN_CD8 () {0x28;}' unless defined(&EMU_CHAN_CD8);
    eval 'sub EMU_CHAN_CD9 () {0x29;}' unless defined(&EMU_CHAN_CD9);
    eval 'sub EMU_CHAN_CDA () {0x2a;}' unless defined(&EMU_CHAN_CDA);
    eval 'sub EMU_CHAN_CDB () {0x2b;}' unless defined(&EMU_CHAN_CDB);
    eval 'sub EMU_CHAN_CDC () {0x2c;}' unless defined(&EMU_CHAN_CDC);
    eval 'sub EMU_CHAN_CDD () {0x2d;}' unless defined(&EMU_CHAN_CDD);
    eval 'sub EMU_CHAN_CDE () {0x2e;}' unless defined(&EMU_CHAN_CDE);
    eval 'sub EMU_CHAN_CDF () {0x2f;}' unless defined(&EMU_CHAN_CDF);
    eval 'sub EMU_PTB () {0x40;}' unless defined(&EMU_PTB);
    eval 'sub EMU_PTB_MASK () {0xfffff000;}' unless defined(&EMU_PTB_MASK);
    eval 'sub EMU_TCB () {0x41;}' unless defined(&EMU_TCB);
    eval 'sub EMU_TCB_MASK () {0xfffff000;}' unless defined(&EMU_TCB_MASK);
    eval 'sub EMU_ADCCR () {0x42;}' unless defined(&EMU_ADCCR);
    eval 'sub EMU_ADCCR_RCHANENABLE () {0x10;}' unless defined(&EMU_ADCCR_RCHANENABLE);
    eval 'sub EMU_A_ADCCR_RCHANENABLE () {0x20;}' unless defined(&EMU_A_ADCCR_RCHANENABLE);
    eval 'sub EMU_ADCCR_LCHANENABLE () {0x8;}' unless defined(&EMU_ADCCR_LCHANENABLE);
    eval 'sub EMU_A_ADCCR_LCHANENABLE () {0x10;}' unless defined(&EMU_A_ADCCR_LCHANENABLE);
    eval 'sub EMU_ADCCR_SAMPLERATE_MASK () {0x7;}' unless defined(&EMU_ADCCR_SAMPLERATE_MASK);
    eval 'sub EMU_A_ADCCR_SAMPLERATE_MASK () {0xf;}' unless defined(&EMU_A_ADCCR_SAMPLERATE_MASK);
    eval 'sub EMU_ADCCR_SAMPLERATE_48 () {0x;}' unless defined(&EMU_ADCCR_SAMPLERATE_48);
    eval 'sub EMU_ADCCR_SAMPLERATE_44 () {0x1;}' unless defined(&EMU_ADCCR_SAMPLERATE_44);
    eval 'sub EMU_ADCCR_SAMPLERATE_32 () {0x2;}' unless defined(&EMU_ADCCR_SAMPLERATE_32);
    eval 'sub EMU_ADCCR_SAMPLERATE_24 () {0x3;}' unless defined(&EMU_ADCCR_SAMPLERATE_24);
    eval 'sub EMU_ADCCR_SAMPLERATE_22 () {0x4;}' unless defined(&EMU_ADCCR_SAMPLERATE_22);
    eval 'sub EMU_ADCCR_SAMPLERATE_16 () {0x5;}' unless defined(&EMU_ADCCR_SAMPLERATE_16);
    eval 'sub EMU_A_ADCCR_SAMPLERATE_12 () {0x6;}' unless defined(&EMU_A_ADCCR_SAMPLERATE_12);
    eval 'sub EMU_ADCCR_SAMPLERATE_11 () {0x6;}' unless defined(&EMU_ADCCR_SAMPLERATE_11);
    eval 'sub EMU_A_ADCCR_SAMPLERATE_11 () {0x7;}' unless defined(&EMU_A_ADCCR_SAMPLERATE_11);
    eval 'sub EMU_ADCCR_SAMPLERATE_8 () {0x7;}' unless defined(&EMU_ADCCR_SAMPLERATE_8);
    eval 'sub EMU_A_ADCCR_SAMPLERATE_8 () {0x8;}' unless defined(&EMU_A_ADCCR_SAMPLERATE_8);
    eval 'sub EMU_FXWC () {0x43;}' unless defined(&EMU_FXWC);
    eval 'sub EMU_TCBS () {0x44;}' unless defined(&EMU_TCBS);
    eval 'sub EMU_TCBS_MASK () {0x7;}' unless defined(&EMU_TCBS_MASK);
    eval 'sub EMU_TCBS_BUFFSIZE_16K () {0x;}' unless defined(&EMU_TCBS_BUFFSIZE_16K);
    eval 'sub EMU_TCBS_BUFFSIZE_32K () {0x1;}' unless defined(&EMU_TCBS_BUFFSIZE_32K);
    eval 'sub EMU_TCBS_BUFFSIZE_64K () {0x2;}' unless defined(&EMU_TCBS_BUFFSIZE_64K);
    eval 'sub EMU_TCBS_BUFFSIZE_128K () {0x3;}' unless defined(&EMU_TCBS_BUFFSIZE_128K);
    eval 'sub EMU_TCBS_BUFFSIZE_256K () {0x4;}' unless defined(&EMU_TCBS_BUFFSIZE_256K);
    eval 'sub EMU_TCBS_BUFFSIZE_512K () {0x5;}' unless defined(&EMU_TCBS_BUFFSIZE_512K);
    eval 'sub EMU_TCBS_BUFFSIZE_1024K () {0x6;}' unless defined(&EMU_TCBS_BUFFSIZE_1024K);
    eval 'sub EMU_TCBS_BUFFSIZE_2048K () {0x7;}' unless defined(&EMU_TCBS_BUFFSIZE_2048K);
    eval 'sub EMU_MICBA () {0x45;}' unless defined(&EMU_MICBA);
    eval 'sub EMU_ADCBA () {0x46;}' unless defined(&EMU_ADCBA);
    eval 'sub EMU_FXBA () {0x47;}' unless defined(&EMU_FXBA);
    eval 'sub EMU_RECBA_MASK () {0xfffff000;}' unless defined(&EMU_RECBA_MASK);
    eval 'sub EMU_MICBS () {0x49;}' unless defined(&EMU_MICBS);
    eval 'sub EMU_ADCBS () {0x4a;}' unless defined(&EMU_ADCBS);
    eval 'sub EMU_FXBS () {0x4b;}' unless defined(&EMU_FXBS);
    eval 'sub EMU_RECBS_BUFSIZE_NONE () {0x;}' unless defined(&EMU_RECBS_BUFSIZE_NONE);
    eval 'sub EMU_RECBS_BUFSIZE_384 () {0x1;}' unless defined(&EMU_RECBS_BUFSIZE_384);
    eval 'sub EMU_RECBS_BUFSIZE_448 () {0x2;}' unless defined(&EMU_RECBS_BUFSIZE_448);
    eval 'sub EMU_RECBS_BUFSIZE_512 () {0x3;}' unless defined(&EMU_RECBS_BUFSIZE_512);
    eval 'sub EMU_RECBS_BUFSIZE_640 () {0x4;}' unless defined(&EMU_RECBS_BUFSIZE_640);
    eval 'sub EMU_RECBS_BUFSIZE_768 () {0x5;}' unless defined(&EMU_RECBS_BUFSIZE_768);
    eval 'sub EMU_RECBS_BUFSIZE_896 () {0x6;}' unless defined(&EMU_RECBS_BUFSIZE_896);
    eval 'sub EMU_RECBS_BUFSIZE_1024 () {0x7;}' unless defined(&EMU_RECBS_BUFSIZE_1024);
    eval 'sub EMU_RECBS_BUFSIZE_1280 () {0x8;}' unless defined(&EMU_RECBS_BUFSIZE_1280);
    eval 'sub EMU_RECBS_BUFSIZE_1536 () {0x9;}' unless defined(&EMU_RECBS_BUFSIZE_1536);
    eval 'sub EMU_RECBS_BUFSIZE_1792 () {0xa;}' unless defined(&EMU_RECBS_BUFSIZE_1792);
    eval 'sub EMU_RECBS_BUFSIZE_2048 () {0xb;}' unless defined(&EMU_RECBS_BUFSIZE_2048);
    eval 'sub EMU_RECBS_BUFSIZE_2560 () {0xc;}' unless defined(&EMU_RECBS_BUFSIZE_2560);
    eval 'sub EMU_RECBS_BUFSIZE_3072 () {0xd;}' unless defined(&EMU_RECBS_BUFSIZE_3072);
    eval 'sub EMU_RECBS_BUFSIZE_3584 () {0xe;}' unless defined(&EMU_RECBS_BUFSIZE_3584);
    eval 'sub EMU_RECBS_BUFSIZE_4096 () {0xf;}' unless defined(&EMU_RECBS_BUFSIZE_4096);
    eval 'sub EMU_RECBS_BUFSIZE_5120 () {0x10;}' unless defined(&EMU_RECBS_BUFSIZE_5120);
    eval 'sub EMU_RECBS_BUFSIZE_6144 () {0x11;}' unless defined(&EMU_RECBS_BUFSIZE_6144);
    eval 'sub EMU_RECBS_BUFSIZE_7168 () {0x12;}' unless defined(&EMU_RECBS_BUFSIZE_7168);
    eval 'sub EMU_RECBS_BUFSIZE_8192 () {0x13;}' unless defined(&EMU_RECBS_BUFSIZE_8192);
    eval 'sub EMU_RECBS_BUFSIZE_10240 () {0x14;}' unless defined(&EMU_RECBS_BUFSIZE_10240);
    eval 'sub EMU_RECBS_BUFSIZE_12288 () {0x15;}' unless defined(&EMU_RECBS_BUFSIZE_12288);
    eval 'sub EMU_RECBS_BUFSIZE_14366 () {0x16;}' unless defined(&EMU_RECBS_BUFSIZE_14366);
    eval 'sub EMU_RECBS_BUFSIZE_16384 () {0x17;}' unless defined(&EMU_RECBS_BUFSIZE_16384);
    eval 'sub EMU_RECBS_BUFSIZE_20480 () {0x18;}' unless defined(&EMU_RECBS_BUFSIZE_20480);
    eval 'sub EMU_RECBS_BUFSIZE_24576 () {0x19;}' unless defined(&EMU_RECBS_BUFSIZE_24576);
    eval 'sub EMU_RECBS_BUFSIZE_28672 () {0x1a;}' unless defined(&EMU_RECBS_BUFSIZE_28672);
    eval 'sub EMU_RECBS_BUFSIZE_32768 () {0x1b;}' unless defined(&EMU_RECBS_BUFSIZE_32768);
    eval 'sub EMU_RECBS_BUFSIZE_40960 () {0x1c;}' unless defined(&EMU_RECBS_BUFSIZE_40960);
    eval 'sub EMU_RECBS_BUFSIZE_49152 () {0x1d;}' unless defined(&EMU_RECBS_BUFSIZE_49152);
    eval 'sub EMU_RECBS_BUFSIZE_57344 () {0x1e;}' unless defined(&EMU_RECBS_BUFSIZE_57344);
    eval 'sub EMU_RECBS_BUFSIZE_65536 () {0x1f;}' unless defined(&EMU_RECBS_BUFSIZE_65536);
    eval 'sub EMU_CDCS () {0x50;}' unless defined(&EMU_CDCS);
    eval 'sub EMU_GPSCS () {0x51;}' unless defined(&EMU_GPSCS);
    eval 'sub EMU_DBG () {0x52;}' unless defined(&EMU_DBG);
    eval 'sub EMU_DBG_ZC () {0x80000000;}' unless defined(&EMU_DBG_ZC);
    eval 'sub EMU_DBG_SATURATION_OCCURED () {0x2000000;}' unless defined(&EMU_DBG_SATURATION_OCCURED);
    eval 'sub EMU_DBG_SATURATION_ADDR () {0x1ff0000;}' unless defined(&EMU_DBG_SATURATION_ADDR);
    eval 'sub EMU_DBG_SINGLE_STEP () {0x8000;}' unless defined(&EMU_DBG_SINGLE_STEP);
    eval 'sub EMU_DBG_STEP () {0x4000;}' unless defined(&EMU_DBG_STEP);
    eval 'sub EMU_DBG_CONDITION_CODE () {0x3e00;}' unless defined(&EMU_DBG_CONDITION_CODE);
    eval 'sub EMU_DBG_SINGLE_STEP_ADDR () {0x1ff;}' unless defined(&EMU_DBG_SINGLE_STEP_ADDR);
    eval 'sub EMU_A_DBG () {0x53;}' unless defined(&EMU_A_DBG);
    eval 'sub EMU_A_DBG_SINGLE_STEP () {0x20000;}' unless defined(&EMU_A_DBG_SINGLE_STEP);
    eval 'sub EMU_A_DBG_ZC () {0x40000000;}' unless defined(&EMU_A_DBG_ZC);
    eval 'sub EMU_A_DBG_STEP_ADDR () {0x3ff;}' unless defined(&EMU_A_DBG_STEP_ADDR);
    eval 'sub EMU_A_DBG_SATURATION_OCCRD () {0x20000000;}' unless defined(&EMU_A_DBG_SATURATION_OCCRD);
    eval 'sub EMU_A_DBG_SATURATION_ADDR () {0xffc0000;}' unless defined(&EMU_A_DBG_SATURATION_ADDR);
    eval 'sub EMU_SPCS0 () {0x54;}' unless defined(&EMU_SPCS0);
    eval 'sub EMU_SPCS1 () {0x55;}' unless defined(&EMU_SPCS1);
    eval 'sub EMU_SPCS2 () {0x56;}' unless defined(&EMU_SPCS2);
    eval 'sub EMU_SPCS_CLKACCYMASK () {0x30000000;}' unless defined(&EMU_SPCS_CLKACCYMASK);
    eval 'sub EMU_SPCS_CLKACCY_1000PPM () {0x;}' unless defined(&EMU_SPCS_CLKACCY_1000PPM);
    eval 'sub EMU_SPCS_CLKACCY_50PPM () {0x10000000;}' unless defined(&EMU_SPCS_CLKACCY_50PPM);
    eval 'sub EMU_SPCS_CLKACCY_VARIABLE () {0x20000000;}' unless defined(&EMU_SPCS_CLKACCY_VARIABLE);
    eval 'sub EMU_SPCS_SAMPLERATEMASK () {0xf000000;}' unless defined(&EMU_SPCS_SAMPLERATEMASK);
    eval 'sub EMU_SPCS_SAMPLERATE_44 () {0x;}' unless defined(&EMU_SPCS_SAMPLERATE_44);
    eval 'sub EMU_SPCS_SAMPLERATE_48 () {0x2000000;}' unless defined(&EMU_SPCS_SAMPLERATE_48);
    eval 'sub EMU_SPCS_SAMPLERATE_32 () {0x3000000;}' unless defined(&EMU_SPCS_SAMPLERATE_32);
    eval 'sub EMU_SPCS_CHANNELNUMMASK () {0xf00000;}' unless defined(&EMU_SPCS_CHANNELNUMMASK);
    eval 'sub EMU_SPCS_CHANNELNUM_UNSPEC () {0x;}' unless defined(&EMU_SPCS_CHANNELNUM_UNSPEC);
    eval 'sub EMU_SPCS_CHANNELNUM_LEFT () {0x100000;}' unless defined(&EMU_SPCS_CHANNELNUM_LEFT);
    eval 'sub EMU_SPCS_CHANNELNUM_RIGHT () {0x200000;}' unless defined(&EMU_SPCS_CHANNELNUM_RIGHT);
    eval 'sub EMU_SPCS_SOURCENUMMASK () {0xf0000;}' unless defined(&EMU_SPCS_SOURCENUMMASK);
    eval 'sub EMU_SPCS_SOURCENUM_UNSPEC () {0x;}' unless defined(&EMU_SPCS_SOURCENUM_UNSPEC);
    eval 'sub EMU_SPCS_GENERATIONSTATUS () {0x8000;}' unless defined(&EMU_SPCS_GENERATIONSTATUS);
    eval 'sub EMU_SPCS_CATEGORYCODEMASK () {0x7f00;}' unless defined(&EMU_SPCS_CATEGORYCODEMASK);
    eval 'sub EMU_SPCS_MODEMASK () {0xc0;}' unless defined(&EMU_SPCS_MODEMASK);
    eval 'sub EMU_SPCS_EMPHASISMASK () {0x38;}' unless defined(&EMU_SPCS_EMPHASISMASK);
    eval 'sub EMU_SPCS_EMPHASIS_NONE () {0x;}' unless defined(&EMU_SPCS_EMPHASIS_NONE);
    eval 'sub EMU_SPCS_EMPHASIS_50_15 () {0x8;}' unless defined(&EMU_SPCS_EMPHASIS_50_15);
    eval 'sub EMU_SPCS_COPYRIGHT () {0x4;}' unless defined(&EMU_SPCS_COPYRIGHT);
    eval 'sub EMU_SPCS_NOTAUDIODATA () {0x2;}' unless defined(&EMU_SPCS_NOTAUDIODATA);
    eval 'sub EMU_SPCS_PROFESSIONAL () {0x1;}' unless defined(&EMU_SPCS_PROFESSIONAL);
    eval 'sub EMU_CLIEL () {0x58;}' unless defined(&EMU_CLIEL);
    eval 'sub EMU_CLIEH () {0x59;}' unless defined(&EMU_CLIEH);
    eval 'sub EMU_CLIPL () {0x5a;}' unless defined(&EMU_CLIPL);
    eval 'sub EMU_CLIPH () {0x5b;}' unless defined(&EMU_CLIPH);
    eval 'sub EMU_SOLEL () {0x5c;}' unless defined(&EMU_SOLEL);
    eval 'sub EMU_SOLEH () {0x5d;}' unless defined(&EMU_SOLEH);
    eval 'sub EMU_SPBYPASS () {0x5e;}' unless defined(&EMU_SPBYPASS);
    eval 'sub EMU_SPBYPASS_ENABLE () {0x1;}' unless defined(&EMU_SPBYPASS_ENABLE);
    eval 'sub EMU_SPBYPASS_24_BITS () {0xf00;}' unless defined(&EMU_SPBYPASS_24_BITS);
    eval 'sub EMU_AC97SLOT () {0x5f;}' unless defined(&EMU_AC97SLOT);
    eval 'sub EMU_AC97SLOT_CENTER () {0x10;}' unless defined(&EMU_AC97SLOT_CENTER);
    eval 'sub EMU_AC97SLOT_LFE () {0x20;}' unless defined(&EMU_AC97SLOT_LFE);
    eval 'sub EMU_CDSRCS () {0x60;}' unless defined(&EMU_CDSRCS);
    eval 'sub EMU_GPSRCS () {0x61;}' unless defined(&EMU_GPSRCS);
    eval 'sub EMU_ZVSRCS () {0x62;}' unless defined(&EMU_ZVSRCS);
    eval 'sub EMU_SRCS_SPDIFLOCKED () {0x2000000;}' unless defined(&EMU_SRCS_SPDIFLOCKED);
    eval 'sub EMU_SRCS_RATELOCKED () {0x1000000;}' unless defined(&EMU_SRCS_RATELOCKED);
    eval 'sub EMU_SRCS_ESTSAMPLERATE () {0x7ffff;}' unless defined(&EMU_SRCS_ESTSAMPLERATE);
    eval 'sub EMU_MICIDX () {0x63;}' unless defined(&EMU_MICIDX);
    eval 'sub EMU_A_MICIDX () {0x64;}' unless defined(&EMU_A_MICIDX);
    eval 'sub EMU_ADCIDX () {0x64;}' unless defined(&EMU_ADCIDX);
    eval 'sub EMU_A_ADCIDX () {0x63;}' unless defined(&EMU_A_ADCIDX);
    eval 'sub EMU_FXIDX () {0x65;}' unless defined(&EMU_FXIDX);
    eval 'sub EMU_RECIDX_MASK () {0xffff;}' unless defined(&EMU_RECIDX_MASK);
    eval 'sub EMU_RECIDX {
        local($idxreg) = @_;
	    eval q((0x10000000|($idxreg)));
    }' unless defined(&EMU_RECIDX);
    eval 'sub EMU_A_MUDATA1 () {0x70;}' unless defined(&EMU_A_MUDATA1);
    eval 'sub EMU_A_MUCMD1 () {0x71;}' unless defined(&EMU_A_MUCMD1);
    eval 'sub EMU_A_MUSTAT1 () { &EMU_A_MUCMD1;}' unless defined(&EMU_A_MUSTAT1);
    eval 'sub EMU_A_MUDATA2 () {0x72;}' unless defined(&EMU_A_MUDATA2);
    eval 'sub EMU_A_MUCMD2 () {0x73;}' unless defined(&EMU_A_MUCMD2);
    eval 'sub EMU_A_MUSTAT2 () { &EMU_A_MUCMD2;}' unless defined(&EMU_A_MUSTAT2);
    eval 'sub EMU_A_FXWC1 () {0x74;}' unless defined(&EMU_A_FXWC1);
    eval 'sub EMU_A_FXWC2 () {0x75;}' unless defined(&EMU_A_FXWC2);
    eval 'sub EMU_A_SPDIF_SAMPLERATE () {0x76;}' unless defined(&EMU_A_SPDIF_SAMPLERATE);
    eval 'sub EMU_A_SPDIF_48000 () {0x80;}' unless defined(&EMU_A_SPDIF_48000);
    eval 'sub EMU_A_SPDIF_44100 () {0x;}' unless defined(&EMU_A_SPDIF_44100);
    eval 'sub EMU_A_SPDIF_96000 () {0x40;}' unless defined(&EMU_A_SPDIF_96000);
    eval 'sub EMU_A2_SPDIF_SAMPLERATE () { &EMU_MKSUBREG(3, 9,  &EMU_A_SPDIF_SAMPLERATE);}' unless defined(&EMU_A2_SPDIF_SAMPLERATE);
    eval 'sub EMU_A2_SPDIF_MASK () {0xe00;}' unless defined(&EMU_A2_SPDIF_MASK);
    eval 'sub EMU_A2_SPDIF_UNKNOWN () {0x2;}' unless defined(&EMU_A2_SPDIF_UNKNOWN);
    eval 'sub EMU_A_CHAN_FXRT2 () {0x7c;}' unless defined(&EMU_A_CHAN_FXRT2);
    eval 'sub EMU_A_CHAN_FXRT_CHANNELE () {0x3f;}' unless defined(&EMU_A_CHAN_FXRT_CHANNELE);
    eval 'sub EMU_A_CHAN_FXRT_CHANNELF () {0x3f00;}' unless defined(&EMU_A_CHAN_FXRT_CHANNELF);
    eval 'sub EMU_A_CHAN_FXRT_CHANNELG () {0x3f0000;}' unless defined(&EMU_A_CHAN_FXRT_CHANNELG);
    eval 'sub EMU_A_CHAN_FXRT_CHANNELH () {0x3f000000;}' unless defined(&EMU_A_CHAN_FXRT_CHANNELH);
    eval 'sub EMU_A_CHAN_SENDAMOUNTS () {0x7d;}' unless defined(&EMU_A_CHAN_SENDAMOUNTS);
    eval 'sub EMU_A_CHAN_FXSENDAMOUNTS_E_MASK () {0xff000000;}' unless defined(&EMU_A_CHAN_FXSENDAMOUNTS_E_MASK);
    eval 'sub EMU_A_CHAN_FXSENDAMOUNTS_F_MASK () {0xff0000;}' unless defined(&EMU_A_CHAN_FXSENDAMOUNTS_F_MASK);
    eval 'sub EMU_A_CHAN_FXSENDAMOUNTS_G_MASK () {0xff00;}' unless defined(&EMU_A_CHAN_FXSENDAMOUNTS_G_MASK);
    eval 'sub EMU_A_CHAN_FXSENDAMOUNTS_H_MASK () {0xff;}' unless defined(&EMU_A_CHAN_FXSENDAMOUNTS_H_MASK);
    eval 'sub EMU_A_CHAN_FXRT1 () {0x7e;}' unless defined(&EMU_A_CHAN_FXRT1);
    eval 'sub EMU_A_CHAN_FXRT_CHANNELA () {0x3f;}' unless defined(&EMU_A_CHAN_FXRT_CHANNELA);
    eval 'sub EMU_A_CHAN_FXRT_CHANNELB () {0x3f00;}' unless defined(&EMU_A_CHAN_FXRT_CHANNELB);
    eval 'sub EMU_A_CHAN_FXRT_CHANNELC () {0x3f0000;}' unless defined(&EMU_A_CHAN_FXRT_CHANNELC);
    eval 'sub EMU_A_CHAN_FXRT_CHANNELD () {0x3f000000;}' unless defined(&EMU_A_CHAN_FXRT_CHANNELD);
    eval 'sub EMU_FXGPREGBASE () {0x100;}' unless defined(&EMU_FXGPREGBASE);
    eval 'sub EMU_A_FXGPREGBASE () {0x400;}' unless defined(&EMU_A_FXGPREGBASE);
    eval 'sub EMU_TANKMEMDATAREGBASE () {0x200;}' unless defined(&EMU_TANKMEMDATAREGBASE);
    eval 'sub EMU_TANKMEMDATAREG_MASK () {0xfffff;}' unless defined(&EMU_TANKMEMDATAREG_MASK);
    eval 'sub EMU_TANKMEMADDRREGBASE () {0x300;}' unless defined(&EMU_TANKMEMADDRREGBASE);
    eval 'sub EMU_TANKMEMADDRREG_ADDR_MASK () {0xfffff;}' unless defined(&EMU_TANKMEMADDRREG_ADDR_MASK);
    eval 'sub EMU_TANKMEMADDRREG_CLEAR () {0x800000;}' unless defined(&EMU_TANKMEMADDRREG_CLEAR);
    eval 'sub EMU_TANKMEMADDRREG_ALIGN () {0x400000;}' unless defined(&EMU_TANKMEMADDRREG_ALIGN);
    eval 'sub EMU_TANKMEMADDRREG_WRITE () {0x200000;}' unless defined(&EMU_TANKMEMADDRREG_WRITE);
    eval 'sub EMU_TANKMEMADDRREG_READ () {0x100000;}' unless defined(&EMU_TANKMEMADDRREG_READ);
    eval 'sub EMU_MICROCODEBASE () {0x400;}' unless defined(&EMU_MICROCODEBASE);
    eval 'sub EMU_A_MICROCODEBASE () {0x600;}' unless defined(&EMU_A_MICROCODEBASE);
    eval 'sub EMU_DSP_LOWORD_OPX_MASK () {0xffc00;}' unless defined(&EMU_DSP_LOWORD_OPX_MASK);
    eval 'sub EMU_DSP_LOWORD_OPY_MASK () {0x3ff;}' unless defined(&EMU_DSP_LOWORD_OPY_MASK);
    eval 'sub EMU_DSP_HIWORD_OPCODE_MASK () {0xf00000;}' unless defined(&EMU_DSP_HIWORD_OPCODE_MASK);
    eval 'sub EMU_DSP_HIWORD_RESULT_MASK () {0xffc00;}' unless defined(&EMU_DSP_HIWORD_RESULT_MASK);
    eval 'sub EMU_DSP_HIWORD_OPA_MASK () {0x3ff;}' unless defined(&EMU_DSP_HIWORD_OPA_MASK);
    eval 'sub EMU_A_DSP_LOWORD_OPX_MASK () {0x7ff000;}' unless defined(&EMU_A_DSP_LOWORD_OPX_MASK);
    eval 'sub EMU_A_DSP_LOWORD_OPY_MASK () {0x7ff;}' unless defined(&EMU_A_DSP_LOWORD_OPY_MASK);
    eval 'sub EMU_A_DSP_HIWORD_OPCODE_MASK () {0xf000000;}' unless defined(&EMU_A_DSP_HIWORD_OPCODE_MASK);
    eval 'sub EMU_A_DSP_HIWORD_RESULT_MASK () {0x7ff000;}' unless defined(&EMU_A_DSP_HIWORD_RESULT_MASK);
    eval 'sub EMU_A_DSP_HIWORD_OPA_MASK () {0x7ff;}' unless defined(&EMU_A_DSP_HIWORD_OPA_MASK);
    eval 'sub EMU_DSP_OP_MACS () {0x;}' unless defined(&EMU_DSP_OP_MACS);
    eval 'sub EMU_DSP_OP_MACS1 () {0x1;}' unless defined(&EMU_DSP_OP_MACS1);
    eval 'sub EMU_DSP_OP_MACW () {0x2;}' unless defined(&EMU_DSP_OP_MACW);
    eval 'sub EMU_DSP_OP_MACW1 () {0x3;}' unless defined(&EMU_DSP_OP_MACW1);
    eval 'sub EMU_DSP_OP_MACINTS () {0x4;}' unless defined(&EMU_DSP_OP_MACINTS);
    eval 'sub EMU_DSP_OP_MACINTW () {0x5;}' unless defined(&EMU_DSP_OP_MACINTW);
    eval 'sub EMU_DSP_OP_ACC3 () {0x6;}' unless defined(&EMU_DSP_OP_ACC3);
    eval 'sub EMU_DSP_OP_MACMV () {0x7;}' unless defined(&EMU_DSP_OP_MACMV);
    eval 'sub EMU_DSP_OP_ANDXOR () {0x8;}' unless defined(&EMU_DSP_OP_ANDXOR);
    eval 'sub EMU_DSP_OP_TSTNEG () {0x9;}' unless defined(&EMU_DSP_OP_TSTNEG);
    eval 'sub EMU_DSP_OP_LIMIT () {0xa;}' unless defined(&EMU_DSP_OP_LIMIT);
    eval 'sub EMU_DSP_OP_LIMIT1 () {0xb;}' unless defined(&EMU_DSP_OP_LIMIT1);
    eval 'sub EMU_DSP_OP_LOG () {0xc;}' unless defined(&EMU_DSP_OP_LOG);
    eval 'sub EMU_DSP_OP_EXP () {0xd;}' unless defined(&EMU_DSP_OP_EXP);
    eval 'sub EMU_DSP_OP_INTERP () {0xe;}' unless defined(&EMU_DSP_OP_INTERP);
    eval 'sub EMU_DSP_OP_SKIP () {0xf;}' unless defined(&EMU_DSP_OP_SKIP);
    eval 'sub EMU_DSP_FX {
        local($num) = @_;
	    eval q(($num));
    }' unless defined(&EMU_DSP_FX);
    eval 'sub EMU_DSP_IOL {
        local($base, $num) = @_;
	    eval q(($base + ($num << 1)));
    }' unless defined(&EMU_DSP_IOL);
    eval 'sub EMU_DSP_IOR {
        local($base, $num) = @_;
	    eval q(( &EMU_DSP_IOL($base, $num) + 1));
    }' unless defined(&EMU_DSP_IOR);
    eval 'sub EMU_DSP_INL_BASE () {0x10;}' unless defined(&EMU_DSP_INL_BASE);
    eval 'sub EMU_DSP_INL {
        local($num) = @_;
	    eval q(( &EMU_DSP_IOL( &EMU_DSP_INL_BASE, $num)));
    }' unless defined(&EMU_DSP_INL);
    eval 'sub EMU_DSP_INR {
        local($num) = @_;
	    eval q(( &EMU_DSP_IOR( &EMU_DSP_INL_BASE, $num)));
    }' unless defined(&EMU_DSP_INR);
    eval 'sub EMU_A_DSP_INL_BASE () {0x40;}' unless defined(&EMU_A_DSP_INL_BASE);
    eval 'sub EMU_A_DSP_INL {
        local($num) = @_;
	    eval q(( &EMU_DSP_IOL( &EMU_A_DSP_INL_BASE, $num)));
    }' unless defined(&EMU_A_DSP_INL);
    eval 'sub EMU_A_DSP_INR {
        local($num) = @_;
	    eval q(( &EMU_DSP_IOR( &EMU_A_DSP_INL_BASE, $num)));
    }' unless defined(&EMU_A_DSP_INR);
    eval 'sub EMU_DSP_IN_AC97 () {0;}' unless defined(&EMU_DSP_IN_AC97);
    eval 'sub EMU_DSP_IN_CDSPDIF () {1;}' unless defined(&EMU_DSP_IN_CDSPDIF);
    eval 'sub EMU_DSP_IN_ZOOM () {2;}' unless defined(&EMU_DSP_IN_ZOOM);
    eval 'sub EMU_DSP_IN_TOSOPT () {3;}' unless defined(&EMU_DSP_IN_TOSOPT);
    eval 'sub EMU_DSP_IN_LVDLM1 () {4;}' unless defined(&EMU_DSP_IN_LVDLM1);
    eval 'sub EMU_DSP_IN_LVDCOS () {5;}' unless defined(&EMU_DSP_IN_LVDCOS);
    eval 'sub EMU_DSP_IN_LVDLM2 () {6;}' unless defined(&EMU_DSP_IN_LVDLM2);
    eval 'sub EMU_DSP_IN_UNKNOWN () {7;}' unless defined(&EMU_DSP_IN_UNKNOWN);
    eval 'sub EMU_DSP_OUTL_BASE () {0x20;}' unless defined(&EMU_DSP_OUTL_BASE);
    eval 'sub EMU_DSP_OUTL {
        local($num) = @_;
	    eval q(( &EMU_DSP_IOL( &EMU_DSP_OUTL_BASE, $num)));
    }' unless defined(&EMU_DSP_OUTL);
    eval 'sub EMU_DSP_OUTR {
        local($num) = @_;
	    eval q(( &EMU_DSP_IOR( &EMU_DSP_OUTL_BASE, $num)));
    }' unless defined(&EMU_DSP_OUTR);
    eval 'sub EMU_DSP_OUT_A_FRONT () {0;}' unless defined(&EMU_DSP_OUT_A_FRONT);
    eval 'sub EMU_DSP_OUT_D_FRONT () {1;}' unless defined(&EMU_DSP_OUT_D_FRONT);
    eval 'sub EMU_DSP_OUT_D_CENTER () {2;}' unless defined(&EMU_DSP_OUT_D_CENTER);
    eval 'sub EMU_DSP_OUT_DRIVE_HP () {3;}' unless defined(&EMU_DSP_OUT_DRIVE_HP);
    eval 'sub EMU_DSP_OUT_AD_REAR () {4;}' unless defined(&EMU_DSP_OUT_AD_REAR);
    eval 'sub EMU_DSP_OUT_ADC () {5;}' unless defined(&EMU_DSP_OUT_ADC);
    eval 'sub EMU_DSP_OUTL_MIC () {6;}' unless defined(&EMU_DSP_OUTL_MIC);
    eval 'sub EMU_A_DSP_OUTL_BASE () {0x60;}' unless defined(&EMU_A_DSP_OUTL_BASE);
    eval 'sub EMU_A_DSP_OUTL {
        local($num) = @_;
	    eval q(( &EMU_DSP_IOL( &EMU_A_DSP_OUTL_BASE, $num)));
    }' unless defined(&EMU_A_DSP_OUTL);
    eval 'sub EMU_A_DSP_OUTR {
        local($num) = @_;
	    eval q(( &EMU_DSP_IOR( &EMU_A_DSP_OUTL_BASE, $num)));
    }' unless defined(&EMU_A_DSP_OUTR);
    eval 'sub EMU_A_DSP_OUT_D_FRONT () {0;}' unless defined(&EMU_A_DSP_OUT_D_FRONT);
    eval 'sub EMU_A_DSP_OUT_D_CENTER () {1;}' unless defined(&EMU_A_DSP_OUT_D_CENTER);
    eval 'sub EMU_A_DSP_OUT_DRIVE_HP () {2;}' unless defined(&EMU_A_DSP_OUT_DRIVE_HP);
    eval 'sub EMU_A_DSP_OUT_DREAR () {3;}' unless defined(&EMU_A_DSP_OUT_DREAR);
    eval 'sub EMU_A_DSP_OUT_A_FRONT () {4;}' unless defined(&EMU_A_DSP_OUT_A_FRONT);
    eval 'sub EMU_A_DSP_OUT_A_CENTER () {5;}' unless defined(&EMU_A_DSP_OUT_A_CENTER);
    eval 'sub EMU_A_DSP_OUT_A_REAR () {7;}' unless defined(&EMU_A_DSP_OUT_A_REAR);
    eval 'sub EMU_A_DSP_OUT_ADC () {11;}' unless defined(&EMU_A_DSP_OUT_ADC);
    eval 'sub EMU_DSP_CST_BASE () {0x40;}' unless defined(&EMU_DSP_CST_BASE);
    eval 'sub EMU_A_DSP_CST_BASE () {0xc0;}' unless defined(&EMU_A_DSP_CST_BASE);
    eval 'sub EMU_DSP_CST {
        local($num) = @_;
	    eval q(( &EMU_DSP_CST_BASE + $num));
    }' unless defined(&EMU_DSP_CST);
    eval 'sub EMU_A_DSP_CST {
        local($num) = @_;
	    eval q(( &EMU_A_DSP_CST_BASE + $num));
    }' unless defined(&EMU_A_DSP_CST);
    eval 'sub EMU_DSP_HWR_ACC () {0x56;}' unless defined(&EMU_DSP_HWR_ACC);
    eval 'sub EMU_DSP_HWR_CCR () {0x57;}' unless defined(&EMU_DSP_HWR_CCR);
    eval 'sub EMU_DSP_HWR_CCR_S () {0x4;}' unless defined(&EMU_DSP_HWR_CCR_S);
    eval 'sub EMU_DSP_HWR_CCR_Z () {0x3;}' unless defined(&EMU_DSP_HWR_CCR_Z);
    eval 'sub EMU_DSP_HWR_CCR_M () {0x2;}' unless defined(&EMU_DSP_HWR_CCR_M);
    eval 'sub EMU_DSP_HWR_CCR_N () {0x1;}' unless defined(&EMU_DSP_HWR_CCR_N);
    eval 'sub EMU_DSP_HWR_CCR_B () {0x;}' unless defined(&EMU_DSP_HWR_CCR_B);
    eval 'sub EMU_DSP_HWR_NOISE0 () {0x58;}' unless defined(&EMU_DSP_HWR_NOISE0);
    eval 'sub EMU_DSP_HWR_NOISE1 () {0x59;}' unless defined(&EMU_DSP_HWR_NOISE1);
    eval 'sub EMU_DSP_HWR_INTR () {0x5a;}' unless defined(&EMU_DSP_HWR_INTR);
    eval 'sub EMU_DSP_HWR_DBAC () {0x5b;}' unless defined(&EMU_DSP_HWR_DBAC);
    eval 'sub EMU_DSP_GPR {
        local($num) = @_;
	    eval q(( &EMU_FXGPREGBASE + $num));
    }' unless defined(&EMU_DSP_GPR);
    eval 'sub EMU_A_DSP_GPR {
        local($num) = @_;
	    eval q(( &EMU_A_FXGPREGBASE + $num));
    }' unless defined(&EMU_A_DSP_GPR);
}
1;
