require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AMD64_CPUFUNC_H_)) {
    eval 'sub _AMD64_CPUFUNC_H_ () {1;}' unless defined(&_AMD64_CPUFUNC_H_);
    require 'sys/cdefs.ph';
    require 'sys/types.ph';
    require 'machine/specialreg.ph';
    eval 'sub invlpg {
        local($addr) = @_;
	    eval q({  &__asm  &__volatile(\\"invlpg (%0)\\" : : \\"r\\" ($addr) : \\"memory\\"); } );
    }' unless defined(&invlpg);
    eval 'sub lidt {
        local($p) = @_;
	    eval q({  &__asm  &__volatile(\\"lidt (%0)\\" : : \\"r\\" ($p)); });
    }' unless defined(&lidt);
    eval 'sub lldt {
        local($sel) = @_;
	    eval q({  &__asm  &__volatile(\\"lldt %0\\" : : \\"r\\" ($sel)); });
    }' unless defined(&lldt);
    eval 'sub ltr {
        local($sel) = @_;
	    eval q({  &__asm  &__volatile(\\"ltr %0\\" : : \\"r\\" ($sel)); });
    }' unless defined(&ltr);
    eval 'sub lcr8 {
        local($val) = @_;
	    eval q({  &u_int64_t  &val64 = $val;  &__asm  &__volatile(\\"movq %0,%%cr8\\" : : \\"r\\" ( &val64)); });
    }' unless defined(&lcr8);
    eval 'sub rcr0 {
        local($void) = @_;
	    eval q({  &u_int64_t  &val64; \'u_int\'  &val;  &__asm  &__volatile(\\"movq %%cr0,%0\\" : \\"=r\\" ( &val64));  &val =  &val64;  &val; });
    }' unless defined(&rcr0);
    eval 'sub rcr2 {
        local($void) = @_;
	    eval q({  &u_int64_t  &val;  &__asm  &__volatile(\\"movq %%cr2,%0\\" : \\"=r\\" ( &val));  &val; });
    }' unless defined(&rcr2);
    eval 'sub lcr3 {
        local($val) = @_;
	    eval q({  &__asm  &__volatile(\\"movq %0,%%cr3\\" : : \\"r\\" ($val)); });
    }' unless defined(&lcr3);
    eval 'sub rcr3 {
        local($void) = @_;
	    eval q({  &u_int64_t  &val;  &__asm  &__volatile(\\"movq %%cr3,%0\\" : \\"=r\\" ( &val));  &val; });
    }' unless defined(&rcr3);
    eval 'sub rcr4 {
        local($void) = @_;
	    eval q({ \'u_int\'  &val;  &u_int64_t  &val64;  &__asm  &__volatile(\\"movq %%cr4,%0\\" : \\"=r\\" ( &val64));  &val =  &val64;  &val; });
    }' unless defined(&rcr4);
    eval 'sub tlbflush {
        local($void) = @_;
	    eval q({  &u_int64_t  &val;  &__asm  &__volatile(\\"movq %%cr3,%0\\" : \\"=r\\" ( &val));  &__asm  &__volatile(\\"movq %0,%%cr3\\" : : \\"r\\" ( &val)); });
    }' unless defined(&tlbflush);
    eval 'sub tlbflushg {
        local($void) = @_;
	    eval q({  &if ( &cpu_feature &  &CPUID_PGE) { \'u_int\'  &cr4 =  &rcr4();  &lcr4( &cr4 & ~ &CR4_PGE);  &lcr4( &cr4); }  &else  &tlbflush(); });
    }' unless defined(&tlbflushg);
    if(defined(&notyet)) {
    }
    eval 'sub enable_intr {
        local($void) = @_;
	    eval q({  &__asm  &__volatile(\\"sti\\"); });
    }' unless defined(&enable_intr);
    eval 'sub read_rflags {
        local($void) = @_;
	    eval q({ my $ef;  &__asm  &__volatile(\\"pushfq; popq %0\\" : \\"=r\\" ( $ef)); ( $ef); });
    }' unless defined(&read_rflags);
    eval 'sub write_rflags {
        local($ef) = @_;
	    eval q({  &__asm  &__volatile(\\"pushq %0; popfq\\" : : \\"r\\" ($ef)); });
    }' unless defined(&write_rflags);
    eval 'sub rdmsr {
        local($msr) = @_;
	    eval q({  &uint32_t  &hi,  &lo;  &__asm  &__volatile(\\"rdmsr\\" : \\"=d\\" ( &hi), \\"=a\\" ( &lo) : \\"c\\" ($msr)); ((( &uint64_t) &hi << 32) | ( &uint64_t)  &lo); });
    }' unless defined(&rdmsr);
    eval 'sub wrmsr {
        local($msr,$newval) = @_;
	    eval q({  &__asm  &__volatile(\\"wrmsr\\" : : \\"a\\" ($newval & 0xffffffff), \\"d\\" ($newval >> 32), \\"c\\" ($msr)); });
    }' unless defined(&wrmsr);
    eval 'sub wbinvd {
        local($void) = @_;
	    eval q({  &__asm  &__volatile(\\"wbinvd\\"); });
    }' unless defined(&wbinvd);
    eval 'sub rdtsc {
        local($void) = @_;
	    eval q({  &uint32_t  &hi,  &lo;  &__asm  &__volatile(\\"rdtsc\\" : \\"=d\\" ( &hi), \\"=a\\" ( &lo)); ((( &uint64_t) &hi << 32) | ( &uint64_t)  &lo); });
    }' unless defined(&rdtsc);
    eval 'sub rdpmc {
        local($pmc) = @_;
	    eval q({  &uint32_t  &hi,  &lo;  &__asm  &__volatile(\\"rdpmc\\" : \\"=d\\" ( &hi), \\"=a\\" ( &lo) : \\"c\\" ($pmc)); ((( &uint64_t) &hi << 32) | ( &uint64_t)  &lo); });
    }' unless defined(&rdpmc);
    eval 'sub read_psl () {
        eval q( &read_rflags());
    }' unless defined(&read_psl);
    eval 'sub write_psl {
        local($x) = @_;
	    eval q( &write_rflags($x));
    }' unless defined(&write_psl);
}
    }
1;
