require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&WB_BUSCTL)) {
    sub WB_BUSCTL () {	0x;}
}
unless(defined(&WB_TXSTART)) {
    sub WB_TXSTART () {	0x4;}
}
unless(defined(&WB_RXSTART)) {
    sub WB_RXSTART () {	0x8;}
}
unless(defined(&WB_RXADDR)) {
    sub WB_RXADDR () {	0xc;}
}
unless(defined(&WB_TXADDR)) {
    sub WB_TXADDR () {	0x10;}
}
unless(defined(&WB_ISR)) {
    sub WB_ISR () {	0x14;}
}
unless(defined(&WB_NETCFG)) {
    sub WB_NETCFG () {	0x18;}
}
unless(defined(&WB_IMR)) {
    sub WB_IMR () {	0x1c;}
}
unless(defined(&WB_FRAMESDISCARDED)) {
    sub WB_FRAMESDISCARDED () {	0x20;}
}
unless(defined(&WB_SIO)) {
    sub WB_SIO () {	0x24;}
}
unless(defined(&WB_BOOTROMADDR)) {
    sub WB_BOOTROMADDR () {	0x28;}
}
unless(defined(&WB_TIMER)) {
    sub WB_TIMER () {	0x2c;}
}
unless(defined(&WB_CURRXCTL)) {
    sub WB_CURRXCTL () {	0x30;}
}
unless(defined(&WB_CURRXBUF)) {
    sub WB_CURRXBUF () {	0x34;}
}
unless(defined(&WB_MAR0)) {
    sub WB_MAR0 () {	0x38;}
}
unless(defined(&WB_MAR1)) {
    sub WB_MAR1 () {	0x3c;}
}
unless(defined(&WB_NODE0)) {
    sub WB_NODE0 () {	0x40;}
}
unless(defined(&WB_NODE1)) {
    sub WB_NODE1 () {	0x44;}
}
unless(defined(&WB_BOOTROMSIZE)) {
    sub WB_BOOTROMSIZE () {	0x48;}
}
unless(defined(&WB_CURTXCTL)) {
    sub WB_CURTXCTL () {	0x4c;}
}
unless(defined(&WB_CURTXBUF)) {
    sub WB_CURTXBUF () {	0x50;}
}
unless(defined(&WB_BUSCTL_RESET)) {
    sub WB_BUSCTL_RESET () {	0x1;}
}
unless(defined(&WB_BUSCTL_ARBITRATION)) {
    sub WB_BUSCTL_ARBITRATION () {	0x2;}
}
unless(defined(&WB_BUSCTL_SKIPLEN)) {
    sub WB_BUSCTL_SKIPLEN () {	0x7c;}
}
unless(defined(&WB_BUSCTL_BUF_BIGENDIAN)) {
    sub WB_BUSCTL_BUF_BIGENDIAN () {	0x80;}
}
unless(defined(&WB_BUSCTL_BURSTLEN)) {
    sub WB_BUSCTL_BURSTLEN () {	0x3f00;}
}
unless(defined(&WB_BUSCTL_CACHEALIGN)) {
    sub WB_BUSCTL_CACHEALIGN () {	0xc000;}
}
unless(defined(&WB_BUSCTL_DES_BIGENDIAN)) {
    sub WB_BUSCTL_DES_BIGENDIAN () {	0x100000;}
}
unless(defined(&WB_BUSCTL_WAIT)) {
    sub WB_BUSCTL_WAIT () {	0x200000;}
}
unless(defined(&WB_BUSCTL_MUSTBEONE)) {
    sub WB_BUSCTL_MUSTBEONE () {	0x400000;}
}
unless(defined(&WB_SKIPLEN_1LONG)) {
    sub WB_SKIPLEN_1LONG () {	0x4;}
}
unless(defined(&WB_SKIPLEN_2LONG)) {
    sub WB_SKIPLEN_2LONG () {	0x8;}
}
unless(defined(&WB_SKIPLEN_3LONG)) {
    sub WB_SKIPLEN_3LONG () {	0x10;}
}
unless(defined(&WB_SKIPLEN_4LONG)) {
    sub WB_SKIPLEN_4LONG () {	0x20;}
}
unless(defined(&WB_SKIPLEN_5LONG)) {
    sub WB_SKIPLEN_5LONG () {	0x40;}
}
unless(defined(&WB_CACHEALIGN_NONE)) {
    sub WB_CACHEALIGN_NONE () {	0x;}
}
unless(defined(&WB_CACHEALIGN_8LONG)) {
    sub WB_CACHEALIGN_8LONG () {	0x4000;}
}
unless(defined(&WB_CACHEALIGN_16LONG)) {
    sub WB_CACHEALIGN_16LONG () {	0x8000;}
}
unless(defined(&WB_CACHEALIGN_32LONG)) {
    sub WB_CACHEALIGN_32LONG () {	0xc000;}
}
unless(defined(&WB_BURSTLEN_USECA)) {
    sub WB_BURSTLEN_USECA () {	0x;}
}
unless(defined(&WB_BURSTLEN_1LONG)) {
    sub WB_BURSTLEN_1LONG () {	0x100;}
}
unless(defined(&WB_BURSTLEN_2LONG)) {
    sub WB_BURSTLEN_2LONG () {	0x200;}
}
unless(defined(&WB_BURSTLEN_4LONG)) {
    sub WB_BURSTLEN_4LONG () {	0x400;}
}
unless(defined(&WB_BURSTLEN_8LONG)) {
    sub WB_BURSTLEN_8LONG () {	0x800;}
}
unless(defined(&WB_BURSTLEN_16LONG)) {
    sub WB_BURSTLEN_16LONG () {	0x1000;}
}
unless(defined(&WB_BURSTLEN_32LONG)) {
    sub WB_BURSTLEN_32LONG () {	0x2000;}
}
unless(defined(&WB_BUSCTL_CONFIG)) {
    sub WB_BUSCTL_CONFIG () {	( &WB_CACHEALIGN_8LONG| &WB_SKIPLEN_3LONG|  &WB_BURSTLEN_8LONG);}
}
unless(defined(&WB_ISR_TX_OK)) {
    sub WB_ISR_TX_OK () {	0x1;}
}
unless(defined(&WB_ISR_TX_IDLE)) {
    sub WB_ISR_TX_IDLE () {	0x2;}
}
unless(defined(&WB_ISR_TX_NOBUF)) {
    sub WB_ISR_TX_NOBUF () {	0x4;}
}
unless(defined(&WB_ISR_RX_EARLY)) {
    sub WB_ISR_RX_EARLY () {	0x8;}
}
unless(defined(&WB_ISR_RX_ERR)) {
    sub WB_ISR_RX_ERR () {	0x10;}
}
unless(defined(&WB_ISR_TX_UNDERRUN)) {
    sub WB_ISR_TX_UNDERRUN () {	0x20;}
}
unless(defined(&WB_ISR_RX_OK)) {
    sub WB_ISR_RX_OK () {	0x40;}
}
unless(defined(&WB_ISR_RX_NOBUF)) {
    sub WB_ISR_RX_NOBUF () {	0x80;}
}
unless(defined(&WB_ISR_RX_IDLE)) {
    sub WB_ISR_RX_IDLE () {	0x100;}
}
unless(defined(&WB_ISR_TX_EARLY)) {
    sub WB_ISR_TX_EARLY () {	0x400;}
}
unless(defined(&WB_ISR_TIMER_EXPIRED)) {
    sub WB_ISR_TIMER_EXPIRED () {	0x800;}
}
unless(defined(&WB_ISR_BUS_ERR)) {
    sub WB_ISR_BUS_ERR () {	0x2000;}
}
unless(defined(&WB_ISR_ABNORMAL)) {
    sub WB_ISR_ABNORMAL () {	0x8000;}
}
unless(defined(&WB_ISR_NORMAL)) {
    sub WB_ISR_NORMAL () {	0x10000;}
}
unless(defined(&WB_ISR_RX_STATE)) {
    sub WB_ISR_RX_STATE () {	0xe0000;}
}
unless(defined(&WB_ISR_TX_STATE)) {
    sub WB_ISR_TX_STATE () {	0x700000;}
}
unless(defined(&WB_ISR_BUSERRTYPE)) {
    sub WB_ISR_BUSERRTYPE () {	0x3800000;}
}
unless(defined(&WB_RXSTATE_STOPPED)) {
    sub WB_RXSTATE_STOPPED () {	0x;}
}
unless(defined(&WB_RXSTATE_FETCH)) {
    sub WB_RXSTATE_FETCH () {	0x20000;}
}
unless(defined(&WB_RXSTATE_ENDCHECK)) {
    sub WB_RXSTATE_ENDCHECK () {	0x40000;}
}
unless(defined(&WB_RXSTATE_WAIT)) {
    sub WB_RXSTATE_WAIT () {	0x60000;}
}
unless(defined(&WB_RXSTATE_SUSPEND)) {
    sub WB_RXSTATE_SUSPEND () {	0x80000;}
}
unless(defined(&WB_RXSTATE_CLOSE)) {
    sub WB_RXSTATE_CLOSE () {	0xa0000;}
}
unless(defined(&WB_RXSTATE_FLUSH)) {
    sub WB_RXSTATE_FLUSH () {	0xc0000;}
}
unless(defined(&WB_RXSTATE_DEQUEUE)) {
    sub WB_RXSTATE_DEQUEUE () {	0xe0000;}
}
unless(defined(&WB_TXSTATE_RESET)) {
    sub WB_TXSTATE_RESET () {	0x;}
}
unless(defined(&WB_TXSTATE_FETCH)) {
    sub WB_TXSTATE_FETCH () {	0x100000;}
}
unless(defined(&WB_TXSTATE_WAITEND)) {
    sub WB_TXSTATE_WAITEND () {	0x200000;}
}
unless(defined(&WB_TXSTATE_READING)) {
    sub WB_TXSTATE_READING () {	0x300000;}
}
unless(defined(&WB_TXSTATE_RSVD)) {
    sub WB_TXSTATE_RSVD () {	0x400000;}
}
unless(defined(&WB_TXSTATE_SETUP)) {
    sub WB_TXSTATE_SETUP () {	0x500000;}
}
unless(defined(&WB_TXSTATE_SUSPEND)) {
    sub WB_TXSTATE_SUSPEND () {	0x600000;}
}
unless(defined(&WB_TXSTATE_CLOSE)) {
    sub WB_TXSTATE_CLOSE () {	0x700000;}
}
unless(defined(&WB_NETCFG_RX_ON)) {
    sub WB_NETCFG_RX_ON () {	0x2;}
}
unless(defined(&WB_NETCFG_RX_ALLPHYS)) {
    sub WB_NETCFG_RX_ALLPHYS () {	0x8;}
}
unless(defined(&WB_NETCFG_RX_MULTI)) {
    sub WB_NETCFG_RX_MULTI () {	0x10;}
}
unless(defined(&WB_NETCFG_RX_BROAD)) {
    sub WB_NETCFG_RX_BROAD () {	0x20;}
}
unless(defined(&WB_NETCFG_RX_RUNT)) {
    sub WB_NETCFG_RX_RUNT () {	0x40;}
}
unless(defined(&WB_NETCFG_RX_ERR)) {
    sub WB_NETCFG_RX_ERR () {	0x80;}
}
unless(defined(&WB_NETCFG_FULLDUPLEX)) {
    sub WB_NETCFG_FULLDUPLEX () {	0x200;}
}
unless(defined(&WB_NETCFG_LOOPBACK)) {
    sub WB_NETCFG_LOOPBACK () {	0xc00;}
}
unless(defined(&WB_NETCFG_TX_ON)) {
    sub WB_NETCFG_TX_ON () {	0x2000;}
}
unless(defined(&WB_NETCFG_TX_THRESH)) {
    sub WB_NETCFG_TX_THRESH () {	0x1fc000;}
}
unless(defined(&WB_NETCFG_RX_EARLYTHRSH)) {
    sub WB_NETCFG_RX_EARLYTHRSH () {	0x1fe00000;}
}
unless(defined(&WB_NETCFG_100MBPS)) {
    sub WB_NETCFG_100MBPS () {	0x20000000;}
}
unless(defined(&WB_NETCFG_TX_EARLY_ON)) {
    sub WB_NETCFG_TX_EARLY_ON () {	0x40000000;}
}
unless(defined(&WB_NETCFG_RX_EARLY_ON)) {
    sub WB_NETCFG_RX_EARLY_ON () {	0x80000000;}
}
unless(defined(&WB_TXTHRESH)) {
    sub WB_TXTHRESH {
	local($x) = @_;
	eval q((($x >> 5) << 14));
    }
}
unless(defined(&WB_TXTHRESH_CHUNK)) {
    sub WB_TXTHRESH_CHUNK () {	32;}
}
unless(defined(&WB_TXTHRESH_INIT)) {
    sub WB_TXTHRESH_INIT () {	0;}
}
unless(defined(&WB_IMR_TX_OK)) {
    sub WB_IMR_TX_OK () {	0x1;}
}
unless(defined(&WB_IMR_TX_IDLE)) {
    sub WB_IMR_TX_IDLE () {	0x2;}
}
unless(defined(&WB_IMR_TX_NOBUF)) {
    sub WB_IMR_TX_NOBUF () {	0x4;}
}
unless(defined(&WB_IMR_RX_EARLY)) {
    sub WB_IMR_RX_EARLY () {	0x8;}
}
unless(defined(&WB_IMR_RX_ERR)) {
    sub WB_IMR_RX_ERR () {	0x10;}
}
unless(defined(&WB_IMR_TX_UNDERRUN)) {
    sub WB_IMR_TX_UNDERRUN () {	0x20;}
}
unless(defined(&WB_IMR_RX_OK)) {
    sub WB_IMR_RX_OK () {	0x40;}
}
unless(defined(&WB_IMR_RX_NOBUF)) {
    sub WB_IMR_RX_NOBUF () {	0x80;}
}
unless(defined(&WB_IMR_RX_IDLE)) {
    sub WB_IMR_RX_IDLE () {	0x100;}
}
unless(defined(&WB_IMR_TX_EARLY)) {
    sub WB_IMR_TX_EARLY () {	0x400;}
}
unless(defined(&WB_IMR_TIMER_EXPIRED)) {
    sub WB_IMR_TIMER_EXPIRED () {	0x800;}
}
unless(defined(&WB_IMR_BUS_ERR)) {
    sub WB_IMR_BUS_ERR () {	0x2000;}
}
unless(defined(&WB_IMR_ABNORMAL)) {
    sub WB_IMR_ABNORMAL () {	0x8000;}
}
unless(defined(&WB_IMR_NORMAL)) {
    sub WB_IMR_NORMAL () {	0x10000;}
}
unless(defined(&WB_INTRS)) {
    sub WB_INTRS () {	( &WB_IMR_RX_OK| &WB_IMR_TX_OK| &WB_IMR_RX_NOBUF| &WB_IMR_RX_ERR|  &WB_IMR_TX_NOBUF| &WB_IMR_TX_UNDERRUN| &WB_IMR_BUS_ERR|  &WB_IMR_ABNORMAL| &WB_IMR_NORMAL| &WB_IMR_TX_EARLY);}
}
unless(defined(&WB_SIO_EE_CS)) {
    sub WB_SIO_EE_CS () {	0x1;}
}
unless(defined(&WB_SIO_EE_CLK)) {
    sub WB_SIO_EE_CLK () {	0x2;}
}
unless(defined(&WB_SIO_EE_DATAIN)) {
    sub WB_SIO_EE_DATAIN () {	0x4;}
}
unless(defined(&WB_SIO_EE_DATAOUT)) {
    sub WB_SIO_EE_DATAOUT () {	0x8;}
}
unless(defined(&WB_SIO_ROMDATA4)) {
    sub WB_SIO_ROMDATA4 () {	0x10;}
}
unless(defined(&WB_SIO_ROMDATA5)) {
    sub WB_SIO_ROMDATA5 () {	0x20;}
}
unless(defined(&WB_SIO_ROMDATA6)) {
    sub WB_SIO_ROMDATA6 () {	0x40;}
}
unless(defined(&WB_SIO_ROMDATA7)) {
    sub WB_SIO_ROMDATA7 () {	0x80;}
}
unless(defined(&WB_SIO_ROMCTL_WRITE)) {
    sub WB_SIO_ROMCTL_WRITE () {	0x200;}
}
unless(defined(&WB_SIO_ROMCTL_READ)) {
    sub WB_SIO_ROMCTL_READ () {	0x400;}
}
unless(defined(&WB_SIO_EESEL)) {
    sub WB_SIO_EESEL () {	0x800;}
}
unless(defined(&WB_SIO_MII_CLK)) {
    sub WB_SIO_MII_CLK () {	0x10000;}
}
unless(defined(&WB_SIO_MII_DATAIN)) {
    sub WB_SIO_MII_DATAIN () {	0x20000;}
}
unless(defined(&WB_SIO_MII_DIR)) {
    sub WB_SIO_MII_DIR () {	0x40000;}
}
unless(defined(&WB_SIO_MII_DATAOUT)) {
    sub WB_SIO_MII_DATAOUT () {	0x80000;}
}
unless(defined(&WB_EECMD_WRITE)) {
    sub WB_EECMD_WRITE () {	0x140;}
}
unless(defined(&WB_EECMD_READ)) {
    sub WB_EECMD_READ () {	0x180;}
}
unless(defined(&WB_EECMD_ERASE)) {
    sub WB_EECMD_ERASE () {	0x1c0;}
}
unless(defined(&wb_data)) {
    sub wb_data () {	 &wb_ptr1;}
}
unless(defined(&wb_next)) {
    sub wb_next () {	 &wb_ptr2;}
}
unless(defined(&WB_RXSTAT_CRCERR)) {
    sub WB_RXSTAT_CRCERR () {	0x2;}
}
unless(defined(&WB_RXSTAT_DRIBBLE)) {
    sub WB_RXSTAT_DRIBBLE () {	0x4;}
}
unless(defined(&WB_RXSTAT_MIIERR)) {
    sub WB_RXSTAT_MIIERR () {	0x8;}
}
unless(defined(&WB_RXSTAT_LATEEVENT)) {
    sub WB_RXSTAT_LATEEVENT () {	0x40;}
}
unless(defined(&WB_RXSTAT_GIANT)) {
    sub WB_RXSTAT_GIANT () {	0x80;}
}
unless(defined(&WB_RXSTAT_LASTFRAG)) {
    sub WB_RXSTAT_LASTFRAG () {	0x100;}
}
unless(defined(&WB_RXSTAT_FIRSTFRAG)) {
    sub WB_RXSTAT_FIRSTFRAG () {	0x200;}
}
unless(defined(&WB_RXSTAT_MULTICAST)) {
    sub WB_RXSTAT_MULTICAST () {	0x400;}
}
unless(defined(&WB_RXSTAT_RUNT)) {
    sub WB_RXSTAT_RUNT () {	0x800;}
}
unless(defined(&WB_RXSTAT_RXTYPE)) {
    sub WB_RXSTAT_RXTYPE () {	0x3000;}
}
unless(defined(&WB_RXSTAT_RXERR)) {
    sub WB_RXSTAT_RXERR () {	0x8000;}
}
unless(defined(&WB_RXSTAT_RXLEN)) {
    sub WB_RXSTAT_RXLEN () {	0x3fff0000;}
}
unless(defined(&WB_RXSTAT_RXCMP)) {
    sub WB_RXSTAT_RXCMP () {	0x40000000;}
}
unless(defined(&WB_RXSTAT_OWN)) {
    sub WB_RXSTAT_OWN () {	0x80000000;}
}
unless(defined(&WB_RXBYTES)) {
    sub WB_RXBYTES {
	local($x) = @_;
	eval q((($x &  &WB_RXSTAT_RXLEN) >> 16));
    }
}
unless(defined(&WB_RXSTAT)) {
    sub WB_RXSTAT () {	( &WB_RXSTAT_FIRSTFRAG| &WB_RXSTAT_LASTFRAG| &WB_RXSTAT_OWN);}
}
unless(defined(&WB_RXCTL_BUFLEN1)) {
    sub WB_RXCTL_BUFLEN1 () {	0xfff;}
}
unless(defined(&WB_RXCTL_BUFLEN2)) {
    sub WB_RXCTL_BUFLEN2 () {	0xfff000;}
}
unless(defined(&WB_RXCTL_RLINK)) {
    sub WB_RXCTL_RLINK () {	0x1000000;}
}
unless(defined(&WB_RXCTL_RLAST)) {
    sub WB_RXCTL_RLAST () {	0x2000000;}
}
unless(defined(&WB_TXSTAT_DEFER)) {
    sub WB_TXSTAT_DEFER () {	0x1;}
}
unless(defined(&WB_TXSTAT_UNDERRUN)) {
    sub WB_TXSTAT_UNDERRUN () {	0x2;}
}
unless(defined(&WB_TXSTAT_COLLCNT)) {
    sub WB_TXSTAT_COLLCNT () {	0x78;}
}
unless(defined(&WB_TXSTAT_SQE)) {
    sub WB_TXSTAT_SQE () {	0x80;}
}
unless(defined(&WB_TXSTAT_ABORT)) {
    sub WB_TXSTAT_ABORT () {	0x100;}
}
unless(defined(&WB_TXSTAT_LATECOLL)) {
    sub WB_TXSTAT_LATECOLL () {	0x200;}
}
unless(defined(&WB_TXSTAT_NOCARRIER)) {
    sub WB_TXSTAT_NOCARRIER () {	0x400;}
}
unless(defined(&WB_TXSTAT_CARRLOST)) {
    sub WB_TXSTAT_CARRLOST () {	0x800;}
}
unless(defined(&WB_TXSTAT_TXERR)) {
    sub WB_TXSTAT_TXERR () {	0x1000;}
}
unless(defined(&WB_TXSTAT_OWN)) {
    sub WB_TXSTAT_OWN () {	0x80000000;}
}
unless(defined(&WB_TXCTL_BUFLEN1)) {
    sub WB_TXCTL_BUFLEN1 () {	0x7ff;}
}
unless(defined(&WB_TXCTL_BUFLEN2)) {
    sub WB_TXCTL_BUFLEN2 () {	0x3ff800;}
}
unless(defined(&WB_TXCTL_PAD)) {
    sub WB_TXCTL_PAD () {	0x800000;}
}
unless(defined(&WB_TXCTL_TLINK)) {
    sub WB_TXCTL_TLINK () {	0x1000000;}
}
unless(defined(&WB_TXCTL_TLAST)) {
    sub WB_TXCTL_TLAST () {	0x2000000;}
}
unless(defined(&WB_TXCTL_NOCRC)) {
    sub WB_TXCTL_NOCRC () {	0x8000000;}
}
unless(defined(&WB_TXCTL_FIRSTFRAG)) {
    sub WB_TXCTL_FIRSTFRAG () {	0x20000000;}
}
unless(defined(&WB_TXCTL_LASTFRAG)) {
    sub WB_TXCTL_LASTFRAG () {	0x40000000;}
}
unless(defined(&WB_TXCTL_FINT)) {
    sub WB_TXCTL_FINT () {	0x80000000;}
}
unless(defined(&WB_MAXFRAGS)) {
    sub WB_MAXFRAGS () {	16;}
}
unless(defined(&WB_RX_LIST_CNT)) {
    sub WB_RX_LIST_CNT () {	64;}
}
unless(defined(&WB_TX_LIST_CNT)) {
    sub WB_TX_LIST_CNT () {	64;}
}
unless(defined(&WB_MIN_FRAMELEN)) {
    sub WB_MIN_FRAMELEN () {	60;}
}
unless(defined(&WB_TXNEXT)) {
    sub WB_TXNEXT {
	local($x) = @_;
	eval q( ($x->{wb_ptr}->{wb_frag[$x}->{wb_lastdesc]}->{wb_next}));
    }
}
unless(defined(&WB_TXSTATUS)) {
    sub WB_TXSTATUS {
	local($x) = @_;
	eval q( ($x->{wb_ptr}->{wb_frag[$x}->{wb_lastdesc]}->{wb_status}));
    }
}
unless(defined(&WB_TXCTL)) {
    sub WB_TXCTL {
	local($x) = @_;
	eval q( ($x->{wb_ptr}->{wb_frag[$x}->{wb_lastdesc]}->{wb_ctl}));
    }
}
unless(defined(&WB_TXDATA)) {
    sub WB_TXDATA {
	local($x) = @_;
	eval q( ($x->{wb_ptr}->{wb_frag[$x}->{wb_lastdesc]}->{wb_data}));
    }
}
unless(defined(&WB_TXOWN)) {
    sub WB_TXOWN {
	local($x) = @_;
	eval q( ($x->{wb_ptr}->{wb_frag[0]}->{wb_status}));
    }
}
unless(defined(&WB_UNSENT)) {
    sub WB_UNSENT () {	0x1234;}
}
unless(defined(&WB_BUFBYTES)) {
    sub WB_BUFBYTES () {	(1024* $sizeof{ &u_int32_t});}
}
unless(defined(&WB_MII_STARTDELIM)) {
    sub WB_MII_STARTDELIM () {	0x1;}
}
unless(defined(&WB_MII_READOP)) {
    sub WB_MII_READOP () {	0x2;}
}
unless(defined(&WB_MII_WRITEOP)) {
    sub WB_MII_WRITEOP () {	0x1;}
}
unless(defined(&WB_MII_TURNAROUND)) {
    sub WB_MII_TURNAROUND () {	0x2;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{wb_btag}),  ($sc->{wb_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{wb_btag}),  ($sc->{wb_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{wb_btag}),  ($sc->{wb_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{wb_btag}),  ($sc->{wb_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{wb_btag}),  ($sc->{wb_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{wb_btag}),  ($sc->{wb_bhandle}), $reg));
    }
}
unless(defined(&WB_TIMEOUT)) {
    sub WB_TIMEOUT () {	1000;}
}
unless(defined(&WB_VENDORID)) {
    sub WB_VENDORID () {	0x1050;}
}
unless(defined(&WB_DEVICEID_840F)) {
    sub WB_DEVICEID_840F () {	0x840;}
}
unless(defined(&CP_VENDORID)) {
    sub CP_VENDORID () {	0x11f6;}
}
unless(defined(&CP_DEVICEID_RL100)) {
    sub CP_DEVICEID_RL100 () {	0x2011;}
}
unless(defined(&WB_PCI_VENDOR_ID)) {
    sub WB_PCI_VENDOR_ID () {	0x;}
}
unless(defined(&WB_PCI_DEVICE_ID)) {
    sub WB_PCI_DEVICE_ID () {	0x2;}
}
unless(defined(&WB_PCI_COMMAND)) {
    sub WB_PCI_COMMAND () {	0x4;}
}
unless(defined(&WB_PCI_STATUS)) {
    sub WB_PCI_STATUS () {	0x6;}
}
unless(defined(&WB_PCI_CLASSCODE)) {
    sub WB_PCI_CLASSCODE () {	0x9;}
}
unless(defined(&WB_PCI_CACHELEN)) {
    sub WB_PCI_CACHELEN () {	0xc;}
}
unless(defined(&WB_PCI_LATENCY_TIMER)) {
    sub WB_PCI_LATENCY_TIMER () {	0xd;}
}
unless(defined(&WB_PCI_HEADER_TYPE)) {
    sub WB_PCI_HEADER_TYPE () {	0xe;}
}
unless(defined(&WB_PCI_LOIO)) {
    sub WB_PCI_LOIO () {	0x10;}
}
unless(defined(&WB_PCI_LOMEM)) {
    sub WB_PCI_LOMEM () {	0x14;}
}
unless(defined(&WB_PCI_BIOSROM)) {
    sub WB_PCI_BIOSROM () {	0x30;}
}
unless(defined(&WB_PCI_INTLINE)) {
    sub WB_PCI_INTLINE () {	0x3c;}
}
unless(defined(&WB_PCI_INTPIN)) {
    sub WB_PCI_INTPIN () {	0x3d;}
}
unless(defined(&WB_PCI_MINGNT)) {
    sub WB_PCI_MINGNT () {	0x3e;}
}
unless(defined(&WB_PCI_MINLAT)) {
    sub WB_PCI_MINLAT () {	0xf;}
}
unless(defined(&WB_PCI_RESETOPT)) {
    sub WB_PCI_RESETOPT () {	0x48;}
}
unless(defined(&WB_PCI_EEPROM_DATA)) {
    sub WB_PCI_EEPROM_DATA () {	0x4c;}
}
unless(defined(&WB_PCI_CAPID)) {
    sub WB_PCI_CAPID () {	0xdc;}
}
unless(defined(&WB_PCI_NEXTPTR)) {
    sub WB_PCI_NEXTPTR () {	0xdd;}
}
unless(defined(&WB_PCI_PWRMGMTCAP)) {
    sub WB_PCI_PWRMGMTCAP () {	0xde;}
}
unless(defined(&WB_PCI_PWRMGMTCTRL)) {
    sub WB_PCI_PWRMGMTCTRL () {	0xe0;}
}
unless(defined(&WB_PSTATE_MASK)) {
    sub WB_PSTATE_MASK () {	0x3;}
}
unless(defined(&WB_PSTATE_D0)) {
    sub WB_PSTATE_D0 () {	0x;}
}
unless(defined(&WB_PSTATE_D1)) {
    sub WB_PSTATE_D1 () {	0x2;}
}
unless(defined(&WB_PSTATE_D2)) {
    sub WB_PSTATE_D2 () {	0x2;}
}
unless(defined(&WB_PSTATE_D3)) {
    sub WB_PSTATE_D3 () {	0x3;}
}
unless(defined(&WB_PME_EN)) {
    sub WB_PME_EN () {	0x10;}
}
unless(defined(&WB_PME_STATUS)) {
    sub WB_PME_STATUS () {	0x8000;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        local($va) = @_;
	    eval q( &alpha_XXX_dmamap(( &vaddr_t)$va));
    }' unless defined(&vtophys);
}
1;
