require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&ASSEMBLER)) {
    if(defined(&_STANDALONE)) {
    }
}
unless(defined(&PROM_R_CLOSE)) {
    sub PROM_R_CLOSE () {	0x11;}
}
unless(defined(&PROM_R_GETC)) {
    sub PROM_R_GETC () {	0x1;}
}
unless(defined(&PROM_R_GETENV)) {
    sub PROM_R_GETENV () {	0x22;}
}
unless(defined(&PROM_R_OPEN)) {
    sub PROM_R_OPEN () {	0x10;}
}
unless(defined(&PROM_R_PUTS)) {
    sub PROM_R_PUTS () {	0x2;}
}
unless(defined(&PROM_R_READ)) {
    sub PROM_R_READ () {	0x13;}
}
unless(defined(&PROM_R_WRITE)) {
    sub PROM_R_WRITE () {	0x14;}
}
unless(defined(&PROM_R_IOCTL)) {
    sub PROM_R_IOCTL () {	0x12;}
}
unless(defined(&PROM_I_SKIP2IRG)) {
    sub PROM_I_SKIP2IRG () {	1;}
}
unless(defined(&PROM_I_SKIP2MARK)) {
    sub PROM_I_SKIP2MARK () {	2;}
}
unless(defined(&PROM_I_REWIND)) {
    sub PROM_I_REWIND () {	3;}
}
unless(defined(&PROM_I_WRITEMARK)) {
    sub PROM_I_WRITEMARK () {	4;}
}
unless(defined(&PROM_E_BOOTED_DEV)) {
    sub PROM_E_BOOTED_DEV () {	0x4;}
}
unless(defined(&PROM_E_BOOTED_FILE)) {
    sub PROM_E_BOOTED_FILE () {	0x6;}
}
unless(defined(&PROM_E_BOOTED_OSFLAGS)) {
    sub PROM_E_BOOTED_OSFLAGS () {	0x8;}
}
unless(defined(&PROM_E_TTY_DEV)) {
    sub PROM_E_TTY_DEV () {	0xf;}
}
unless(defined(&PROM_E_SCSIID)) {
    sub PROM_E_SCSIID () {	0x42;}
}
unless(defined(&PROM_E_SCSIFAST)) {
    sub PROM_E_SCSIFAST () {	0x43;}
}
if(defined( &_STANDALONE) || defined( &ENABLEPROM)) {
    eval 'sub prom_close {
        local($chan) = @_;
	    eval q( &prom_dispatch( &PROM_R_CLOSE, $chan, 0, 0, 0));
    }' unless defined(&prom_close);
    eval 'sub prom_read {
        local($chan, $len, $buf, $blkno) = @_;
	    eval q( &prom_dispatch( &PROM_R_READ, $chan, $len, ( &u_int64_t)$buf, $blkno));
    }' unless defined(&prom_read);
    eval 'sub prom_write {
        local($chan, $len, $buf, $blkno) = @_;
	    eval q( &prom_dispatch( &PROM_R_WRITE, $chan, $len, ( &u_int64_t)$buf, $blkno));
    }' unless defined(&prom_write);
    eval 'sub prom_ioctl {
        local($chan, $op, $count) = @_;
	    eval q( &prom_dispatch( &PROM_R_IOCTL, $chan, $op, ( &int64_t)$count, 0, 0));
    }' unless defined(&prom_ioctl);
    eval 'sub prom_putstr {
        local($chan, $str, $len) = @_;
	    eval q( &prom_dispatch( &PROM_R_PUTS, $chan, ( &u_int64_t)$str, $len, 0));
    }' unless defined(&prom_putstr);
    eval 'sub prom_getc {
        local($chan) = @_;
	    eval q( &prom_dispatch( &PROM_R_GETC, $chan, 0, 0, 0));
    }' unless defined(&prom_getc);
    eval 'sub prom_getenv_disp {
        local($id, $buf, $len) = @_;
	    eval q( &prom_dispatch( &PROM_R_GETENV, $id, ( &u_int64_t)$buf, $len, 0));
    }' unless defined(&prom_getenv_disp);
}
unless(defined(&ASSEMBLER)) {
    if(defined(&_KERNEL)) {
    }
}
1;
