require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_PMAP_MACHINE_)) {
    eval 'sub _PMAP_MACHINE_ () {1;}' unless defined(&_PMAP_MACHINE_);
    require 'sys/lock.ph';
    require 'sys/queue.ph';
    require 'machine/pte.ph';
    eval 'sub PMAP_ASN_RESERVED () {0;}' unless defined(&PMAP_ASN_RESERVED);
    eval 'sub pmap_kernel () {
        eval q(( &kernel_pmap_store));
    }' unless defined(&pmap_kernel);
    eval 'sub PGA_MODIFIED () {0x1;}' unless defined(&PGA_MODIFIED);
    eval 'sub PGA_REFERENCED () {0x2;}' unless defined(&PGA_REFERENCED);
    eval 'sub PGU_NORMAL () {0;}' unless defined(&PGU_NORMAL);
    eval 'sub PGU_PVENT () {1;}' unless defined(&PGU_PVENT);
    eval 'sub PGU_L1PT () {2;}' unless defined(&PGU_L1PT);
    eval 'sub PGU_L2PT () {3;}' unless defined(&PGU_L2PT);
    eval 'sub PGU_L3PT () {4;}' unless defined(&PGU_L3PT);
    eval 'sub PGU_ISPTPAGE {
        local($pgu) = @_;
	    eval q((($pgu) >=  &PGU_L1PT));
    }' unless defined(&PGU_ISPTPAGE);
    eval 'sub PGU_STRINGS () {{ "normal", "pvent", "l1pt", "l2pt", "l3pt", };}' unless defined(&PGU_STRINGS);
    if(defined(&_KERNEL)) {
	unless(defined(&_LKM)) {
	    if(defined( &NEW_SCC_DRIVER)) {
		if(defined( &DEC_KN8AE)) {
		    eval 'sub _PMAP_MAY_USE_PROM_CONSOLE () {1;}' unless defined(&_PMAP_MAY_USE_PROM_CONSOLE);
		}
	    } else {
		if(defined( &DEC_3000_300) || defined( &DEC_3000_500) || defined( &DEC_KN8AE) ) {
		    eval 'sub _PMAP_MAY_USE_PROM_CONSOLE () {1;}' unless defined(&_PMAP_MAY_USE_PROM_CONSOLE);
		}
	    }
	    if(defined( &MULTIPROCESSOR)) {
		eval 'sub PMAP_TLB_SHOOTDOWN {
		    local($pm, $va, $pte) = @_;
    		    eval q( &pmap_tlb_shootdown(($pm), ($va), ($pte)));
		}' unless defined(&PMAP_TLB_SHOOTDOWN);
	    } else {
		eval 'sub PMAP_TLB_SHOOTDOWN {
		    local($pm, $va, $pte) = @_;
    		    eval q();
		}' unless defined(&PMAP_TLB_SHOOTDOWN);
	    }
	}
	eval 'sub pmap_resident_count {
	    local($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_wired_count {
	    local($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
	eval 'sub pmap_update {
	    local($pmap) = @_;
    	    eval q();
	}' unless defined(&pmap_update);
	eval 'sub pmap_phys_address {
	    local($ppn) = @_;
    	    eval q( &ptoa($ppn));
	}' unless defined(&pmap_phys_address);
	eval 'sub pmap_proc_iflush {
	    local($p, $va, $len) = @_;
    	    eval q();
	}' unless defined(&pmap_proc_iflush);
	eval 'sub pmap_unuse_final {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&pmap_unuse_final);
	eval 'sub PMAP_STEAL_MEMORY () {1;}' unless defined(&PMAP_STEAL_MEMORY);
	eval 'sub PMAP_GROWKERNEL () {1;}' unless defined(&PMAP_GROWKERNEL);
	eval 'sub pmap_map_direct {
	    local($pg) = @_;
    	    eval q( &ALPHA_PHYS_TO_K0SEG( &VM_PAGE_TO_PHYS($pg)));
	}' unless defined(&pmap_map_direct);
	eval 'sub pmap_unmap_direct {
	    local($va) = @_;
    	    eval q( &PHYS_TO_VM_PAGE( &ALPHA_K0SEG_TO_PHYS(($va))));
	}' unless defined(&pmap_unmap_direct);
	eval 'sub __HAVE_PMAP_DIRECT () {1;}' unless defined(&__HAVE_PMAP_DIRECT);
	if(defined(&_PMAP_MAY_USE_PROM_CONSOLE)) {
	}
	eval 'sub pmap_pte_pa {
	    local($pte) = @_;
    	    eval q(( &PG_PFNUM(*($pte)) <<  &PGSHIFT));
	}' unless defined(&pmap_pte_pa);
	eval 'sub pmap_pte_prot {
	    local($pte) = @_;
    	    eval q((*($pte) &  &PG_PROT));
	}' unless defined(&pmap_pte_prot);
	eval 'sub pmap_pte_w {
	    local($pte) = @_;
    	    eval q((*($pte) &  &PG_WIRED));
	}' unless defined(&pmap_pte_w);
	eval 'sub pmap_pte_v {
	    local($pte) = @_;
    	    eval q((*($pte) &  &PG_V));
	}' unless defined(&pmap_pte_v);
	eval 'sub pmap_pte_pv {
	    local($pte) = @_;
    	    eval q((*($pte) &  &PG_PVLIST));
	}' unless defined(&pmap_pte_pv);
	eval 'sub pmap_pte_asm {
	    local($pte) = @_;
    	    eval q((*($pte) &  &PG_ASM));
	}' unless defined(&pmap_pte_asm);
	eval 'sub pmap_pte_exec {
	    local($pte) = @_;
    	    eval q((*($pte) &  &PG_EXEC));
	}' unless defined(&pmap_pte_exec);
	eval 'sub pmap_pte_set_w {
	    local($pte, $v) = @_;
    	    eval q( &do {  &if ($v) *($pte) |=  &PG_WIRED;  &else *($pte) &= ~ &PG_WIRED; }  &while (0));
	}' unless defined(&pmap_pte_set_w);
	eval 'sub pmap_pte_w_chg {
	    local($pte, $nw) = @_;
    	    eval q((($nw) ^  &pmap_pte_w($pte)));
	}' unless defined(&pmap_pte_w_chg);
	eval 'sub pmap_pte_set_prot {
	    local($pte, $np) = @_;
    	    eval q( &do { *($pte) &= ~ &PG_PROT; *($pte) |= ($np); }  &while (0));
	}' unless defined(&pmap_pte_set_prot);
	eval 'sub pmap_pte_prot_chg {
	    local($pte, $np) = @_;
    	    eval q((($np) ^  &pmap_pte_prot($pte)));
	}' unless defined(&pmap_pte_prot_chg);
	eval 'sub pmap_l1pte {
	    local($pmap, $v) = @_;
    	    eval q((($pmap)-> $pm_lev1map[ &l1pte_index(( &vaddr_t)($v))]));
	}' unless defined(&pmap_l1pte);
	eval 'sub pmap_l2pte {
	    local($pmap,$v,$l1pte) = @_;
    	    eval q(;  &vaddr_t $v;  &pt_entry_t *$l1pte; {  &pt_entry_t * &lev2map;  &if ($l1pte ==  &NULL) { $l1pte =  &pmap_l1pte($pmap, $v);  &if ( &pmap_pte_v($l1pte) == 0) ( &NULL); }  &lev2map = ( &pt_entry_t *) &ALPHA_PHYS_TO_K0SEG( &pmap_pte_pa($l1pte)); ( $lev2map[ &l2pte_index($v)]); });
	}' unless defined(&pmap_l2pte);
	eval 'sub pmap_l3pte {
	    local($pmap,$v,$l2pte) = @_;
    	    eval q(;  &vaddr_t $v;  &pt_entry_t *$l2pte; {  &pt_entry_t * &l1pte, * &lev2map, * &lev3map;  &if ($l2pte ==  &NULL) {  &l1pte =  &pmap_l1pte($pmap, $v);  &if ( &pmap_pte_v( &l1pte) == 0) ( &NULL);  &lev2map = ( &pt_entry_t *) &ALPHA_PHYS_TO_K0SEG( &pmap_pte_pa( &l1pte)); $l2pte =  $lev2map[ &l2pte_index($v)];  &if ( &pmap_pte_v($l2pte) == 0) ( &NULL); }  &lev3map = ( &pt_entry_t *) &ALPHA_PHYS_TO_K0SEG( &pmap_pte_pa($l2pte)); ( $lev3map[ &l3pte_index($v)]); });
	}' unless defined(&pmap_l3pte);
	eval 'sub PMAP_LOCK {
	    local($pmap) = @_;
    	    eval q( &simple_lock(($pmap)-> &pm_slock));
	}' unless defined(&PMAP_LOCK);
	eval 'sub PMAP_UNLOCK {
	    local($pmap) = @_;
    	    eval q( &simple_unlock(($pmap)-> &pm_slock));
	}' unless defined(&PMAP_UNLOCK);
	eval 'sub PMAP_USERRET {
	    local($pmap) = @_;
    	    eval q( &do { \'u_long cpu_mask\' = (1 <<  &cpu_number());  &if (($pmap)-> &pm_needisync &  &cpu_mask) {  &atomic_clearbits_ulong(($pmap)-> &pm_needisync,  &cpu_mask);  &alpha_pal_imb(); } }  &while (0));
	}' unless defined(&PMAP_USERRET);
    }
}
1;
