.\" $OpenBSD: wsfb.man,v 1.12 2005/01/22 22:37:00 miod Exp $
.\"
.\" Copyright (c) 2001,2002 Matthieu Herrb
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\"
.\"    - Redistributions of source code must retain the above copyright
.\"      notice, this list of conditions and the following disclaimer.
.\"    - Redistributions in binary form must reproduce the above
.\"      copyright notice, this list of conditions and the following
.\"      disclaimer in the documentation and/or other materials provided
.\"      with the distribution.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
.\" "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
.\" LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
.\" FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
.\" COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
.\" INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
.\" BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
.\" LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
.\" CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
.\" ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
.\" POSSIBILITY OF SUCH DAMAGE.
.\"
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH WSFB __drivermansuffix__ __vendorversion__
.SH NAME
wsfb \- video driver for wsdisplay framebuffer device
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qwsfb\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B wsfb
is an XFree86 driver for the OpenBSD wsdisplay framebuffer devices.
This is a non-accelerated driver. 
The following framebuffer depths are supported: 1, 8, 16 and 24, given
that the wsdisplay device underneath supports them.
.br
A StaticGray monochrome visual is provided for depth 1,
all visual types are supported for depth 8 and a TrueColor visual is
supported for the other depths.
Multi-head configurations are supported.
.SH SUPPORTED HARDWARE
The
.B wsfb
driver supports all hardware where a wsdisplay framebuffer driver
is available on OpenBSD.
Currently this includes OpenBSD/macppc, OpenBSD/sparc, OpenBSD/sparc64
and OpenBSD/alpha on TGA graphics cards.
.SH CONFIGURATION DETAILS
Please refer to XF86Config(__filemansuffix__) for general configuration
details.
This section only covers configuration details specific to this driver.
.PP
For this driver it is not required to specify modes in the 
.B Screen
section of the configuration file.
The
.B wsfb
driver picks up the currently used video mode from the framebuffer
driver and uses it.
Video modes specifications in the configuration file are ignored.
.PP
The following driver options are supported in the 
.B Device
section:
.TP
.BI "Option \*qdevice\*q \*q" string \*q
The wsdisplay framebuffer device to use.
Default: \fI/dev/ttyC0\fP.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable use of the shadow framebuffer layer.
See shadowfb(__drivermansuffix__) for further information.
Default: on for depths were it is supported, off otherwise.
.br
ShadowFB is currently not supported on monochrome displays.
.TP
.BI "Option \*qRotate\*q \*q" string \*q
Enable rotation of the display. The supported values are "CW" (clockwise,
90 degrees), "UD" (upside down, 180 degrees) and "CCW" (counter clockwise,
270 degrees). Implies use of the shadow framebuffer layer.   Default: off.
.SH "SEE ALSO"
XFree86(1), XF86Config(__filemansuffix__), xf86config(1), Xserver(1),
X(__miscmansuffix__), wsdisplay(__drivermansuffix__).
.SH AUTHORS
Authors include: Matthieu Herrb, Gerd Knorr, Michel Dnzer, Geert Uytterhoeven
